/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.IExpressionsListener;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.core.IExpressionsListener2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;

public class ExpressionManagerModelProxy
extends AbstractModelProxy
implements IExpressionsListener2,
IPropertyChangeListener {
    public void init(IPresentationContext context) {
        super.init(context);
        this.getExpressionManager().addExpressionListener((IExpressionsListener)this);
        context.addPropertyChangeListener(this);
    }

    public void installed(Viewer viewer) {
        this.updateExpressions(this.getExpressionManager().getExpressions(), 0x400000);
    }

    protected IExpressionManager getExpressionManager() {
        return DebugPlugin.getDefault().getExpressionManager();
    }

    public synchronized void dispose() {
        this.getPresentationContext().removePropertyChangeListener(this);
        super.dispose();
        this.getExpressionManager().removeExpressionListener((IExpressionsListener)this);
    }

    public void expressionsMoved(IExpression[] expressions, int index) {
        IExpression expression;
        ModelDelta delta = new ModelDelta(this.getExpressionManager(), 0);
        int count = this.getElementsCount();
        int i = 0;
        while (i < expressions.length) {
            expression = expressions[i];
            delta.addNode(expression, 2);
            ++i;
        }
        i = 0;
        while (i < expressions.length) {
            expression = expressions[i];
            delta.addNode(expression, index + i, 1, count);
            ++i;
        }
        this.fireModelChanged(delta);
    }

    public void expressionsInserted(IExpression[] expressions, int index) {
        int count = this.getElementsCount();
        ModelDelta delta = new ModelDelta(this.getExpressionManager(), 0);
        int i = 0;
        while (i < expressions.length) {
            IExpression expression = expressions[i];
            delta.addNode(expression, index + i, 0x400001, count);
            ++i;
        }
        this.fireModelChanged(delta);
    }

    public void expressionsAdded(IExpression[] expressions) {
        int index = this.getExpressionManager().getExpressions().length - expressions.length;
        int count = this.getElementsCount();
        ModelDelta delta = new ModelDelta(this.getExpressionManager(), 0);
        int i = 0;
        while (i < expressions.length) {
            IExpression expression = expressions[i];
            delta.addNode(expression, index + i, 0x400001, count);
            ++i;
        }
        this.fireModelChanged(delta);
        this.updateExpressions(expressions, 0x400001);
    }

    public void expressionsRemoved(IExpression[] expressions) {
        this.updateExpressions(expressions, 0x800002);
    }

    public void expressionsChanged(IExpression[] expressions) {
        this.updateExpressions(expressions, 3072);
    }

    private void updateExpressions(IExpression[] expressions, int flags) {
        ModelDelta delta = new ModelDelta(this.getExpressionManager(), 0);
        int i = 0;
        while (i < expressions.length) {
            IExpression expression = expressions[i];
            delta.addNode(expression, flags);
            ++i;
        }
        this.fireModelChanged(delta);
    }

    private int getElementsCount() {
        return this.getExpressionManager().getExpressions().length + (this.getPresentationContext().getColumns() != null ? 1 : 0);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("PROPERTY_COLUMNS".equals(event.getProperty())) {
            this.fireModelChanged(new ModelDelta(this.getExpressionManager(), 1024));
        }
    }
}

