/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.jmol.api.JmolAdapter;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.JmolPanel;

public class FilePreview
extends JPanel
implements PropertyChangeListener {
    JCheckBox active = null;
    JCheckBox append = null;
    JFileChooser chooser = null;
    private JmolPanel display = null;

    public FilePreview(JFileChooser jFileChooser, JmolAdapter jmolAdapter) {
        this.chooser = jFileChooser;
        Box box = Box.createVerticalBox();
        this.active = new JCheckBox(GT._("Preview"), false);
        this.active.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FilePreview.this.active.isSelected()) {
                    FilePreview.this.updatePreview(FilePreview.this.chooser.getSelectedFile());
                } else {
                    FilePreview.this.updatePreview(null);
                }
            }
        });
        box.add(this.active);
        this.display = new JmolPanel(jmolAdapter);
        this.display.setPreferredSize(new Dimension(80, 80));
        this.display.setMinimumSize(new Dimension(50, 50));
        box.add(this.display);
        this.append = new JCheckBox(GT._("Append models"), false);
        box.add(this.append);
        this.add(box);
        jFileChooser.setAccessory(this);
        jFileChooser.addPropertyChangeListener(this);
    }

    public boolean isAppendSelected() {
        if (this.append != null) {
            return this.append.isSelected();
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (this.active.isSelected() && "SelectedFileChangedProperty".equals(string = propertyChangeEvent.getPropertyName())) {
            this.updatePreview((File)propertyChangeEvent.getNewValue());
        }
    }

    void updatePreview(File file) {
        if (file != null) {
            this.display.getViewer().evalStringQuiet("load \"" + file.getAbsolutePath() + "\"");
            this.display.repaint();
        } else {
            this.display.getViewer().evalStringQuiet("zap");
        }
    }
}

