/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jmol.util.Logger;
import org.openscience.jmol.app.ConsoleTextPane;

class ConsoleDocument
extends DefaultStyledDocument {
    ConsoleTextPane consoleTextPane;
    SimpleAttributeSet attError = new SimpleAttributeSet();
    SimpleAttributeSet attEcho;
    SimpleAttributeSet attPrompt;
    SimpleAttributeSet attUserInput;
    SimpleAttributeSet attStatus;
    Position positionBeforePrompt;
    Position positionAfterPrompt;
    int offsetAfterPrompt;

    ConsoleDocument() {
        StyleConstants.setForeground(this.attError, Color.red);
        this.attPrompt = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attPrompt, Color.magenta);
        this.attUserInput = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attUserInput, Color.black);
        this.attEcho = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attEcho, Color.blue);
        StyleConstants.setBold(this.attEcho, true);
        this.attStatus = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attStatus, Color.black);
        StyleConstants.setItalic(this.attStatus, true);
    }

    void setConsoleTextPane(ConsoleTextPane consoleTextPane) {
        this.consoleTextPane = consoleTextPane;
    }

    void clearContent() {
        try {
            super.remove(0, this.getLength());
        }
        catch (BadLocationException badLocationException) {
            Logger.error("Could not clear script window content", badLocationException);
        }
    }

    void setPrompt() {
        try {
            super.insertString(this.getLength(), "$ ", this.attPrompt);
            this.setOffsetPositions();
            this.consoleTextPane.setCaretPosition(this.offsetAfterPrompt);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    void setOffsetPositions() {
        try {
            this.offsetAfterPrompt = this.getLength();
            this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt - 2);
            this.positionAfterPrompt = this.createPosition(this.offsetAfterPrompt - 1);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    void setNoPrompt() {
        try {
            this.offsetAfterPrompt = this.getLength();
            this.positionAfterPrompt = this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt);
            this.consoleTextPane.setCaretPosition(this.offsetAfterPrompt);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    void outputBeforePrompt(String string, SimpleAttributeSet simpleAttributeSet) {
        try {
            int n = this.consoleTextPane.getCaretPosition();
            Position position = this.createPosition(n);
            n = this.positionBeforePrompt.getOffset();
            super.insertString(n, string + "\n", simpleAttributeSet);
            this.offsetAfterPrompt += string.length() + 1;
            this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt - 2);
            this.positionAfterPrompt = this.createPosition(this.offsetAfterPrompt - 1);
            n = position.getOffset();
            this.consoleTextPane.setCaretPosition(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.consoleTextPane.setCaretPosition(this.getLength());
        }
    }

    void outputError(String string) {
        this.outputBeforePrompt(string, this.attError);
    }

    void outputErrorForeground(String string) {
        try {
            super.insertString(this.getLength(), string + "\n", this.attError);
            this.consoleTextPane.setCaretPosition(this.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    void outputEcho(String string) {
        this.outputBeforePrompt(string, this.attEcho);
    }

    void outputStatus(String string) {
        this.outputBeforePrompt(string, this.attStatus);
    }

    void appendNewline() {
        try {
            super.insertString(this.getLength(), "\n", this.attUserInput);
            this.consoleTextPane.setCaretPosition(this.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        int n2 = string.indexOf(10);
        if (n2 != 0) {
            if (n < this.offsetAfterPrompt) {
                n = this.getLength();
            }
            super.insertString(n, string, attributeSet == this.attError ? attributeSet : this.attUserInput);
            this.consoleTextPane.setCaretPosition(n + string.length());
        }
        if (n2 >= 0) {
            this.consoleTextPane.enterPressed();
        }
    }

    String getCommandString() {
        String string = "";
        try {
            int n = this.positionAfterPrompt.getOffset();
            string = this.getText(n, this.getLength() - n);
            while (string.length() > 0 && string.charAt(0) == ' ') {
                string = string.substring(1);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return string;
    }

    public void remove(int n, int n2) throws BadLocationException {
        if (n < this.offsetAfterPrompt) {
            if ((n2 -= this.offsetAfterPrompt - n) <= 0) {
                return;
            }
            n = this.offsetAfterPrompt;
        }
        super.remove(n, n2);
    }

    public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        if (n < this.offsetAfterPrompt) {
            if (n + n2 < this.offsetAfterPrompt) {
                n = this.getLength();
                n2 = 0;
            } else {
                n2 -= this.offsetAfterPrompt - n;
                n = this.offsetAfterPrompt;
            }
        }
        super.replace(n, n2, string, attributeSet);
    }

    void replaceCommand(String string, boolean bl) throws BadLocationException {
        if (this.positionAfterPrompt == this.positionBeforePrompt) {
            return;
        }
        this.replace(this.offsetAfterPrompt, this.getLength() - this.offsetAfterPrompt, string, bl ? this.attError : this.attUserInput);
    }

    void colorCommand(SimpleAttributeSet simpleAttributeSet) {
        if (this.positionAfterPrompt == this.positionBeforePrompt) {
            return;
        }
        this.setCharacterAttributes(this.offsetAfterPrompt, this.getLength() - this.offsetAfterPrompt, simpleAttributeSet, true);
    }
}

