/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.i18n.GT;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.util.Logger;
import org.jmol.viewer.Eval;
import org.jmol.viewer.Function;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

class Compiler {
    Hashtable localFunctions = new Hashtable();
    static Hashtable globalFunctions = new Hashtable();
    private Function thisFunction;
    private Viewer viewer;
    private String filename;
    private String script;
    private short[] lineNumbers;
    private int[] lineIndices;
    private Token[][] aatokenCompiled;
    private String errorMessage;
    private String errorLine;
    private boolean preDefining;
    private boolean isSilent;
    private boolean isShowScriptOutput;
    private boolean isCheckOnly;
    private Hashtable contextVariables;
    private boolean logMessages = false;
    private FlowContext flowContext;
    private int nSemiSkip = 0;
    private int cchScript;
    private short lineCurrent;
    private int ichToken;
    private int cchToken;
    private int iCommand;
    private int ichCurrentCommand;
    private boolean isNewSet;
    private boolean isSetBrace;
    private int ptNewSetModifier;
    private boolean iHaveQuotedString = false;
    private Vector ltoken;
    private Token lastToken;
    private boolean isShowCommand;
    static String[] loadFormats = new String[]{"append", "files", "trajectory", "menu", "alchemy", "mol2", "mopac", "nmrpdb", "charmm", "xyz", "mdl", "pdb"};
    boolean isImplicitExpression;
    boolean isSetOrDefine;
    Token tokenCommand;
    int tokCommand;
    Vector ltokenPostfix = null;
    Token[] atokenInfix;
    int itokenInfix;
    boolean isEmbeddedExpression;
    boolean isCommaAsOrAllowed;
    Token theToken;
    Object theValue;
    boolean haveString;
    private boolean residueSpecCodeGenerated;

    boolean isFunction(String string) {
        return (string.indexOf("_") == 0 ? this.localFunctions : globalFunctions).containsKey(string);
    }

    Compiler(Viewer viewer) {
        this.viewer = viewer;
    }

    boolean compile(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.isCheckOnly = bl4;
        this.filename = string;
        this.isSilent = bl2;
        this.script = Compiler.cleanScriptComments(string2);
        this.contextVariables = null;
        this.logMessages = !bl2 && !bl && bl3;
        this.preDefining = string == "#predefine";
        return this.compile0() || this.handleError();
    }

    String getScript() {
        return this.script;
    }

    short[] getLineNumbers() {
        return this.lineNumbers;
    }

    int[] getLineIndices() {
        return this.lineIndices;
    }

    Hashtable getContextVariables() {
        return this.contextVariables;
    }

    private void addContextVariable(String string) {
        if (this.thisFunction == null) {
            if (this.contextVariables == null) {
                this.contextVariables = new Hashtable();
            }
            this.contextVariables.put(string, new Token(4, ""));
        } else {
            this.thisFunction.addVariable(string, false);
        }
    }

    Token[][] getAatokenCompiled() {
        return this.aatokenCompiled;
    }

    static boolean tokAttr(int n, int n2) {
        return (n & n2) == n2;
    }

    static boolean tokAttrOr(int n, int n2, int n3) {
        return (n & n2) == n2 || (n & n3) == n3;
    }

    static int modelValue(String string) {
        int n = string.indexOf(".");
        if (n < 1 || string.charAt(0) == '-') {
            return Integer.MAX_VALUE;
        }
        int n2 = 0;
        int n3 = 0;
        if (n > 0 && (n2 = Integer.parseInt(string.substring(0, n))) < 0) {
            n2 = -n2;
        }
        if (n < string.length() - 1) {
            try {
                n3 = Integer.parseInt(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2 * 1000000 + n3;
    }

    private void log(String string) {
        if (this.logMessages) {
            Logger.debug(string);
        }
    }

    private static String cleanScriptComments(String string) {
        int n;
        String string2;
        int n2;
        int n3;
        while ((n3 = string.indexOf("/**")) >= 0 && (n2 = string.indexOf("**/", n3 + 3)) >= 0) {
            string2 = string.substring(n3, n2);
            n = string2.indexOf("**** Jmol Embedded Script ****");
            if (n >= 0) {
                return string2.substring(n + 30);
            }
            string = string.substring(0, n3) + string.substring(n2 + 3);
        }
        while ((n3 = string.indexOf("/*")) >= 0 && (n2 = string.indexOf("*/", n3 + 2)) >= 0) {
            string2 = string.substring(n3 + 2, n2);
            n = string2.indexOf("**** Jmol Embedded Script ****");
            if (n >= 0) {
                return string2.substring(n + 30);
            }
            string = string.substring(0, n3) + string.substring(n2 + 2);
        }
        return string;
    }

    private void addTokenToPrefix(Token token) {
        this.ltoken.addElement(token);
        this.lastToken = token;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean compile0() {
        this.lineNumbers = null;
        this.lineIndices = null;
        this.aatokenCompiled = null;
        this.errorLine = null;
        this.errorMessage = null;
        this.flowContext = null;
        this.nSemiSkip = 0;
        this.cchScript = this.script.length();
        this.ichToken = 0;
        this.lineCurrent = 1;
        this.iCommand = 0;
        int n = 8;
        int n2 = 0;
        int n3 = 0;
        this.lineNumbers = new short[n];
        this.lineIndices = new int[n];
        this.isSetBrace = false;
        this.isNewSet = false;
        this.ptNewSetModifier = 1;
        this.isShowScriptOutput = false;
        Vector<Token[]> vector = new Vector<Token[]>();
        this.ltoken = new Vector();
        int n4 = 0;
        while (true) {
            block88: {
                int n5;
                block105: {
                    Token token;
                    int n6;
                    block91: {
                        block104: {
                            block103: {
                                block102: {
                                    float f;
                                    block101: {
                                        block100: {
                                            block98: {
                                                int n7;
                                                block99: {
                                                    block97: {
                                                        block95: {
                                                            block96: {
                                                                block94: {
                                                                    block93: {
                                                                        block92: {
                                                                            block90: {
                                                                                block89: {
                                                                                    if ((n5 = this.ltoken.size()) == 0 && this.thisFunction != null && this.thisFunction.chpt0 == 0) {
                                                                                        this.thisFunction.chpt0 = this.ichToken;
                                                                                    }
                                                                                    if (this.lookingAtLeadingWhitespace() || this.lookingAtComment()) break block88;
                                                                                    boolean bl = this.lookingAtEndOfLine();
                                                                                    if (!bl && !this.lookingAtEndOfStatement()) break block89;
                                                                                    if (n5 > 0) {
                                                                                        this.iCommand = vector.size();
                                                                                        if (this.thisFunction != null && this.thisFunction.cmdpt0 < 0) {
                                                                                            this.thisFunction.cmdpt0 = this.iCommand;
                                                                                        }
                                                                                        if (!this.compileCommand()) {
                                                                                            return false;
                                                                                        }
                                                                                        if (!Compiler.tokAttr(n4, 8192) || this.atokenInfix[0].intValue <= 0) {
                                                                                            if (this.iCommand == n) {
                                                                                                short[] sArray = new short[n * 2];
                                                                                                System.arraycopy(this.lineNumbers, 0, sArray, 0, n);
                                                                                                this.lineNumbers = sArray;
                                                                                                int[] nArray = new int[n * 2];
                                                                                                System.arraycopy(this.lineIndices, 0, nArray, 0, n);
                                                                                                this.lineIndices = nArray;
                                                                                                n *= 2;
                                                                                            }
                                                                                            this.lineNumbers[this.iCommand] = this.lineCurrent;
                                                                                            this.lineIndices[this.iCommand] = this.ichCurrentCommand;
                                                                                            vector.addElement(this.atokenInfix);
                                                                                        }
                                                                                        this.ltoken.setSize(0);
                                                                                        n5 = 0;
                                                                                        n4 = 0;
                                                                                        this.tokenCommand = null;
                                                                                        this.iHaveQuotedString = false;
                                                                                    }
                                                                                    if (this.ichToken >= this.cchScript) {
                                                                                        this.aatokenCompiled = new Token[vector.size()][];
                                                                                        vector.copyInto((Object[])this.aatokenCompiled);
                                                                                        if (this.flowContext == null) return true;
                                                                                        return this.missingEnd(Token.nameOf(this.flowContext.token.tok));
                                                                                    }
                                                                                    if (bl) {
                                                                                        this.lineCurrent = (short)(this.lineCurrent + 1);
                                                                                    }
                                                                                    break block88;
                                                                                }
                                                                                if (n5 != 0) break block90;
                                                                                this.isSetBrace = false;
                                                                                this.isNewSet = false;
                                                                                this.ptNewSetModifier = 1;
                                                                                this.nSemiSkip = 0;
                                                                                n2 = 0;
                                                                                n3 = 0;
                                                                                break block91;
                                                                            }
                                                                            if (n5 != this.ptNewSetModifier) break block92;
                                                                            char c = this.script.charAt(this.ichToken);
                                                                            if (n4 != 169247 && !Compiler.tokAttr(n4, 65536) || (!Compiler.tokAttr(n4, 65536) || c != '=') && (!this.isNewSet && !this.isSetBrace || c != '=' && c != '[' && c != '.')) break block92;
                                                                            this.tokenCommand = c == '=' ? Token.tokenSet : (c == '[' ? Token.tokenSetArray : Token.tokenSetProperty);
                                                                            n4 = 169247;
                                                                            this.ltoken.insertElementAt(this.tokenCommand, 0);
                                                                            this.cchToken = 1;
                                                                            if (c == '[') {
                                                                                this.addTokenToPrefix(new Token(0x880010, "["));
                                                                            }
                                                                            if (c == '.') {
                                                                                this.addTokenToPrefix(new Token(524289, "."));
                                                                            }
                                                                            break block88;
                                                                        }
                                                                        if (!this.lookingAtString()) break block93;
                                                                        if (this.cchToken < 0) {
                                                                            return this.endOfCommandUnexpected();
                                                                        }
                                                                        String string = (n4 == 17305865 || n4 == 17301771) && !this.iHaveQuotedString ? this.script.substring(this.ichToken + 1, this.ichToken + this.cchToken - 1) : this.getUnescapedStringLiteral();
                                                                        this.addTokenToPrefix(new Token(4, string));
                                                                        this.iHaveQuotedString = true;
                                                                        if (n4 == 17301778 && string.indexOf("@") < 0 && !this.getData(string)) {
                                                                            return this.missingEnd("data");
                                                                        }
                                                                        break block88;
                                                                    }
                                                                    if (n4 != 375 || n5 != 1 || !this.charToken()) break block94;
                                                                    String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                                                                    this.addTokenToPrefix(new Token(1, string));
                                                                    break block88;
                                                                }
                                                                if (n4 != 17305865) break block95;
                                                                if (!this.lookingAtLoadFormat()) break block96;
                                                                String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                                                                if ((string = string.toLowerCase()).equals("append") || string.equals("files") || string.equals("menu") || string.equals("trajectory")) {
                                                                    this.addTokenToPrefix(new Token(1, string));
                                                                    break block88;
                                                                } else if (string.indexOf("=") == 0) {
                                                                    this.addTokenToPrefix(new Token(4, string));
                                                                }
                                                                break block88;
                                                            }
                                                            if (this.iHaveQuotedString || !this.lookingAtSpecialString()) break block95;
                                                            String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken).trim();
                                                            int n8 = string.indexOf(" ");
                                                            if (n8 > 0) {
                                                                this.cchToken = n8;
                                                                string = string.substring(0, n8);
                                                            }
                                                            this.addTokenToPrefix(new Token(4, string));
                                                            this.iHaveQuotedString = true;
                                                            break block88;
                                                        }
                                                        if (n4 != 17301771 || this.iHaveQuotedString || !this.lookingAtSpecialString()) break block97;
                                                        String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken).trim();
                                                        int n9 = string.indexOf(" ");
                                                        if (n9 > 0) {
                                                            this.cchToken = n9;
                                                            string = string.substring(0, n9);
                                                        }
                                                        this.addTokenToPrefix(new Token(4, string));
                                                        this.iHaveQuotedString = true;
                                                        break block88;
                                                    }
                                                    if (n4 != 301) break block98;
                                                    n7 = this.cchToken;
                                                    if (n5 <= 2 || this.iHaveQuotedString || !this.lookingAtSpecialString()) break block98;
                                                    String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken).trim();
                                                    if (string.indexOf(" ") >= 0) break block99;
                                                    this.addTokenToPrefix(new Token(4, string));
                                                    this.iHaveQuotedString = true;
                                                    break block88;
                                                }
                                                this.cchToken = n7;
                                            }
                                            if (!Compiler.tokAttr(n4, 2048) || n4 == 17301771 && this.iHaveQuotedString || !this.lookingAtSpecialString()) break block100;
                                            String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                                            this.addTokenToPrefix(new Token(4, string));
                                            break block88;
                                        }
                                        f = this.lookingAtExponential();
                                        if (Float.isNaN(f)) break block101;
                                        this.addTokenToPrefix(new Token(3, new Float(f)));
                                        break block88;
                                    }
                                    if (!this.lookingAtDecimal()) break block102;
                                    f = Float.valueOf(this.script.substring(this.ichToken, this.ichToken + this.cchToken)).floatValue();
                                    int n10 = Compiler.modelValue(this.script.substring(this.ichToken, this.ichToken + this.cchToken));
                                    this.ltoken.addElement(new Token(3, n10, new Float(f)));
                                    break block88;
                                }
                                if (!this.lookingAtSeqcode()) break block103;
                                char c = this.script.charAt(this.ichToken);
                                int n11 = c == '*' || c == '^' ? Integer.MAX_VALUE : Integer.parseInt(this.script.substring(this.ichToken, this.ichToken + this.cchToken - 2));
                                char c2 = this.script.charAt(this.ichToken + this.cchToken - 1);
                                if (c2 == '^') {
                                    c2 = ' ';
                                }
                                n6 = Group.getSeqcode(n11, c2);
                                this.addTokenToPrefix(new Token(5, n6, "seqcode"));
                                break block88;
                            }
                            if (!this.lookingAtInteger(Compiler.tokAttr(n4, 4096))) break block104;
                            String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                            int n12 = Integer.parseInt(string);
                            if (n4 == 16648 || n4 == 16649) {
                                if (n5 != 1) {
                                    return this.badArgumentCount();
                                }
                                FlowContext flowContext = this.getBreakableContext(n12 = Math.abs(n12));
                                if (flowContext == null) {
                                    return this.badContext((String)this.tokenCommand.value);
                                }
                                ((Token)this.ltoken.get((int)0)).intValue = flowContext.pt0;
                            }
                            this.addTokenToPrefix(new Token(2, n12, string));
                            break block88;
                        }
                        if (Compiler.tokenAttr(this.lastToken, 0x1080000)) break block91;
                        boolean bl = this.script.charAt(this.ichToken) == '[';
                        BitSet bitSet = this.lookingAtBitset();
                        if (bitSet == null) break block91;
                        if (bl) {
                            this.addTokenToPrefix(new Token(262215, new Bond.BondSet(bitSet)));
                            break block88;
                        } else {
                            this.addTokenToPrefix(new Token(262215, bitSet));
                        }
                        break block88;
                    }
                    if (!this.lookingAtLookupToken()) break block105;
                    String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                    if (string.length() == 1) {
                        token = Token.getTokenFromName(string);
                        if (token == null && (token = Token.getTokenFromName(string.toLowerCase())) != null) {
                            token = new Token(token.tok, token.intValue, string);
                        }
                    } else {
                        string = string.toLowerCase();
                        token = Token.getTokenFromName(string);
                    }
                    if (token == null) {
                        token = string.indexOf("property_") == 0 ? new Token(73990156, string.toLowerCase()) : new Token(1, string);
                    }
                    int n13 = token.tok;
                    switch (n4) {
                        case 0: {
                            this.ichCurrentCommand = this.ichToken;
                            this.tokenCommand = token;
                            n4 = n13;
                            if (Compiler.tokAttr(n4, 16384)) {
                                n6 = vector.size();
                                boolean bl = false;
                                boolean bl2 = true;
                                switch (n13) {
                                    case 24842: {
                                        if (this.flowContext == null) {
                                            return this.badContext("end");
                                        }
                                        bl = true;
                                        if (this.flowContext.token.tok == 17326337) break;
                                        token = new Token(n13, -this.flowContext.pt0, token.value);
                                        break;
                                    }
                                    case 54530: 
                                    case 54534: 
                                    case 54535: {
                                        break;
                                    }
                                    case 16645: {
                                        bl = true;
                                        if (this.flowContext == null) return this.badContext("endif");
                                        if (this.flowContext.token.tok == 54530 || this.flowContext.token.tok == 16644 || this.flowContext.token.tok == 54531) break;
                                        return this.badContext("endif");
                                    }
                                    case 16644: {
                                        if (this.flowContext == null) return this.badContext("else");
                                        if (this.flowContext.token.tok != 54530 && this.flowContext.token.tok != 54531) {
                                            return this.badContext("else");
                                        }
                                        this.flowContext.token.intValue = this.flowContext.pt0 = n6;
                                        break;
                                    }
                                    case 16648: 
                                    case 16649: {
                                        bl2 = false;
                                        FlowContext flowContext = this.getBreakableContext(0);
                                        if (flowContext == null) {
                                            return this.badContext((String)token.value);
                                        }
                                        token = new Token(n13, flowContext.pt0, token.value);
                                        break;
                                    }
                                    case 54531: {
                                        if (this.flowContext == null) return this.badContext("elseif");
                                        if (this.flowContext.token.tok != 54530 && this.flowContext.token.tok != 54531 && this.flowContext.token.tok != 16644) {
                                            return this.badContext("elseif");
                                        }
                                        this.flowContext.token.intValue = this.flowContext.pt0 = n6;
                                        break;
                                    }
                                    case 17326337: {
                                        if (this.flowContext == null) break;
                                        return this.badContext("function");
                                    }
                                }
                                if (bl) {
                                    this.flowContext.token.intValue = n6;
                                    if (n13 != 16645) break;
                                    this.flowContext = this.flowContext.parent;
                                    break;
                                }
                                if (!bl2) break;
                                token = new Token(n13, token.value);
                                if (n13 == 16644 || n13 == 54531) {
                                    this.flowContext.token = token;
                                    break;
                                }
                                this.flowContext = new FlowContext(token, n6, this.flowContext);
                                break;
                            }
                            if (Compiler.tokAttr(n4, 256)) break;
                            if (!Compiler.tokAttr(n13, 1) && !Compiler.tokAttr(n13, 65536)) {
                                return this.commandExpected();
                            }
                            n4 = 169247;
                            this.isSetBrace = n13 == 524291;
                            this.isNewSet = !this.isSetBrace;
                            n2 = this.isSetBrace ? 1 : 0;
                            n3 = 0;
                            this.ptNewSetModifier = this.isNewSet ? 1 : Integer.MAX_VALUE;
                            break;
                        }
                        case 17326337: {
                            if (this.tokenCommand.intValue == 0) {
                                if (n5 != 1) break;
                                this.tokenCommand.value = string;
                                break block88;
                            } else {
                                if (n5 == 1) {
                                    this.thisFunction = new Function(string);
                                    this.flowContext.setFunction(this.thisFunction);
                                    break;
                                }
                                if (n5 == 2) {
                                    if (n13 == 0x880000) break;
                                    return this.leftParenthesisExpected();
                                }
                                if (n5 == 3 && n13 == 0x880001) break;
                                if (n5 % 2 == 0) {
                                    if (n13 == 0x880008 || n13 == 0x880001) break;
                                    return this.commaOrCloseExpected();
                                }
                                this.thisFunction.addVariable(string, true);
                                break;
                            }
                        }
                        case 16644: {
                            if (n5 != 1) return this.badArgumentCount();
                            if (n13 != 54530) {
                                return this.badArgumentCount();
                            }
                            this.ltoken.removeElementAt(0);
                            token = new Token(54531, "elseif");
                            this.ltoken.addElement(token);
                            this.flowContext.token = token;
                            n4 = 54531;
                            break block88;
                        }
                        case 111994: {
                            if (n5 != 1) break;
                            this.addContextVariable(string);
                            this.ltoken.removeElementAt(0);
                            this.ltoken.addElement(Token.tokenSetVar);
                            n4 = 169247;
                            break;
                        }
                        case 24842: {
                            if (n5 != 1) {
                                return this.badArgumentCount();
                            }
                            if (this.flowContext == null || this.flowContext.token.tok != n13) {
                                if (n13 != 54530) return this.badContext("end " + string);
                                if (this.flowContext.token.tok != 16644 && this.flowContext.token.tok != 54531) {
                                    return this.badContext("end " + string);
                                }
                            }
                            switch (n13) {
                                case 54530: 
                                case 54534: 
                                case 54535: {
                                    break;
                                }
                                case 17326337: {
                                    if (!this.isCheckOnly) {
                                        (this.thisFunction.name.indexOf("_") == 0 ? this.localFunctions : globalFunctions).put(this.thisFunction.name, this.thisFunction);
                                    }
                                    this.flowContext.setFunction(this.script, this.ichCurrentCommand, vector.size(), this.lineNumbers, this.lineIndices, vector);
                                    this.thisFunction = null;
                                    this.tokenCommand.intValue = Integer.MAX_VALUE;
                                    this.flowContext = this.flowContext.parent;
                                    break block88;
                                }
                                default: {
                                    return this.unrecognizedToken("end " + string);
                                }
                            }
                            this.flowContext = this.flowContext.parent;
                            break;
                        }
                        case 54534: {
                            if (n5 == 1) {
                                if (n13 != 0x880000) {
                                    return this.unrecognizedToken(string);
                                }
                                this.nSemiSkip = 2;
                            }
                            if (n5 != 3 || ((Token)this.ltoken.get((int)2)).tok != 111994) break;
                            this.addContextVariable(string);
                            break;
                        }
                        case 169247: {
                            if (n13 == 524291) {
                                ++n2;
                            } else if (n13 == 524292 && this.isSetBrace && --n2 == 0 && this.ptNewSetModifier == Integer.MAX_VALUE) {
                                this.ptNewSetModifier = n5 + 1;
                            }
                            if (n5 != this.ptNewSetModifier) break;
                            n6 = 0;
                            if (n13 == 42467380 || n13 == 0x880010) {
                                token = (Token)this.ltoken.get(0);
                                this.ltoken.removeElementAt(0);
                                n6 = n13 == 0x880010 ? 1 : 0;
                                this.ltoken.addElement(n6 != 0 ? Token.tokenSetArray : Token.tokenSet);
                                n13 = token.tok;
                                n4 = 169247;
                            }
                            if (n13 == 0x880000) {
                                token = (Token)this.ltoken.get(0);
                                this.ltoken.removeElementAt(0);
                                this.tokenCommand = new Token(17326337, 0, token.value);
                                this.ltoken.add(0, this.tokenCommand);
                                n4 = 17326337;
                                token = Token.tokenLeftParen;
                                n13 = 0x880000;
                                break;
                            }
                            if (n13 != 1 && !Compiler.tokAttr(n13, 65536)) {
                                boolean bl;
                                if (this.isNewSet) {
                                    bl = this.commandExpected();
                                    return bl;
                                }
                                bl = this.unrecognizedParameter("SET", string);
                                return bl;
                            }
                            if (n6 == 0) break;
                            this.addTokenToPrefix(token);
                            token = Token.tokenArraySelector;
                            n13 = 0x880010;
                            break;
                        }
                        case 590601: {
                            if (n5 == 1) {
                                if (n13 == 1) break;
                                if (this.preDefining) {
                                    if (Compiler.tokAttr(n13, 0x180000)) break;
                                    return this.compileError("ERROR IN Token.java or JmolConstants.java -- the following term was used in JmolConstants.java but not listed as predefinedset in Token.java: " + string);
                                }
                                if (Compiler.tokAttr(n13, 0x180000)) {
                                    Logger.warn("WARNING: predefined term '" + string + "' has been redefined by the user until the next file load.");
                                    break;
                                }
                                if (this.isCheckOnly || string.length() <= 1) break;
                                Logger.warn("WARNING: redefining " + string + "; was " + token + "not all commands may continue to be functional for the life of the applet!");
                                token.tok = 1;
                                n13 = 1;
                                Token.addToken(string, token);
                                break;
                            }
                            if (n5 == 2 && n13 == 42467380) {
                                this.ltoken.insertElementAt(Token.tokenSet, 0);
                                break block88;
                            } else {
                                if (n13 == 1 || n13 == 169247 || Compiler.tokAttr(n13, 524288)) break;
                                return this.invalidExpressionToken(string);
                            }
                        }
                        case 772: {
                            if (n13 == 1 || n13 == 524293 || Compiler.tokAttr(n13, 524288)) break;
                            return this.invalidExpressionToken(string);
                        }
                        case 793: 
                        case 798: 
                        case 847: 
                        case 66411: {
                            if (n13 == 0x880010) {
                                ++n3;
                            }
                            if (n13 == 0x880011) {
                                --n3;
                            }
                            if (n13 == 1 || Compiler.tokAttr(n13, 524288) || n13 == 64 || n13 == 128 || n3 != 0) break;
                            return this.invalidExpressionToken(string);
                        }
                    }
                    this.addTokenToPrefix(token);
                    break block88;
                }
                if (n5 == 0) return this.commandExpected();
                if (!this.isNewSet) {
                    if (!this.isSetBrace) return this.unrecognizedToken(this.script.substring(this.ichToken, this.ichToken + 1));
                }
                if (n5 != this.ptNewSetModifier) return this.unrecognizedToken(this.script.substring(this.ichToken, this.ichToken + 1));
                return this.commandExpected();
            }
            this.ichToken += this.cchToken;
        }
    }

    private FlowContext getBreakableContext(int n) {
        FlowContext flowContext = this.flowContext;
        while (flowContext != null && (flowContext.token.tok != 54534 && flowContext.token.tok != 54535 || n-- > 0)) {
            flowContext = flowContext.parent;
        }
        return flowContext;
    }

    private boolean getData(String string) {
        int n;
        this.ichToken += string.length() + 2;
        if (this.script.length() > this.ichToken && this.script.charAt(this.ichToken) == '\r') {
            ++this.ichToken;
        }
        if (this.script.length() > this.ichToken && this.script.charAt(this.ichToken) == '\n') {
            ++this.ichToken;
        }
        if ((n = this.script.indexOf("\"" + string + "\"", this.ichToken) - 4) < 0 || !this.script.substring(n, n + 4).equalsIgnoreCase("END ")) {
            return false;
        }
        String string2 = this.script.substring(this.ichToken, n);
        this.addTokenToPrefix(new Token(17301778, string2));
        this.addTokenToPrefix(new Token(1, "end"));
        this.addTokenToPrefix(new Token(4, string));
        this.cchToken = n - this.ichToken + string.length() + 6;
        return true;
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private boolean eol(char c) {
        return c == '\r' || c == '\n' || c == ';' && this.nSemiSkip <= 0;
    }

    private boolean lookingAtLeadingWhitespace() {
        char c;
        int n;
        for (n = this.ichToken; n < this.cchScript && Compiler.isSpaceOrTab(this.script.charAt(n)); ++n) {
        }
        if (n < this.cchScript - 1 && this.script.charAt(n) == '\\' && ((c = this.script.charAt(n + 1)) == '\r' || c == '\n')) {
            while (++n < this.cchScript && ((c = this.script.charAt(n)) == '\r' || c == '\n')) {
            }
        }
        this.cchToken = n - this.ichToken;
        return this.cchToken > 0;
    }

    private boolean lookingAtComment() {
        int n;
        int n2 = 88;
        int n3 = -1;
        if (this.ichToken == this.ichCurrentCommand && this.ichToken < this.cchScript && this.script.charAt(this.ichToken) == '$') {
            this.isShowScriptOutput = true;
            for (n = this.ichToken; n2 != 93 && n < this.cchScript; ++n) {
                char c = this.script.charAt(n);
                n2 = c;
                if (this.eol(c)) break;
            }
            this.cchToken = n - this.ichToken;
            this.isShowCommand = true;
            return true;
        }
        if (this.isShowScriptOutput) {
            if (!this.isShowCommand) {
                n3 = this.ichToken;
            }
            if (this.ichToken >= this.cchScript || this.eol(this.script.charAt(this.ichToken))) {
                this.isShowCommand = false;
                return false;
            }
        }
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n2 = c;
            if (this.eol(c)) break;
            if (n2 == 35 && n3 == -1) {
                n3 = n;
            }
            ++n;
        }
        if (n3 == -1) {
            return false;
        }
        if (this.cchScript - n3 >= 3 && this.script.charAt(n3 + 1) == 'j' && this.script.charAt(n3 + 2) == 'c') {
            this.cchToken = n - this.ichToken;
            return true;
        }
        if (n3 != this.ichToken) {
            return false;
        }
        if (this.cchScript > this.ichToken + 3 && this.script.charAt(this.ichToken + 1) == 'j' && this.script.charAt(this.ichToken + 2) == 'x' && Compiler.isSpaceOrTab(this.script.charAt(this.ichToken + 3))) {
            this.cchToken = 4;
            return true;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean lookingAtEndOfLine() {
        if (this.ichToken >= this.cchScript) {
            return true;
        }
        int n = this.ichToken;
        char c = this.script.charAt(n);
        if (c == '\r') {
            if (++n < this.cchScript && this.script.charAt(n) == '\n') {
                ++n;
            }
        } else if (c == '\n') {
            ++n;
        } else {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean lookingAtEndOfStatement() {
        if (this.ichToken == this.cchScript || this.script.charAt(this.ichToken) != ';' || this.nSemiSkip-- > 0) {
            return false;
        }
        this.cchToken = 1;
        return true;
    }

    private boolean lookingAtString() {
        char c;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        if (this.script.charAt(this.ichToken) != '\"') {
            return false;
        }
        int n = this.ichToken;
        boolean bl = false;
        while (++n < this.cchScript && ((c = this.script.charAt(n)) != '\"' || bl)) {
            bl = c == '\\' ? !bl : false;
        }
        this.cchToken = n == this.cchScript ? -1 : ++n - this.ichToken;
        return true;
    }

    String getUnescapedStringLiteral() {
        if (this.cchToken < 2) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(this.cchToken - 2);
        int n = this.ichToken + this.cchToken - 1;
        int n2 = this.ichToken + 1;
        while (n2 < n) {
            int n3;
            if ((n3 = this.script.charAt(n2++)) == 92 && n2 < n) {
                n3 = this.script.charAt(n2++);
                switch (n3) {
                    case 98: {
                        n3 = 8;
                        break;
                    }
                    case 110: {
                        n3 = 10;
                        break;
                    }
                    case 116: {
                        n3 = 9;
                        break;
                    }
                    case 114: {
                        n3 = 13;
                    }
                    case 34: 
                    case 39: 
                    case 92: {
                        break;
                    }
                    case 117: 
                    case 120: {
                        char c;
                        int n4;
                        int n5;
                        int n6 = n5 = n3 == 120 ? 2 : 4;
                        if (n2 >= n) break;
                        int n7 = 0;
                        int n8 = n5;
                        while (--n8 >= 0 && n2 < n && (n4 = Compiler.getHexitValue(c = this.script.charAt(n2))) >= 0) {
                            n7 <<= 4;
                            n7 += n4;
                            ++n2;
                        }
                        n3 = (char)n7;
                    }
                }
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    static int getHexitValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        return -1;
    }

    private boolean lookingAtLoadFormat() {
        String string = this.script.substring(this.ichToken, Math.min(this.cchScript, this.ichToken + 10)).toLowerCase();
        int n = loadFormats.length;
        while (--n >= 0) {
            int n2;
            String string2 = loadFormats[n];
            int n3 = string2.length();
            if (string.indexOf(string2) != 0 || (n2 = this.ichToken + n3) >= this.cchScript || !Compiler.isSpaceOrTab(this.script.charAt(n2))) continue;
            this.cchToken = n3;
            return true;
        }
        return false;
    }

    private boolean lookingAtSpecialString() {
        int n;
        for (n = this.ichToken; n < this.cchScript && !this.eol(this.script.charAt(n)); ++n) {
        }
        if (n > this.ichToken && this.script.charAt(this.ichToken) == '@' && (n <= this.ichToken + 1 || this.script.charAt(this.ichToken + 1) != '{')) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        this.log("lookingAtSpecialString cchToken=" + this.cchToken);
        return this.cchToken > 0;
    }

    private float lookingAtExponential() {
        boolean bl;
        boolean bl2;
        if (this.ichToken == this.cchScript) {
            return Float.NaN;
        }
        int n = this.ichToken;
        boolean bl3 = bl2 = this.script.charAt(n) == '-';
        if (bl2) {
            ++n;
        }
        int n2 = n;
        boolean bl4 = false;
        int n3 = 88;
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n3 = c;
            if (!Character.isDigit(c)) break;
            ++n;
            bl4 = true;
        }
        if (n < this.cchScript && n3 == 46) {
            ++n;
        }
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n3 = c;
            if (!Character.isDigit(c)) break;
            ++n;
            bl4 = true;
        }
        if (n == this.cchScript || !bl4) {
            return Float.NaN;
        }
        int n4 = n;
        int n5 = 1;
        int n6 = 0;
        boolean bl5 = bl = n3 == 69 || n3 == 101;
        if (!bl || ++n == this.cchScript) {
            return Float.NaN;
        }
        n3 = this.script.charAt(n);
        if (n3 == 45 || n3 == 43) {
            ++n;
            int n7 = n5 = n3 == 45 ? -1 : 1;
        }
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n3 = c;
            if (!Character.isDigit(c)) break;
            ++n;
            n6 = n6 * 10 + n3 - 48;
        }
        if (n6 == 0) {
            return Float.NaN;
        }
        this.cchToken = n - this.ichToken;
        double d = Float.valueOf(this.script.substring(n2, n4)).doubleValue();
        return (float)(d *= (double)(bl2 ? -1 : 1) * Math.pow(10.0, n5 * n6));
    }

    private boolean lookingAtDecimal() {
        char c;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int n = this.ichToken;
        if (this.script.charAt(n) == '-') {
            ++n;
        }
        boolean bl = false;
        int n2 = 88;
        while (n < this.cchScript) {
            char c2 = this.script.charAt(n++);
            n2 = c2;
            if (!Character.isDigit(c2)) break;
            bl = true;
        }
        if (n2 != 46) {
            return false;
        }
        if (n < this.cchScript && !this.eol(c = this.script.charAt(n))) {
            if (Character.isLetter(c) || c == '?') {
                return false;
            }
            if (n + 1 < this.cchScript && (Character.isLetter(c = this.script.charAt(n + 1)) || c == '?')) {
                return false;
            }
        }
        while (n < this.cchScript && Character.isDigit(this.script.charAt(n))) {
            ++n;
            bl = true;
        }
        this.cchToken = n - this.ichToken;
        return bl;
    }

    private boolean lookingAtSeqcode() {
        int n;
        char c = ' ';
        if (n + 1 < this.cchScript && this.script.charAt(n) == '*' && this.script.charAt(n + 1) == '^') {
            c = '^';
            ++n;
        } else {
            for (n = this.ichToken; n < this.cchScript; ++n) {
                char c2 = this.script.charAt(n);
                c = c2;
                if (!Character.isDigit(c2)) break;
            }
        }
        if (c != '^') {
            return false;
        }
        if ((c = ++n == this.cchScript ? (char)' ' : (char)this.script.charAt(n++)) != ' ' && c != '*' && c != '?' && !Character.isLetter(c)) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean lookingAtInteger(boolean bl) {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int n = this.ichToken;
        if (bl && this.script.charAt(this.ichToken) == '-') {
            ++n;
        }
        int n2 = n;
        while (n < this.cchScript && Character.isDigit(this.script.charAt(n))) {
            ++n;
        }
        if (n2 == n) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    BitSet lookingAtBitset() {
        int n;
        if (this.script.indexOf("({null})", this.ichToken) == this.ichToken) {
            this.cchToken = 8;
            return new BitSet();
        }
        if (this.ichToken + 4 > this.cchScript || this.script.charAt(this.ichToken + 1) != '{' || this.script.charAt(this.ichToken) != '(' && this.script.charAt(this.ichToken) != '[') {
            return null;
        }
        char c = this.script.charAt(this.ichToken) == '(' ? (char)')' : ']';
        char c2 = ' ';
        for (n = this.ichToken + 2; n < this.cchScript; ++n) {
            char c3 = this.script.charAt(n);
            c2 = c3;
            if (c3 == '}' || !Character.isDigit(c2) && !Compiler.isSpaceOrTab(c2) && c2 != 58) break;
        }
        if (c2 != '}' || n + 1 == this.cchScript || this.script.charAt(n + 1) != c) {
            return null;
        }
        int n2 = -1;
        int n3 = 0;
        BitSet bitSet = new BitSet();
        int n4 = this.ichToken + 2;
        while (n4 < n) {
            while (Compiler.isSpaceOrTab(c2 = this.script.charAt(n4))) {
                ++n4;
            }
            n3 = n4;
            while (Character.isDigit(c2 = this.script.charAt(n3))) {
                ++n3;
            }
            if (n3 == n4) {
                return null;
            }
            int n5 = Integer.parseInt(this.script.substring(n4, n3));
            if (c2 == ':') {
                n2 = n5;
            } else {
                if (n2 >= 0) {
                    if (n2 > n5) {
                        return null;
                    }
                    for (int i = n2; i <= n5; ++i) {
                        bitSet.set(i);
                    }
                } else {
                    bitSet.set(n5);
                }
                n2 = -1;
            }
            n4 = ++n3;
        }
        if (n2 >= 0) {
            return null;
        }
        this.cchToken = n + 2 - this.ichToken;
        return bitSet;
    }

    private boolean lookingAtLookupToken() {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int n = this.ichToken;
        char c = this.script.charAt(n++);
        switch (c) {
            case '$': 
            case '%': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case ':': 
            case ';': 
            case '@': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                break;
            }
            case '&': 
            case '|': {
                if (n >= this.cchScript || this.script.charAt(n) != c) break;
                ++n;
                break;
            }
            case '<': 
            case '=': 
            case '>': {
                if (n >= this.cchScript || (c = this.script.charAt(n)) != '<' && c != '=' && c != '>') break;
                ++n;
                break;
            }
            case '!': 
            case '/': {
                if (n >= this.cchScript || this.script.charAt(n) != '=') break;
                ++n;
                break;
            }
            default: {
                if (!Character.isLetter(c)) {
                    return false;
                }
            }
            case '\'': 
            case '?': 
            case '_': 
            case '~': {
                while (n < this.cchScript && (Character.isLetterOrDigit(c = this.script.charAt(n)) || c == '_' || c == '?' || c == '~' || c == '\'') || c == '^' && n > this.ichToken && Character.isDigit(this.script.charAt(n - 1))) {
                    ++n;
                }
                break block0;
            }
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean charToken() {
        int n;
        char c;
        if (this.ichToken == this.cchScript || (c = this.script.charAt(this.ichToken)) == '\"' || c == '@') {
            return false;
        }
        for (n = this.ichToken; n < this.cchScript && !Compiler.isSpaceOrTab(c = this.script.charAt(n)) && c != '#' && !this.eol(c); ++n) {
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean compileCommand() {
        int n;
        int n2;
        this.tokenCommand = (Token)this.ltoken.firstElement();
        this.tokCommand = this.tokenCommand.tok;
        this.isImplicitExpression = Compiler.tokAttr(this.tokCommand, 37888);
        this.isSetOrDefine = this.tokCommand == 169247 || this.tokCommand == 590601;
        this.isCommaAsOrAllowed = Compiler.tokAttr(this.tokCommand, 512);
        int n3 = this.ltoken.size();
        if (n3 == 1 && !Compiler.tokAttr(this.tokCommand, 16384) && this.tokenCommand.intValue != Integer.MAX_VALUE && Compiler.tokAttr(this.tokenCommand.intValue, 33)) {
            this.addTokenToPrefix(Token.tokenOn);
        }
        this.atokenInfix = new Token[this.ltoken.size()];
        this.ltoken.copyInto(this.atokenInfix);
        if (this.logMessages) {
            for (n2 = 0; n2 < this.atokenInfix.length; ++n2) {
                Logger.debug(n2 + ": " + this.atokenInfix[n2]);
            }
        }
        if (Compiler.tokAttr(this.tokCommand, 131072) && !this.compileColorParam()) {
            return false;
        }
        this.isEmbeddedExpression = Compiler.tokAttr(this.tokCommand, 1024);
        n2 = Compiler.tokAttrOr(this.tokCommand, 512, 1024) ? 1 : 0;
        if (this.tokCommand == 772 && this.tokAt(1) == 524293) {
            n2 = 0;
        }
        if (n2 != 0 && !this.compileExpression()) {
            return false;
        }
        n3 = this.atokenInfix.length;
        int n4 = 0;
        for (n = 1; n < n3; ++n) {
            if (this.tokAt(n) != 590601) continue;
            ++n4;
        }
        if (this.isNewSet && (n3 -= n4) == 1) {
            this.atokenInfix[0] = new Token(17326337, 0, this.atokenInfix[0].value);
            this.isNewSet = false;
        }
        if ((this.isNewSet || this.isSetBrace) && n3 < this.ptNewSetModifier + 2) {
            return this.commandExpected();
        }
        if (this.isSetOrDefine || Compiler.tokAttrOr(this.tokenCommand.tok, 8192, 16384)) {
            return true;
        }
        n = (this.tokenCommand.intValue & 0xF) + 1;
        if (!Compiler.tokAttr(this.tokenCommand.intValue, 16)) {
            if (n3 > n) {
                return this.badArgumentCount();
            }
            if (n3 < n) {
                return this.endOfCommandUnexpected();
            }
        } else if (n > 1 && n3 > n) {
            return this.badArgumentCount();
        }
        return true;
    }

    private boolean compileExpression() {
        int n = this.isSetOrDefine && !this.isSetBrace ? 2 : 1;
        this.ltokenPostfix = new Vector();
        this.itokenInfix = 0;
        for (int i = 0; i < n && this.addNextToken(); ++i) {
        }
        while (this.moreTokens()) {
            if (this.isEmbeddedExpression) {
                while (!this.isExpressionNext() && this.addNextToken()) {
                }
                if (!this.moreTokens()) break;
            }
            if (this.lastToken.tok == 590601) {
                if (this.clauseDefine()) continue;
                return false;
            }
            if (!this.isImplicitExpression) {
                this.addTokenToPostfix(Token.tokenExpressionBegin);
            }
            if (!this.clauseOr(this.isCommaAsOrAllowed || !this.isImplicitExpression && this.tokPeek(0x880000))) {
                return false;
            }
            if (!(this.isImplicitExpression || this.isEmbeddedExpression && this.lastToken == Token.tokenCoordinateEnd)) {
                this.addTokenToPostfix(Token.tokenExpressionEnd);
            }
            if (!this.moreTokens() || this.isEmbeddedExpression) continue;
            return this.endOfExpressionExpected();
        }
        this.atokenInfix = new Token[this.ltokenPostfix.size()];
        this.ltokenPostfix.copyInto(this.atokenInfix);
        return true;
    }

    private boolean isExpressionNext() {
        return this.tokPeek(524291) || !this.isImplicitExpression && this.tokPeek(0x880000);
    }

    private static boolean tokenAttr(Token token, int n) {
        return token != null && (token.tok & n) == n;
    }

    private boolean moreTokens() {
        return this.itokenInfix < this.atokenInfix.length;
    }

    private int tokAt(int n) {
        return n < this.atokenInfix.length ? this.atokenInfix[n].tok : 0;
    }

    private int tokPeek() {
        if (this.itokenInfix >= this.atokenInfix.length) {
            return 0;
        }
        return this.atokenInfix[this.itokenInfix].tok;
    }

    private boolean tokPeek(int n) {
        if (this.itokenInfix >= this.atokenInfix.length) {
            return false;
        }
        return this.atokenInfix[this.itokenInfix].tok == n;
    }

    private int intPeek() {
        if (this.itokenInfix >= this.atokenInfix.length) {
            return Integer.MAX_VALUE;
        }
        return this.atokenInfix[this.itokenInfix].intValue;
    }

    private Object valuePeek() {
        if (this.moreTokens()) {
            return this.atokenInfix[this.itokenInfix].value;
        }
        return "";
    }

    private Token tokenNext() {
        if (this.itokenInfix >= this.atokenInfix.length) {
            return null;
        }
        return this.atokenInfix[this.itokenInfix++];
    }

    private boolean tokenNext(int n) {
        Token token = this.tokenNext();
        return token != null && token.tok == n;
    }

    private boolean returnToken() {
        --this.itokenInfix;
        return false;
    }

    private Token getToken() {
        this.theToken = this.tokenNext();
        this.theValue = this.theToken == null ? null : this.theToken.value;
        return this.theToken;
    }

    private boolean isToken(int n) {
        return this.theToken != null && this.theToken.tok == n;
    }

    private boolean getNumericalToken() {
        return this.getToken() != null && (this.isToken(2) || this.isToken(3));
    }

    private float floatValue() {
        switch (this.theToken.tok) {
            case 2: {
                return this.theToken.intValue;
            }
            case 3: {
                return ((Float)this.theValue).floatValue();
            }
        }
        return 0.0f;
    }

    private boolean addTokenToPostfix(int n, Object object) {
        return this.addTokenToPostfix(new Token(n, object));
    }

    private boolean addTokenToPostfix(int n, int n2, Object object) {
        return this.addTokenToPostfix(new Token(n, n2, object));
    }

    private boolean addTokenToPostfix(Token token) {
        if (token == null) {
            return false;
        }
        if (this.logMessages) {
            this.log("addTokenToPostfix" + token);
        }
        this.ltokenPostfix.addElement(token);
        this.lastToken = token;
        return true;
    }

    private boolean addNextToken() {
        return this.addTokenToPostfix(this.tokenNext());
    }

    private boolean addNextTokenIf(int n) {
        return this.tokPeek(n) && this.addNextToken();
    }

    private boolean addSubstituteTokenIf(int n, Token token) {
        if (!this.tokPeek(n)) {
            return false;
        }
        ++this.itokenInfix;
        return this.addTokenToPostfix(token);
    }

    private boolean clauseOr(boolean bl) {
        int n;
        this.haveString = false;
        if (!this.clauseAnd()) {
            return false;
        }
        while ((n = this.tokPeek()) == 0x880018 || n == 8912921 || n == 8912922 || bl && n == 0x880008) {
            if (n == 0x880008 && !this.haveString) {
                this.addSubstituteTokenIf(0x880008, Token.tokenOr);
            } else {
                this.addNextToken();
            }
            if (this.clauseAnd()) continue;
            return false;
        }
        return true;
    }

    private boolean clauseAnd() {
        if (!this.clauseNot()) {
            return false;
        }
        while (this.tokPeek(0x880020)) {
            this.addNextToken();
            if (this.clauseNot()) continue;
            return false;
        }
        return true;
    }

    private boolean clauseNot() {
        if (this.tokPeek(0x880028)) {
            this.addNextToken();
            return this.clauseNot();
        }
        return this.clausePrimitive();
    }

    private boolean clausePrimitive() {
        int n = this.tokPeek();
        switch (n) {
            case 1: 
            case 5: 
            case 524290: 
            case 0x880010: 
            case 0x880038: 
            case 8912961: 
            case 8912962: {
                if (this.clauseResidueSpec()) {
                    return true;
                }
            }
            default: {
                if (Compiler.tokAttrOr(n, 73990156, 0x280000)) {
                    return this.clauseComparator();
                }
                if (!Compiler.tokAttr(n, 0x180000)) break;
            }
            case 262215: 
            case 524301: 
            case 524303: 
            case 524306: {
                return this.addNextToken();
            }
            case 2: {
                if (this.clauseResidueSpec()) {
                    return true;
                }
            }
            case 0x880040: {
                this.addNextToken();
                return true;
            }
            case 4: {
                this.haveString = true;
                return this.addNextToken();
            }
            case 590601: {
                this.addNextToken();
                switch (this.tokPeek()) {
                    case 0: {
                        break;
                    }
                    default: {
                        return this.clauseDefine();
                    }
                }
            }
            case 0: {
                return this.endOfCommandUnexpected();
            }
            case 591122: 
            case 6881282: {
                this.addNextToken();
                if (this.tokPeek(262215)) {
                    this.addNextToken();
                } else if (this.tokPeek(590601)) {
                    this.addNextToken();
                    return this.clauseDefine();
                }
                return true;
            }
            case 2621445: {
                return this.clauseCell();
            }
            case 17301545: {
                this.addNextToken();
                return this.clauseWithin();
            }
            case 17301546: {
                this.addNextToken();
                return this.clauseConnected();
            }
            case 17301514: {
                this.addNextToken();
                return this.clauseSubstructure();
            }
            case 3: {
                return this.addTokenToPostfix(524319, this.getToken().intValue, this.theValue);
            }
            case 0x880000: {
                this.addNextToken();
                if (!this.clauseOr(true)) {
                    return false;
                }
                if (!this.addNextTokenIf(0x880001)) {
                    return this.rightParenthesisExpected();
                }
                return this.checkForItemSelector();
            }
            case 524291: {
                return this.checkForCoordinate(this.isImplicitExpression);
            }
        }
        return this.unrecognizedExpressionToken();
    }

    private boolean checkForCoordinate(boolean bl) {
        boolean bl2 = false;
        int n = this.ltokenPostfix.size();
        if (bl) {
            this.addTokenToPostfix(Token.tokenExpressionBegin);
            this.tokenNext();
        } else if (this.isEmbeddedExpression) {
            this.tokenNext();
            --n;
        } else {
            this.addNextToken();
        }
        if (!this.clauseOr(false)) {
            return false;
        }
        int n2 = 1;
        while (!this.tokPeek(524292)) {
            boolean bl3 = this.addNextTokenIf(0x880008);
            if (!this.clauseOr(false)) {
                return bl3 || n2 < 3 ? false : this.rightBraceExpected();
            }
            ++n2;
        }
        boolean bl4 = bl2 = n2 >= 2;
        if (bl2 && (bl || this.isEmbeddedExpression)) {
            this.ltokenPostfix.set(n, Token.tokenCoordinateBegin);
            this.addTokenToPostfix(Token.tokenCoordinateEnd);
            this.tokenNext();
        } else if (bl) {
            this.addTokenToPostfix(Token.tokenExpressionEnd);
            this.tokenNext();
        } else if (this.isEmbeddedExpression) {
            this.tokenNext();
        } else {
            this.addNextToken();
        }
        return this.checkForItemSelector();
    }

    private boolean checkForItemSelector() {
        for (int i = 0; i < 2 && this.addNextTokenIf(0x880010); ++i) {
            if (!this.clauseItemSelector()) {
                return false;
            }
            if (this.addNextTokenIf(0x880011)) continue;
            return this.rightBracketExpected();
        }
        return true;
    }

    private boolean clauseWithin() {
        if (!this.addNextTokenIf(0x880000)) {
            return false;
        }
        if (this.getToken() == null) {
            return false;
        }
        float f = Float.MAX_VALUE;
        String string = null;
        switch (this.theToken.tok) {
            case 0x880038: {
                if (this.getToken() == null) {
                    return false;
                }
                if (this.theToken.tok != 2) {
                    return this.numberExpected();
                }
                f = -this.theToken.intValue;
                break;
            }
            case 2: 
            case 3: {
                f = this.floatValue();
                break;
            }
            case 4: 
            case 524296: 
            case 524297: 
            case 524300: 
            case 2621446: 
            case 2621454: 
            case 2621459: 
            case 2621709: 
            case 6886669: 
            case 17303586: {
                string = (String)this.theValue;
                break;
            }
            case 1: {
                string = ((String)this.theValue).toLowerCase();
                break;
            }
            default: {
                return this.unrecognizedParameter("WITHIN", "" + this.theToken.value);
            }
        }
        if (string == null) {
            this.addTokenToPostfix(3, new Float(f));
        } else {
            this.addTokenToPostfix(4, string);
        }
        while (this.addNextTokenIf(0x880008)) {
            int n = this.tokPeek();
            if (f != Float.MAX_VALUE && (n == 524305 || n == 524304)) {
                this.addTokenToPostfix(this.getToken());
                if (!this.addNextTokenIf(0x880008)) break;
                n = this.tokPeek();
            }
            boolean bl = false;
            if (string == null) {
                if (n == 1) {
                    this.getToken();
                    string = ((String)this.theValue).toLowerCase();
                    if (string.equals("hkl")) {
                        bl = true;
                        this.addTokenToPostfix(4, string);
                    } else {
                        this.returnToken();
                    }
                } else if (n == 524300 || n == 17303586) {
                    bl = true;
                    this.addNextToken();
                } else if (n == 524291) {
                    this.returnToken();
                    bl = true;
                    this.addTokenToPostfix(Token.getTokenFromName(f == Float.MAX_VALUE ? "plane" : "coord"));
                }
            }
            this.addNextTokenIf(0x880008);
            n = this.tokPeek();
            if (bl) {
                block12: while (!this.tokPeek(0x880001)) {
                    switch (this.tokPeek()) {
                        case 0: {
                            return this.endOfCommandUnexpected();
                        }
                        case 0x880000: {
                            this.addTokenToPostfix(Token.tokenExpressionBegin);
                            this.addNextToken();
                            if (!this.clauseOr(false)) {
                                return this.unrecognizedParameter("WITHIN", "?");
                            }
                            if (!this.addNextTokenIf(0x880001)) {
                                return this.commaOrCloseExpected();
                            }
                            this.addTokenToPostfix(Token.tokenExpressionEnd);
                            continue block12;
                        }
                        case 590601: {
                            this.addTokenToPostfix(this.getToken());
                            if (this.clauseDefine()) continue block12;
                            return false;
                        }
                    }
                    this.addTokenToPostfix(this.getToken());
                }
                continue;
            }
            if (this.clauseOr(true)) continue;
            return this.endOfCommandUnexpected();
        }
        if (!this.addNextTokenIf(0x880001)) {
            return this.rightParenthesisExpected();
        }
        return true;
    }

    private boolean clauseConnected() {
        block10: {
            block11: {
                String string;
                block12: {
                    if (!this.addNextTokenIf(0x880000)) {
                        this.addTokenToPostfix(Token.tokenLeftParen);
                        this.addTokenToPostfix(Token.tokenRightParen);
                        return true;
                    }
                    if (this.addNextTokenIf(2) && !this.addNextTokenIf(0x880008) || this.addNextTokenIf(2) && !this.addNextTokenIf(0x880008) || this.addNextTokenIf(3) && !this.addNextTokenIf(0x880008) || this.addNextTokenIf(3) && !this.addNextTokenIf(0x880008)) break block10;
                    if (this.tokPeek() != 1 && this.tokPeek() != 590093) break block11;
                    string = (String)this.getToken().value;
                    short s = JmolConstants.getBondOrderFromString(string);
                    if (s != -1) break block12;
                    this.returnToken();
                    break block11;
                }
                this.addTokenToPostfix(4, string);
                if (!this.addNextTokenIf(0x880008)) break block10;
            }
            if (this.addNextTokenIf(0x880001)) {
                return true;
            }
            if (!this.clauseOr(this.tokPeek(0x880000))) {
                return false;
            }
            if (this.addNextTokenIf(0x880001)) {
                return true;
            }
            if (!this.addNextTokenIf(0x880008)) {
                return false;
            }
            if (!this.clauseOr(this.tokPeek(0x880000))) {
                return false;
            }
        }
        if (!this.addNextTokenIf(0x880001)) {
            return this.rightParenthesisExpected();
        }
        return true;
    }

    private boolean clauseSubstructure() {
        if (!this.addNextTokenIf(0x880000)) {
            return false;
        }
        if (!this.addNextTokenIf(4)) {
            return this.stringExpected();
        }
        if (!this.addNextTokenIf(0x880001)) {
            return this.rightParenthesisExpected();
        }
        return true;
    }

    private boolean clauseItemSelector() {
        int n;
        while ((n = this.tokPeek()) != 0 && n != 0x880011) {
            if (!this.clauseOr(false)) {
                return false;
            }
            this.returnToken();
            if (this.tokPeek() != 8912961) {
                this.tokenNext();
            }
            if ((n = this.tokPeek()) == 0x880011 || !Compiler.tokAttr(n, 0x880000)) break;
            if (n == 0x880000) continue;
            this.addNextToken();
        }
        return true;
    }

    private boolean clauseComparator() {
        Token token = this.tokenNext();
        Token token2 = this.tokenNext();
        if (!Compiler.tokenAttr(token2, 0x2080000)) {
            return this.comparisonOperatorExpected();
        }
        if (this.getToken() == null) {
            return this.unrecognizedExpressionToken();
        }
        boolean bl = this.isToken(0x880038);
        if (bl && this.getToken() == null) {
            return this.numberExpected();
        }
        switch (this.theToken.tok) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 524291: 
            case 590601: {
                break;
            }
            default: {
                return this.numberOrVariableNameExpected();
            }
        }
        this.addTokenToPostfix(token2.tok, token.tok, token2.value + (bl ? " -" : ""));
        if (token.tok == 73990156) {
            this.addTokenToPostfix(token);
        }
        if (this.isToken(524291)) {
            this.returnToken();
            return this.clausePrimitive();
        }
        this.addTokenToPostfix(this.theToken);
        if (this.theToken.tok == 590601) {
            return this.clauseDefine();
        }
        return true;
    }

    private boolean clauseCell() {
        Point3f point3f = new Point3f();
        this.tokenNext();
        if (!this.tokenNext(42467380)) {
            return this.equalSignExpected();
        }
        if (this.getToken() == null) {
            return this.coordinateExpected();
        }
        if (this.isToken(2)) {
            int n = this.theToken.intValue;
            point3f.x = n / 100 - 4;
            point3f.y = n % 100 / 10 - 4;
            point3f.z = n % 10 - 4;
            return this.addTokenToPostfix(2621445, point3f);
        }
        if (!this.isToken(524291) || !this.getNumericalToken()) {
            return this.coordinateExpected();
        }
        point3f.x = this.floatValue();
        if (this.tokPeek(0x880008)) {
            this.tokenNext();
        }
        if (!this.getNumericalToken()) {
            return this.coordinateExpected();
        }
        point3f.y = this.floatValue();
        if (this.tokPeek(0x880008)) {
            this.tokenNext();
        }
        if (!this.getNumericalToken() || !this.tokenNext(524292)) {
            return this.coordinateExpected();
        }
        point3f.z = this.floatValue();
        return this.addTokenToPostfix(2621445, point3f);
    }

    private boolean clauseDefine() {
        if (!this.addSubstituteTokenIf(524291, Token.tokenExpressionBegin)) {
            return this.addNextToken() && this.checkForItemSelector();
        }
        while (this.moreTokens() && !this.tokPeek(524292)) {
            if (this.tokPeek(524291)) {
                if (this.checkForCoordinate(true)) continue;
                return false;
            }
            this.addNextToken();
        }
        return this.addSubstituteTokenIf(524292, Token.tokenExpressionEnd) && this.checkForItemSelector();
    }

    private boolean generateResidueSpecCode(Token token) {
        if (this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAnd);
        }
        this.addTokenToPostfix(token);
        this.residueSpecCodeGenerated = true;
        return true;
    }

    private boolean clauseResidueSpec() {
        boolean bl = false;
        this.residueSpecCodeGenerated = false;
        int n = this.tokPeek();
        if (n == 8912961 || n == 0x880010 || n == 1) {
            if (!this.clauseResNameSpec()) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        boolean bl2 = false;
        if (n == 8912961 || n == 0x880038 || n == 2 || n == 5) {
            boolean bl3 = bl2 = n == 2;
            if (!this.clauseResNumSpec()) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        if (n == 524290 || n == 8912961 || n == 1 || n == 2 && !bl2) {
            if (!this.clauseChainSpec(n)) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        if (n == 524289) {
            if (!this.clauseAtomSpec()) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        if (n == 8912962) {
            if (!this.clauseAlternateSpec()) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        if (n == 524290 || n == 0x880040) {
            if (!this.clauseModelSpec()) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        if (!bl) {
            return this.residueSpecificationExpected();
        }
        if (!this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAll);
        }
        return true;
    }

    private boolean clauseResNameSpec() {
        this.getToken();
        if (this.isToken(8912961) || this.isToken(0)) {
            return !this.isToken(0);
        }
        if (this.isToken(0x880010)) {
            int n;
            String string = "";
            while (this.getToken() != null && !this.isToken(0x880011)) {
                string = string + this.theValue;
            }
            if (!this.isToken(0x880011)) {
                return false;
            }
            if (string == "") {
                return true;
            }
            if (string.length() > 0 && (n = string.indexOf("*")) >= 0 && n != string.length() - 1) {
                return this.residueSpecificationExpected();
            }
            string = string.toUpperCase();
            return this.generateResidueSpecCode(new Token(524313, string));
        }
        if (!this.isToken(1)) {
            return this.identifierOrResidueSpecificationExpected();
        }
        if (this.tokPeek(8912961)) {
            String string = this.theValue + "*";
            this.getToken();
            return this.generateResidueSpecCode(new Token(1, string));
        }
        return this.generateResidueSpecCode(this.theToken);
    }

    private boolean clauseResNumSpec() {
        this.log("clauseResNumSpec()");
        if (this.tokPeek(8912961)) {
            return this.getToken() != null;
        }
        return this.clauseSequenceRange();
    }

    private boolean clauseSequenceRange() {
        Token token = this.getSequenceCode(false);
        if (token == null) {
            return false;
        }
        int n = this.tokPeek();
        if (n == 0x880038 || n == 2 && this.intPeek() < 0) {
            if (n == 0x880038) {
                this.tokenNext();
            } else if (this.tokPeek() == 2 && this.intPeek() < 0) {
                int n2;
                this.tokenNext().intValue = n2 = -this.intPeek();
                this.returnToken();
            }
            token.tok = 524315;
            this.generateResidueSpecCode(token);
            token = this.getSequenceCode(true);
            return this.addTokenToPostfix(token);
        }
        return this.generateResidueSpecCode(token);
    }

    private Token getSequenceCode(boolean bl) {
        boolean bl2 = false;
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = this.tokPeek();
        if (n3 == 0x880038) {
            this.tokenNext();
            n3 = this.tokPeek();
            bl2 = true;
        }
        if (n3 == 5) {
            n = this.tokenNext().intValue * (bl2 ? -1 : 1);
        } else if (n3 == 2) {
            n2 = this.tokenNext().intValue * (bl2 ? -1 : 1);
        } else if (!bl) {
            if (bl2) {
                this.returnToken();
            }
            return null;
        }
        return new Token(524314, n2, new Integer(n));
    }

    private boolean clauseChainSpec(int n) {
        char c;
        if (n == 524290) {
            this.tokenNext();
            n = this.tokPeek();
            if (this.isSpecTerminator(n)) {
                return this.generateResidueSpecCode(new Token(524316, 0, "spec_chain"));
            }
        }
        if (n == 8912961) {
            return this.getToken() != null;
        }
        switch (n) {
            case 2: {
                this.getToken();
                int n2 = this.theToken.intValue;
                if (n2 < 0 || n2 > 9) {
                    return this.invalidChainSpecification();
                }
                c = (char)(48 + n2);
                break;
            }
            case 1: {
                String string = (String)this.getToken().value;
                if (string.length() != 1) {
                    return this.invalidChainSpecification();
                }
                c = string.charAt(0);
                if (c != '?') break;
                return true;
            }
            default: {
                return this.invalidChainSpecification();
            }
        }
        return this.generateResidueSpecCode(new Token(524316, c, "spec_chain"));
    }

    private boolean isSpecTerminator(int n) {
        switch (n) {
            case 0: 
            case 0x880001: 
            case 0x880008: 
            case 0x880018: 
            case 0x880020: 
            case 0x880028: 
            case 0x880040: 
            case 8912962: {
                return true;
            }
        }
        return false;
    }

    private boolean clauseAlternateSpec() {
        this.tokenNext();
        int n = this.tokPeek();
        if (this.isSpecTerminator(n)) {
            return this.generateResidueSpecCode(new Token(524317, null));
        }
        String string = (String)this.getToken().value;
        switch (this.theToken.tok) {
            case 1: 
            case 2: 
            case 4: 
            case 8912961: {
                break;
            }
            default: {
                return this.invalidModelSpecification();
            }
        }
        return this.generateResidueSpecCode(new Token(524317, string));
    }

    private boolean clauseModelSpec() {
        this.getToken();
        if (this.tokPeek(8912961)) {
            this.getToken();
            return true;
        }
        switch (this.tokPeek()) {
            case 2: {
                return this.generateResidueSpecCode(new Token(524318, new Integer(this.getToken().intValue)));
            }
            case 3: {
                return this.generateResidueSpecCode(new Token(524318, this.getToken().intValue, this.theValue));
            }
            case 0: 
            case 524292: 
            case 0x880008: {
                return this.generateResidueSpecCode(new Token(524318, new Integer(1)));
            }
        }
        return this.invalidModelSpecification();
    }

    private boolean clauseAtomSpec() {
        if (!this.tokenNext(524289)) {
            return this.invalidAtomSpecification();
        }
        if (this.getToken() == null) {
            return true;
        }
        String string = "";
        if (this.isToken(2)) {
            string = string + "" + this.theToken.intValue;
            if (this.getToken() == null) {
                return this.invalidAtomSpecification();
            }
        }
        switch (this.theToken.tok) {
            case 8912961: {
                return true;
            }
            case 1: {
                break;
            }
            default: {
                return this.invalidAtomSpecification();
            }
        }
        string = string + this.theValue;
        if (this.tokPeek(8912961)) {
            this.tokenNext();
            string = string + "*";
        }
        return this.generateResidueSpecCode(new Token(524320, string));
    }

    private boolean compileColorParam() {
        for (int i = 1; i < this.atokenInfix.length; ++i) {
            String string;
            int n;
            this.theToken = this.atokenInfix[i];
            if (this.isToken(524293)) {
                ++i;
                continue;
            }
            if (!this.isToken(1) || (n = Graphics3D.getArgbFromString(string = (String)this.theToken.value)) == 0) continue;
            this.theToken.tok = 393236;
            this.theToken.intValue = n;
        }
        return true;
    }

    private boolean missingEnd(String string) {
        return this.compileError(GT._("missing END for {0}", string));
    }

    private boolean badContext(String string) {
        return this.compileError(GT._("invalid context for {0}", string));
    }

    private boolean commandExpected() {
        this.ichToken = this.ichCurrentCommand;
        return this.compileError(GT._("command expected"));
    }

    private boolean invalidExpressionToken(String string) {
        return this.compileError(GT._("invalid expression token: {0}", string));
    }

    private boolean unrecognizedToken(String string) {
        return this.compileError(GT._("unrecognized token: {0}", string));
    }

    private boolean endOfCommandUnexpected() {
        return this.compileError(GT._("unexpected end of script command"));
    }

    private boolean badArgumentCount() {
        return this.compileError(GT._("bad argument count"));
    }

    private boolean endOfExpressionExpected() {
        return this.compileError(GT._("end of expression expected"));
    }

    private boolean rightParenthesisExpected() {
        return this.compileError(GT._("right parenthesis expected"));
    }

    private boolean leftParenthesisExpected() {
        return this.compileError(GT._("left parenthesis expected"));
    }

    private boolean rightBraceExpected() {
        return this.compileError(GT._("right brace expected"));
    }

    private boolean rightBracketExpected() {
        return this.compileError(GT._("right bracket expected"));
    }

    private boolean coordinateExpected() {
        return this.compileError(GT._("{ number number number } expected"));
    }

    private boolean unrecognizedExpressionToken() {
        return this.compileError(GT._("unrecognized expression token: {0}", "" + this.valuePeek()));
    }

    private boolean comparisonOperatorExpected() {
        return this.compileError(GT._("comparison operator expected"));
    }

    private boolean equalSignExpected() {
        return this.compileError(GT._("equal sign expected"));
    }

    private boolean numberExpected() {
        return this.compileError(GT._("number expected"));
    }

    private boolean numberOrVariableNameExpected() {
        return this.compileError(GT._("number or variable name expected"));
    }

    private boolean unrecognizedParameter(String string, String string2) {
        return this.compileError(GT._("unrecognized {0} parameter", string) + ": " + string2);
    }

    private boolean identifierOrResidueSpecificationExpected() {
        return this.compileError(GT._("identifier or residue specification expected"));
    }

    private boolean residueSpecificationExpected() {
        return this.compileError(GT._("residue specification (ALA, AL?, A*) expected"));
    }

    private boolean invalidChainSpecification() {
        return this.compileError(GT._("invalid chain specification"));
    }

    private boolean invalidModelSpecification() {
        return this.compileError(GT._("invalid model specification"));
    }

    private boolean invalidAtomSpecification() {
        return this.compileError(GT._("invalid atom specification"));
    }

    private boolean compileError(String string) {
        this.errorMessage = string;
        return false;
    }

    private boolean stringExpected() {
        return this.compileError(GT._("quoted string expected"));
    }

    private boolean commaOrCloseExpected() {
        return this.compileError(GT._("comma or right parenthesis expected"));
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    private boolean handleError() {
        int n = this.script.indexOf(13, this.ichCurrentCommand);
        if (n == -1 && (n = this.script.indexOf(10, this.ichCurrentCommand)) == -1) {
            n = this.script.length();
        }
        this.errorLine = this.script.substring(this.ichCurrentCommand, n);
        String string = (this.ichToken < this.errorLine.length() ? this.errorLine.substring(0, this.ichToken - this.ichCurrentCommand) + " >>>> " + this.errorLine.substring(this.ichToken - this.ichCurrentCommand) : this.errorLine) + " <<<<";
        this.errorMessage = "script compiler ERROR: " + this.errorMessage + Eval.setErrorLineMessage(this.filename, this.lineCurrent, this.iCommand, string);
        if (!this.isSilent) {
            this.viewer.addCommand(this.errorLine + "#??");
            Logger.error(this.errorMessage);
        }
        return false;
    }

    private class FlowContext {
        Token token;
        int pt0;
        Function function;
        FlowContext parent;

        FlowContext(Token token, int n, FlowContext flowContext) {
            this.token = token;
            this.pt0 = n;
            this.parent = flowContext;
        }

        void setFunction(Function function) {
            this.function = function;
        }

        void setFunction(String string, int n, int n2, short[] sArray, int[] nArray, Vector vector) {
            int n3;
            int n4 = this.function.cmdpt0;
            int n5 = this.function.chpt0;
            int n6 = n2 - n4;
            this.function.script = string.substring(n5, n);
            this.function.aatoken = new Token[n6][];
            Token[][] tokenArrayArray = this.function.aatoken;
            this.function.lineIndices = new int[n6];
            this.function.lineNumbers = new short[n6];
            short s = (short)(sArray[n4] - 1);
            for (n3 = 0; n3 < n6; ++n3) {
                this.function.lineNumbers[n3] = (short)(sArray[n4 + n3] - s);
                this.function.lineIndices[n3] = nArray[n4 + n3] - n5;
                tokenArrayArray[n3] = (Token[])vector.get(n4 + n3);
                Token token = tokenArrayArray[n3][0];
                if (!Compiler.tokAttr(token.tok, 16384)) continue;
                token.intValue = token.intValue - (token.intValue < 0 ? -n4 : n4);
            }
            n3 = n2;
            while (--n3 >= n4) {
                vector.remove(n3);
                nArray[n3] = 0;
            }
        }
    }
}

