/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.text.NumberFormat;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.modelset.CellInfo;
import org.jmol.shape.FontLineShapeRenderer;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.TextFormat;

public class UccageRenderer
extends FontLineShapeRenderer {
    NumberFormat nf;
    byte fid;
    boolean doLocalize;
    final Point3i[] screens = new Point3i[8];
    final Point3f[] verticesT = new Point3f[8];

    public UccageRenderer() {
        int n = 8;
        while (--n >= 0) {
            this.screens[n] = new Point3i();
            this.verticesT[n] = new Point3f();
        }
    }

    protected void render() {
        short s = this.viewer.getObjectMad(5);
        this.colix = this.viewer.getObjectColix(5);
        if (s == 0 || !this.g3d.setColix(this.colix) || this.viewer.isJmolDataFrame()) {
            return;
        }
        this.doLocalize = this.viewer.getUseNumberLocalization();
        this.render1(s);
    }

    void render1(short s) {
        CellInfo[] cellInfoArray = this.modelSet.getCellInfos();
        if (cellInfoArray == null) {
            return;
        }
        UnitCell unitCell = this.viewer.getCurrentUnitCell();
        if (unitCell == null) {
            return;
        }
        CellInfo cellInfo = cellInfoArray[this.viewer.getDisplayModelIndex()];
        Point3f[] point3fArray = unitCell.getVertices();
        Point3f point3f = unitCell.getCartesianOffset();
        int n = 8;
        while (--n >= 0) {
            this.verticesT[n].add(point3fArray[n], point3f);
        }
        Point3f[] point3fArray2 = this.viewer.getAxisPoints();
        boolean bl = this.viewer.getObjectMad(1) == 0 || this.viewer.getAxesScale() < 2.0f;
        this.render(s, this.verticesT, this.screens, point3fArray2, bl ? 0 : 3);
        if (this.viewer.getDisplayCellParameters() && !cellInfo.isPeriodic()) {
            this.renderInfo(cellInfo, unitCell);
        }
    }

    private String nfformat(float f) {
        return this.doLocalize && this.nf != null ? this.nf.format(f) : TextFormat.formatDecimal(f, 3);
    }

    private void renderInfo(CellInfo cellInfo, UnitCell unitCell) {
        if (this.isGenerator || !this.g3d.setColix(this.viewer.getColixBackgroundContrast())) {
            return;
        }
        if (this.nf == null) {
            this.nf = NumberFormat.getInstance();
            this.fid = this.g3d.getFontFid("Monospaced", 14);
        }
        if (this.nf != null) {
            this.nf.setMaximumFractionDigits(3);
            this.nf.setMinimumFractionDigits(3);
        }
        this.g3d.setFont(this.fid);
        int n = 15;
        int n2 = 5;
        if (this.antialias) {
            n <<= 1;
            n2 <<= 1;
        }
        int n3 = n;
        String string = cellInfo.getSpaceGroup();
        if (string != null) {
            this.g3d.drawStringNoSlab(string, null, n2, n3 += n, 0);
        }
        this.g3d.drawStringNoSlab("a=" + this.nfformat(unitCell.getInfo(0)) + "\u00c5", null, n2, n3 += n, 0);
        this.g3d.drawStringNoSlab("b=" + this.nfformat(unitCell.getInfo(1)) + "\u00c5", null, n2, n3 += n, 0);
        this.g3d.drawStringNoSlab("c=" + this.nfformat(unitCell.getInfo(2)) + "\u00c5", null, n2, n3 += n, 0);
        if (this.nf != null) {
            this.nf.setMaximumFractionDigits(1);
        }
        this.g3d.drawStringNoSlab("\u03b1=" + this.nfformat(unitCell.getInfo(3)) + "\u00b0", null, n2, n3 += n, 0);
        this.g3d.drawStringNoSlab("\u03b2=" + this.nfformat(unitCell.getInfo(4)) + "\u00b0", null, n2, n3 += n, 0);
        this.g3d.drawStringNoSlab("\u03b3=" + this.nfformat(unitCell.getInfo(5)) + "\u00b0", null, n2, n3 += n, 0);
    }
}

