/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public abstract class ProteinStructure {
    static int globalSerialID = 0;
    AlphaPolymer apolymer;
    byte type;
    int monomerIndexFirst;
    int monomerIndexLast;
    int monomerCount;
    Point3f axisA;
    Point3f axisB;
    Vector3f axisUnitVector;
    final Vector3f vectorProjection = new Vector3f();
    Point3f[] segments;
    int uniqueID = ++globalSerialID;

    ProteinStructure(AlphaPolymer alphaPolymer, byte by, int n, int n2) {
        this.apolymer = alphaPolymer;
        this.type = by;
        this.monomerIndexFirst = n;
        this.addMonomer(n + n2 - 1);
        if (Logger.debugging) {
            Logger.debug("Creating ProteinStructure " + this.uniqueID + " " + JmolConstants.getProteinStructureName(by) + " from " + this.monomerIndexFirst + " through " + this.monomerIndexLast + " in polymer " + alphaPolymer);
        }
    }

    void addMonomer(int n) {
        this.monomerIndexFirst = Math.min(this.monomerIndexFirst, n);
        this.monomerIndexLast = Math.max(this.monomerIndexLast, n);
        this.monomerCount = this.monomerIndexLast - this.monomerIndexFirst + 1;
    }

    int removeMonomer(int n) {
        if (n > this.monomerIndexLast || n < this.monomerIndexFirst) {
            return 0;
        }
        int n2 = this.monomerIndexLast - n;
        this.monomerIndexLast = Math.max(this.monomerIndexFirst, n) - 1;
        this.monomerCount = this.monomerIndexLast - this.monomerIndexFirst + 1;
        return n2;
    }

    public void calcAxis() {
    }

    void calcSegments() {
        if (this.segments != null) {
            return;
        }
        this.calcAxis();
        this.segments = new Point3f[this.monomerCount + 1];
        this.segments[this.monomerCount] = this.axisB;
        this.segments[0] = this.axisA;
        Vector3f vector3f = new Vector3f(this.axisUnitVector);
        vector3f.scale(this.axisB.distance(this.axisA) / (float)this.monomerCount);
        for (int i = 1; i < this.monomerCount; ++i) {
            Point3f point3f = this.segments[i] = new Point3f();
            point3f.set(this.segments[i - 1]);
            point3f.add(vector3f);
        }
    }

    boolean lowerNeighborIsHelixOrSheet() {
        if (this.monomerIndexFirst == 0) {
            return false;
        }
        return this.apolymer.monomers[this.monomerIndexFirst - 1].isHelix() || this.apolymer.monomers[this.monomerIndexFirst - 1].isSheet();
    }

    boolean upperNeighborIsHelixOrSheet() {
        int n = this.monomerIndexFirst + this.monomerCount;
        if (n == this.apolymer.monomerCount) {
            return false;
        }
        return this.apolymer.monomers[n].isHelix() || this.apolymer.monomers[n].isSheet();
    }

    public int getMonomerCount() {
        return this.monomerCount;
    }

    public int getMonomerIndex() {
        return this.monomerIndexFirst;
    }

    public int getIndex(Monomer monomer) {
        Monomer[] monomerArray = this.apolymer.monomers;
        int n = this.monomerCount;
        while (--n >= 0 && monomerArray[this.monomerIndexFirst + n] != monomer) {
        }
        return n;
    }

    public Point3f[] getSegments() {
        if (this.segments == null) {
            this.calcSegments();
        }
        return this.segments;
    }

    public Point3f getAxisStartPoint() {
        this.calcAxis();
        return this.axisA;
    }

    public Point3f getAxisEndPoint() {
        this.calcAxis();
        return this.axisB;
    }

    Point3f getStructureMidPoint(int n) {
        if (this.segments == null) {
            this.calcSegments();
        }
        return this.segments[n];
    }

    void resetAxes() {
        this.axisA = null;
        this.segments = null;
    }
}

