/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BitSetUtil;

public final class Chain {
    ModelSet modelSet;
    Model model;
    char chainID;
    int groupCount;
    int selectedGroupCount;
    private boolean isDna;
    private boolean isRna;
    BitSet bsSelectedGroups;
    Group[] groups = new Group[16];

    public Chain(ModelSet modelSet, Model model, char c) {
        this.modelSet = modelSet;
        this.model = model;
        this.chainID = c;
    }

    public char getChainID() {
        return this.chainID;
    }

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    public boolean isDna() {
        return this.isDna;
    }

    public boolean isRna() {
        return this.isRna;
    }

    public void setIsDna(boolean bl) {
        this.isDna = bl;
    }

    public void setIsRna(boolean bl) {
        this.isRna = bl;
    }

    public Group getGroup(int n) {
        return this.groups[n];
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public Atom getAtom(int n) {
        return this.modelSet.atoms[n];
    }

    public void calcSelectedGroupsCount(BitSet bitSet) {
        this.selectedGroupCount = 0;
        if (this.bsSelectedGroups == null) {
            this.bsSelectedGroups = new BitSet();
        }
        BitSetUtil.clear(this.bsSelectedGroups);
        for (int i = 0; i < this.groupCount; ++i) {
            if (this.groups[i].isSelected(bitSet)) {
                ++this.selectedGroupCount;
                this.groups[i].selectedIndex = this.groups[i].selectedIndex;
                this.bsSelectedGroups.set(i);
                continue;
            }
            this.groups[i].selectedIndex = -1;
        }
    }

    public void selectSeqcodeRange(int n, int n2, BitSet bitSet) {
        int n3;
        int n4 = 0;
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.getMaxSeqcode();
        }
        if ((n3 = this.getNextSeqcodeIndex(0, n2)) < 0) {
            return;
        }
        do {
            int n5;
            int n6;
            int n7;
            if ((n7 = this.getNextSeqcodeIndex(n4, n)) < 0) {
                return;
            }
            if (n3 < 0 && (n3 = this.getNextSeqcodeIndex(n4, n2)) < 0) {
                return;
            }
            if (n7 <= n3) {
                n6 = n7;
                n5 = n3;
            } else {
                n6 = n3;
                n5 = n7;
            }
            n3 = -1;
            for (n4 = n6; n4 <= n5; ++n4) {
                this.groups[n4].selectAtoms(bitSet);
            }
        } while (n4 < this.groupCount);
    }

    int getMaxSeqcode() {
        int n = 0;
        for (int i = 0; i < this.groupCount; ++i) {
            if (this.groups[i].seqcode <= n) continue;
            n = this.groups[i].seqcode;
        }
        return n;
    }

    int getNextSeqcodeIndex(int n, int n2) {
        for (int i = n; i < this.groupCount; ++i) {
            if (this.groups[i].seqcode != n2) continue;
            return i;
        }
        return -1;
    }

    int getSelectedGroupCount() {
        return this.selectedGroupCount;
    }

    public final void updateOffsetsForAlternativeLocations(BitSet bitSet, int n, byte[] byArray, int n2, int n3) {
        String[] stringArray = this.modelSet.getAtomNames();
        int n4 = byArray.length;
        block0: while (--n4 >= 0) {
            int n5;
            Atom atom;
            int n6 = byArray[n4] & 0xFF;
            if (n6 == 255 || (atom = this.getAtom(n5 = n2 + n6)).getAlternateLocationID() == 0) continue;
            int n7 = n3 - n2;
            for (int i = 1; i <= n7; ++i) {
                int n8;
                int n9 = n5 + i;
                if (n9 > n3) {
                    n9 -= n7 + 1;
                }
                if ((n8 = n9 - n2) < 0 || n8 > 255 || n9 == n5 || stringArray[n9] != stringArray[n5] || !bitSet.get(n9)) continue;
                byArray[n4] = (byte)n8;
                continue block0;
            }
        }
    }
}

