/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.awt.Rectangle;
import java.util.BitSet;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.atomdata.AtomData;
import org.jmol.bspt.Bspf;
import org.jmol.g3d.Graphics3D;
import org.jmol.geodesic.EnvelopeCalculation;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public abstract class AtomCollection {
    public Viewer viewer;
    Graphics3D g3d;
    protected static final boolean showRebondTimes = true;
    public Atom[] atoms;
    int atomCount;
    String[] atomNames;
    int[] atomSerials;
    byte[] specialAtomIDs;
    Object[] clientAtomReferences;
    Vector3f[] vibrationVectors;
    byte[] occupancies;
    short[] bfactor100s;
    float[] partialCharges;
    protected int[] surfaceDistance100s;
    private BitSet bsHidden = new BitSet();
    protected float maxBondingRadius = Float.MIN_VALUE;
    private float maxVanderwaalsRadius = Float.MIN_VALUE;
    private boolean hasBfactorRange;
    private int bfactor100Lo;
    private int bfactor100Hi;
    private int surfaceDistanceMax;
    private BitSet bsSurface;
    private int nSurfaceAtoms;
    protected Bspf bspf;
    public static final byte TAINT_COORD = 0;
    private static final byte TAINT_FORMALCHARGE = 1;
    private static final byte TAINT_OCCUPANCY = 2;
    private static final byte TAINT_PARTIALCHARGE = 3;
    private static final byte TAINT_TEMPERATURE = 4;
    private static final byte TAINT_VALENCE = 5;
    private static final byte TAINT_VIBRATION = 6;
    protected static final byte TAINT_MAX = 7;
    protected BitSet[] tainted;
    private static final int minimumPixelSelectionRadius = 6;
    final BitSet bsEmpty = new BitSet();
    final BitSet bsFoundRectangle = new BitSet();

    protected void releaseModelSet() {
        this.atoms = null;
        this.viewer = null;
        this.g3d = null;
        this.bspf = null;
        this.surfaceDistance100s = null;
        this.bsSurface = null;
        this.tainted = null;
        this.atomNames = null;
        this.atomSerials = null;
        this.clientAtomReferences = null;
        this.vibrationVectors = null;
        this.occupancies = null;
        this.bfactor100s = null;
        this.partialCharges = null;
        this.specialAtomIDs = null;
    }

    protected void merge(AtomCollection atomCollection) {
        this.tainted = atomCollection.tainted;
        this.atomNames = atomCollection.atomNames;
        this.atomSerials = atomCollection.atomSerials;
        this.clientAtomReferences = atomCollection.clientAtomReferences;
        this.vibrationVectors = atomCollection.vibrationVectors;
        this.occupancies = atomCollection.occupancies;
        this.bfactor100s = atomCollection.bfactor100s;
        this.partialCharges = atomCollection.partialCharges;
        this.specialAtomIDs = atomCollection.specialAtomIDs;
    }

    Atom[] getAtoms() {
        return this.atoms;
    }

    public Atom getAtomAt(int n) {
        return this.atoms[n];
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public String[] getAtomNames() {
        return this.atomNames;
    }

    public boolean modelSetHasVibrationVectors() {
        return this.vibrationVectors != null;
    }

    public float[] getPartialCharges() {
        return this.partialCharges;
    }

    public short[] getBFactors() {
        return this.bfactor100s;
    }

    public void setBsHidden(BitSet bitSet) {
        this.bsHidden = bitSet;
    }

    public boolean isAtomHidden(int n) {
        return this.bsHidden.get(n);
    }

    public String getAtomInfo(int n) {
        return this.atoms[n].getInfo();
    }

    public String getAtomInfoXYZ(int n, boolean bl) {
        return this.atoms[n].getInfoXYZ(bl);
    }

    public String getElementSymbol(int n) {
        return this.atoms[n].getElementSymbol();
    }

    public int getElementNumber(int n) {
        return this.atoms[n].getElementNumber();
    }

    String getElementName(int n) {
        return JmolConstants.elementNameFromNumber(this.atoms[n].getAtomicAndIsotopeNumber());
    }

    public String getAtomName(int n) {
        return this.atoms[n].getAtomName();
    }

    public int getAtomNumber(int n) {
        return this.atoms[n].getAtomNumber();
    }

    public float getAtomX(int n) {
        return this.atoms[n].x;
    }

    public float getAtomY(int n) {
        return this.atoms[n].y;
    }

    public float getAtomZ(int n) {
        return this.atoms[n].z;
    }

    public Point3f getAtomPoint3f(int n) {
        return this.atoms[n];
    }

    public float getAtomRadius(int n) {
        return this.atoms[n].getRadius();
    }

    public float getAtomVdwRadius(int n) {
        return this.atoms[n].getVanderwaalsRadiusFloat();
    }

    public short getAtomColix(int n) {
        return this.atoms[n].getColix();
    }

    public String getAtomChain(int n) {
        return "" + this.atoms[n].getChainID();
    }

    public String getAtomSequenceCode(int n) {
        return this.atoms[n].getSeqcodeString();
    }

    public int getAtomModelIndex(int n) {
        return this.atoms[n].getModelIndex();
    }

    protected int getAtomCountInModel(int n) {
        int n2 = 0;
        int n3 = this.atomCount;
        while (--n3 >= 0) {
            if (this.atoms[n3].modelIndex != n) continue;
            ++n2;
        }
        return n2;
    }

    public int getAtomIndexFromAtomNumber(int n) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].getAtomNumber() != n) continue;
            return i;
        }
        return -1;
    }

    public void setFormalCharges(BitSet bitSet, int n) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bitSet.get(i)) continue;
            this.atoms[i].setFormalCharge(n);
            this.taint(i, (byte)1);
        }
    }

    public void setProteinType(BitSet bitSet, byte by) {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bitSet.get(i)) continue;
            if (n2 != i - 1) {
                n = -1;
            }
            n2 = i;
            n = this.atoms[i].setProteinStructureType(by, n);
        }
    }

    public float calcRotationRadius(Point3f point3f) {
        float f = 0.0f;
        int n = this.atomCount;
        while (--n >= 0) {
            float f2;
            Atom atom = this.atoms[n];
            float f3 = point3f.distance(atom);
            float f4 = f3 + (f2 = atom.getVanderwaalsRadiusFloat());
            if (!(f4 > f)) continue;
            f = f4;
        }
        return f == 0.0f ? 10.0f : f;
    }

    public float getMaxVanderwaalsRadius() {
        if (this.maxVanderwaalsRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        return this.maxVanderwaalsRadius;
    }

    protected void findMaxRadii() {
        int n = this.atomCount;
        while (--n >= 0) {
            float f;
            Atom atom = this.atoms[n];
            float f2 = atom.getBondingRadiusFloat();
            if (f2 > this.maxBondingRadius) {
                this.maxBondingRadius = f2;
            }
            if (!((f = atom.getVanderwaalsRadiusFloat()) > this.maxVanderwaalsRadius)) continue;
            this.maxVanderwaalsRadius = f;
        }
    }

    public void clearBfactorRange() {
        this.hasBfactorRange = false;
    }

    private void calcBfactorRange(BitSet bitSet) {
        if (!this.hasBfactorRange) {
            this.bfactor100Lo = Integer.MAX_VALUE;
            this.bfactor100Hi = Integer.MIN_VALUE;
            int n = this.atomCount;
            while (--n > 0) {
                if (bitSet != null && !bitSet.get(n)) continue;
                int n2 = this.atoms[n].getBfactor100();
                if (n2 < this.bfactor100Lo) {
                    this.bfactor100Lo = n2;
                    continue;
                }
                if (n2 <= this.bfactor100Hi) continue;
                this.bfactor100Hi = n2;
            }
            this.hasBfactorRange = true;
        }
    }

    public int getBfactor100Lo() {
        if (!this.hasBfactorRange) {
            if (this.viewer.isRangeSelected()) {
                this.calcBfactorRange(this.viewer.getSelectionSet());
            } else {
                this.calcBfactorRange(null);
            }
        }
        return this.bfactor100Lo;
    }

    public int getBfactor100Hi() {
        this.getBfactor100Lo();
        return this.bfactor100Hi;
    }

    public int getSurfaceDistanceMax() {
        if (this.surfaceDistance100s == null) {
            this.calcSurfaceDistances();
        }
        return this.surfaceDistanceMax;
    }

    int getSurfaceDistance100(int n) {
        if (this.nSurfaceAtoms == 0) {
            return -1;
        }
        if (this.surfaceDistance100s == null) {
            this.calcSurfaceDistances();
        }
        return this.surfaceDistance100s[n];
    }

    private void calcSurfaceDistances() {
        this.calculateSurface(null, -1.0f);
    }

    public Point3f[] calculateSurface(BitSet bitSet, float f) {
        if (f < 0.0f) {
            f = 3.0f;
        }
        EnvelopeCalculation envelopeCalculation = new EnvelopeCalculation(this.viewer, this.atomCount, null);
        envelopeCalculation.calculate(Float.MAX_VALUE, f, 1.0f, Float.MAX_VALUE, bitSet, BitSetUtil.copyInvert(bitSet, this.atomCount), true, false, false, false, true);
        Point3f[] point3fArray = envelopeCalculation.getPoints();
        this.surfaceDistanceMax = 0;
        this.bsSurface = envelopeCalculation.getBsSurfaceClone();
        this.surfaceDistance100s = new int[this.atomCount];
        this.nSurfaceAtoms = BitSetUtil.cardinalityOf(this.bsSurface);
        if (this.nSurfaceAtoms == 0 || point3fArray == null || point3fArray.length == 0) {
            return point3fArray;
        }
        float f2 = f == Float.MAX_VALUE ? 0.0f : f;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.bsSurface.get(i)) {
                this.surfaceDistance100s[i] = 0;
                continue;
            }
            float f3 = Float.MAX_VALUE;
            Atom atom = this.atoms[i];
            int n = point3fArray.length;
            while (--n >= 0) {
                float f4 = Math.abs(point3fArray[n].distance(atom) - f2);
                if (f4 < 0.0f && Logger.debugging) {
                    Logger.debug("draw d" + n + " " + Escape.escape(point3fArray[n]) + " \"" + f4 + " ? " + atom.getInfo() + "\"");
                }
                f3 = Math.min(f4, f3);
            }
            n = this.surfaceDistance100s[i] = (int)(f3 * 100.0f);
            this.surfaceDistanceMax = Math.max(this.surfaceDistanceMax, n);
        }
        return point3fArray;
    }

    public float getMeasurement(int[] nArray) {
        float f = Float.NaN;
        if (nArray == null) {
            return f;
        }
        int n = nArray[0];
        if (n < 2) {
            return f;
        }
        int n2 = n;
        while (--n2 >= 0) {
            if (nArray[n2 + 1] >= 0) continue;
            return f;
        }
        switch (n) {
            case 2: {
                f = this.getDistance(nArray[1], nArray[2]);
                break;
            }
            case 3: {
                f = this.getAngle(nArray[1], nArray[2], nArray[3]);
                break;
            }
            case 4: {
                f = this.getTorsion(nArray[1], nArray[2], nArray[3], nArray[4]);
                break;
            }
            default: {
                Logger.error("Invalid count in measurement calculation:" + n);
                throw new IndexOutOfBoundsException();
            }
        }
        return f;
    }

    public float getDistance(int n, int n2) {
        return this.atoms[n].distance(this.atoms[n2]);
    }

    public float getAngle(int n, int n2, int n3) {
        Atom atom = this.atoms[n];
        Atom atom2 = this.atoms[n2];
        Atom atom3 = this.atoms[n3];
        return Measure.computeAngle(atom, atom2, atom3, true);
    }

    public float getTorsion(int n, int n2, int n3, int n4) {
        return Measure.computeTorsion(this.atoms[n], this.atoms[n2], this.atoms[n3], this.atoms[n4], true);
    }

    public void setAtomCoord(BitSet bitSet, int n, Object object) {
        Point3f point3f = null;
        Point3f[] point3fArray = null;
        if (object instanceof Point3f) {
            point3f = (Point3f)object;
        } else {
            point3fArray = (Point3f[])object;
        }
        if (point3f == null && (point3fArray == null || point3fArray.length == 0)) {
            return;
        }
        int n2 = 0;
        block5: for (int i = 0; i < this.atomCount; ++i) {
            if (!bitSet.get(i)) continue;
            if (point3fArray != null) {
                if (n2 >= point3fArray.length) {
                    return;
                }
                point3f = point3fArray[n2++];
            }
            switch (n) {
                case 73924617: {
                    this.setAtomCoord(i, point3f.x, point3f.y, point3f.z);
                    continue block5;
                }
                case 73924618: {
                    this.atoms[i].setFractionalCoord(point3f);
                    this.taint(i, (byte)0);
                    continue block5;
                }
                case 73924619: {
                    this.setAtomVibrationVector(i, point3f.x, point3f.y, point3f.z);
                }
            }
        }
    }

    private void setAtomVibrationVector(int n, float f, float f2, float f3) {
        this.setVibrationVector(n, f, f2, f3);
        this.taint(n, (byte)6);
    }

    public void setAtomCoord(int n, float f, float f2, float f3) {
        if (n < 0 || n >= this.atomCount) {
            return;
        }
        this.bspf = null;
        this.atoms[n].x = f;
        this.atoms[n].y = f2;
        this.atoms[n].z = f3;
        this.taint(n, (byte)0);
    }

    public void setAtomCoordRelative(int n, float f, float f2, float f3) {
        if (n < 0 || n >= this.atomCount) {
            return;
        }
        this.bspf = null;
        this.atoms[n].x += f;
        this.atoms[n].y += f2;
        this.atoms[n].z += f3;
        this.taint(n, (byte)0);
    }

    protected void setAtomCoordRelative(BitSet bitSet, float f, float f2, float f3) {
        this.bspf = null;
        int n = this.atomCount;
        while (--n >= 0) {
            if (!bitSet.get(n)) continue;
            this.setAtomCoordRelative(n, f, f2, f3);
        }
    }

    public void setAtomProperty(BitSet bitSet, int n, int n2, float f, float[] fArray) {
        int n3 = 0;
        if (fArray != null && fArray.length == 0) {
            return;
        }
        block12: for (int i = 0; i < this.atomCount; ++i) {
            if (!bitSet.get(i)) continue;
            if (fArray != null) {
                if (n3 >= fArray.length) {
                    return;
                }
                f = fArray[n3++];
                n2 = (int)f;
            }
            Atom atom = this.atoms[i];
            switch (n) {
                case 69730336: {
                    this.setAtomCoord(i, f, atom.y, atom.z);
                    continue block12;
                }
                case 69730337: {
                    this.setAtomCoord(i, atom.x, f, atom.z);
                    continue block12;
                }
                case 69730338: {
                    this.setAtomCoord(i, atom.x, atom.y, f);
                    continue block12;
                }
                case 69730347: 
                case 69730348: 
                case 69730349: {
                    this.setVibrationVector(i, n, f);
                    continue block12;
                }
                case 69730339: 
                case 69730340: 
                case 69730341: {
                    atom.setFractionalCoord(n, f);
                    this.taint(i, (byte)0);
                    continue block12;
                }
                case 69795849: {
                    atom.setFormalCharge(n2);
                    this.taint(i, (byte)1);
                    continue block12;
                }
                case 69730319: {
                    this.setOccupancy(i, n2);
                    this.taint(i, (byte)2);
                    continue block12;
                }
                case 69730342: {
                    this.setPartialCharge(i, f);
                    this.taint(i, (byte)3);
                    continue block12;
                }
                case 69730346: {
                    this.setBFactor(i, f);
                    this.taint(i, (byte)4);
                    continue block12;
                }
                case 69730327: {
                    atom.setValency(n2);
                    this.taint(i, (byte)5);
                }
            }
        }
    }

    public float getVibrationCoord(int n, char c) {
        if (this.vibrationVectors == null || this.vibrationVectors[n] == null) {
            return 0.0f;
        }
        switch (c) {
            case 'x': {
                return this.vibrationVectors[n].x;
            }
            case 'y': {
                return this.vibrationVectors[n].y;
            }
        }
        return this.vibrationVectors[n].z;
    }

    public Vector3f getVibrationVector(int n) {
        return this.vibrationVectors == null ? null : this.vibrationVectors[n];
    }

    protected void setVibrationVector(int n, float f, float f2, float f3) {
        if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) {
            return;
        }
        if (this.vibrationVectors == null) {
            this.vibrationVectors = new Vector3f[this.atoms.length];
        }
        this.vibrationVectors[n] = new Vector3f(f, f2, f3);
        this.atoms[n].setVibrationVector();
    }

    private void setVibrationVector(int n, int n2, float f) {
        Vector3f vector3f = this.getVibrationVector(n);
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        switch (n2) {
            case 69730347: {
                vector3f.x = f;
                break;
            }
            case 69730348: {
                vector3f.y = f;
                break;
            }
            case 69730349: {
                vector3f.z = f;
            }
        }
        this.setAtomVibrationVector(n, vector3f.x, vector3f.y, vector3f.z);
    }

    protected void setOccupancy(int n, int n2) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 100) {
            n2 = 100;
        }
        if (n2 != 100) {
            if (this.occupancies == null) {
                this.occupancies = new byte[this.atoms.length];
            }
            this.occupancies[n] = (byte)n2;
        }
    }

    protected void setPartialCharge(int n, float f) {
        if (Float.isNaN(f)) {
            return;
        }
        if (this.partialCharges == null) {
            this.partialCharges = new float[this.atoms.length];
        }
        this.partialCharges[n] = f;
    }

    protected void setBFactor(int n, float f) {
        if (Float.isNaN(f) || f == 0.0f) {
            return;
        }
        if (this.bfactor100s == null) {
            this.bfactor100s = new short[this.atoms.length];
        }
        this.bfactor100s[n] = (short)(f * 100.0f);
    }

    public void loadData(String string, String string2) {
        if (string.equalsIgnoreCase("coord")) {
            this.loadCoordinates(string2, false);
            return;
        }
        if (string.equalsIgnoreCase("vibrationvector")) {
            this.loadCoordinates(string2, true);
            return;
        }
        byte by = 0;
        if (string.equalsIgnoreCase("formalcharge")) {
            by = 1;
        } else if (string.equalsIgnoreCase("occupancy")) {
            by = 2;
        } else if (string.equalsIgnoreCase("partialcharge")) {
            by = 3;
        } else if (string.equalsIgnoreCase("temperature")) {
            by = 4;
        } else if (string.equalsIgnoreCase("valence")) {
            by = 5;
        } else {
            return;
        }
        int[] nArray = Parser.markLines(string2, ';');
        try {
            int n = Parser.parseInt(string2.substring(0, nArray[0] - 1));
            for (int i = 1; i <= n; ++i) {
                String[] stringArray = Parser.getTokens(Parser.parseTrimmed(string2.substring(nArray[i], nArray[i + 1] - 1)));
                int n2 = Parser.parseInt(stringArray[0]) - 1;
                float f = Parser.parseFloat(stringArray[stringArray.length - 1]);
                switch (by) {
                    case 1: {
                        this.atoms[n2].setFormalCharge((int)f);
                        break;
                    }
                    case 3: {
                        this.setPartialCharge(n2, f);
                        break;
                    }
                    case 4: {
                        this.setBFactor(n2, f);
                        break;
                    }
                    case 5: {
                        this.atoms[n2].setValency((int)f);
                    }
                }
                this.taint(n2, by);
            }
        }
        catch (Exception exception) {
            Logger.error("Frame.loadCoordinate error: " + exception);
        }
    }

    private void loadCoordinates(String string, boolean bl) {
        if (!bl) {
            this.bspf = null;
        }
        int[] nArray = Parser.markLines(string, ';');
        try {
            int n = Parser.parseInt(string.substring(0, nArray[0] - 1));
            for (int i = 1; i <= n; ++i) {
                String[] stringArray = Parser.getTokens(Parser.parseTrimmed(string.substring(nArray[i], nArray[i + 1])));
                int n2 = Parser.parseInt(stringArray[0]) - 1;
                float f = Parser.parseFloat(stringArray[3]);
                float f2 = Parser.parseFloat(stringArray[4]);
                float f3 = Parser.parseFloat(stringArray[5]);
                if (bl) {
                    this.setAtomVibrationVector(n2, f, f2, f3);
                    continue;
                }
                this.setAtomCoord(n2, f, f2, f3);
            }
        }
        catch (Exception exception) {
            Logger.error("Frame.loadCoordinate error: " + exception);
        }
    }

    public BitSet getTaintedAtoms(byte by) {
        return this.tainted == null ? null : this.tainted[by];
    }

    protected void taint(int n, byte by) {
        if (this.tainted == null) {
            this.tainted = new BitSet[7];
        }
        if (this.tainted[by] == null) {
            this.tainted[by] = new BitSet(this.atomCount);
        }
        this.tainted[by].set(n);
    }

    public void setTaintedAtoms(BitSet bitSet, byte by) {
        if (bitSet == null) {
            if (this.tainted == null) {
                return;
            }
            this.tainted[by] = null;
            return;
        }
        if (this.tainted == null) {
            this.tainted = new BitSet[7];
        }
        if (this.tainted[by] == null) {
            this.tainted[by] = new BitSet(this.atomCount);
        }
        BitSetUtil.copy(bitSet, this.tainted[by]);
    }

    protected void getTaintedState(StringBuffer stringBuffer, byte by) {
        BitSet bitSet = this.getTaintedAtoms(by);
        stringBuffer.append("\n");
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        String string = "";
        switch (by) {
            case 0: {
                string = "coord set";
                break;
            }
            case 1: {
                string = "formalcharge set";
                break;
            }
            case 2: {
                string = "occupancy set";
                break;
            }
            case 3: {
                string = "partialcharge set";
                break;
            }
            case 4: {
                string = "temperature set";
                break;
            }
            case 5: {
                string = "valence set";
                break;
            }
            case 6: {
                string = "vibrationvector set";
            }
        }
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bitSet.get(i)) continue;
            stringBuffer2.append(i + 1).append(" ").append(this.atoms[i].getElementSymbol()).append(" ").append(this.atoms[i].getInfo().replace(' ', '_')).append(" ");
            switch (by) {
                case 0: {
                    stringBuffer2.append(" ").append(this.atoms[i].x).append(" ").append(this.atoms[i].y).append(" ").append(this.atoms[i].z);
                    break;
                }
                case 1: {
                    stringBuffer2.append(this.atoms[i].getFormalCharge());
                    break;
                }
                case 2: {
                    stringBuffer2.append(this.atoms[i].getOccupancy());
                    break;
                }
                case 3: {
                    stringBuffer2.append(this.atoms[i].getPartialCharge());
                    break;
                }
                case 4: {
                    stringBuffer2.append((float)this.atoms[i].getBfactor100() / 100.0f);
                    break;
                }
                case 5: {
                    stringBuffer2.append(this.atoms[i].getValence());
                    break;
                }
                case 6: {
                    Vector3f vector3f = this.getVibrationVector(i);
                    if (vector3f == null) {
                        vector3f = new Vector3f();
                    }
                    stringBuffer2.append(" ").append(vector3f.x).append(" ").append(vector3f.y).append(" ").append(vector3f.z);
                }
            }
            stringBuffer2.append(" ;\n");
            ++n;
        }
        stringBuffer.append("  DATA \"" + string + "\"\n").append(n).append(" ;\nJmol Property Data Format 1 -- Jmol ").append(Viewer.getJmolVersion()).append(";\n");
        stringBuffer.append(stringBuffer2);
        stringBuffer.append("  end \"" + string + "\";\n");
    }

    protected void findNearestAtomIndex(int n, int n2, Atom[] atomArray) {
        Atom atom = null;
        int n3 = this.atomCount;
        while (--n3 >= 0) {
            Atom atom2 = this.atoms[n3];
            if (!atom2.isClickable() || !this.isCursorOnTopOf(atom2, n, n2, 6, atom)) continue;
            atom = atom2;
        }
        atomArray[0] = atom;
    }

    boolean isCursorOnTopOf(Atom atom, int n, int n2, int n3, Atom atom2) {
        return atom.screenZ > 1 && !this.g3d.isClippedZ(atom.screenZ) && this.g3d.isInDisplayRange(atom.screenX, atom.screenY) && atom.isCursorOnTopOf(n, n2, n3, atom2);
    }

    public BitSet findAtomsInRectangle(Rectangle rectangle) {
        this.bsFoundRectangle.and(this.bsEmpty);
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            if (!rectangle.contains(atom.screenX, atom.screenY)) continue;
            this.bsFoundRectangle.set(n);
        }
        return this.bsFoundRectangle;
    }

    protected void fillAtomData(AtomData atomData, int n) {
        boolean bl;
        atomData.atomXyz = this.atoms;
        atomData.atomCount = this.atomCount;
        atomData.atomicNumber = new int[this.atomCount];
        boolean bl2 = bl = n == 2;
        if (bl) {
            atomData.atomRadius = new float[this.atomCount];
        }
        for (int i = 0; i < this.atomCount; ++i) {
            if (atomData.modelIndex >= 0 && this.atoms[i].modelIndex != atomData.firstModelIndex) {
                if (atomData.bsIgnored == null) {
                    atomData.bsIgnored = new BitSet();
                }
                atomData.bsIgnored.set(i);
                continue;
            }
            atomData.atomicNumber[i] = this.atoms[i].getElementNumber();
            atomData.lastModelIndex = this.atoms[i].modelIndex;
            if (!bl) continue;
            atomData.atomRadius[i] = atomData.useIonic ? this.atoms[i].getBondingRadiusFloat() : this.atoms[i].getVanderwaalsRadiusFloat();
        }
    }

    protected Point3f[][] getAdditionalHydrogens(BitSet bitSet, int[] nArray) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Point3f[][] point3fArray = new Point3f[this.atomCount][];
        int n = 0;
        block5: for (int i = 0; i < this.atomCount; ++i) {
            String string;
            int n2;
            if (!bitSet.get(i) || this.atoms[i].getElementNumber() != 6) continue;
            int n3 = 0;
            Atom atom = this.atoms[i];
            int n4 = n2 = atom.getCovalentHydrogenCount() > 0 ? 0 : atom.getCovalentBondCount();
            if (!(n2 != 3 && n2 != 2 || (string = this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3", true)) != null && !string.equals("sp"))) {
                n2 = 0;
            }
            if (n2 > 0 && n2 <= 4) {
                n3 += 4 - n2;
            }
            point3fArray[i] = new Point3f[n3];
            n += n3;
            n3 = 0;
            switch (n2) {
                case 1: {
                    this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3a", false);
                    Point3f point3f = new Point3f(vector3f);
                    point3f.scaleAdd(1.1f, atom);
                    point3fArray[i][n3++] = point3f;
                    this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3b", false);
                    point3f = new Point3f(vector3f);
                    point3f.scaleAdd(1.1f, atom);
                    point3fArray[i][n3++] = point3f;
                    this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3c", false);
                    point3f = new Point3f(vector3f);
                    point3f.scaleAdd(1.1f, atom);
                    point3fArray[i][n3++] = point3f;
                    continue block5;
                }
                case 2: {
                    string = this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3", true);
                    if (string == null || string.equals("sp")) continue block5;
                    this.getHybridizationAndAxes(i, vector3f, vector3f2, "lpa", false);
                    Point3f point3f = new Point3f(vector3f);
                    point3f.scaleAdd(1.1f, atom);
                    point3fArray[i][n3++] = point3f;
                    this.getHybridizationAndAxes(i, vector3f, vector3f2, "lpb", false);
                    point3f = new Point3f(vector3f);
                    point3f.scaleAdd(1.1f, atom);
                    point3fArray[i][n3++] = point3f;
                    continue block5;
                }
                case 3: {
                    if (this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3", true) == null) continue block5;
                    Point3f point3f = new Point3f(vector3f);
                    point3f.scaleAdd(1.1f, atom);
                    point3fArray[i][n3++] = point3f;
                }
            }
        }
        nArray[0] = n;
        return point3fArray;
    }

    public String getHybridizationAndAxes(int n, Vector3f vector3f, Vector3f vector3f2, String string, boolean bl) {
        String string2 = string.length() > 0 && string.charAt(0) == '-' ? string.substring(1) : string;
        Atom atom = this.atoms[n];
        String string3 = "";
        vector3f.set(0.0f, 0.0f, 0.0f);
        vector3f2.set(0.0f, 0.0f, 0.0f);
        Atom atom2 = atom;
        Atom atom3 = atom;
        int n2 = 0;
        float f = 2.984513f;
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        Vector3f vector3f5 = new Vector3f(3.14159f, 2.71828f, 1.41421f);
        Vector3f vector3f6 = new Vector3f();
        Vector3f vector3f7 = new Vector3f();
        Vector3f vector3f8 = new Vector3f();
        if (atom.bonds != null) {
            int n3 = atom.bonds.length;
            block11: while (--n3 >= 0) {
                if (!atom.bonds[n3].isCovalent()) continue;
                atom2 = atom.bonds[n3].getOtherAtom(atom);
                vector3f3.sub(atom, atom2);
                vector3f3.normalize();
                vector3f.add(vector3f3);
                switch (++n2) {
                    case 1: {
                        vector3f2.set(vector3f3);
                        atom3 = atom2;
                        continue block11;
                    }
                    case 2: {
                        vector3f4.set(vector3f3);
                        continue block11;
                    }
                    case 3: {
                        vector3f5.set(vector3f3);
                        vector3f6.set(-vector3f.x, -vector3f.y, -vector3f.z);
                        continue block11;
                    }
                    case 4: {
                        vector3f6.set(vector3f3);
                        continue block11;
                    }
                }
                n3 = -1;
            }
        }
        switch (n2) {
            case 0: {
                vector3f.set(0.0f, 0.0f, 1.0f);
                vector3f2.set(1.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                if (string2.indexOf("sp3") == 0) {
                    string3 = "sp3";
                    vector3f2.cross(vector3f5, vector3f);
                    vector3f7.cross(vector3f, vector3f2);
                    vector3f2.normalize();
                    vector3f7.normalize();
                    vector3f8.set(vector3f2);
                    vector3f.normalize();
                    vector3f2.scaleAdd(2.828f, vector3f2, vector3f);
                    if (!string2.equals("sp3a") && !string2.equals("sp3")) {
                        vector3f2.normalize();
                        AxisAngle4f axisAngle4f = new AxisAngle4f(vector3f.x, vector3f.y, vector3f.z, (float)(string2.equals("sp3b") ? 1 : -1) * 2.0943952f);
                        Matrix3f matrix3f = new Matrix3f();
                        matrix3f.setIdentity();
                        matrix3f.set(axisAngle4f);
                        matrix3f.transform(vector3f2);
                    }
                    vector3f.set(vector3f2);
                    vector3f2.cross(vector3f7, vector3f);
                    break;
                }
                string3 = "sp";
                if (atom2.getCovalentBondCount() == 3) {
                    this.getHybridizationAndAxes(atom2.atomIndex, vector3f, vector3f5, string2, false);
                    vector3f5.set(vector3f2);
                    if (string2.indexOf("sp2") == 0) {
                        string3 = "sp2";
                        vector3f.scale(-1.0f);
                    }
                }
                vector3f2.cross(vector3f5, vector3f);
                break;
            }
            case 2: {
                if ((double)vector3f.length() < 0.1) {
                    string3 = "sp";
                    if (!string2.equals("pz")) {
                        if (atom2.getCovalentBondCount() != 3) {
                            atom2 = atom3;
                        }
                        if (atom2.getCovalentBondCount() == 3) {
                            this.getHybridizationAndAxes(atom2.atomIndex, vector3f2, vector3f, "pz", false);
                            if (string2.equals("px")) {
                                vector3f2.scale(-1.0f);
                            }
                            vector3f.set(vector3f4);
                            break;
                        }
                    }
                    vector3f.set(vector3f2);
                    vector3f2.cross(vector3f5, vector3f);
                    break;
                }
                string3 = string2.indexOf("sp3") == 0 ? "sp3" : "sp2";
                vector3f5.cross(vector3f, vector3f2);
                if (string2.indexOf("sp") == 0) {
                    if (string2.equals("sp2a") || string2.equals("sp2b")) {
                        vector3f.set(string2.indexOf("b") >= 0 ? vector3f4 : vector3f2);
                        vector3f.scale(-1.0f);
                    }
                    vector3f2.cross(vector3f, vector3f5);
                    break;
                }
                if (string2.indexOf("lp") == 0) {
                    string3 = "lp";
                    vector3f5.normalize();
                    vector3f.normalize();
                    vector3f7.scaleAdd(1.2f, vector3f5, vector3f);
                    vector3f8.scaleAdd(-1.2f, vector3f5, vector3f);
                    if (!string2.equals("lp")) {
                        vector3f.set(string2.indexOf("b") >= 0 ? vector3f8 : vector3f7);
                    }
                    vector3f2.cross(vector3f, vector3f5);
                    break;
                }
                string3 = string2;
                vector3f2.cross(vector3f, vector3f5);
                vector3f.set(vector3f5);
                if (!(vector3f.z < 0.0f)) break;
                vector3f.set(-vector3f.x, -vector3f.y, -vector3f.z);
                vector3f2.set(-vector3f2.x, -vector3f2.y, -vector3f2.z);
                break;
            }
            default: {
                if (vector3f2.angle(vector3f4) < f) {
                    vector3f7.cross(vector3f2, vector3f4);
                } else {
                    vector3f7.cross(vector3f2, vector3f5);
                }
                vector3f7.normalize();
                if (vector3f4.angle(vector3f5) < f) {
                    vector3f8.cross(vector3f4, vector3f5);
                } else {
                    vector3f8.cross(vector3f2, vector3f5);
                }
                vector3f8.normalize();
                if (Math.abs(vector3f8.dot(vector3f7)) < 0.95f) {
                    string3 = "sp3";
                    if (string2.indexOf("sp") == 0) {
                        vector3f.set(string2.equalsIgnoreCase("sp3") || string2.indexOf("d") >= 0 ? vector3f6 : (string2.indexOf("c") >= 0 ? vector3f5 : (string2.indexOf("b") >= 0 ? vector3f4 : vector3f2)));
                        vector3f.scale(-1.0f);
                        vector3f2.set(vector3f7);
                        break;
                    }
                    if (string2.indexOf("lp") == 0 && n2 == 3) {
                        string3 = "lp";
                    }
                    vector3f2.cross(vector3f, vector3f2);
                    break;
                }
                string3 = "sp2";
                if (string2.indexOf("sp") == 0) {
                    vector3f.set(string2.equalsIgnoreCase("sp3") || string2.indexOf("d") >= 0 ? vector3f6 : (string2.indexOf("c") >= 0 ? vector3f5 : (string2.indexOf("b") >= 0 ? vector3f4 : vector3f2)));
                    vector3f.scale(-1.0f);
                    vector3f2.set(vector3f7);
                    break;
                }
                vector3f.set(vector3f7);
                if (!(vector3f.z < 0.0f)) break;
                vector3f.set(-vector3f.x, -vector3f.y, -vector3f.z);
                vector3f2.set(-vector3f2.x, -vector3f2.y, -vector3f2.z);
            }
        }
        vector3f2.normalize();
        vector3f.normalize();
        if (Logger.debugging) {
            Logger.debug(atom.getInfo() + " nBonds=" + n2 + " " + string3);
        }
        if (bl) {
            if (string3 == "") {
                return null;
            }
            if (string2.indexOf("p") == 0 ? string3 == "sp3" : string2.indexOf(string3) < 0) {
                return null;
            }
        }
        return string3;
    }

    protected BitSet getAtomBits(int n) {
        switch (n) {
            case 0x190001: {
                return this.getHeteroSet();
            }
            case 1638402: {
                return this.getHydrogenSet();
            }
            case 1572870: {
                return this.getProteinSet();
            }
            case 1572883: {
                return this.getCarbohydrateSet();
            }
            case 1572871: {
                return this.getNucleicSet();
            }
            case 0x180008: {
                return this.getDnaSet();
            }
            case 1572873: {
                return this.getRnaSet();
            }
            case 1572874: {
                return this.getPurineSet();
            }
            case 1572875: {
                return this.getPyrimidineSet();
            }
        }
        return null;
    }

    public BitSet getModelBitSet(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        for (int i = 0; i < this.atomCount; ++i) {
            if (bitSet != null && !bitSet.get(i)) continue;
            bitSet2.set(this.atoms[i].modelIndex);
        }
        return bitSet2;
    }

    private BitSet getHeteroSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isHetero()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getHydrogenSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (this.atoms[n].getElementNumber() != 1) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getProteinSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isProtein()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getCarbohydrateSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isCarbohydrate()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getNucleicSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isNucleic()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getDnaSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isDna()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getRnaSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isRna()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getPurineSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isPurine()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getPyrimidineSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isPyrimidine()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    public BitSet getAtomBits(int n, String string) {
        switch (n) {
            case 1: {
                return this.getIdentifierOrNull(string);
            }
            case 524320: {
                return this.getSpecAtom(string);
            }
            case 524313: {
                return this.getSpecName(string);
            }
            case 524317: {
                return this.getSpecAlternate(string);
            }
        }
        return null;
    }

    protected BitSet getAtomBits(int n, int n2) {
        switch (n) {
            case 2621441: {
                return this.getSpecAtomNumber(n2);
            }
            case 524312: {
                return this.getSpecResid(n2);
            }
            case 524316: {
                return this.getSpecChain((char)n2);
            }
            case 524314: {
                return this.getSpecSeqcode(n2, true);
            }
        }
        return null;
    }

    private BitSet getIdentifierOrNull(String string) {
        int n;
        BitSet bitSet;
        BitSet bitSet2 = this.getSpecNameOrNull(string);
        if (bitSet2 != null || string.indexOf("?") > 0) {
            return bitSet2;
        }
        int n2 = string.indexOf("*");
        if (n2 > 0) {
            return this.getSpecNameOrNull(string.substring(0, n2) + "??????????" + string.substring(n2 + 1));
        }
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && Character.isLetter(string.charAt(n2)); ++n2) {
        }
        bitSet2 = this.getSpecNameOrNull(string.substring(0, n2));
        if (n2 == n3) {
            return bitSet2;
        }
        if (bitSet2 == null) {
            bitSet2 = new BitSet();
        }
        int n4 = n2;
        while (n2 < n3 && Character.isDigit(string.charAt(n2))) {
            ++n2;
        }
        int n5 = 0;
        try {
            n5 = Integer.parseInt(string.substring(n4, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        char c = ' ';
        if (n2 < n3 && string.charAt(n2) == '^' && ++n2 < n3) {
            c = string.charAt(n2);
        }
        if ((bitSet = this.getSpecSeqcode(n = Group.getSeqcode(n5, c), false)) == null) {
            if (c != ' ') {
                bitSet = this.getSpecSeqcode(Character.toUpperCase(string.charAt(n2)), false);
            }
            if (bitSet == null) {
                return null;
            }
            ++n2;
        }
        bitSet2.and(bitSet);
        if (n2 >= n3) {
            return bitSet2;
        }
        char c2 = string.charAt(n2++);
        bitSet2.and(this.getSpecChain(c2));
        if (n2 == n3) {
            return bitSet2;
        }
        return null;
    }

    private BitSet getSpecAtom(String string) {
        BitSet bitSet = new BitSet();
        string = string.toUpperCase();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isAtomNameMatch(string)) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getSpecName(String string) {
        BitSet bitSet = this.getSpecNameOrNull(string);
        if (bitSet != null) {
            return bitSet;
        }
        int n = string.indexOf("*");
        if (n > 0) {
            bitSet = this.getSpecNameOrNull(string.substring(0, n) + "??????????" + string.substring(n + 1));
        }
        return bitSet == null ? new BitSet() : bitSet;
    }

    private BitSet getSpecNameOrNull(String string) {
        BitSet bitSet = null;
        string = string.toUpperCase();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isGroup3OrNameMatch(string)) continue;
            if (bitSet == null) {
                bitSet = new BitSet(n + 1);
            }
            bitSet.set(n);
        }
        return bitSet;
    }

    protected BitSet getSpecAlternate(String string) {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isAlternateLocationMatch(string)) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    protected BitSet getSpecResid(int n) {
        BitSet bitSet = new BitSet();
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            if (this.atoms[n2].getGroupID() != n) continue;
            bitSet.set(n2);
        }
        return bitSet;
    }

    protected BitSet getSpecSeqcode(int n, boolean bl) {
        BitSet bitSet = new BitSet();
        int n2 = Group.getSequenceNumber(n);
        boolean bl2 = n2 != Integer.MAX_VALUE;
        boolean bl3 = true;
        char c = Group.getInsertionCode(n);
        switch (c) {
            case '?': {
                int n3 = this.atomCount;
                while (--n3 >= 0) {
                    int n4 = this.atoms[n3].getSeqcode();
                    if (bl2 && (n2 != Group.getSequenceNumber(n4) || Group.getInsertionCodeValue(n4) == 0)) continue;
                    bitSet.set(n3);
                    bl3 = false;
                }
                break;
            }
            default: {
                int n5 = this.atomCount;
                while (--n5 >= 0) {
                    int n6 = this.atoms[n5].getSeqcode();
                    if (n != n6 && (bl2 || n != Group.getInsertionCodeValue(n6)) && (c != '*' || n2 != Group.getSequenceNumber(n6))) continue;
                    bitSet.set(n5);
                    bl3 = false;
                }
                break block0;
            }
        }
        return !bl3 || bl ? bitSet : null;
    }

    protected BitSet getSpecChain(char c) {
        boolean bl = this.viewer.getChainCaseSensitive();
        if (!bl) {
            c = Character.toUpperCase(c);
        }
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            char c2 = this.atoms[n].getChainID();
            if (!bl) {
                c2 = Character.toUpperCase(c2);
            }
            if (c != c2) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    protected BitSet getSpecAtomNumber(int n) {
        BitSet bitSet = new BitSet();
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            if (this.atoms[n2].getAtomNumber() != n) continue;
            bitSet.set(n2);
        }
        return bitSet;
    }

    protected BitSet getCellSet(int n, int n2, int n3) {
        BitSet bitSet = new BitSet();
        Point3f point3f = new Point3f((float)n / 1000.0f, (float)n2 / 1000.0f, (float)n3 / 1000.0f);
        int n4 = this.atomCount;
        while (--n4 >= 0) {
            if (!this.atoms[n4].isInLatticeCell(point3f)) continue;
            bitSet.set(n4);
        }
        return bitSet;
    }

    public int[] getAtomIndices(BitSet bitSet) {
        int n = bitSet.size();
        int n2 = 0;
        int[] nArray = new int[this.atomCount];
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            nArray[i] = ++n2;
        }
        return nArray;
    }

    public BitSet getAtomsWithin(float f, Point4f point4f) {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            float f2 = Graphics3D.distanceToPlane(point4f, atom);
            if (!(f > 0.0f && (double)f2 >= -0.1 && f2 <= f || f < 0.0f && (double)f2 <= 0.1 && f2 >= f) && (f != 0.0f || !((double)Math.abs(f2) < 0.01))) continue;
            bitSet.set(atom.atomIndex);
        }
        return bitSet;
    }

    public BitSet getVisibleSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isVisible()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    public BitSet getClickableSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isClickable()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    public BitSet getAtomsWithin(int n, BitSet bitSet) {
        switch (n) {
            case 524296: {
                return this.withinGroup(bitSet);
            }
            case 524297: {
                return this.withinChain(bitSet);
            }
            case 2621709: {
                return this.withinModel(bitSet);
            }
            case 2621446: {
                return this.withinElement(bitSet);
            }
            case 2621459: {
                return this.withinSite(bitSet);
            }
        }
        return null;
    }

    private BitSet withinGroup(BitSet bitSet) {
        Group group = null;
        BitSet bitSet2 = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom;
            Group group2;
            if (!bitSet.get(n) || (group2 = (atom = this.atoms[n]).getGroup()) == group) continue;
            group2.selectAtoms(bitSet2);
            group = group2;
        }
        return bitSet2;
    }

    private BitSet withinChain(BitSet bitSet) {
        Chain chain = null;
        BitSet bitSet2 = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            Chain chain2;
            if (!bitSet.get(n) || (chain2 = this.atoms[n].getChain()) == chain) continue;
            int n2 = this.atomCount;
            while (--n2 >= 0) {
                if (this.atoms[n2].getChain() != chain2) continue;
                bitSet2.set(n2);
            }
            chain = chain2;
        }
        return bitSet2;
    }

    private BitSet withinModel(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!bitSet.get(n)) continue;
            bitSet3.set(this.atoms[n].modelIndex);
        }
        n = this.atomCount;
        while (--n >= 0) {
            if (!bitSet3.get(this.atoms[n].modelIndex)) continue;
            bitSet2.set(n);
        }
        return bitSet2;
    }

    private BitSet withinSite(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!bitSet.get(n)) continue;
            bitSet3.set(this.atoms[n].atomSite);
        }
        n = this.atomCount;
        while (--n >= 0) {
            if (!bitSet3.get(this.atoms[n].atomSite)) continue;
            bitSet2.set(n);
        }
        return bitSet2;
    }

    private BitSet withinElement(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!bitSet.get(n)) continue;
            bitSet3.set(this.getElementNumber(n));
        }
        n = this.atomCount;
        while (--n >= 0) {
            if (!bitSet3.get(this.getElementNumber(n))) continue;
            bitSet2.set(n);
        }
        return bitSet2;
    }
}

