/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.calc.MarchingSquares;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.ApbsReader;
import org.jmol.jvxl.readers.CubeReader;
import org.jmol.jvxl.readers.IsoFxyReader;
import org.jmol.jvxl.readers.IsoMOReader;
import org.jmol.jvxl.readers.IsoMepReader;
import org.jmol.jvxl.readers.IsoPlaneReader;
import org.jmol.jvxl.readers.IsoShapeReader;
import org.jmol.jvxl.readers.IsoSolventReader;
import org.jmol.jvxl.readers.JaguarReader;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.jvxl.readers.PltFormattedReader;
import org.jmol.jvxl.readers.VolumeDataReader;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.jvxl.readers.VoxelReader;
import org.jmol.jvxl.readers.XplorReader;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Logger;

public class SurfaceGenerator {
    private ColorEncoder colorEncoder;
    private JvxlData jvxlData;
    private MeshData meshData;
    private Parameters params;
    private VolumeData volumeData;
    private MeshDataServer meshDataServer;
    private AtomDataServer atomDataServer;
    private MarchingSquares marchingSquares;
    VoxelReader voxelReader;
    private int state;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_DATA_READ = 2;
    private static final int STATE_DATA_COLORED = 3;
    int colorPtr;
    private boolean rangeDefined;

    public SurfaceGenerator() {
        this.setup(null, null, null, null, null);
    }

    public SurfaceGenerator(AtomDataServer atomDataServer, MeshDataServer meshDataServer, ColorEncoder colorEncoder, MeshData meshData, JvxlData jvxlData) {
        this.setup(atomDataServer, meshDataServer, colorEncoder, meshData, jvxlData);
    }

    private void setup(AtomDataServer atomDataServer, MeshDataServer meshDataServer, ColorEncoder colorEncoder, MeshData meshData, JvxlData jvxlData) {
        this.atomDataServer = atomDataServer;
        this.meshDataServer = meshDataServer;
        this.params = new Parameters();
        this.colorEncoder = colorEncoder == null ? new ColorEncoder() : colorEncoder;
        this.meshData = meshData == null ? new MeshData() : meshData;
        this.jvxlData = jvxlData == null ? new JvxlData() : jvxlData;
        this.volumeData = new VolumeData();
        this.initializeIsosurface();
    }

    MeshDataServer getMeshDataServer() {
        return this.meshDataServer;
    }

    AtomDataServer getAtomDataServer() {
        return this.atomDataServer;
    }

    ColorEncoder getColorEncoder() {
        return this.colorEncoder;
    }

    public void setJvxlData(JvxlData jvxlData) {
        this.jvxlData = jvxlData;
    }

    public JvxlData getJvxlData() {
        return this.jvxlData;
    }

    MeshData getMeshData() {
        return this.meshData;
    }

    void setMarchingSquares(MarchingSquares marchingSquares) {
        this.marchingSquares = marchingSquares;
    }

    MarchingSquares getMarchingSquares() {
        return this.marchingSquares;
    }

    Parameters getParams() {
        return this.params;
    }

    public String getScript() {
        return this.params.script;
    }

    public String[] getTitle() {
        return this.params.title;
    }

    public BitSet getBsSelected() {
        return this.params.bsSelected;
    }

    public BitSet getBsIgnore() {
        return this.params.bsIgnore;
    }

    VolumeData getVolumeData() {
        return this.volumeData;
    }

    public Point4f getPlane() {
        return this.params.thePlane;
    }

    public int getState() {
        return this.state;
    }

    public int getColor(int n) {
        switch (n) {
            case -1: {
                return this.params.colorNeg;
            }
            case 1: {
                return this.params.colorPos;
            }
        }
        return 0;
    }

    public void setModelIndex(int n) {
        this.params.modelIndex = n;
    }

    public boolean getIUseBitSets() {
        return this.params.iUseBitSets;
    }

    public boolean getIAddGridPoints() {
        return this.params.iAddGridPoints;
    }

    public boolean getIsPositiveOnly() {
        return this.params.isPositiveOnly;
    }

    public boolean isInsideOut() {
        return this.params.insideOut;
    }

    public float getCutoff() {
        return this.params.cutoff;
    }

    public Hashtable getMoData() {
        return this.params.moData;
    }

    public boolean isCubeData() {
        return this.jvxlData.wasCubic;
    }

    public boolean setParameter(String string, Object object) {
        return this.setParameter(string, object, null);
    }

    public boolean setParameter(String string, Object object, BitSet bitSet) {
        String string2;
        if ("debug" == string) {
            boolean bl;
            this.params.logMessages = bl = ((Boolean)object).booleanValue();
            this.params.logCube = bl;
            return true;
        }
        if ("init" == string) {
            this.initializeIsosurface();
            this.params.script = (String)object;
            return false;
        }
        if ("finalize" == string) {
            this.initializeIsosurface();
            return true;
        }
        if ("commandOption" == string) {
            String string3 = " # " + (String)object;
            if (this.params.script.indexOf(string3) < 0) {
                this.params.script = this.params.script + string3;
            }
            return true;
        }
        if ("clear" == string) {
            if (this.voxelReader != null) {
                this.voxelReader.discardTempData(true);
            }
            return false;
        }
        if ("fileIndex" == string) {
            this.params.fileIndex = (Integer)object;
            if (this.params.fileIndex < 1) {
                this.params.fileIndex = 1;
            }
            return true;
        }
        if ("blockData" == string) {
            this.params.blockCubeData = (Boolean)object;
            return true;
        }
        if ("bsSolvent" == string) {
            this.params.bsSolvent = (BitSet)object;
            return true;
        }
        if ("propertySmoothing" == string) {
            this.params.propertySmoothing = (Boolean)object;
            return true;
        }
        if ("title" == string) {
            if (object == null) {
                this.params.title = null;
                return true;
            }
            if (object instanceof String[]) {
                this.params.title = (String[])object;
                for (int i = 0; i < this.params.title.length; ++i) {
                    if (this.params.title[i].length() <= 0) continue;
                    Logger.info(this.params.title[i]);
                }
            }
            return true;
        }
        if ("cutoff" == string) {
            this.params.cutoff = ((Float)object).floatValue();
            this.params.isPositiveOnly = false;
            return true;
        }
        if ("cutoffPositive" == string) {
            this.params.cutoff = ((Float)object).floatValue();
            this.params.isPositiveOnly = true;
            return true;
        }
        if ("cappingPlane" == string) {
            this.params.cappingPlane = (Point4f)object;
            this.params.doCapIsosurface = this.params.cappingPlane != null;
            return true;
        }
        if ("select" == string) {
            this.params.bsSelected = (BitSet)object;
            return true;
        }
        if ("ignore" == string) {
            this.params.bsIgnore = (BitSet)object;
            return true;
        }
        if ("scale" == string) {
            this.params.scale = ((Float)object).floatValue();
            return true;
        }
        if ("angstroms" == string) {
            this.params.isAngstroms = true;
            return true;
        }
        if ("resolution" == string) {
            float f = ((Float)object).floatValue();
            this.params.resolution = f > 0.0f ? f : Float.MAX_VALUE;
            return true;
        }
        if ("anisotropy" == string) {
            if ((this.params.dataType & 0x20) == 0) {
                this.params.setAnisotropy((Point3f)object);
            }
            return true;
        }
        if ("eccentricity" == string) {
            this.params.setEccentricity((Point4f)object);
            return true;
        }
        if ("addHydrogens" == string) {
            this.params.addHydrogens = (Boolean)object;
            return true;
        }
        if ("squareData" == string) {
            this.params.isSquared = (Boolean)object;
            return true;
        }
        if ("gridPoints" == string) {
            this.params.iAddGridPoints = true;
            return true;
        }
        if ("atomIndex" == string) {
            this.params.atomIndex = (Integer)object;
            return true;
        }
        if ("remappable" == string) {
            this.params.remappable = true;
            return true;
        }
        if ("insideOut" == string) {
            this.params.insideOut = true;
            return true;
        }
        if ("sign" == string) {
            this.params.isCutoffAbsolute = true;
            this.params.colorBySign = true;
            this.colorPtr = 0;
            return true;
        }
        if ("colorRGB" == string) {
            int n;
            this.params.colorPos = this.params.colorPosLCAO = (n = ((Integer)object).intValue());
            if (this.colorPtr++ == 0) {
                this.params.colorNeg = this.params.colorNegLCAO = n;
            }
            return true;
        }
        if ("rangeAll" == string) {
            this.params.rangeAll = true;
            return true;
        }
        if ("red" == string) {
            this.params.valueMappedToRed = ((Float)object).floatValue();
            return true;
        }
        if ("blue" == string) {
            this.params.valueMappedToBlue = ((Float)object).floatValue();
            this.params.rangeDefined = true;
            this.params.rangeAll = false;
            return true;
        }
        if ("reverseColor" == string) {
            this.params.isColorReversed = true;
            return true;
        }
        if ("setColorScheme" == string) {
            string2 = (String)object;
            if (string2.equals("sets")) {
                string = "mapColor";
            } else {
                this.colorEncoder.setColorScheme(string2);
                if (this.state == 3) {
                    this.voxelReader.applyColorScale();
                }
                return true;
            }
        }
        if ("center" == string) {
            this.params.center.set((Point3f)object);
            return true;
        }
        if ("withinDistance" == string) {
            this.params.distance = ((Float)object).floatValue();
            return true;
        }
        if ("withinPoint" == string) {
            this.params.point = (Point3f)object;
            return true;
        }
        if ("progressive" == string) {
            this.params.isXLowToHigh = true;
            return true;
        }
        if ("phase" == string) {
            string2 = (String)object;
            this.params.isCutoffAbsolute = true;
            this.params.colorBySign = true;
            this.params.colorByPhase = true;
            this.params.colorPhase = VoxelReader.getColorPhaseIndex(string2);
            if (this.params.colorPhase < 0) {
                Logger.warn(" invalid color phase: " + string2);
                this.params.colorPhase = 0;
            }
            boolean bl = this.params.colorByPhase = this.params.colorPhase != 0;
            if (this.state >= 2) {
                this.params.dataType = this.params.surfaceType;
                this.state = 3;
                this.params.isBicolorMap = true;
                this.voxelReader.applyColorScale();
            }
            return true;
        }
        boolean bl = "ionicRadius" == string;
        if (bl || "vdwRadius" == string) {
            this.params.setRadius(bl, ((Float)object).floatValue());
            return true;
        }
        if ("envelopeRadius" == string) {
            this.params.envelopeRadius = ((Float)object).floatValue();
            return true;
        }
        if ("cavityRadius" == string) {
            this.params.cavityRadius = ((Float)object).floatValue();
            return true;
        }
        if ("cavity" == string) {
            this.params.isCavity = true;
            return true;
        }
        if ("pocket" == string) {
            this.params.pocket = (Boolean)object;
            return true;
        }
        if ("minset" == string) {
            this.params.minSet = (Integer)object;
            return true;
        }
        if ("plane" == string) {
            this.params.setPlane((Point4f)object);
            return true;
        }
        if ("contour" == string) {
            this.params.isContoured = true;
            int n = (Integer)object;
            if (n >= 0) {
                this.params.nContours = n;
            } else {
                this.params.thisContour = -n;
            }
            return true;
        }
        if ("property" == string) {
            this.params.dataType = 181;
            this.params.theProperty = (float[])object;
            this.mapSurface(null);
            return true;
        }
        if ("sphere" == string) {
            this.params.setSphere(((Float)object).floatValue());
            this.voxelReader = new IsoShapeReader(this, this.params.distance);
            this.generateSurface();
            return true;
        }
        if ("ellipsoid" == string) {
            this.params.setEllipsoid((Point4f)object);
            this.voxelReader = new IsoShapeReader(this, this.params.distance);
            this.generateSurface();
            return true;
        }
        if ("lobe" == string) {
            this.params.setLobe((Point4f)object);
            this.voxelReader = new IsoShapeReader(this, 3, 2, 0, 15.0f);
            this.generateSurface();
            return true;
        }
        if ("hydrogenOrbital" == string) {
            if (!this.params.setAtomicOrbital((float[])object, this.state >= 2)) {
                return true;
            }
            this.voxelReader = new IsoShapeReader(this, this.params.psi_n, this.params.psi_l, this.params.psi_m, this.params.psi_Znuc);
            this.processState();
            return true;
        }
        if ("functionXY" == string) {
            this.params.setFunctionXY((Vector)object);
            if (this.params.isContoured) {
                this.volumeData.setPlaneParameters(new Point4f(0.0f, 0.0f, 1.0f, 0.0f));
            }
            this.generateSurface();
            return true;
        }
        if ("lcaoType" == string) {
            this.params.setLcao((String)object, this.colorPtr);
            return true;
        }
        if ("lcaoCartoonCenter" == string) {
            if (++this.state != 2) {
                return true;
            }
            if (this.params.center.x == Float.MAX_VALUE) {
                this.params.center.set((Vector3f)object);
            }
            return false;
        }
        if ("molecular" == string || "solvent" == string || "sasurface" == string || "nomap" == string) {
            this.params.setSolvent(string, ((Float)object).floatValue());
            Logger.info(this.params.calculationType);
            if (this.state < 2) {
                this.params.cutoff = 0.0f;
            }
            this.processState();
            return true;
        }
        if ("moData" == string) {
            this.params.moData = (Hashtable)object;
            return true;
        }
        if ("mep" == string) {
            this.params.setMep((float[])object, this.state >= 2, this.rangeDefined);
            this.processState();
            return true;
        }
        if ("molecularOrbital" == string) {
            this.params.setMO((Integer)object, this.state >= 2);
            Logger.info(this.params.calculationType);
            this.processState();
            return true;
        }
        if ("fileName" == string) {
            this.params.fileName = (String)object;
            return true;
        }
        if ("readFile" == string) {
            this.voxelReader = this.setFileData(object);
            if (this.voxelReader == null) {
                Logger.error("Could not set the data");
                return true;
            }
            this.generateSurface();
            return true;
        }
        if ("mapColor" == string) {
            if (object instanceof String && ((String)object).equalsIgnoreCase("sets")) {
                if (this.meshDataServer == null) {
                    this.meshData.getSurfaceSet(0);
                } else {
                    this.meshDataServer.fillMeshData(this.meshData, 1);
                    this.meshData.getSurfaceSet(0);
                    this.meshDataServer.fillMeshData(this.meshData, 3);
                }
                this.params.colorBySets = true;
            } else {
                this.voxelReader = this.setFileData(object);
                if (this.voxelReader == null) {
                    Logger.error("Could not set the mapping data");
                    return true;
                }
            }
            this.mapSurface(object);
            return true;
        }
        return false;
    }

    private void processState() {
        if (this.state == 1 && this.params.thePlane != null) {
            ++this.state;
        }
        if (this.state >= 2) {
            this.mapSurface(null);
        } else {
            this.generateSurface();
        }
    }

    private void setReader() {
        if (this.voxelReader != null) {
            return;
        }
        switch (this.params.dataType) {
            case 180: {
                this.voxelReader = new IsoPlaneReader(this);
                break;
            }
            case 171: 
            case 172: 
            case 179: 
            case 181: {
                this.voxelReader = new IsoSolventReader(this);
                break;
            }
            case 301: {
                this.voxelReader = new IsoMOReader(this);
                break;
            }
            case 517: {
                this.voxelReader = new IsoFxyReader(this);
                break;
            }
            case 304: {
                this.voxelReader = new IsoMepReader(this);
            }
        }
    }

    private void generateSurface() {
        boolean bl;
        if (++this.state != 2) {
            return;
        }
        this.setReader();
        boolean bl2 = bl = this.meshDataServer != null;
        if (this.params.colorBySign) {
            this.params.isBicolorMap = true;
        }
        if (this.voxelReader == null) {
            Logger.error("voxelReader is null for " + this.params.dataType);
            return;
        }
        if (!this.voxelReader.createIsosurface(false)) {
            Logger.error("Could not create isosurface");
            return;
        }
        if (this.params.pocket != null && bl) {
            this.voxelReader.selectPocket(this.params.pocket == false);
        }
        if (this.params.minSet > 0) {
            this.voxelReader.excludeMinimumSet();
        }
        if (bl) {
            this.meshDataServer.notifySurfaceGenerationCompleted();
        }
        if (this.jvxlData.jvxlDataIs2dContour) {
            this.voxelReader.colorIsosurface();
            this.state = 3;
        }
        if (this.params.colorBySign || this.params.isBicolorMap) {
            this.state = 3;
            this.voxelReader.applyColorScale();
        }
        this.voxelReader.jvxlUpdateInfo();
        this.setMarchingSquares(this.voxelReader.marchingSquares);
        this.voxelReader.discardTempData(false);
        this.voxelReader = null;
        this.params.mappedDataMin = Float.MAX_VALUE;
    }

    private void mapSurface(Object object) {
        if (this.state == 1 && this.params.thePlane != null) {
            ++this.state;
        }
        if (++this.state != 3) {
            return;
        }
        this.setReader();
        this.params.doCapIsosurface = false;
        if (this.params.thePlane != null) {
            this.params.cutoff = 0.0f;
            this.voxelReader.createIsosurface(true);
            if (this.meshDataServer != null) {
                this.meshDataServer.notifySurfaceGenerationCompleted();
            }
            this.params.mappedDataMin = Float.MAX_VALUE;
            this.voxelReader.readVolumeData(true);
        } else if (!this.params.colorBySets) {
            this.voxelReader.readVolumeParameters();
            this.params.mappedDataMin = Float.MAX_VALUE;
            this.voxelReader.readVolumeData(true);
        }
        this.voxelReader.colorIsosurface();
        this.voxelReader.jvxlUpdateInfo();
        this.voxelReader.updateTriangles();
        this.voxelReader.discardTempData(true);
        if (this.meshDataServer != null) {
            this.meshDataServer.notifySurfaceMappingCompleted();
        }
    }

    public Object getProperty(String string, int n) {
        if (string == "plane") {
            return this.jvxlData.jvxlPlane;
        }
        if (string == "jvxlFileData") {
            return JvxlReader.jvxlGetFile(this.jvxlData, this.params.title, "", true, n, null, null);
        }
        if (string == "jvxlFileInfo") {
            return this.jvxlData.jvxlInfoLine;
        }
        if (string == "jvxlSurfaceData") {
            return JvxlReader.jvxlGetFile(this.jvxlData, this.params.title, "", false, 1, null, null);
        }
        return null;
    }

    VoxelReader setFileData(Object object) {
        if (object instanceof VolumeData) {
            this.volumeData = (VolumeData)object;
            return new VolumeDataReader(this);
        }
        if (object instanceof Hashtable) {
            this.volumeData = (VolumeData)((Hashtable)object).get("volumeData");
            return new VolumeDataReader(this);
        }
        BufferedReader bufferedReader = (BufferedReader)object;
        String string = VolumeFileReader.determineFileType(bufferedReader);
        Logger.info("data file type was determined to be " + string);
        if (string.equals("Jvxl+")) {
            return new JvxlReader(this, bufferedReader);
        }
        if (string.equals("Jvxl")) {
            return new JvxlReader(this, bufferedReader);
        }
        if (string.equals("Apbs")) {
            return new ApbsReader(this, bufferedReader);
        }
        if (string.equals("Cube")) {
            return new CubeReader(this, bufferedReader);
        }
        if (string.equals("Jaguar")) {
            return new JaguarReader(this, bufferedReader);
        }
        if (string.equals("Xplor")) {
            return new XplorReader(this, bufferedReader);
        }
        if (string.equals("PltFormatted")) {
            return new PltFormattedReader(this, bufferedReader);
        }
        return null;
    }

    void initializeIsosurface() {
        this.params.initialize();
        this.colorPtr = 0;
        this.voxelReader = null;
        this.marchingSquares = null;
        this.initState();
    }

    public void initState() {
        this.state = 1;
        this.params.surfaceType = 0;
        this.params.dataType = 0;
    }

    public String setLcao() {
        this.params.colorPos = this.params.colorPosLCAO;
        this.params.colorNeg = this.params.colorNegLCAO;
        return this.params.lcaoType;
    }
}

