/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;

class ApbsReader
extends VolumeFileReader {
    ApbsReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.isApbsDx = true;
        this.jvxlData.wasCubic = true;
    }

    protected void readTitleLines() throws Exception {
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.skipComments(true);
        while (this.line != null && this.line.length() == 0) {
            this.br.readLine();
        }
        this.jvxlFileHeaderBuffer.append("APBS OpenDx DATA ").append(this.line).append("\n");
        this.jvxlFileHeaderBuffer.append("see http://apbs.sourceforge.net\n");
        this.isAngstroms = true;
    }

    protected void readAtomCountAndOrigin() throws Exception {
        String string = this.br.readLine();
        String[] stringArray = Parser.getTokens(string, 0);
        this.negativeAtomCount = false;
        this.atomCount = 0;
        if (stringArray.length >= 4) {
            this.volumetricOrigin.set(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
        }
        JvxlReader.jvxlCheckAtomLine(this.isXLowToHigh, this.isAngstroms, stringArray[0], string, this.jvxlFileHeaderBuffer);
    }

    protected void adjustVoxelVectorLine(int n) {
        this.line = "%dx" + n + this.line;
    }

    protected void readVoxelVector(int n) throws Exception {
        super.readVoxelVector(n);
        if (n == 2) {
            this.line = this.br.readLine();
            String[] stringArray = this.getTokens();
            String string = this.jvxlFileHeaderBuffer.toString();
            this.voxelCounts[0] = this.parseInt(stringArray[5]);
            string = TextFormat.simpleReplace(string, "%dx0delta", "" + this.voxelCounts[0]);
            this.voxelCounts[1] = this.parseInt(stringArray[6]);
            string = TextFormat.simpleReplace(string, "%dx1delta", "" + this.voxelCounts[1]);
            this.voxelCounts[2] = this.parseInt(stringArray[7]);
            string = TextFormat.simpleReplace(string, "%dx2delta", "" + this.voxelCounts[2]);
            this.jvxlFileHeaderBuffer = new StringBuffer(string);
            this.br.readLine();
        }
    }
}

