/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.io.IOException;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.export._Exporter;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.Text;
import org.jmol.util.BitSetUtil;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

public class _PovrayExporter
extends _Exporter {
    private int nBytes;
    private boolean isSlabEnabled;
    int nText;

    public _PovrayExporter() {
        this.use2dBondOrderCalculation = true;
    }

    private void output(String string) {
        this.nBytes += string.length();
        try {
            this.bw.write(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String finalizeOutput() {
        super.finalizeOutput();
        return this.getAuxiliaryFileData();
    }

    public void getHeader() {
        this.nBytes = 0;
        this.isSlabEnabled = this.viewer.getSlabEnabled();
        float f = this.viewer.getRotationRadius() * 2.0f;
        f *= 1.1f;
        f /= this.viewer.getZoomPercentFloat() / 100.0f;
        int n = Math.min(this.screenWidth, this.screenHeight);
        this.output("// ******************************************************\n");
        this.output("// Created by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("//\n");
        this.output("// This script was generated on " + this.getExportDate() + "\n");
        this.output("// ******************************************************\n");
        this.output("\n/* **** Jmol Embedded Script **** \n");
        this.output(TextFormat.simpleReplace(this.viewer.getSavedState("_Export"), "/*file*/", ""));
        this.output("\n*/\n");
        this.output("\n");
        this.output("// ******************************************************\n");
        this.output("// Declare the resolution, camera, and light sources.\n");
        this.output("// ******************************************************\n");
        this.output("\n");
        this.output("// NOTE: if you plan to render at a different resolution,\n");
        this.output("// be sure to update the following two lines to maintain\n");
        this.output("// the correct aspect ratio.\n\n");
        this.output("#declare Width = " + this.screenWidth + ";\n");
        this.output("#declare Height = " + this.screenHeight + ";\n");
        this.output("#declare minScreenDimension = " + n + ";\n");
        this.output("#declare showAtoms = true;\n");
        this.output("#declare showBonds = true;\n");
        this.output("#declare noShadows = true;\n");
        this.output("camera{\n");
        this.output("  orthographic\n");
        this.output("  location < " + (float)this.screenWidth / 2.0f + ", " + (float)this.screenHeight / 2.0f + ", 0>\n" + "\n");
        this.output("  // Negative right for a right hand coordinate system.\n");
        this.output("\n");
        this.output("  sky < 0, -1, 0 >\n");
        this.output("  right < -" + this.screenWidth + ", 0, 0>\n");
        this.output("  up < 0, " + this.screenHeight + ", 0 >\n");
        this.output("  look_at < " + (float)this.screenWidth / 2.0f + ", " + (float)this.screenHeight / 2.0f + ", 1000 >\n");
        this.output("}\n");
        this.output("\n");
        this.output("background { color rgb <" + this.rgbFractionalFromColix(this.viewer.getObjectColix(0), ',') + "> }\n");
        this.output("\n");
        this.tempP1.set(Graphics3D.getLightSource());
        this.output("// " + this.tempP1 + " \n");
        float f2 = Math.max(this.screenWidth, this.screenHeight);
        this.output("light_source { <" + this.tempP1.x * f2 + "," + this.tempP1.y * f2 + ", " + -1.0f * this.tempP1.z * f2 + "> " + " rgb <0.6,0.6,0.6> }\n");
        this.output("\n");
        this.output("\n");
        this.output("// ***********************************************\n");
        this.output("// macros for common shapes\n");
        this.output("// ***********************************************\n");
        this.output("\n");
        this.writeMacros();
    }

    private void writeMacros() {
        this.output("#default { finish {\n  ambient " + (float)Graphics3D.getAmbientPercent() / 100.0f + "\n" + "  diffuse " + (float)Graphics3D.getDiffusePercent() / 100.0f + "\n" + "  specular " + (float)Graphics3D.getSpecularPercent() / 100.0f + "\n" + "  roughness .00001\n  metallic\n  phong 0.9\n  phong_size 120\n}}" + "\n\n");
        this.output("#macro check_shadow()\n #if (noShadows)\n  no_shadow \n #end\n#end\n\n");
        this.output("#declare slabZ = " + this.slabZ + ";\n" + "#declare depthZ = " + this.depthZ + ";\n" + "#declare dzSlab = 10;\n" + "#declare dzDepth = dzSlab;\n" + "#declare dzStep = 0.001;\n\n");
        this.output("#macro clip()\n  clipped_by { box {<0,0,slabZ>,<Width,Height,depthZ>} }\n#end\n\n");
        this.output("#macro circleCap(Z,RADIUS,R,G,B,T)\n// cap for lower clip\n #local cutDiff = Z - slabZ;\n #local cutRadius2 = (RADIUS*RADIUS) - (cutDiff*cutDiff);\n #if (cutRadius2 > 0)\n  #local cutRadius = sqrt(cutRadius2);\n  #if (dzSlab > 0)\n   #declare dzSlab = dzSlab - dzStep;\n  #end\n  cylinder{<X,Y,slabZ-dzSlab>,<X,Y,(slabZ+1)>,cutRadius\n   pigment{rgbt<R,G,B,T>}\n   translucentFinish(T)\n   check_shadow()}\n #end\n// cap for upper clip\n #declare cutDiff = Z - depthZ;\n #declare cutRadius2 = (RADIUS*RADIUS) - (cutDiff*cutDiff);\n #if (cutRadius2 > 0)\n  #local cutRadius = sqrt(cutRadius2);\n  #if (dzDepth > 0)\n   #declare dzDepth = dzDepth - dzStep;\n  #end\n  cylinder{<X,Y,depthZ+dzDepth>,<X,Y,(depthZ-1)>,cutRadius\n   pigment{rgbt<R,G,B,T>}\n   translucentFinish(T)\n   check_shadow()}\n #end\n#end\n\n");
        this.writeMacrosFinish();
        this.writeMacrosAtom();
        this.writeMacrosBond();
        this.writeMacrosJoint();
        this.writeMacrosTriangle();
        this.writeMacrosTextPixel();
    }

    private void writeMacrosFinish() {
        this.output("#macro translucentFinish(T)\n #local shineFactor = T;\n #if (T <= 0.25)\n  #declare shineFactor = (1.0-4*T);\n #end\n #if (T > 0.25)\n  #declare shineFactor = 0;\n #end\n finish {\n  ambient " + (float)Graphics3D.getAmbientPercent() / 100.0f + "\n" + "  diffuse " + (float)Graphics3D.getDiffusePercent() / 100.0f + "\n" + "  specular " + (float)Graphics3D.getSpecularPercent() / 100.0f + "\n" + "  roughness .00001\n" + "  metallic shineFactor\n" + "  phong 0.9*shineFactor\n" + "  phong_size 120*shineFactor\n}" + "#end\n\n");
    }

    private void writeMacrosAtom() {
        this.output("#macro a(X,Y,Z,RADIUS,R,G,B,T)\n sphere{<X,Y,Z>,RADIUS\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n" + (this.isSlabEnabled ? " circleCap(Z,RADIUS,R,G,B,T)\n" : "") + "#end\n\n");
    }

    private void writeMacrosBond() {
        this.output("#macro b(X1,Y1,Z1,RADIUS1,X2,Y2,Z2,RADIUS2,R,G,B,T)\n cone{<X1,Y1,Z1>,RADIUS1,<X2,Y2,Z2>,RADIUS2\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n#end\n\n");
    }

    private void writeMacrosJoint() {
        this.output("#macro s(X,Y,Z,RADIUS,R,G,B,T)\n sphere{<X,Y,Z>,RADIUS\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n" + (this.isSlabEnabled ? " circleCap(Z,RADIUS,R,G,B,T)\n" : "") + "#end\n\n");
    }

    private void writeMacrosTriangle() {
        this.output("#macro r(X1,Y1,Z1,X2,Y2,Z2,X3,Y3,Z3,R,G,B,T)\n triangle{<X1,Y1,Z1>,<X2,Y2,Z2>,<X3,Y3,Z3>\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n#end\n\n");
    }

    private void writeMacrosTextPixel() {
        this.output("#macro p(X,Y,Z,R,G,B)\n box{<X,Y,Z>,<X+1,Y+1,Z+1>\n  pigment{rgb<R,G,B>}\n  clip()\n  check_shadow()}\n#end\n\n");
    }

    private String triad(Tuple3f tuple3f) {
        if (Float.isNaN(tuple3f.x)) {
            return "0,0,0";
        }
        return tuple3f.x + "," + tuple3f.y + "," + tuple3f.z;
    }

    private String color4(short s) {
        return this.rgbFractionalFromColix(s, ',') + "," + this.translucencyFractionalFromColix(s);
    }

    public void getFooter() {
    }

    private String getAuxiliaryFileData() {
        return "; Created by: Jmol " + Viewer.getJmolVersion() + "\n; Creation date: " + this.getExportDate() + "\n; File created: " + this.fileName + " (" + this.nBytes + " bytes)\n\n" + (this.commandLineOptions != null ? this.commandLineOptions : "\n; Jmol state: " + this.fileName + ".spt" + "\nInput_File_Name=" + this.fileName + "\nOutput_to_File=true" + "\nOutput_File_Type=%FILETYPE%" + "\nOutput_File_Name=%OUTPUTFILENAME%" + "\nWidth=" + this.screenWidth + "\nHeight=" + this.screenHeight + "\nAntialias=true" + "\nAntialias_Threshold=0.1" + "\nDisplay=true" + "\nPause_When_Done=true" + "\nWarning_Level=5" + "\nVerbose=false" + "\n");
    }

    public void renderAtom(Atom atom, short s) {
        this.fillSphereCentered(atom.screenDiameter, atom.screenX, atom.screenY, atom.screenZ, s);
    }

    public void fillCylinder(Point3f point3f, Point3f point3f2, short s, short s2, byte by, int n, int n2) {
        if (s == s2) {
            this.renderJoint(point3f, s, by, n);
            this.renderCylinder(point3f, point3f2, s, by, n);
            this.renderJoint(point3f2, s2, by, n);
            return;
        }
        this.tempV2.set(point3f2);
        this.tempV2.add(point3f);
        this.tempV2.scale(0.5f);
        this.tempP1.set(this.tempV2);
        this.renderJoint(point3f, s, by, n);
        this.renderCylinder(point3f, this.tempP1, s, by, n);
        this.renderCylinder(this.tempP1, point3f2, s2, by, n);
        this.renderJoint(point3f2, s2, by, n);
    }

    public void renderCylinder(Point3f point3f, Point3f point3f2, short s, byte by, int n) {
        short s2 = this.viewer.scaleToScreen((int)point3f.z, n);
        if (point3f.distance(point3f2) == 0.0f) {
            this.fillSphereCentered(s, s2, point3f);
            return;
        }
        String string = this.rgbFractionalFromColix(s, ',');
        float f = (float)s2 / 2.0f;
        float f2 = this.viewer.scaleToScreen((int)point3f2.z, n / 2);
        this.output("b(" + point3f.x + "," + point3f.y + "," + point3f.z + "," + f + "," + point3f2.x + "," + point3f2.y + "," + point3f2.z + "," + f2 + "," + string + "," + this.translucencyFractionalFromColix(s) + ")\n");
    }

    private void renderJoint(Point3f point3f, short s, byte by, int n) {
        if (by == 3) {
            String string = this.rgbFractionalFromColix(s, ',');
            float f = this.viewer.scaleToScreen((int)point3f.z, n / 2);
            this.output("s(" + point3f.x + "," + point3f.y + "," + point3f.z + "," + f + "," + string + "," + this.translucencyFractionalFromColix(s) + ")\n");
        }
    }

    public void renderIsosurface(Point3f[] point3fArray, short s, short[] sArray, Vector3f[] vector3fArray, int[][] nArray, BitSet bitSet, int n, int n2) {
        String string;
        int n3;
        int n4;
        if (n == 0) {
            return;
        }
        int n5 = 0;
        int n6 = BitSetUtil.length(bitSet);
        while (--n6 >= 0) {
            if (!bitSet.get(n6)) continue;
            n5 += n2 == 4 && nArray[n6].length == 4 ? 2 : 1;
        }
        if (n5 == 0) {
            return;
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        this.output("mesh2 {\n");
        this.output("vertex_vectors { " + n);
        for (n4 = 0; n4 < n; ++n4) {
            this.viewer.transformPoint(point3fArray[n4], this.tempP1);
            this.output(", <" + this.triad(this.tempP1) + ">");
            this.output(" //" + n4 + "\n");
        }
        this.output("\n}\n");
        int n7 = n4 = vector3fArray != null ? 1 : 0;
        if (n4 != 0) {
            this.output("normal_vectors { " + n);
            for (n3 = 0; n3 < n; ++n3) {
                this.output(", <" + this.triad(this.getNormal(point3fArray[n3], vector3fArray[n3])) + ">");
                this.output(" //" + n3 + "\n");
            }
            this.output("\n}\n");
        }
        if (sArray != null) {
            n3 = 0;
            for (int i = 0; i < n; ++i) {
                string = this.color4(sArray[i]);
                if (hashtable.containsKey(string)) continue;
                hashtable.put(string, new Integer(n3++));
            }
            String[] stringArray = new String[n3];
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                stringArray[((Integer)hashtable.get((Object)string)).intValue()] = string = (String)enumeration.nextElement();
            }
            this.output("texture_list { " + n3);
            for (int i = 0; i < n3; ++i) {
                this.output("\n, texture{pigment{rgbt<" + stringArray[i] + ">}" + " translucentFinish(" + this.translucencyFractionalFromColix(sArray[0]) + ")}");
            }
            this.output("\n}\n");
        }
        this.output("face_indices { " + n5);
        n3 = BitSetUtil.length(bitSet);
        while (--n3 >= 0) {
            if (!bitSet.get(n3)) continue;
            this.output(", <" + nArray[n3][0] + "," + nArray[n3][1] + "," + nArray[n3][2] + ">");
            if (sArray != null) {
                string = this.color4(sArray[nArray[n3][0]]);
                this.output("," + (Integer)hashtable.get(string));
                string = this.color4(sArray[nArray[n3][1]]);
                this.output("," + (Integer)hashtable.get(string));
                string = this.color4(sArray[nArray[n3][2]]);
                this.output("," + (Integer)hashtable.get(string));
            }
            this.output(" //\n");
            if (n2 != 4 || nArray[n3].length != 4) continue;
            this.output(", <" + nArray[n3][0] + "," + nArray[n3][2] + "," + nArray[n3][3] + ">");
            if (sArray != null) {
                string = this.color4(sArray[nArray[n3][0]]);
                this.output("," + (Integer)hashtable.get(string));
                string = this.color4(sArray[nArray[n3][2]]);
                this.output("," + (Integer)hashtable.get(string));
                string = this.color4(sArray[nArray[n3][3]]);
                this.output("," + (Integer)hashtable.get(string));
            }
            this.output(" //\n");
        }
        this.output("\n}\n");
        if (sArray == null) {
            this.output("pigment{rgbt<" + this.color4(s) + ">}\n");
            this.output("  translucentFinish(" + this.translucencyFractionalFromColix(s) + ")\n");
        }
        this.output("  check_shadow()\n");
        this.output("  clip()\n");
        this.output("}\n");
    }

    private Point3f getNormal(Point3f point3f, Vector3f vector3f) {
        this.tempP1.set(point3f);
        this.tempP1.add(vector3f);
        this.viewer.transformPoint(point3f, this.tempP2);
        this.viewer.transformPoint(this.tempP1, this.tempP3);
        this.tempP3.sub(this.tempP2);
        return this.tempP3;
    }

    public void fillCylinder(short s, byte by, int n, Point3f point3f, Point3f point3f2) {
        float f;
        if (point3f.distance(point3f2) == 0.0f) {
            this.fillSphereCentered(n, point3f.x, point3f.y, point3f.z, s);
            return;
        }
        float f2 = f = (float)n / 2.0f;
        this.output("b(" + this.triad(point3f) + "," + f + "," + this.triad(point3f2) + "," + f2 + "," + this.color4(s) + ")\n");
    }

    public void fillScreenedCircleCentered(short s, int n, int n2, int n3, int n4) {
        String string = this.rgbFractionalFromColix(s, ',');
        float f = (float)n / 2.0f;
        this.output("b(" + n2 + "," + n3 + "," + n4 + "," + f + "," + n2 + "," + n3 + "," + (n4 + 1) + "," + f + "," + string + ",0.8)\n");
    }

    public void drawPixel(short s, int n, int n2, int n3) {
        this.fillSphereCentered(1.5f, n, n2, n3, s);
    }

    public void drawTextPixel(int n, int n2, int n3, int n4) {
        this.output("p(" + n2 + "," + n3 + "," + n4 + "," + this.rgbFractionalFromArgb(n, ',') + ")\n");
    }

    public void fillTriangle(short s, Point3f point3f, Point3f point3f2, Point3f point3f3) {
        this.output("r(" + this.triad(point3f) + "," + this.triad(point3f2) + "," + this.triad(point3f3) + "," + this.color4(s) + ")\n");
    }

    public void fillCone(short s, byte by, int n, Point3f point3f, Point3f point3f2) {
        this.output("b(" + this.triad(point3f) + "," + (float)n / 2.0f + "," + this.triad(point3f2) + ",0" + "," + this.color4(s) + ")\n");
    }

    public void fillSphereCentered(short s, int n, Point3f point3f) {
        this.output("a(" + this.triad(point3f) + "," + (float)n / 2.0f + "," + this.color4(s) + ")\n");
    }

    private void fillSphereCentered(float f, float f2, float f3, float f4, short s) {
        this.output("a(" + f2 + "," + f3 + "," + f4 + "," + f / 2.0f + "," + this.color4(s) + ")\n");
    }

    public void plotText(int n, int n2, int n3, int n4, String string, Font3D font3D) {
        this.output("// start text " + ++this.nText + ": " + string + "\n");
        this.g3d.plotText(n, n2, n3, n4, string, font3D, this.jmolRenderer);
        this.output("// end text " + this.nText + ": " + string + "\n");
    }

    public void fillHermite(short s, int n, int n2, int n3, int n4, Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
    }

    public void drawHermite(short s, int n, Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
    }

    public void drawHermite(short s, boolean bl, boolean bl2, int n, Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, Point3f point3f5, Point3f point3f6, Point3f point3f7, Point3f point3f8, int n2) {
    }

    public void renderText(Text text) {
    }

    public void drawString(short s, String string, Font3D font3D, int n, int n2, int n3, int n4) {
    }
}

