/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.readers.more.SpartanArchive;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class SpartanReader
extends AtomSetCollectionReader {
    String modelName = "Spartan file";
    int atomCount;
    Hashtable moData = new Hashtable();

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("spartan");
        String string = "Cartesian Coordinates (Ang";
        try {
            if (this.isSpartanArchive(string)) {
                SpartanArchive spartanArchive = new SpartanArchive(this, this.atomSetCollection, this.moData);
                this.atomCount = spartanArchive.readArchive(this.line, true);
                if (this.atomCount > 0) {
                    this.atomSetCollection.setAtomSetName(this.modelName);
                }
            } else if (this.line.indexOf(string) >= 0) {
                this.readAtoms();
                this.discardLinesUntilContains("Vibrational Frequencies");
                if (this.line != null) {
                    this.readFrequencies();
                }
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    boolean isSpartanArchive(String string) throws Exception {
        String string2 = "";
        while (this.readLine() != null) {
            if (this.line.equals("GEOMETRY")) {
                this.line = string2;
                return true;
            }
            if (this.line.indexOf(string) >= 0) {
                return false;
            }
            string2 = this.line;
        }
        return false;
    }

    void readAtoms() throws Exception {
        this.discardLinesUntilBlank();
        while (this.readLine() != null && this.parseInt(this.line, 0, 3) > 0) {
            String string = this.parseToken(this.line, 4, 6);
            String string2 = this.parseToken(this.line, 7, 13);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = string;
            atom.atomName = string2;
            atom.set(this.parseFloat(this.line, 17, 30), this.parseFloat(this.line, 31, 44), this.parseFloat(this.line, 45, 58));
        }
    }

    void readFrequencies() throws Exception {
        int n = 0;
        block0: while (true) {
            float f;
            int n2;
            this.discardLinesUntilNonBlank();
            int n3 = n;
            this.next[0] = 16;
            for (n2 = 0; n2 < 3 && !Float.isNaN(f = this.parseFloat()); ++n2) {
                if (++n <= 1) continue;
                this.atomSetCollection.cloneFirstAtomSet();
            }
            if (n2 == 0) {
                return;
            }
            Atom[] atomArray = this.atomSetCollection.getAtoms();
            this.discardLines(2);
            int n4 = this.atomSetCollection.getFirstAtomSetAtomCount();
            int n5 = 0;
            while (true) {
                if (n5 >= n4) continue block0;
                this.readLine();
                for (int i = 0; i < n2; ++i) {
                    int n6 = i * 23 + 10;
                    float f2 = this.parseFloat(this.line, n6, n6 + 7);
                    float f3 = this.parseFloat(this.line, n6 + 7, n6 + 14);
                    float f4 = this.parseFloat(this.line, n6 + 14, n6 + 21);
                    int n7 = (n3 + i) * n4 + n5;
                    Atom atom = atomArray[n7];
                    atom.vectorX = f2;
                    atom.vectorY = f3;
                    atom.vectorZ = f4;
                }
                ++n5;
            }
            break;
        }
    }
}

