/*
 * Decompiled with CFR 0.152.
 */
package org.pf.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.pf.util.Association;
import org.pf.util.AssociationList;
import org.pf.util.OrderedSet;

public class OrderedMap
implements Map {
    private AssociationList mapping = null;

    protected AssociationList getMapping() {
        return this.mapping;
    }

    protected void setMapping(AssociationList newValue) {
        this.mapping = newValue;
    }

    public OrderedMap() {
        this.setMapping(this.createEmptyMapping());
    }

    public void clear() {
        this.getMapping().clear();
    }

    public boolean containsKey(Object key) {
        return this.getMapping().findAssociation(key) != null;
    }

    public boolean containsValue(Object value) {
        return this.getMapping().asHashMap().containsValue(value);
    }

    public Set entrySet() {
        OrderedSet entrySet = new OrderedSet(this.size());
        int i = 0;
        while (i < this.size()) {
            Association assoc = this.getMapping().associationAt(i);
            entrySet.add(assoc);
            ++i;
        }
        return entrySet;
    }

    public Object get(Object key) {
        return this.getMapping().valueAt(key);
    }

    public boolean isEmpty() {
        return this.getMapping().size() == 0;
    }

    public Set keySet() {
        OrderedSet keys = new OrderedSet(this.size());
        keys.addAll(this.getMapping().keys());
        return keys;
    }

    public Object put(Object key, Object value) {
        this.getMapping().put(key, value);
        return value;
    }

    public void putAll(Map map) {
        this.getMapping().putAll(map);
    }

    public Object remove(Object key) {
        Association assoc = this.getMapping().removeKey(key);
        if (assoc == null) {
            return null;
        }
        return assoc.value();
    }

    public int size() {
        return this.getMapping().size();
    }

    public Collection values() {
        return this.getMapping().values();
    }

    protected AssociationList createEmptyMapping() {
        return new AssociationList();
    }
}

