/*
 * Decompiled with CFR 0.152.
 */
package org.pf.util;

public class BitSet {
    private static final int LOW_BIT = 0;
    private static final int HIGH_BIT = 7;
    private int bits = 0;

    protected int getBits() {
        return this.bits;
    }

    protected void setBits(int newValue) {
        this.bits = newValue;
    }

    public BitSet() {
        this(0);
    }

    public BitSet(int initialValue) {
        if (initialValue >= 0 && initialValue <= 255) {
            this.setBits(initialValue);
        }
    }

    public int getValue() {
        return this.getBits();
    }

    public boolean isBitSet(int bit) {
        int andValue = 1 << bit;
        return (this.getBits() & andValue) > 0;
    }

    public boolean isBitNotSet(int bit) {
        return !this.isBitSet(bit);
    }

    public void setBit(int bit) {
        int orValue = 1 << bit;
        this.setBits(this.getBits() | orValue);
    }

    public void unsetBit(int bit) {
        int i = 0;
        int andValue = 0;
        i = 0;
        while (i <= 7) {
            if (i != bit) {
                andValue |= 1 << i;
            }
            ++i;
        }
        this.setBits(this.getBits() & andValue);
    }

    public void toggleBit(int bit) {
        if (this.isBitSet(bit)) {
            this.unsetBit(bit);
        } else {
            this.setBit(bit);
        }
    }

    public String toString() {
        int i = 0;
        StringBuffer buffer = null;
        buffer = new StringBuffer();
        i = 7;
        while (i >= 0) {
            buffer.append(this.isBitSet(i) ? "1" : "0");
            --i;
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BitSet) {
            return ((BitSet)obj).getValue() == this.getValue();
        }
        return false;
    }

    public int hashCode() {
        return this.getValue();
    }
}

