/*
 * Decompiled with CFR 0.152.
 */
package org.pf.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pf.bif.callback.IObjectProcessor;
import org.pf.bif.filter.IObjectFilter;
import org.pf.util.AAssociationProcessor;
import org.pf.util.Association;
import org.pf.util.CollectionUtil;

public class AssociationList {
    public static final Association[] EMPTY_ASSOCIATION_ARRAY = new Association[0];
    private List list = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected List getList() {
        return this.list;
    }

    protected void setList(List newValue) {
        this.list = newValue;
    }

    public AssociationList() {
        this.clear();
    }

    public AssociationList(Map map) {
        this.clear();
        this.addAll(map);
    }

    public void clear() {
        this.setList(new ArrayList());
    }

    public int size() {
        return this.getList().size();
    }

    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    public void add(Association association) {
        if (this.isValidAssociation(association)) {
            this.basicAdd(association);
        }
    }

    public void add(Object key, Object value) {
        this.add(this.newElement(key, value));
    }

    public void addAll(Map map) {
        this.addOrPutAll(map, true);
    }

    public void addAll(Association[] associations) {
        if (associations != null) {
            int i = 0;
            while (i < associations.length) {
                this.add(associations[i]);
                ++i;
            }
        }
    }

    public Association[] associationArray() {
        return this.associationArray(null);
    }

    public Association[] associationArray(IObjectFilter filter) {
        Collection result = this.collectElements(filter);
        if (this.collUtil().isNullOrEmpty(result)) {
            return EMPTY_ASSOCIATION_ARRAY;
        }
        return (Association[])this.collUtil().toArray(result);
    }

    public List asList() {
        ArrayList newList = new ArrayList(this.size());
        newList.addAll(this.getList());
        return newList;
    }

    public Hashtable asHashtable() {
        Hashtable map = new Hashtable(this.size());
        return (Hashtable)this.addAllToMap(map);
    }

    public HashMap asHashMap() {
        HashMap map = new HashMap(this.size());
        return (HashMap)this.addAllToMap(map);
    }

    public Map addAllToMap(final Map map) {
        AAssociationProcessor processor = new AAssociationProcessor(){

            public boolean processObject(Association association) {
                map.put(association.key(), association.value());
                return true;
            }
        };
        this.processEach(processor);
        return map;
    }

    public void processEach(IObjectProcessor associationProcessor) {
        boolean goOn = true;
        int count = this.getList().size();
        int i = 0;
        while (i < count && goOn) {
            goOn = associationProcessor.processObject(this.getList().get(i));
            ++i;
        }
    }

    public Association associationAt(int index) {
        return (Association)this.getList().get(index);
    }

    public void setAssociationAt(int index, Association associaction) {
        this.getList().set(index, associaction);
    }

    public Object keyAt(int index) {
        return this.associationAt(index).key();
    }

    public Object valueAt(int index) {
        return this.associationAt(index).value();
    }

    public Object valueAt(Object key) {
        return this.findValue(key);
    }

    public Association findAssociation(Object key) {
        if (key != null) {
            Iterator iter = this.getList().iterator();
            while (iter.hasNext()) {
                Association assoc = (Association)iter.next();
                if (!key.equals(assoc.key())) continue;
                return assoc;
            }
        }
        return null;
    }

    public boolean remove(Association association) {
        return this.getList().remove(association);
    }

    public Association remove(int index) {
        return (Association)this.getList().remove(index);
    }

    public Association removeKey(Object key) {
        Association assoc = this.findAssociation(key);
        if (assoc == null) {
            return null;
        }
        if (this.remove(assoc)) {
            return assoc;
        }
        return null;
    }

    public void removeAll(Collection assocCollection) {
        this.getList().removeAll(assocCollection);
    }

    public List values() {
        ArrayList<Object> values = new ArrayList<Object>(this.size());
        int i = 0;
        while (i < this.size()) {
            values.add(this.valueAt(i));
            ++i;
        }
        return values;
    }

    public List keys() {
        ArrayList<Object> keys = new ArrayList<Object>(this.size());
        int i = 0;
        while (i < this.size()) {
            keys.add(this.keyAt(i));
            ++i;
        }
        return keys;
    }

    public boolean containsKey(Object key) {
        return this.findAssociation(key) != null;
    }

    public void put(Object key, Object value) {
        Association assoc = this.findAssociation(key);
        if (assoc == null) {
            assoc = this.newElement(key, value);
            this.add(assoc);
        } else {
            assoc.value(value);
        }
    }

    public void put(Association association) {
        if (!this.isCorrectElementType(association)) {
            return;
        }
        int index = this.indexOf(association.key());
        if (index < 0) {
            this.add(association);
        } else {
            this.getList().set(index, association);
        }
    }

    public void putAll(Association[] associations) {
        if (associations != null) {
            int i = 0;
            while (i < associations.length) {
                this.put(associations[i]);
                ++i;
            }
        }
    }

    public void putAll(Map map) {
        this.addOrPutAll(map, false);
    }

    public int indexOf(Object key) {
        if (key != null) {
            int i = 0;
            while (i < this.size()) {
                Association assoc = (Association)this.getList().get(i);
                if (key.equals(assoc.key())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected boolean isValidAssociation(Association association) {
        return association != null && association.key() != null && association.value() != null && this.isCorrectElementType(association);
    }

    protected void basicAdd(Association association) {
        this.getList().add(association);
    }

    protected Object findValue(Object key) {
        Association assoc = this.findAssociation(key);
        if (assoc == null) {
            return null;
        }
        return assoc.value();
    }

    protected void addOrPutAll(Map map, boolean add) {
        if (map != null) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!this.isCorrectKeyType(entry.getKey()) || !this.isCorrectValueType(entry.getValue())) continue;
                if (add) {
                    this.add((String)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                this.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    protected boolean isCorrectElementType(Association association) {
        return this.elementClass().isInstance(association);
    }

    protected boolean isCorrectKeyType(Object key) {
        return this.keyClass().isInstance(key);
    }

    protected boolean isCorrectValueType(Object value) {
        return this.valueClass().isInstance(value);
    }

    protected Association newElement(Object key, Object value) {
        return new Association(key, value);
    }

    protected Class elementClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.pf.util.Association");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected Class keyClass() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected Class valueClass() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected Collection collectElements(IObjectFilter filter) {
        Collection result = filter == null ? this.getList() : CollectionUtil.current().copy(this.getList(), filter);
        return result;
    }

    protected CollectionUtil collUtil() {
        return CollectionUtil.current();
    }
}

