/*
 * Decompiled with CFR 0.152.
 */
package org.pf.textx;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import org.pf.textx.BasicVariableContainer;
import org.pf.textx.UnknownVariableException;
import org.pf.textx.VariableContainer;

public class GlobalLocalVariables
implements VariableContainer {
    private VariableContainer globalVars = null;
    private VariableContainer localVars = null;

    protected VariableContainer getGlobalVars() {
        return this.globalVars;
    }

    protected void setGlobalVars(VariableContainer newValue) {
        this.globalVars = newValue;
    }

    protected VariableContainer getLocalVars() {
        return this.localVars;
    }

    protected void setLocalVars(VariableContainer newValue) {
        this.localVars = newValue;
    }

    public GlobalLocalVariables() {
        this.setGlobalVars(new BasicVariableContainer());
        this.setLocalVars(new BasicVariableContainer());
    }

    public void newLocalContext(VariableContainer varContainer) {
        if (varContainer != null) {
            this.setLocalVars(varContainer);
        }
    }

    public void newGlobalContext(VariableContainer varContainer) {
        if (varContainer != null) {
            this.setGlobalVars(varContainer);
        }
    }

    public void set(String varName, String value, boolean global) {
        if (global) {
            this.setGlobal(varName, value);
        } else {
            this.setLocal(varName, value);
        }
    }

    public void setLocal(String varName, String value) {
        this.localVariables().setValue(varName, value);
    }

    public void setLocalObject(String varName, Object value) {
        this.localVariables().setValueFor(varName, value);
    }

    public void setGlobal(String varName, String value) {
        this.globalVariables().setValue(varName, value);
    }

    public void setGlobalObject(String varName, Object value) {
        this.globalVariables().setValueFor(varName, value);
    }

    public void setGlobalFrom(Properties vars) {
        this.setVariablesFrom(vars, true);
    }

    public void setLocalFrom(Properties vars) {
        this.setVariablesFrom(vars, false);
    }

    public void setValue(String varName, String value) {
        this.setLocal(varName, value);
    }

    public void setValueFor(String varName, Object value) {
        this.setLocalObject(varName, value);
    }

    public void removeVariable(String varName) {
        this.getLocalVars().removeVariable(varName);
        this.getGlobalVars().removeVariable(varName);
    }

    public Set knownVariableNames() {
        HashSet names = new HashSet();
        names.addAll(this.getGlobalVars().knownVariableNames());
        names.addAll(this.getLocalVars().knownVariableNames());
        return names;
    }

    public Object getValue(String varName) throws UnknownVariableException {
        if (this.localVariables().isKnownVariable(varName)) {
            return this.localVariables().getValue(varName);
        }
        return this.globalVariables().getValue(varName);
    }

    public boolean isKnownVariable(String varName) {
        if (this.localVariables().isKnownVariable(varName)) {
            return true;
        }
        return this.globalVariables().isKnownVariable(varName);
    }

    protected void setVariablesFrom(Properties vars, boolean global) {
        Enumeration keys = ((Hashtable)vars).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.set(key, vars.getProperty(key), global);
        }
    }

    protected VariableContainer localVariables() {
        return this.getLocalVars();
    }

    protected VariableContainer globalVariables() {
        return this.getGlobalVars();
    }
}

