/*
 * Decompiled with CFR 0.152.
 */
package org.pf.textx;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.pf.textx.FunctionResolver;
import org.pf.textx.InvalidParameterException;
import org.pf.textx.UnknownFunctionException;

public class BasicTextFunctionResolver
implements FunctionResolver {
    public static final String UPPERCASE_FIRST_LETTER = "UC1";
    public static final String LOWERCASE_FIRST_LETTER = "LC1";
    public static final String UPPERCASE = "UC";
    public static final String LOWERCASE = "LC";
    public static final String DATE = "Date";

    public Object executeFunction(String functionName, Vector parameter) throws UnknownFunctionException, InvalidParameterException {
        if (functionName.equals(UPPERCASE_FIRST_LETTER)) {
            return this.funcUppercaseFirstLetter(parameter);
        }
        if (functionName.equals(LOWERCASE_FIRST_LETTER)) {
            return this.funcLowercaseFirstLetter(parameter);
        }
        if (functionName.equals(UPPERCASE)) {
            return this.funcUppercase(parameter);
        }
        if (functionName.equals(LOWERCASE)) {
            return this.funcLowercase(parameter);
        }
        if (functionName.equals(DATE)) {
            return this.funcDate(parameter);
        }
        throw new UnknownFunctionException(functionName);
    }

    public boolean isKnownFunction(String functionName) {
        if (functionName.equals(UPPERCASE_FIRST_LETTER)) {
            return true;
        }
        if (functionName.equals(LOWERCASE_FIRST_LETTER)) {
            return true;
        }
        if (functionName.equals(UPPERCASE)) {
            return true;
        }
        if (functionName.equals(LOWERCASE)) {
            return true;
        }
        return functionName.equals(DATE);
    }

    protected String upperLowerFirstLetter(Vector parameter, boolean upper) throws InvalidParameterException {
        String param1 = null;
        String result = null;
        this.checkParameterCount(UPPERCASE_FIRST_LETTER, parameter, 1);
        param1 = (String)parameter.elementAt(0);
        if (param1.length() > 0) {
            result = param1.substring(0, 1);
            result = upper ? String.valueOf(result.toUpperCase()) + param1.substring(1) : String.valueOf(result.toLowerCase()) + param1.substring(1);
        } else {
            result = param1;
        }
        return result;
    }

    protected String funcUppercaseFirstLetter(Vector parameter) throws InvalidParameterException {
        return this.upperLowerFirstLetter(parameter, true);
    }

    protected String funcLowercaseFirstLetter(Vector parameter) throws InvalidParameterException {
        return this.upperLowerFirstLetter(parameter, false);
    }

    protected String funcUppercase(Vector parameter) throws InvalidParameterException {
        this.checkParameterCount(UPPERCASE, parameter, 1);
        String param = (String)parameter.elementAt(0);
        return param.toUpperCase();
    }

    protected String funcLowercase(Vector parameter) throws InvalidParameterException {
        this.checkParameterCount(LOWERCASE, parameter, 1);
        String param = (String)parameter.elementAt(0);
        return param.toLowerCase();
    }

    protected String funcDate(Vector parameter) throws InvalidParameterException {
        SimpleDateFormat df = null;
        if (parameter != null) {
            if (parameter.size() == 0) {
                df = new SimpleDateFormat();
            } else if (parameter.size() == 1) {
                df = new SimpleDateFormat((String)parameter.elementAt(0));
            } else {
                this.checkParameterCount(DATE, parameter, 1);
            }
        }
        if (df == null) {
            df = new SimpleDateFormat();
        }
        return df.format(new Date());
    }

    protected void checkParameterCount(String funcName, Vector parameter, int count) throws InvalidParameterException {
        String message = null;
        if (parameter.size() != count) {
            message = "Wrong number of parameters ! ";
            message = String.valueOf(message) + "Required: " + Integer.toString(count) + " ; ";
            message = String.valueOf(message) + "Given: " + Integer.toString(parameter.size()) + ".";
            throw new InvalidParameterException(funcName, message);
        }
    }
}

