/*
 * Decompiled with CFR 0.152.
 */
package org.pf.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class TakeAllLayoutManager
implements LayoutManager {
    private int topMargin = 0;
    private int bottomMargin = 0;
    private int leftMargin = 0;
    private int rightMargin = 0;

    public TakeAllLayoutManager() {
        this(0);
    }

    public TakeAllLayoutManager(int margin) {
        this(margin, margin, margin, margin);
    }

    public TakeAllLayoutManager(int left, int right, int top, int bottom) {
        this.setLeftMargin(left);
        this.setRightMargin(right);
        this.setTopMargin(top);
        this.setBottomMargin(bottom);
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        insets.left += this.getLeftMargin();
        insets.top += this.getTopMargin();
        insets.right += this.getRightMargin();
        insets.bottom += this.getBottomMargin();
        int maxWidth = parent.getSize().width - (insets.left + insets.right);
        int maxHeight = parent.getSize().height - (insets.top + insets.bottom);
        int nComps = parent.getComponentCount();
        int i = 0;
        while (i < nComps) {
            Component comp = parent.getComponent(i);
            comp.setBounds(insets.left, insets.top, maxWidth, maxHeight);
            ++i;
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public Dimension minimumLayoutSize(Container parent) {
        return null;
    }

    public Dimension preferredLayoutSize(Container parent) {
        return null;
    }

    public void removeLayoutComponent(Component comp) {
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(int newValue) {
        if (newValue >= 0) {
            this.topMargin = newValue;
        }
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(int newValue) {
        if (newValue >= 0) {
            this.bottomMargin = newValue;
        }
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(int newValue) {
        if (newValue >= 0) {
            this.leftMargin = newValue;
        }
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(int newValue) {
        if (newValue >= 0) {
            this.rightMargin = newValue;
        }
    }
}

