/*
 * Decompiled with CFR 0.152.
 */
package org.pf.plugin;

import java.util.Properties;
import org.pf.plugin.IInitializablePlugin;
import org.pf.reflect.ClassInfo;

class PluginHolder {
    private String externalId = null;
    private ClassInfo classInfo = null;
    private boolean isSingleton = false;
    private Properties configuration = new Properties();
    private Object soleInstance = null;

    protected String getExternalId() {
        return this.externalId;
    }

    protected void setExternalId(String newValue) {
        this.externalId = newValue;
    }

    protected ClassInfo getClassInfo() {
        return this.classInfo;
    }

    protected void setClassInfo(ClassInfo newValue) {
        this.classInfo = newValue;
    }

    protected boolean isSingleton() {
        return this.isSingleton;
    }

    protected void isSingleton(boolean newValue) {
        this.isSingleton = newValue;
    }

    protected Properties getConfiguration() {
        return this.configuration;
    }

    protected void setConfiguration(Properties newValue) {
        this.configuration = newValue;
    }

    protected Object getSoleInstance() {
        return this.soleInstance;
    }

    protected void setSoleInstance(Object newValue) {
        this.soleInstance = newValue;
    }

    protected PluginHolder(String id, ClassInfo info) {
        this.setExternalId(id);
        this.setClassInfo(info);
    }

    public Object getInstance() {
        if (this.isSingleton()) {
            if (this.getSoleInstance() == null) {
                this.setSoleInstance(this.createNewInstance());
            }
            return this.getSoleInstance();
        }
        return this.createNewInstance();
    }

    public boolean isPluginType(Class pluginType) {
        if (pluginType == null) {
            return false;
        }
        return this.getClassInfo().isAssignableTo(pluginType);
    }

    protected Object createNewInstance() {
        Object object = this.getClassInfo().createInstance();
        if (object instanceof IInitializablePlugin) {
            IInitializablePlugin initializablePlugin = (IInitializablePlugin)object;
            initializablePlugin.initPlugin(this.getExternalId(), this.getConfiguration());
        }
        return object;
    }
}

