/*
 * Decompiled with CFR 0.152.
 */
package org.pf.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.pf.file.Classpath;
import org.pf.file.ClasspathElement;
import org.pf.file.FileUtil;
import org.pf.plugin.ClassRegistry;
import org.pf.plugin.LoggerProvider;
import org.pf.plugin.PluginUtil;

public class PluginCollector {
    protected static final boolean DEBUG = "true".equals(System.getProperty("org.pf.plugin.PluginCollector.debug"));
    protected static final String DEBUG_PREFIX = "org.pf.plugin.PluginCollector: ";
    private ClassRegistry classRegistry = null;

    public ClassRegistry getClassRegistry() {
        return this.classRegistry;
    }

    protected void setClassRegistry(ClassRegistry newValue) {
        this.classRegistry = newValue;
    }

    public PluginCollector() {
        this(null);
    }

    public PluginCollector(ClassRegistry registry) {
        this.setClassRegistry(registry == null ? new ClassRegistry() : registry);
    }

    public ClassRegistry loadPlugins(String filename) {
        return this.loadPlugins(filename, this.getPluginClasspath());
    }

    public ClassRegistry loadPlugins(String filename, String classpath) {
        this.readPlugins(filename, classpath);
        return this.getClassRegistry();
    }

    public ClassRegistry loadPlugins(String filename, Classpath classpath) {
        this.readPlugins(filename, classpath);
        return this.getClassRegistry();
    }

    protected void readPlugins(String filename, String strClasspath) {
        Classpath classpath = new Classpath(strClasspath);
        classpath.removeDuplicates();
        this.readPlugins(filename, classpath);
    }

    protected void readPlugins(String filename, Classpath classpath) {
        if (DEBUG) {
            this.debug("Lookup file <" + filename + "> in <" + classpath + ">");
        }
        ClasspathElement[] elements = classpath.elementsContaining(filename);
        int i = 0;
        while (i < elements.length) {
            if (DEBUG) {
                this.debug("Found file <" + filename + "> in <" + elements[i].getName() + ">");
            }
            this.readMapping(elements[i], filename);
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readMapping(ClasspathElement element, String filename) {
        Properties properties;
        InputStream stream = null;
        try {
            try {
                stream = element.open(filename);
                properties = new Properties();
                properties.load(stream);
            }
            catch (IOException e) {
                if (DEBUG) {
                    this.debug("Exception reading file <" + filename + "> : " + e.toString());
                }
                Object var6_6 = null;
                this.fileUtil().close(stream);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fileUtil().close(stream);
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.fileUtil().close(stream);
        }
        this.addMappings(properties);
    }

    protected void addMappings(Properties properties) {
        Iterator iter = ((Hashtable)properties).keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = properties.getProperty(key);
            if (DEBUG) {
                this.debug("Register plugin key=" + key + " | value=" + value);
            }
            this.getClassRegistry().register((Object)key, value);
        }
    }

    protected Classpath getPluginClasspath() {
        return PluginUtil.current().getPluginClasspath();
    }

    protected FileUtil fileUtil() {
        return FileUtil.current();
    }

    protected void debug(String text) {
        LoggerProvider.getLogger().logDebug(DEBUG_PREFIX + text);
    }
}

