/*
 * Decompiled with CFR 0.152.
 */
package org.pf.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pf.plugin.ClassRegistryException;
import org.pf.reflect.ClassInfo;

public class ClassRegistry {
    private Class entryType = null;
    private Map registry = null;

    protected Class getEntryType() {
        return this.entryType;
    }

    protected void setEntryType(Class newValue) {
        this.entryType = newValue;
    }

    protected Map registry() {
        return this.registry;
    }

    protected void registry(Map newValue) {
        this.registry = newValue;
    }

    public ClassRegistry() {
        this.registry(new HashMap());
    }

    public ClassRegistry(Class typeOfRegisteredClasses) {
        this();
        this.setEntryType(typeOfRegisteredClasses);
    }

    public String getClassName(Object key) {
        ClassInfo classInfo = this.get(key);
        return classInfo == null ? null : classInfo.getClassName();
    }

    public Class getClass(Object key) {
        ClassInfo classInfo = this.get(key);
        return classInfo == null ? null : classInfo.getClassObject();
    }

    public Object newInstance(Object key) {
        ClassInfo classInfo = this.get(key);
        return classInfo == null ? null : classInfo.createInstance();
    }

    public boolean register(Object key, String className) {
        try {
            this.put(key, className);
            return true;
        }
        catch (ClassRegistryException ex) {
            return false;
        }
    }

    public void put(Object key, String className) throws ClassRegistryException {
        this.assertArgNotNull("put", "key", key);
        this.assertArgNotNull("put", "className", className);
        ClassInfo classInfo = new ClassInfo(className);
        this.put(key, classInfo);
    }

    public boolean register(Object key, Class aClass) {
        try {
            this.put(key, aClass);
            return true;
        }
        catch (ClassRegistryException ex) {
            return false;
        }
    }

    public void put(Object key, Class aClass) throws ClassRegistryException {
        this.assertArgNotNull("put", "key", key);
        this.assertArgNotNull("put", "aClass", aClass);
        ClassInfo classInfo = new ClassInfo(aClass);
        this.put(key, classInfo);
    }

    public boolean remove(Object key) {
        if (key != null) {
            Object obj = this.registry().remove(key);
            return obj != null;
        }
        return false;
    }

    public String[] keys() {
        Set keys = this.registry().keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public ClassInfo[] values() {
        Collection values = this.registry().values();
        return values.toArray(new ClassInfo[values.size()]);
    }

    public Class[] classes() {
        List classes = this.collect(false);
        return classes.toArray(new Class[classes.size()]);
    }

    public String[] classNames() {
        List names = this.collect(true);
        return names.toArray(new String[names.size()]);
    }

    public ClassInfo getClassInfo(String key) {
        return this.get(key);
    }

    protected ClassInfo get(Object key) {
        if (key == null) {
            return null;
        }
        return (ClassInfo)this.registry().get(key);
    }

    protected void put(Object key, ClassInfo classInfo) throws ClassRegistryException {
        this.assertArgNotNull("put", "key", key);
        this.validate(classInfo);
        this.registry().put(key, classInfo);
    }

    protected void validate(ClassInfo classInfo) throws ClassRegistryException {
        this.assertClassFound(classInfo);
        this.assertValidType(classInfo);
        this.assertInstanceCreation(classInfo);
    }

    protected void assertClassFound(ClassInfo classInfo) throws ClassRegistryException {
        Class aClass = classInfo.getClassObject();
        if (aClass == null) {
            throw new ClassRegistryException("Class " + classInfo.getClassName() + " not found");
        }
    }

    protected void assertValidType(ClassInfo classInfo) throws ClassRegistryException {
        if (this.isTyped() && !this.getEntryType().isAssignableFrom(classInfo.getClassObject())) {
            throw new ClassRegistryException("Class " + classInfo.getClassName() + " is not compatible to type " + this.getEntryType().getName());
        }
    }

    protected void assertInstanceCreation(ClassInfo classInfo) throws ClassRegistryException {
        try {
            classInfo.newInstance();
        }
        catch (Exception ex) {
            throw new ClassRegistryException("Unable to create instances of class " + classInfo.getClassName() + " (" + ex.getMessage() + ")");
        }
    }

    protected boolean isTyped() {
        return this.getEntryType() != null;
    }

    protected void assertArgNotNull(String methodName, String argName, Object arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument '" + argName + "' not valid in method '" + this.getClass().getName() + "." + methodName + "'");
        }
    }

    protected void illegalArgumentException(String methodName, String argName) {
        throw new IllegalArgumentException("Argument '" + argName + "' not valid in method '" + this.getClass().getName() + "." + methodName + "'");
    }

    protected List collect(boolean collectNames) {
        Collection values = this.registry().values();
        ArrayList<Object> result = new ArrayList<Object>(values.size());
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iter.next();
            if (collectNames) {
                result.add(classInfo.getClassName());
                continue;
            }
            result.add(classInfo.getClassObject());
        }
        return result;
    }
}

