/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.util.Properties;
import org.pf.file.PropertyFileLoader;
import org.pf.joi.ElementFilter;
import org.pf.util.Bool;

public class Preferences {
    protected static final String CONFIG_FILENAME = "joi.properties";
    protected static final String DEFAULT_CONFIG_FILENAME = "joi_default.properties";
    protected static final int DEFAULT_MAIN_MARGIN = 2;
    protected static final int DEFAULT_WINDOW_WIDTH = 700;
    protected static final int DEFAULT_WINDOW_HEIGHT = 500;
    protected static final int DEFAULT_TREE_WIDTH = 200;
    protected static final int DEFAULT_DOUBLE_CLICK_MODE = 3;
    protected static final int DEFAULT_MIDDLE_BUTTON_MODE = 2;
    protected static final boolean DEFAULT_AUTO_SORT = false;
    protected static final boolean DEFAULT_ALLOW_MODIFY = true;
    protected static final String OPT_DOUBLE_CLICK_ACTION = "action.doubleclick";
    protected static final String OPT_MIDDLE_BUTTON = "action.middle.button";
    protected static final String OPT_WINDOW_WIDTH = "window.width";
    protected static final String OPT_WINDOW_HEIGHT = "window.height";
    protected static final String OPT_TREE_WIDTH = "tree.width";
    protected static final String OPT_AUTO_SORT = "auto.sort";
    protected static final String OPT_ALLOW_MODIFY = "allow.modification";
    protected static final String OPT_QUOTE_STRINGS = "quote.strings";
    protected static final String OPT_STATIC_DEFAULT = "modifier.static.default";
    protected static final String OPT_FINAL_DEFAULT = "modifier.final.default";
    protected static final String OPT_TRANSIENT_DEFAULT = "modifier.transient.default";
    protected static final String OPT_PUBLIC_DEFAULT = "modifier.public.default";
    protected static final String OPT_PRIVATE_DEFAULT = "modifier.private.default";
    protected static final String OPT_PROTECTED_DEFAULT = "modifier.protected.default";
    protected static final String OPT_PACKAGE_DEFAULT = "modifier.package.default";
    protected static final String DOUBLE_CLICK_OPEN_WINDOW = "openNewWindow";
    protected static final String DOUBLE_CLICK_OPEN_TAB = "openNewTab";
    protected static final String DOUBLE_CLICK_REPLACE = "openReplaceCurrent";
    static final String[] MODIFIER_OPTIONS = new String[]{"modifier.static.default", "modifier.final.default", "modifier.transient.default", "modifier.private.default", "modifier.protected.default", "modifier.public.default", "modifier.package.default"};
    private static Preferences soleInstance = new Preferences();
    private int doubleClickMode = 3;
    private int middleButtonMode = 2;
    private int windowWidth = 700;
    private int windowHeight = 500;
    private int treeWidth = 200;
    private boolean autoSort = false;
    private boolean isEditingSupported = true;
    private boolean quoteStrings = true;
    private ElementFilter initialElementFilter = null;

    protected void setDoubleClickMode(int newValue) {
        this.doubleClickMode = newValue;
    }

    protected void setMiddleButtonMode(int newValue) {
        this.middleButtonMode = newValue;
    }

    protected void setWindowWidth(int newValue) {
        this.windowWidth = newValue;
    }

    protected void setWindowHeight(int newValue) {
        this.windowHeight = newValue;
    }

    protected void setTreeWidth(int newValue) {
        this.treeWidth = newValue;
    }

    protected boolean getAutoSort() {
        return this.autoSort;
    }

    protected void setAutoSort(boolean newValue) {
        this.autoSort = newValue;
    }

    protected void setIsEditingSupported(boolean newValue) {
        this.isEditingSupported = newValue;
    }

    protected void setQuoteStrings(boolean newValue) {
        this.quoteStrings = newValue;
    }

    protected void setInitialElementFilter(ElementFilter newValue) {
        this.initialElementFilter = newValue;
    }

    public static Preferences instance() {
        return soleInstance;
    }

    private Preferences() {
        this.initialize();
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public int getMainMargin() {
        return 2;
    }

    public int getTreeWidth() {
        return this.treeWidth;
    }

    public int getDoubleClickMode() {
        return this.doubleClickMode;
    }

    public int getMiddleButtonMode() {
        return this.middleButtonMode;
    }

    public boolean isAutoSortOn() {
        return this.getAutoSort();
    }

    public boolean isEditingSupported() {
        return this.isEditingSupported;
    }

    public boolean getQuoteStrings() {
        return this.quoteStrings;
    }

    public ElementFilter getInitialElementFilter() {
        return this.initialElementFilter.copy();
    }

    protected void initialize() {
        Properties defaultConfig = PropertyFileLoader.loadProperties(DEFAULT_CONFIG_FILENAME);
        Properties config = PropertyFileLoader.loadProperties(CONFIG_FILENAME, defaultConfig);
        if (config == null) {
            config = defaultConfig;
        }
        if (config != null) {
            this.initialize(config);
        }
    }

    protected void initialize(Properties config) {
        this.initDoubleClickAction(config.getProperty(OPT_DOUBLE_CLICK_ACTION));
        this.initMiddleButtonAction(config.getProperty(OPT_MIDDLE_BUTTON));
        this.initWindowWidth(config.getProperty(OPT_WINDOW_WIDTH));
        this.initWindowHeight(config.getProperty(OPT_WINDOW_HEIGHT));
        this.initTreeWidth(config.getProperty(OPT_TREE_WIDTH));
        this.initAutoSort(config.getProperty(OPT_AUTO_SORT));
        this.initAllowModify(config.getProperty(OPT_ALLOW_MODIFY));
        this.initQuoteStrings(config.getProperty(OPT_QUOTE_STRINGS));
        this.initInitialElementFilter(config);
    }

    protected void initDoubleClickAction(String option) {
        int action = this.detectOpenAction(option);
        if (action >= 0) {
            this.setDoubleClickMode(action);
        }
    }

    protected void initMiddleButtonAction(String option) {
        int action = this.detectOpenAction(option);
        if (action >= 0) {
            this.setMiddleButtonMode(action);
        }
    }

    protected void initWindowWidth(String option) {
        int value = this.positiveInt(option);
        if (value >= 300) {
            this.setWindowWidth(value);
        }
    }

    protected void initWindowHeight(String option) {
        int value = this.positiveInt(option);
        if (value >= 200) {
            this.setWindowHeight(value);
        }
    }

    protected void initTreeWidth(String option) {
        int value = this.positiveInt(option);
        if (value >= 100) {
            this.setTreeWidth(value);
        }
    }

    protected void initAutoSort(String option) {
        if (option != null) {
            this.setAutoSort(Bool.isTrue(option));
        }
    }

    protected void initAllowModify(String option) {
        if (option != null) {
            this.setIsEditingSupported(Bool.isTrue(option));
        }
    }

    protected void initQuoteStrings(String option) {
        if (option != null) {
            this.setQuoteStrings(Bool.isTrue(option));
        }
    }

    protected int positiveInt(String str) {
        int value = -1;
        if (str != null) {
            try {
                value = Integer.parseInt(str.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    protected int detectOpenAction(String option) {
        if (option != null) {
            if (DOUBLE_CLICK_OPEN_TAB.equalsIgnoreCase(option)) {
                return 2;
            }
            if (DOUBLE_CLICK_OPEN_WINDOW.equalsIgnoreCase(option)) {
                return 3;
            }
            if (DOUBLE_CLICK_REPLACE.equalsIgnoreCase(option)) {
                return 1;
            }
        }
        return -1;
    }

    protected void initInitialElementFilter(Properties config) {
        int modifier = 0;
        ElementFilter filter = new ElementFilter(0, false);
        this.setInitialElementFilter(filter);
        int i = 0;
        while (i < MODIFIER_OPTIONS.length) {
            String value = config.getProperty(MODIFIER_OPTIONS[i], "true");
            if (Bool.isFalse(value)) {
                if (OPT_STATIC_DEFAULT.equals(MODIFIER_OPTIONS[i])) {
                    modifier = 8;
                } else if (OPT_FINAL_DEFAULT.equals(MODIFIER_OPTIONS[i])) {
                    modifier = 16;
                } else if (OPT_TRANSIENT_DEFAULT.equals(MODIFIER_OPTIONS[i])) {
                    modifier = 128;
                } else if (OPT_PUBLIC_DEFAULT.equals(MODIFIER_OPTIONS[i])) {
                    modifier = 1;
                } else if (OPT_PRIVATE_DEFAULT.equals(MODIFIER_OPTIONS[i])) {
                    modifier = 2;
                } else if (OPT_PROTECTED_DEFAULT.equals(MODIFIER_OPTIONS[i])) {
                    modifier = 4;
                } else if (OPT_PACKAGE_DEFAULT.equals(MODIFIER_OPTIONS[i])) {
                    modifier = -1;
                }
                filter.toggleSwitch(modifier);
            }
            ++i;
        }
    }
}

