/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pf.joi.ImageProvider;
import org.pf.joi.InspectionView;
import org.pf.joi.InspectionWindowController;
import org.pf.joi.Inspector;
import org.pf.joi.Preferences;
import org.pf.swing.SwingUtil;
import org.pf.swing.TakeAllLayoutManager;

public class InspectionFrame
extends JFrame
implements ChangeListener,
MouseListener {
    private transient InspectionWindowController controller = null;
    private transient JPanel contentPanel = null;
    private transient int elementCount = 0;

    protected InspectionWindowController getController() {
        return this.controller;
    }

    protected void setController(InspectionWindowController newValue) {
        this.controller = newValue;
    }

    protected JPanel getContentPanel() {
        return this.contentPanel;
    }

    protected void setContentPanel(JPanel newValue) {
        this.contentPanel = newValue;
    }

    protected int getElementCount() {
        return this.elementCount;
    }

    protected void setElementCount(int newValue) {
        this.elementCount = newValue;
    }

    public InspectionFrame(InspectionWindowController controller) {
        this.setController(controller);
        this.initialize();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            if ((e.getModifiers() & 4) > 0) {
                this.createTabPopupMenu().show(tabbedPane, e.getX(), e.getY());
            }
        }
    }

    public void addInspection(InspectionView inspectView) {
        if (this.getElementCount() == 0) {
            this.getContentPanel().add(inspectView);
        } else {
            JTabbedPane tabbedPane;
            if (this.getElementCount() == 1) {
                InspectionView firstView = (InspectionView)this.getContentPanel().getComponent(0);
                this.getContentPanel().removeAll();
                tabbedPane = this.createTabbedPane(firstView);
                this.getContentPanel().add(tabbedPane);
            } else {
                tabbedPane = this.getTabbedPane();
            }
            this.addToTabbedPane(tabbedPane, inspectView);
            tabbedPane.setSelectedComponent(inspectView);
        }
        ++this.elementCount;
    }

    public void replaceInspection(InspectionView inspectView) {
        if (this.getElementCount() > 0) {
            if (this.getElementCount() == 1) {
                this.getContentPanel().removeAll();
                this.getContentPanel().add(inspectView);
                this.getContentPanel().revalidate();
            } else {
                JTabbedPane tabbedPane = this.getTabbedPane();
                int currentIndex = tabbedPane.getSelectedIndex();
                if (currentIndex >= 0) {
                    tabbedPane.setComponentAt(currentIndex, inspectView);
                    tabbedPane.setTitleAt(currentIndex, inspectView.getDisplayName());
                }
            }
            this.getContentPanel().repaint();
            this.viewChanged(inspectView);
        }
    }

    public void removeInspection(InspectionView inspectView) {
        if (this.getElementCount() > 1) {
            JTabbedPane tabbedPane = this.getTabbedPane();
            int index = tabbedPane.indexOfComponent(inspectView);
            if (index >= 0) {
                tabbedPane.remove(index);
                --this.elementCount;
            }
            if (this.getElementCount() == 1) {
                InspectionView lastView = (InspectionView)tabbedPane.getComponent(0);
                this.releaseTabbedPane(tabbedPane);
                this.getContentPanel().removeAll();
                this.getContentPanel().add(lastView);
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
        InspectionView selectedView = (InspectionView)tabbedPane.getSelectedComponent();
        this.viewChanged(selectedView);
    }

    public void mousePressed(MouseEvent e) {
        this.mouseClicked(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    protected void initialize() {
        SwingUtil.current().centerFrame(this, this.prefs().getWindowWidth(), this.prefs().getWindowHeight());
        this.setTitle(this.composeTitle());
        ImageIcon logo = ImageProvider.instance().getLogoIcon();
        if (logo != null) {
            ((Frame)this).setIconImage(logo.getImage());
        }
        this.addWindowListener(this.getController());
        JPanel panel = new JPanel(new TakeAllLayoutManager(this.prefs().getMainMargin()));
        this.setContentPanel(panel);
        this.getContentPane().add(panel);
    }

    protected JTabbedPane createTabbedPane(InspectionView firstComp) {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addChangeListener(this);
        tabbedPane.addMouseListener(this);
        this.addToTabbedPane(tabbedPane, firstComp);
        return tabbedPane;
    }

    protected void releaseTabbedPane(JTabbedPane tabbedPane) {
        tabbedPane.removeChangeListener(this);
    }

    protected void addToTabbedPane(JTabbedPane tabbedPane, InspectionView comp) {
        tabbedPane.addTab(comp.getDisplayName(), comp);
    }

    protected JTabbedPane getTabbedPane() {
        return (JTabbedPane)this.getContentPanel().getComponent(0);
    }

    protected void viewChanged(InspectionView view) {
        this.getController().viewSelected(view);
        this.setTitle(this.composeTitle());
    }

    protected InspectionView getSelectedView() {
        InspectionView view = null;
        if (this.getContentPanel().getComponent(0) instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)this.getContentPanel().getComponent(0);
            view = (InspectionView)tabbedPane.getSelectedComponent();
        }
        return view;
    }

    protected String composeTitle() {
        String title = null;
        title = String.valueOf(Inspector.getProgSignature()) + " : " + this.getController().getInspectorId() + " (" + this.getController().getInspectedObjectTypeString() + ")";
        return title;
    }

    protected JPopupMenu createTabPopupMenu() {
        JMenuItem menuItem = null;
        JPopupMenu popup = null;
        popup = new JPopupMenu();
        menuItem = this.createMenuItem("Close tab", "actionCloseTab");
        popup.add(menuItem);
        return popup;
    }

    protected JMenuItem createMenuItem(String text, String command) {
        JMenuItem menuItem = null;
        menuItem = new JMenuItem(text);
        menuItem.setActionCommand(command);
        menuItem.addActionListener(this.getController());
        return menuItem;
    }

    protected Preferences prefs() {
        return Preferences.instance();
    }
}

