/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.system.info;

import java.util.HashMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class SystemInformation {
    private static HashMap<String, String> systemInfo = null;
    public static final String NUMCPUS = "NUMCPUS";
    public static final String JAVAVERSION = "JAVAVERSION";
    public static final String JAVAVMNAME = "JAVAVMNAME";
    public static final String TOTALMEMORY = "TOTALMEMORY";
    public static final String OSNAME = "OSNAME";
    public static final String OSVERSION = "OSVERSION";
    public static final String OSARCH = "OSARCH";
    public static final String SUPPORTOPENGL = "SUPPORTOPENGL";
    public static final String SUPPORTGLSL = "SUPPORTGLSL";
    public static final String GPUVENDOR = "GPUVENDOR";
    public static final String MAXTEXDIM = "MAXTEXDIM";

    public static void initialize() {
        systemInfo = new HashMap();
        Runtime runtime = Runtime.getRuntime();
        systemInfo.put(OSNAME, System.getProperty("os.name"));
        systemInfo.put(OSVERSION, System.getProperty("os.version"));
        systemInfo.put(JAVAVERSION, System.getProperty("java.version"));
        systemInfo.put(JAVAVMNAME, System.getProperty("java.vm.name"));
        systemInfo.put(OSARCH, System.getProperty("os.arch"));
        systemInfo.put(TOTALMEMORY, "" + runtime.maxMemory());
        systemInfo.put(NUMCPUS, "" + runtime.availableProcessors());
    }

    public static void writeInfo(GC gC, int n, Color color, Color color2, Color color3) {
        String string;
        float f;
        boolean bl;
        if (systemInfo.get(SUPPORTOPENGL) != null) {
            bl = Boolean.parseBoolean(systemInfo.get(SUPPORTOPENGL));
            if (bl) {
                gC.setForeground(color2);
                gC.drawText("PASSED", n, 30);
            } else {
                gC.setForeground(color);
                gC.drawText("FAILED: Please upgrade your system to a OpenGL1.4 compatible graphics card", n, 30);
            }
        }
        if (systemInfo.get(SUPPORTGLSL) != null) {
            bl = Boolean.parseBoolean(systemInfo.get(SUPPORTGLSL));
            if (bl) {
                gC.setForeground(color2);
                gC.drawText("PASSED", n, 50);
            } else {
                gC.setForeground(color);
                gC.drawText("FAILED: GLSL isn't mandatory but recommended some features need it!", n, 50);
            }
        }
        if ((f = (float)(Runtime.getRuntime().maxMemory() / 0x100000L)) < 300.0f) {
            gC.setForeground(color);
        } else if (f < 1000.0f) {
            gC.setForeground(color3);
        } else {
            gC.setForeground(color2);
        }
        String string2 = f + " Mbyte(s)";
        if (f < 1000.0f) {
            string2 = String.valueOf(string2) + " We recommend at least 1024Mbyte of Java heapspace";
        }
        gC.drawText(string2, n, 70);
        if (Runtime.getRuntime().availableProcessors() < 2) {
            gC.setForeground(color3);
        } else {
            gC.setForeground(color2);
        }
        gC.drawText("" + Runtime.getRuntime().availableProcessors(), n, 90);
        string2 = string = systemInfo.get(JAVAVERSION);
        int n2 = string.indexOf(46);
        if (n2 != -1) {
            String string3 = string.substring(0, n2);
            int n3 = string.indexOf(46, n2 + 1);
            String string4 = string.substring(n2 + 1, n3);
            int n4 = Integer.parseInt(string3);
            int n5 = Integer.parseInt(string4);
            if (n4 == 1 && n5 < 6) {
                gC.setForeground(color);
                string2 = String.valueOf(string2) + " You need Java1.6";
            } else {
                gC.setForeground(color2);
            }
        } else {
            gC.setForeground(color);
        }
        gC.drawText(string2, n, 110);
    }

    public static void setOpenGLVendor(String string) {
        systemInfo.put(GPUVENDOR, string);
    }

    public static String getOpenGLVendor() {
        return systemInfo.get(GPUVENDOR);
    }

    public static void setOpenGLMaxTex(int n) {
        systemInfo.put(MAXTEXDIM, "" + n);
    }

    public static void setOpenGLSupport(boolean bl) {
        systemInfo.put(SUPPORTOPENGL, "" + bl);
    }

    public static void setGLSLSupport(boolean bl) {
        systemInfo.put(SUPPORTGLSL, "" + bl);
    }

    public static String getGPUVendor() {
        return systemInfo.get(GPUVENDOR);
    }

    public static boolean supportsOpenGL() {
        return Boolean.parseBoolean(systemInfo.get(SUPPORTOPENGL));
    }

    public static boolean supportsGLSL() {
        return Boolean.parseBoolean(systemInfo.get(SUPPORTGLSL));
    }

    public static int getNumCPUs() {
        return Integer.parseInt(systemInfo.get(NUMCPUS));
    }

    public static long getTotalMemory() {
        return Long.parseLong(systemInfo.get(TOTALMEMORY));
    }

    public static String getJAVAVMVersion() {
        return systemInfo.get(JAVAVERSION);
    }

    public static String getJAVAVMName() {
        return systemInfo.get(JAVAVMNAME);
    }

    public static String getOSVersion() {
        return systemInfo.get(OSVERSION);
    }

    public static String getOSArchitecture() {
        return systemInfo.get(OSARCH);
    }

    public static String getOSName() {
        return systemInfo.get(OSNAME);
    }

    public static String getSystemString() {
        if (systemInfo == null) {
            SystemInformation.initialize();
        }
        String string = "OSNAME:" + systemInfo.get(OSNAME) + "\n" + OSVERSION + ":" + systemInfo.get(OSVERSION) + "\n" + OSARCH + ":" + systemInfo.get(OSARCH) + "\n" + JAVAVMNAME + ":" + systemInfo.get(JAVAVMNAME) + "\n" + JAVAVERSION + ":" + systemInfo.get(JAVAVERSION) + "\n" + TOTALMEMORY + ":" + systemInfo.get(TOTALMEMORY) + "\n";
        if (systemInfo.get(SUPPORTOPENGL) != null) {
            string = String.valueOf(string) + "SUPPORTOPENGL:" + systemInfo.get(SUPPORTOPENGL) + "\n";
        }
        if (systemInfo.get(SUPPORTGLSL) != null) {
            string = String.valueOf(string) + "SUPPORTGLSL:" + systemInfo.get(SUPPORTGLSL) + "\n";
        }
        if (systemInfo.get(GPUVENDOR) != null) {
            string = String.valueOf(string) + "GPUVENDOR:" + systemInfo.get(GPUVENDOR) + "\n";
        }
        if (systemInfo.get(MAXTEXDIM) != null) {
            string = String.valueOf(string) + "MAXTEXDIM:" + systemInfo.get(MAXTEXDIM);
        }
        return string;
    }
}

