/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.system.info;

import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JOGLChecker {
    private static final Logger logger = LoggerFactory.getLogger(JOGLChecker.class);
    private static int maxXdim = 8192;
    private static int maxYdim = 8192;
    private static String glVendorStr = "";

    public static boolean canUseJOGL_OpenGL(String string, Composite composite) {
        GLCanvas gLCanvas = null;
        boolean bl = true;
        try {
            Class.forName(string).newInstance();
            GLData gLData = new GLData();
            gLData.doubleBuffer = true;
            gLData.depthSize = 16;
            gLData.redSize = 8;
            gLData.greenSize = 8;
            gLData.blueSize = 8;
            gLData.alphaSize = 8;
            gLCanvas = new GLCanvas(composite, 262144, gLData);
            gLCanvas.setCurrent();
            GLContext gLContext = GLDrawableFactory.getFactory().createExternalGLContext();
            gLContext.makeCurrent();
            gLContext.getGL().glMultTransposeMatrixd(new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 0);
            glVendorStr = gLContext.getGL().glGetString(7936);
            IntBuffer intBuffer = IntBuffer.allocate(1);
            GL gL = gLContext.getGL();
            gLContext.getGL();
            gL.glGetIntegerv(3379, intBuffer);
            maxXdim = maxYdim = intBuffer.get(0);
            boolean bl2 = false;
            while (!bl2) {
                GL gL2 = gLContext.getGL();
                gLContext.getGL();
                gLContext.getGL();
                gLContext.getGL();
                gLContext.getGL();
                gL2.glTexImage2D(32868, 0, 6408, maxXdim, maxYdim, 0, 6408, 5120, null);
                GL gL3 = gLContext.getGL();
                gLContext.getGL();
                gLContext.getGL();
                gL3.glGetTexLevelParameteriv(32868, 0, 4096, intBuffer);
                if (intBuffer.get(0) == maxXdim) {
                    bl2 = true;
                    continue;
                }
                maxXdim >>= 1;
                maxYdim >>= 1;
            }
            gLContext.release();
            gLContext.destroy();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.warn("No class found for JOGL hardware acceleration");
            bl = false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.warn("JOGL linking error");
            bl = false;
        }
        catch (Exception exception) {
            logger.warn("No JOGL using software render", (Throwable)exception);
            bl = false;
        }
        if (gLCanvas != null) {
            gLCanvas.dispose();
        }
        return bl;
    }

    public static int getMaxTextureWidth() {
        return maxXdim;
    }

    public static int getMaxTextureHeight() {
        return maxYdim;
    }

    public static String getVendorName() {
        return glVendorStr;
    }
}

