/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.hdf5.nexus;

import java.io.Serializable;
import java.util.List;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h5.H5Datatype;

public class NexusUtils {
    private static String NXCLASS = "NX_class";

    public static void setNexusAttribute(FileFormat fileFormat, HObject hObject, String string) throws Exception {
        Object object;
        Serializable serializable;
        List list = hObject.getMetadata();
        if (list != null) {
            for (Object e : list) {
                if (!(e instanceof Attribute)) continue;
                serializable = (Attribute)e;
                object = (String[])serializable.getValue();
                if (!NXCLASS.equals(serializable.getName()) || !string.equals(object[0])) continue;
                return;
            }
        }
        int n = hObject.open();
        try {
            String[] stringArray = new String[]{string};
            serializable = new H5Datatype(3, stringArray[0].length() + 1, -1, -1);
            object = new Attribute(NXCLASS, (Datatype)serializable, new long[]{1L});
            ((Attribute)object).setValue(stringArray);
            fileFormat.writeAttribute(hObject, (Attribute)object, false);
            if (hObject instanceof Group) {
                list.add(object);
                ((Group)hObject).writeMetadata(list);
            } else if (hObject instanceof Dataset) {
                list.add(object);
                ((Dataset)hObject).writeMetadata(list);
            }
        }
        finally {
            hObject.close(n);
        }
    }
}

