/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.hdf5;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ncsa.hdf.object.Dataset;

public class HierarchicalDataUtils {
    public static final void copy(File file, File file2) throws IOException {
        HierarchicalDataUtils.copy(file, file2, new byte[4096]);
    }

    public static final void copy(File file, File file2, byte[] byArray) throws IOException {
        if (!file.exists()) {
            return;
        }
        File file3 = file2.getParentFile();
        if (!file3.exists()) {
            file3.mkdirs();
        }
        if (!file2.exists()) {
            file2.createNewFile();
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = new BufferedInputStream(new FileInputStream(file));
            outputStream = new BufferedOutputStream(new FileOutputStream(file2));
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    public static boolean isDataType(Dataset dataset, int n) throws OutOfMemoryError, Exception {
        if (n < 0) {
            return true;
        }
        int n2 = dataset.getDatatype().getDatatypeClass();
        if ((n2 == 1 || n2 == 0) && 17061 == n) {
            long[] lArray = HierarchicalDataUtils.getDims(dataset);
            if (lArray == null) {
                return true;
            }
            return lArray.length > 1 || lArray[0] > 1L;
        }
        if (n2 == 2 || n2 == 3) {
            return 17062 == n;
        }
        return n == n2;
    }

    public static long[] getDims(Dataset dataset) throws Exception {
        if (dataset.getDims() == null) {
            dataset.getMetadata();
        }
        return dataset.getDims();
    }

    public static long getSize(Dataset dataset) throws Exception {
        long[] lArray;
        try {
            lArray = HierarchicalDataUtils.getDims(dataset);
        }
        catch (Exception exception) {
            return -1L;
        }
        if (lArray == null) {
            return -1L;
        }
        long l = lArray[0];
        int n = 1;
        while (n < lArray.length) {
            l *= lArray[n];
            ++n;
        }
        n = dataset.getDatatype().getDatatypeSize();
        return (long)n * l;
    }
}

