/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.hdf5;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5ScalarDS;
import org.dawb.hdf5.HierarchicalDataUtils;
import org.dawb.hdf5.HierarchicalInfo;
import org.dawb.hdf5.IHierarchicalDataFile;
import org.dawb.hdf5.nexus.NexusUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HierarchicalDataFile
implements IHierarchicalDataFile {
    private static final Logger logger = LoggerFactory.getLogger(HierarchicalDataFile.class);
    private static Map<String, HierarchicalDataFile> readCache;
    private static Collection<String> writeCache;
    private final int openType;
    private FileFormat file;
    private final String path;
    private int count = 0;

    static synchronized HierarchicalDataFile open(String string, int n) throws Exception {
        if (n == 0) {
            HierarchicalDataFile hierarchicalDataFile;
            if (readCache == null) {
                readCache = new HashMap<String, HierarchicalDataFile>(7);
            }
            if ((hierarchicalDataFile = readCache.get(string)) != null) {
                ++hierarchicalDataFile.count;
                return hierarchicalDataFile;
            }
            hierarchicalDataFile = new HierarchicalDataFile(string, n);
            readCache.put(string, hierarchicalDataFile);
            return hierarchicalDataFile;
        }
        if (n == 1 || n == 2) {
            if (writeCache == null) {
                writeCache = new HashSet<String>(11);
            }
            if (writeCache.contains(string)) {
                throw new Exception("Already writing to " + string + "!");
            }
            HierarchicalDataFile hierarchicalDataFile = new HierarchicalDataFile(string, n);
            writeCache.add(string);
            return hierarchicalDataFile;
        }
        throw new Exception("Unrecognised FileFormat " + n);
    }

    public static synchronized void clear() throws Exception {
        if (readCache != null) {
            Collection<HierarchicalDataFile> collection = readCache.values();
            for (HierarchicalDataFile hierarchicalDataFile : collection) {
                hierarchicalDataFile.close();
            }
        }
    }

    private HierarchicalDataFile(String string, int n) throws Exception {
        this.path = string;
        this.openType = n;
        FileFormat fileFormat = FileFormat.getFileFormat("HDF5");
        if (fileFormat == null) {
            throw new NullPointerException("Cannot deal with hdf5 files!");
        }
        this.file = fileFormat.createInstance(string, n);
        if (this.file == null) {
            throw new Exception("Failed to open file: " + string);
        }
        try {
            this.file.open();
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            fileFormat = FileFormat.getFileFormat("HDF4");
            this.file = fileFormat.createInstance(string, n);
            if (this.file == null) {
                throw new Exception("Failed to open file: " + string);
            }
            this.file.open();
            logger.error("The file " + string + " is HDF4, it will open but plotting features are disabled.");
        }
        if (!(n != 1 && n != 2 || this.file.canWrite())) {
            throw new Exception("Cannot write to '" + string + "'!");
        }
        this.count = 1;
    }

    @Override
    public TreeNode getNode() {
        return this.file.getRootNode();
    }

    @Override
    public Group getRoot() {
        return (Group)((DefaultMutableTreeNode)this.getNode()).getUserObject();
    }

    @Override
    public HObject getData(String string) throws Exception {
        return this.file.get(string);
    }

    @Override
    public HierarchicalInfo getDatasetInformation(int n) throws Exception {
        HierarchicalInfo hierarchicalInfo = new HierarchicalInfo();
        this.getDatasetInformation(this.getRoot(), hierarchicalInfo, n);
        return hierarchicalInfo;
    }

    private void getDatasetInformation(Group group, HierarchicalInfo hierarchicalInfo, int n) throws Exception {
        List<HObject> list = group.getMemberList();
        for (HObject hObject : list) {
            if (hObject instanceof Dataset) {
                Dataset dataset = (Dataset)hObject;
                if (!HierarchicalDataUtils.isDataType(dataset, n)) continue;
                long[] lArray = dataset.getDims();
                int[] nArray = new int[lArray.length];
                long l = lArray[0];
                int n2 = 0;
                while (n2 < nArray.length) {
                    nArray[n2] = (int)lArray[n2];
                    l *= lArray[n2];
                    ++n2;
                }
                hierarchicalInfo.addName(dataset.getFullName());
                hierarchicalInfo.putShape(dataset.getFullName(), nArray);
                hierarchicalInfo.putSize(dataset.getFullName(), (int)l);
            }
            if (!(hObject instanceof Group)) continue;
            this.getDatasetInformation((Group)hObject, hierarchicalInfo, n);
        }
    }

    @Override
    public List<String> getDatasetNames(int n) throws Exception {
        return this.getDatasetNames(this.getRoot(), n, new ArrayList<String>(7));
    }

    private List<String> getDatasetNames(Group group, int n, List<String> list) throws Exception {
        List<HObject> list2 = group.getMemberList();
        for (HObject hObject : list2) {
            if (hObject instanceof Dataset) {
                Dataset dataset = (Dataset)hObject;
                if (!HierarchicalDataUtils.isDataType(dataset, n)) continue;
                list.add(dataset.getFullName());
            }
            if (!(hObject instanceof Group)) continue;
            this.getDatasetNames((Group)hObject, n, list);
        }
        return list;
    }

    @Override
    public Map<String, Integer> getDatasetSizes(int n) throws Exception {
        return this.getDatasetSizes(this.getRoot(), new HashMap<String, Integer>(31), n);
    }

    private Map<String, Integer> getDatasetSizes(Group group, Map<String, Integer> map, int n) throws Exception {
        List<HObject> list = group.getMemberList();
        for (HObject hObject : list) {
            if (hObject instanceof Dataset) {
                Dataset dataset = (Dataset)hObject;
                if (!HierarchicalDataUtils.isDataType(dataset, n)) continue;
                long[] lArray = dataset.getDims();
                if (lArray != null) {
                    long l = lArray[0];
                    int n2 = 1;
                    while (n2 < lArray.length) {
                        l *= lArray[n2];
                        ++n2;
                    }
                    map.put(dataset.getFullName(), new Integer((int)l));
                }
            }
            if (!(hObject instanceof Group)) continue;
            this.getDatasetSizes((Group)hObject, map, n);
        }
        return map;
    }

    @Override
    public Map<String, int[]> getDatasetShapes(int n) throws Exception {
        return this.getDatasetShapes(this.getRoot(), new HashMap<String, int[]>(31), n);
    }

    private Map<String, int[]> getDatasetShapes(Group group, Map<String, int[]> map, int n) throws Exception {
        List<HObject> list = group.getMemberList();
        for (HObject hObject : list) {
            if (hObject instanceof Dataset) {
                Dataset dataset = (Dataset)hObject;
                if (!HierarchicalDataUtils.isDataType(dataset, n)) continue;
                long[] lArray = dataset.getDims();
                int[] nArray = new int[lArray.length];
                int n2 = 0;
                while (n2 < nArray.length) {
                    nArray[n2] = (int)lArray[n2];
                    ++n2;
                }
                map.put(dataset.getFullName(), nArray);
            }
            if (!(hObject instanceof Group)) continue;
            this.getDatasetShapes((Group)hObject, map, n);
        }
        return map;
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.openType == 0) {
            --this.count;
            if (this.count <= 0) {
                this.count = 0;
                this.file.close();
                readCache.remove(this.path);
            }
        } else if (this.openType == 1 || this.openType == 2) {
            this.file.close();
            writeCache.remove(this.path);
        }
    }

    @Override
    public Group group(String string) throws Exception {
        return this.group(string, this.getRoot());
    }

    @Override
    public Group group(String string, Group group) throws Exception {
        HObject hObject = this.checkExists(string, group, Group.class);
        if (hObject != null) {
            return (Group)hObject;
        }
        return this.file.createGroup(string, group);
    }

    private HObject checkExists(String string, Group group, Class<? extends HObject> clazz) throws Exception {
        List<HObject> list = group.getMemberList();
        for (HObject hObject : list) {
            if (!(hObject instanceof HObject)) continue;
            HObject hObject2 = hObject;
            if (clazz.isInstance(hObject2) && hObject2.getName().equals(string)) {
                return hObject2;
            }
            if (!hObject2.getName().equals(string)) continue;
            throw new Exception("'" + string + "' already exists in '" + group.getName() + "' and is not a '" + clazz.getName() + "'");
        }
        return null;
    }

    @Override
    public void print() throws Exception {
        this.printGroup(this.getRoot(), "");
    }

    private void printGroup(Group group, String string) throws Exception {
        List<HObject> list = group.getMemberList();
        int n = list.size();
        string = String.valueOf(string) + "    ";
        HObject hObject = null;
        int n2 = 0;
        while (n2 < n) {
            hObject = list.get(n2);
            System.out.println(String.valueOf(string) + hObject);
            if (hObject instanceof Group) {
                this.printGroup((Group)hObject, string);
            }
            ++n2;
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setNexusAttribute(HObject hObject, String string) throws Exception {
        NexusUtils.setNexusAttribute(this.file, hObject, string);
    }

    @Override
    public Dataset createDataset(String string, String string2, Group group) throws Exception {
        int n = group.open();
        try {
            Dataset dataset;
            string = this.getUnique(string, group, Dataset.class);
            String[] stringArray = new String[]{string2};
            H5Datatype h5Datatype = new H5Datatype(3, stringArray[0].length() + 1, -1, -1);
            Dataset dataset2 = dataset = this.file.createScalarDS(string, group, h5Datatype, new long[]{1L}, null, null, 0, stringArray);
            return dataset2;
        }
        finally {
            group.close(n);
        }
    }

    @Override
    public Dataset createDataset(String string, Datatype datatype, long[] lArray, Object object, Group group) throws Exception {
        int n = group.open();
        try {
            Dataset dataset;
            string = this.getUnique(string, group, Dataset.class);
            Dataset dataset2 = dataset = this.file.createScalarDS(string, group, datatype, lArray, null, null, 0, object);
            return dataset2;
        }
        finally {
            group.close(n);
        }
    }

    @Override
    public synchronized Dataset appendDataset(String string, Datatype datatype, long[] lArray, Object object, Group group) throws Exception {
        int n = group.open();
        try {
            long l;
            HObject hObject = this.checkExists(string, group, Dataset.class);
            if (hObject == null) {
                Dataset dataset;
                long[] lArray2 = new long[lArray.length + 1];
                long[] lArray3 = new long[lArray.length + 1];
                lArray2[0] = 1L;
                lArray3[0] = Long.MAX_VALUE;
                int n2 = 0;
                while (n2 < lArray.length) {
                    lArray2[n2 + 1] = lArray[n2];
                    lArray3[n2 + 1] = lArray[n2];
                    ++n2;
                }
                Dataset dataset2 = dataset = this.file.createScalarDS(string, group, datatype, lArray2, lArray3, null, 0, object);
                return dataset2;
            }
            H5ScalarDS h5ScalarDS = (H5ScalarDS)hObject;
            h5ScalarDS.getMetadata();
            long[] lArray4 = h5ScalarDS.getDims();
            lArray4[0] = l = lArray4[0] + 1L;
            h5ScalarDS.extend(lArray4);
            long[] lArray5 = h5ScalarDS.getStartDims();
            long[] lArray6 = h5ScalarDS.getStride();
            long[] lArray7 = h5ScalarDS.getSelectedDims();
            lArray5[0] = l - 1L;
            int n3 = 1;
            while (n3 < lArray5.length) {
                lArray5[n3] = 0L;
                ++n3;
            }
            lArray6[0] = 1L;
            n3 = 1;
            while (n3 < lArray6.length) {
                lArray6[n3] = 1L;
                ++n3;
            }
            lArray7[0] = 1L;
            n3 = 1;
            while (n3 < lArray7.length) {
                lArray7[n3] = lArray4[n3];
                ++n3;
            }
            h5ScalarDS.write(object);
            H5ScalarDS h5ScalarDS2 = h5ScalarDS;
            return h5ScalarDS2;
        }
        finally {
            group.close(n);
        }
    }

    private String getUnique(String string, Group group, Class<? extends HObject> clazz) throws Exception {
        HObject hObject = this.checkExists(string, group, clazz);
        if (hObject != null) {
            int n = 1;
            while (this.checkExists(String.valueOf(string) + n, group, clazz) != null) {
                ++n;
            }
            string = String.valueOf(string) + n;
        }
        return string;
    }

    public static boolean isWriting(String string) {
        return writeCache != null && writeCache.contains(string);
    }
}

