/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import ncsa.hdf.view.ViewProperties;

public class UserOptionsDialog
extends JDialog
implements ActionListener {
    public static final long serialVersionUID = 240L;
    private final JFrame viewer;
    private String H4toH5Path;
    private JTextField H4toH5Field;
    private JTextField UGField;
    private JTextField workField;
    private JTextField fileExtField;
    private JTextField maxMemberField;
    private JTextField startMemberField;
    private JComboBox fontSizeChoice;
    private JComboBox fontTypeChoice;
    private JComboBox delimiterChoice;
    private JComboBox choiceTreeView;
    private JComboBox choiceMetaDataView;
    private JComboBox choiceTextView;
    private JComboBox choiceTableView;
    private JComboBox choiceImageView;
    private JComboBox choicePaletteView;
    private String rootDir;
    private String workDir;
    private JCheckBox checkCurrentUserDir;
    private JCheckBox checkAutoContrast;
    private JCheckBox checkConvertEnum;
    private JButton currentDirButton;
    private JRadioButton checkReadOnly;
    private int fontSize;
    private boolean isFontChanged;
    private boolean isUserGuideChanged;
    private boolean isWorkDirChanged;
    private static Vector treeViews;
    private static Vector imageViews;
    private static Vector tableViews;
    private static Vector textViews;
    private static Vector metaDataViews;
    private static Vector paletteViews;

    public UserOptionsDialog(JFrame jFrame, String string) {
        super(jFrame, "User Options", true);
        this.viewer = jFrame;
        this.rootDir = string;
        this.isFontChanged = false;
        this.isUserGuideChanged = false;
        this.isWorkDirChanged = false;
        this.fontSize = ViewProperties.getFontSize();
        this.workDir = ViewProperties.getWorkDir();
        if (this.workDir == null) {
            this.workDir = this.rootDir;
        }
        treeViews = ViewProperties.getTreeViewList();
        metaDataViews = ViewProperties.getMetaDataViewList();
        textViews = ViewProperties.getTextViewList();
        tableViews = ViewProperties.getTableViewList();
        imageViews = ViewProperties.getImageViewList();
        paletteViews = ViewProperties.getPaletteViewList();
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(8, 8));
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int n = 700 + (ViewProperties.getFontSize() - 12) * 15;
        int n2 = 650 + (ViewProperties.getFontSize() - 12) * 15;
        jPanel.setPreferredSize(new Dimension(n, n2));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("General Setting", this.createGeneralOptionPanel());
        jTabbedPane.addTab("Default Module", this.createModuleOptionPanel());
        jTabbedPane.setSelectedIndex(0);
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("   Ok   ");
        jButton.setActionCommand("Set options");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        jButton = new JButton("Cancel");
        jButton.setActionCommand("Cancel");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        jPanel.add("Center", jTabbedPane);
        jPanel.add("South", jPanel2);
        Point point = this.getParent().getLocation();
        point.x += 250;
        point.y += 80;
        this.setLocation(point);
        this.validate();
        this.pack();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.isFontChanged = false;
            this.isUserGuideChanged = false;
            this.isWorkDirChanged = false;
            this.fontSize = ViewProperties.getFontSize();
            this.workDir = ViewProperties.getWorkDir();
            if (this.workDir == null) {
                this.workDir = this.rootDir;
            }
        }
        super.setVisible(bl);
    }

    private JPanel createGeneralOptionPanel() {
        JButton jButton;
        String[] stringArray = new String[]{"12", "14", "16", "18", "20", "22", "24", "26", "28", "30", "32", "34", "36", "48"};
        this.fontSizeChoice = new JComboBox<String>(stringArray);
        this.fontSizeChoice.setSelectedItem(String.valueOf(ViewProperties.getFontSize()));
        String[] stringArray2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        String string = ViewProperties.getFontType();
        this.fontTypeChoice = new JComboBox<String>(stringArray2);
        boolean bl = false;
        if (stringArray2 != null) {
            int n = 0;
            while (n < stringArray2.length) {
                if (stringArray2[n].equalsIgnoreCase(string)) {
                    bl = true;
                }
                ++n;
            }
        }
        if (!bl) {
            string = this.viewer.getFont().getFamily();
            ViewProperties.setFontType(string);
        }
        this.fontTypeChoice.setSelectedItem(string);
        String[] stringArray3 = new String[]{"Tab", "Comma", "Space", "Colon", "Semi-Colon"};
        this.delimiterChoice = new JComboBox<String>(stringArray3);
        this.delimiterChoice.setSelectedItem(ViewProperties.getDataDelimiter());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(9, 1, 10, 10));
        jPanel.setBorder(new SoftBevelBorder(1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.checkCurrentUserDir = new JCheckBox("\"Current Working Directory\" or", false);
        jPanel2.add((Component)this.checkCurrentUserDir, "West");
        this.checkCurrentUserDir.addActionListener(this);
        this.checkCurrentUserDir.setActionCommand("Set current dir to user.dir");
        this.workField = new JTextField(this.workDir);
        jPanel2.add((Component)this.workField, "Center");
        this.currentDirButton = jButton = new JButton("Browse...");
        jButton.setActionCommand("Browse current dir");
        jButton.addActionListener(this);
        jPanel2.add((Component)jButton, "East");
        TitledBorder titledBorder = new TitledBorder("Default Working Directory");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel2.setBorder(titledBorder);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)new JLabel("User's Guide:  "), "West");
        this.UGField = new JTextField(ViewProperties.getUsersGuide());
        jPanel2.add((Component)this.UGField, "Center");
        jButton = new JButton("Browse...");
        jButton.setActionCommand("Browse UG");
        jButton.addActionListener(this);
        jPanel2.add((Component)jButton, "East");
        titledBorder = new TitledBorder("Help Document");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel2.setBorder(titledBorder);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 8, 8));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)new JLabel("Extension: "), "West");
        this.fileExtField = new JTextField(ViewProperties.getFileExtension());
        jPanel3.add((Component)this.fileExtField, "Center");
        titledBorder = new TitledBorder("File Extension");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel3.setBorder(titledBorder);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 2, 8, 8));
        this.checkReadOnly = new JRadioButton("Read Only", ViewProperties.isReadOnly());
        jPanel4.add(this.checkReadOnly);
        JRadioButton jRadioButton = new JRadioButton("Read/Write", !ViewProperties.isReadOnly());
        jPanel4.add(jRadioButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.checkReadOnly);
        buttonGroup.add(jRadioButton);
        titledBorder = new TitledBorder("Default File Access Mode");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel4.setBorder(titledBorder);
        jPanel2.add(jPanel4);
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 8, 8));
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)new JLabel("Font Size: "), "West");
        jPanel3.add((Component)this.fontSizeChoice, "Center");
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)new JLabel("Font Type: "), "West");
        jPanel3.add((Component)this.fontTypeChoice, "Center");
        jPanel2.add(jPanel3);
        titledBorder = new TitledBorder("Text Font");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel2.setBorder(titledBorder);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)new JLabel("Data Delimiter:  "), "West");
        jPanel2.add((Component)this.delimiterChoice, "Center");
        titledBorder = new TitledBorder("Text Data Input/Output");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel2.setBorder(titledBorder);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(20, 0));
        this.checkAutoContrast = new JCheckBox("Auto Contrast");
        this.checkAutoContrast.setSelected(ViewProperties.isAutoContrast());
        jPanel2.add((Component)this.checkAutoContrast, "Center");
        JButton jButton2 = new JButton(ViewProperties.getHelpIcon());
        jButton2.setToolTipText("Help on Auto Contrast");
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        jButton2.addActionListener(this);
        jButton2.setActionCommand("Help on Auto Contrast");
        jPanel2.add((Component)jButton2, "West");
        titledBorder = new TitledBorder("Image Brightness/Contrast");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel2.setBorder(titledBorder);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(20, 0));
        this.checkConvertEnum = new JCheckBox("Convert Enum");
        this.checkConvertEnum.setSelected(ViewProperties.isConvertEnum());
        jPanel2.add((Component)this.checkConvertEnum, "Center");
        jButton2 = new JButton(ViewProperties.getHelpIcon());
        jButton2.setToolTipText("Help on Convert Enum");
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        jButton2.addActionListener(this);
        jButton2.setActionCommand("Help on Convert Enum");
        jPanel2.add((Component)jButton2, "West");
        titledBorder = new TitledBorder("Convert Enum Data");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel2.setBorder(titledBorder);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 8, 8));
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)new JLabel("Max Members: "), "West");
        this.maxMemberField = new JTextField(String.valueOf(ViewProperties.getMaxMembers()));
        jPanel3.add((Component)this.maxMemberField, "Center");
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)new JLabel("Start Member: "), "West");
        this.startMemberField = new JTextField(String.valueOf(ViewProperties.getStartMembers()));
        jPanel3.add((Component)this.startMemberField, "Center");
        jPanel2.add(jPanel3);
        titledBorder = new TitledBorder("Max Number of Members to Load in Each Group");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel2.setBorder(titledBorder);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel createModuleOptionPanel() {
        this.choiceTreeView = new JComboBox(treeViews);
        this.choiceTableView = new JComboBox(tableViews);
        this.choiceTextView = new JComboBox(textViews);
        this.choiceImageView = new JComboBox(imageViews);
        this.choiceMetaDataView = new JComboBox(metaDataViews);
        this.choicePaletteView = new JComboBox(paletteViews);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(6, 1, 10, 10));
        jPanel.setBorder(new SoftBevelBorder(1));
        JPanel jPanel2 = new JPanel();
        TitledBorder titledBorder = new TitledBorder("TreeView");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel2.setBorder(titledBorder);
        jPanel.add(jPanel2);
        jPanel2.setLayout(new BorderLayout(5, 5));
        jPanel2.add((Component)this.choiceTreeView, "Center");
        JPanel jPanel3 = new JPanel();
        titledBorder = new TitledBorder("MetaDataView");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel3.setBorder(titledBorder);
        jPanel.add(jPanel3);
        jPanel3.setLayout(new BorderLayout(5, 5));
        jPanel3.add((Component)this.choiceMetaDataView, "Center");
        JPanel jPanel4 = new JPanel();
        titledBorder = new TitledBorder("TextView");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel4.setBorder(titledBorder);
        jPanel.add(jPanel4);
        jPanel4.setLayout(new BorderLayout(5, 5));
        jPanel4.add((Component)this.choiceTextView, "Center");
        JPanel jPanel5 = new JPanel();
        titledBorder = new TitledBorder("TableView");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel5.setBorder(titledBorder);
        jPanel.add(jPanel5);
        jPanel5.setLayout(new BorderLayout(5, 5));
        jPanel5.add((Component)this.choiceTableView, "Center");
        JPanel jPanel6 = new JPanel();
        titledBorder = new TitledBorder("ImageView");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel6.setBorder(titledBorder);
        jPanel.add(jPanel6);
        jPanel6.setLayout(new BorderLayout(5, 5));
        jPanel6.add((Component)this.choiceImageView, "Center");
        JPanel jPanel7 = new JPanel();
        titledBorder = new TitledBorder("PaletteView");
        titledBorder.setTitleColor(Color.darkGray);
        jPanel7.setBorder(titledBorder);
        jPanel.add(jPanel7);
        jPanel7.setLayout(new BorderLayout(5, 5));
        jPanel7.add((Component)this.choicePaletteView, "Center");
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Set options")) {
            this.setUserOptions();
            this.setVisible(false);
        } else if (string.equals("Cancel")) {
            this.isFontChanged = false;
            this.setVisible(false);
        } else if (string.equals("Set current dir to user.dir")) {
            boolean bl = this.checkCurrentUserDir.isSelected();
            this.workField.setEnabled(!bl);
            this.currentDirButton.setEnabled(!bl);
        } else if (string.equals("Browse UG")) {
            JFileChooser jFileChooser = new JFileChooser(this.rootDir);
            int n = jFileChooser.showOpenDialog(this);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String string2 = file.getAbsolutePath();
            if (string2 == null) {
                return;
            }
            this.UGField.setText(string2);
        } else if (string.equals("Browse current dir")) {
            JFileChooser jFileChooser = new JFileChooser(this.rootDir);
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showDialog(this, "Select");
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String string3 = file.getAbsolutePath();
            if (string3 == null) {
                return;
            }
            this.workField.setText(string3);
        } else if (string.equals("Browse h4toh5")) {
            JFileChooser jFileChooser = new JFileChooser(this.rootDir);
            int n = jFileChooser.showOpenDialog(this);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String string4 = file.getAbsolutePath();
            if (string4 == null) {
                return;
            }
            this.H4toH5Path = string4;
            this.H4toH5Field.setText(string4);
        } else if (string.startsWith("Add Module")) {
            String string5 = JOptionPane.showInputDialog(this, "Type the full path of the new module:", string, -1);
            if (string5 == null || string5.length() < 1) {
                return;
            }
            try {
                Class.forName(string5);
            }
            catch (Exception exception) {
                try {
                    ViewProperties.loadExtClass().loadClass(string5);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    JOptionPane.showMessageDialog(this, "Cannot find module:\n " + string5 + "\nPlease check the module name and classpath.", "HDFView", 0);
                    return;
                }
            }
            if (string.endsWith("TreeView") && !treeViews.contains(string5)) {
                treeViews.add(string5);
                this.choiceTreeView.addItem(string5);
            } else if (string.endsWith("MetadataView") && !metaDataViews.contains(string5)) {
                metaDataViews.add(string5);
                this.choiceMetaDataView.addItem(string5);
            } else if (string.endsWith("TextView") && !textViews.contains(string5)) {
                textViews.add(string5);
                this.choiceTextView.addItem(string5);
            } else if (string.endsWith("TableView") && !tableViews.contains(string5)) {
                tableViews.add(string5);
                this.choiceTableView.addItem(string5);
            } else if (string.endsWith("ImageView") && !imageViews.contains(string5)) {
                imageViews.add(string5);
                this.choiceImageView.addItem(string5);
            } else if (string.endsWith("PaletteView") && !paletteViews.contains(string5)) {
                paletteViews.add(string5);
                this.choicePaletteView.addItem(string5);
            }
        } else if (string.startsWith("Delete Module")) {
            JComboBox jComboBox = (JComboBox)object;
            if (jComboBox.getItemCount() == 1) {
                JOptionPane.showMessageDialog(this, "Cannot delete the last module.", string, 0);
                return;
            }
            int n = JOptionPane.showConfirmDialog(this, "Do you want to delete the selected module?", string, 0);
            if (n == 1) {
                return;
            }
            String string6 = (String)jComboBox.getSelectedItem();
            jComboBox.removeItem(string6);
            if (string.endsWith("TreeView")) {
                treeViews.remove(string6);
            } else if (string.endsWith("MetadataView")) {
                metaDataViews.remove(string6);
            } else if (string.endsWith("TextView")) {
                textViews.remove(string6);
            } else if (string.endsWith("TableView")) {
                tableViews.remove(string6);
            } else if (string.endsWith("ImageView")) {
                imageViews.remove(string6);
            } else if (string.endsWith("PaletteView")) {
                paletteViews.remove(string6);
            }
        } else if (string.equals("Help on Auto Contrast")) {
            JOptionPane.showMessageDialog(this, "Auto Contrast does the following to compute a gain/bias \nthat will stretch the pixels in the image to fit the pixel \nvalues of the graphics system. For example, it stretches unsigned\nshort data to fit the full range of an unsigned short. Later \ncode simply takes the high order byte and passes it to the graphics\nsystem (which expects 0-255). It uses some statistics on the pixels \nto prevent outliers from throwing off the gain/bias calculations much.\n\nTo compute the gain/bias we... \nFind the mean and std. deviation of the pixels in the image \nmin = mean - 3 * std.dev. \nmax = mean + 3 * std.dev. \nsmall fudge factor because this tends to overshoot a bit \nStretch to 0-USHRT_MAX \n        gain = USHRT_MAX / (max-min) \n        bias = -min \n\nTo apply the gain/bias to a pixel, use the formula \ndata[i] = (data[i] + bias) * gain \n\nFinally, for auto-ranging the sliders for gain/bias, we do the following \ngain_min = 0 \ngain_max = gain * 3.0 \nbias_min = -fabs(bias) * 3.0 \nbias_max = fabs(bias) * 3.0 \n\n\n");
        } else if (string.equals("Help on Convert Enum")) {
            JOptionPane.showMessageDialog(this, "Convert enum data to strings. \nFor example, a dataset of an enum type of (R=0, G=, B=2) \nhas values of (0, 2, 2, 2, 1, 1). With conversion, the data values are \nshown as (R, B, B, B, G, G).\n\n\n");
        }
    }

    private void setUserOptions() {
        int n;
        String string;
        String string2;
        String string3 = this.UGField.getText();
        if (string3 != null && string3.length() > 0) {
            this.isUserGuideChanged = !(string3 = string3.trim()).equals(ViewProperties.getUsersGuide());
            ViewProperties.setUsersGuide(string3);
        }
        String string4 = this.workField.getText();
        if (this.checkCurrentUserDir.isSelected()) {
            string4 = "user.dir";
        }
        if (string4 != null && string4.length() > 0) {
            this.isWorkDirChanged = !(string4 = string4.trim()).equals(ViewProperties.getWorkDir());
            ViewProperties.setWorkDir(string4);
        }
        if ((string2 = this.fileExtField.getText()) != null && string2.length() > 0) {
            string2 = string2.trim();
            ViewProperties.setFileExtension(string2);
        }
        if (this.checkReadOnly.isSelected()) {
            ViewProperties.setReadOnly(true);
        } else {
            ViewProperties.setReadOnly(false);
        }
        int n2 = 12;
        try {
            n2 = Integer.parseInt((String)this.fontSizeChoice.getSelectedItem());
            ViewProperties.setFontSize(n2);
            if (this.fontSize != ViewProperties.getFontSize()) {
                this.isFontChanged = true;
            }
        }
        catch (Exception exception) {}
        if (!(string = (String)this.fontTypeChoice.getSelectedItem()).equalsIgnoreCase(ViewProperties.getFontType())) {
            this.isFontChanged = true;
            ViewProperties.setFontType(string);
        }
        ViewProperties.setDataDelimiter((String)this.delimiterChoice.getSelectedItem());
        try {
            n = Integer.parseInt(this.maxMemberField.getText());
            ViewProperties.setMaxMembers(n);
        }
        catch (Exception exception) {}
        try {
            n = Integer.parseInt(this.startMemberField.getText());
            ViewProperties.setStartMembers(n);
        }
        catch (Exception exception) {}
        Vector[] vectorArray = new Vector[]{treeViews, metaDataViews, textViews, tableViews, imageViews, paletteViews};
        JComboBox[] jComboBoxArray = new JComboBox[]{this.choiceTreeView, this.choiceMetaDataView, this.choiceTextView, this.choiceTableView, this.choiceImageView, this.choicePaletteView};
        int n3 = 0;
        while (n3 < 6) {
            Object object = jComboBoxArray[n3].getSelectedItem();
            vectorArray[n3].remove(object);
            vectorArray[n3].add(0, object);
            ++n3;
        }
        ViewProperties.setAutoContrast(this.checkAutoContrast.isSelected());
        ViewProperties.setConvertEnum(this.checkConvertEnum.isSelected());
    }

    public boolean isFontChanged() {
        return this.isFontChanged;
    }

    public boolean isUserGuideChanged() {
        return this.isUserGuideChanged;
    }

    public boolean isWorkDirChanged() {
        return this.isWorkDirChanged;
    }
}

