/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.tree.DefaultMutableTreeNode;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;

public final class Tools {
    public static final long MAX_INT8 = 127L;
    public static final long MAX_UINT8 = 255L;
    public static final long MAX_INT16 = 32767L;
    public static final long MAX_UINT16 = 65535L;
    public static final long MAX_INT32 = Integer.MAX_VALUE;
    public static final long MAX_UINT32 = 0xFFFFFFFFL;
    public static final long MAX_INT64 = Long.MAX_VALUE;
    public static final String FILE_TYPE_JPEG = "JPEG";
    public static final String FILE_TYPE_TIFF = "TIFF";
    public static final String FILE_TYPE_PNG = "PNG";
    public static final String FILE_TYPE_GIF = "GIF";
    public static final String FILE_TYPE_BMP = "BMP";
    public static final String FILE_TYPE_IMAGE = "IMG";

    public static final void debug(Object object, Object object2) {
        if (object != null) {
            System.out.println("*** " + object.getClass().getName() + ": " + object2);
        }
    }

    public static void convertImageToHDF(String string, String string2, String string3, String string4) throws Exception {
        File file = null;
        if (string == null) {
            throw new NullPointerException("The source image file is null.");
        }
        file = new File(string);
        if (!file.exists()) {
            throw new NullPointerException("The source image file does not exist.");
        }
        if (string2 == null) {
            throw new NullPointerException("The target HDF file is null.");
        }
        if (!string3.equals(FILE_TYPE_IMAGE)) {
            throw new UnsupportedOperationException("Unsupported image type.");
        }
        if (!string4.equals("HDF4") && !string4.equals("HDF5")) {
            throw new UnsupportedOperationException("Unsupported destination file type.");
        }
        BufferedImage bufferedImage = null;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            bufferedImage = ImageIO.read(bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (Throwable throwable) {
            bufferedImage = null;
        }
        if (bufferedImage == null) {
            throw new UnsupportedOperationException("Failed to read image: " + string);
        }
        int n = bufferedImage.getHeight();
        int n2 = bufferedImage.getWidth();
        byte[] byArray = null;
        try {
            byArray = new byte[3 * n * n2];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            throw new RuntimeException("Out of memory error.");
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < n2) {
                n4 = bufferedImage.getRGB(n6, n5);
                byArray[n3++] = (byte)(n4 >> 16);
                byArray[n3++] = (byte)(n4 >> 8);
                byArray[n3++] = (byte)n4;
                ++n6;
            }
            ++n5;
        }
        long[] lArray = null;
        Datatype datatype = null;
        Group group = null;
        String string5 = file.getName();
        FileFormat fileFormat = null;
        FileFormat fileFormat2 = null;
        if (string4.equals("HDF5")) {
            fileFormat2 = FileFormat.getFileFormat("HDF5");
            long[] lArray2 = new long[]{n, n2, 3L};
            lArray = lArray2;
        } else if (string4.equals("HDF4")) {
            fileFormat2 = FileFormat.getFileFormat("HDF4");
            long[] lArray3 = new long[]{n2, n, 3L};
            lArray = lArray3;
        } else {
            fileFormat2 = null;
        }
        if (fileFormat2 != null) {
            fileFormat = fileFormat2.createInstance(string2, 2);
            fileFormat.open();
            group = (Group)((DefaultMutableTreeNode)fileFormat.getRootNode()).getUserObject();
            datatype = fileFormat.createDatatype(2, 1, -1, 0);
            fileFormat.createImage(string5, group, datatype, lArray, null, null, -1, 3, 0, byArray);
            fileFormat.close();
        }
        byArray = null;
        bufferedImage = null;
        Runtime.getRuntime().gc();
    }

    public static void saveImageAs(BufferedImage bufferedImage, File file, String string) throws Exception {
        if (bufferedImage == null) {
            throw new NullPointerException("The source image is null.");
        }
        ImageIO.write((RenderedImage)bufferedImage, string, file);
    }

    public static final byte[][] createGrayPalette() {
        byte[][] byArray = new byte[3][256];
        int n = 0;
        while (n < 256) {
            byte by = (byte)n;
            byArray[2][n] = by;
            byArray[1][n] = by;
            byArray[0][n] = by;
            ++n;
        }
        return byArray;
    }

    public static final byte[][] createReverseGrayPalette() {
        byte[][] byArray = new byte[3][256];
        int n = 0;
        while (n < 256) {
            byte by = (byte)(255 - n);
            byArray[2][n] = by;
            byArray[1][n] = by;
            byArray[0][n] = by;
            ++n;
        }
        return byArray;
    }

    public static final byte[][] createGrayWavePalette() {
        byte[][] byArray = new byte[3][256];
        int n = 0;
        while (n < 256) {
            byte by = (byte)(127.0 + 127.0 * Math.sin((double)(n - 32) / 20.3));
            byArray[2][n] = by;
            byArray[1][n] = by;
            byArray[0][n] = by;
            ++n;
        }
        return byArray;
    }

    public static final byte[][] createRainbowPalette() {
        byte[][] byArray = new byte[3][256];
        int n = 1;
        while (n < 255) {
            int n2;
            int n3;
            byte by;
            if (n <= 29) {
                by = (byte)(129.36 - (double)n * 4.36);
                n3 = 0;
                n2 = -1;
            } else if (n <= 86) {
                by = 0;
                n3 = (byte)(-133.54 + (double)n * 4.52);
                n2 = -1;
            } else if (n <= 141) {
                by = 0;
                n3 = -1;
                n2 = (byte)(665.83 - (double)n * 4.72);
            } else if (n <= 199) {
                by = (byte)(-635.26 + (double)n * 4.47);
                n3 = -1;
                n2 = 0;
            } else {
                by = (byte)-1;
                n3 = (byte)(1166.81 - (double)n * 4.57);
                n2 = 0;
            }
            byArray[0][n] = by;
            byArray[1][n] = n3;
            byArray[2][n] = n2;
            ++n;
        }
        byArray[2][0] = 0;
        byArray[1][0] = 0;
        byArray[0][0] = 0;
        byArray[2][255] = -1;
        byArray[1][255] = -1;
        byArray[0][255] = -1;
        return byArray;
    }

    public static final byte[][] createNaturePalette() {
        byte[][] byArray = new byte[3][256];
        int n = 1;
        while (n < 210) {
            byArray[0][n] = (byte)((Math.sin((double)(n - 5) / 16.0) + 1.0) * 90.0);
            byArray[1][n] = (byte)((1.0 - Math.sin((double)(n - 30) / 12.0)) * 64.0 * (1.0 - (double)n / 255.0) + 128.0 - (double)(n / 2));
            byArray[2][n] = (byte)((1.0 - Math.sin((double)(n - 8) / 9.0)) * 110.0 + 30.0);
            ++n;
        }
        n = 210;
        while (n < 255) {
            byArray[0][n] = 80;
            byArray[1][n] = 0;
            byArray[2][n] = -56;
            ++n;
        }
        byArray[2][0] = 0;
        byArray[1][0] = 0;
        byArray[0][0] = 0;
        byArray[2][255] = -1;
        byArray[1][255] = -1;
        byArray[0][255] = -1;
        return byArray;
    }

    public static final byte[][] createWavePalette() {
        byte[][] byArray = new byte[3][256];
        int n = 1;
        while (n < 255) {
            byArray[0][n] = (byte)((Math.sin((double)n / 40.0 - 3.2) + 1.0) * 128.0);
            byArray[1][n] = (byte)((1.0 - Math.sin((double)n / 2.55 - 3.1)) * 70.0 + 30.0);
            byArray[2][n] = (byte)((1.0 - Math.sin((double)n / 40.0 - 3.1)) * 128.0);
            ++n;
        }
        byArray[2][0] = 0;
        byArray[1][0] = 0;
        byArray[0][0] = 0;
        byArray[2][255] = -1;
        byArray[1][255] = -1;
        byArray[0][255] = -1;
        return byArray;
    }

    public static final byte[][] readPalette(String string) {
        int n;
        int n2;
        int n3 = 256;
        byte[][] byArray = new byte[3][n3];
        BufferedReader bufferedReader = null;
        String string2 = null;
        int n4 = 0;
        float[][] fArray = new float[n3][4];
        if (string == null) {
            return null;
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (Exception exception) {
            bufferedReader = null;
        }
        if (bufferedReader == null) {
            return null;
        }
        int n5 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        do {
            StringTokenizer stringTokenizer;
            try {
                string2 = bufferedReader.readLine();
            }
            catch (Exception exception) {
                string2 = null;
            }
            if (string2 == null || (stringTokenizer = new StringTokenizer(string2)).countTokens() != 4) continue;
            try {
                f9 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                f8 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                f7 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                f6 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            fArray[n5][0] = f9;
            fArray[n5][1] = f8;
            fArray[n5][2] = f7;
            fArray[n5][3] = f6;
            if (n5 == 0) {
                f4 = f3 = f9;
                f2 = f = f8;
            }
            f4 = Math.max(f4, f9);
            f2 = Math.max(f2, f8);
            f2 = Math.max(f2, f7);
            f2 = Math.max(f2, f6);
            f3 = Math.min(f3, f9);
            f = Math.min(f, f8);
            f = Math.min(f, f7);
            f = Math.min(f, f6);
            if (++n5 >= n3) break;
        } while (string2 != null);
        if ((n4 = n5) <= 1) {
            return null;
        }
        n4 = n5;
        if (f2 <= 1.0f) {
            f5 = f == f2 ? 1.0f : ((float)n3 - 1.0f) / (f2 - f);
            n2 = 0;
            while (n2 < n4) {
                n = 1;
                while (n < 4) {
                    fArray[n2][n] = (fArray[n2][n] - f) * f5;
                    ++n;
                }
                ++n2;
            }
        }
        n5 = 0;
        f5 = f3 == f4 ? 1.0f : ((float)n3 - 1.0f) / (f4 - f3);
        n2 = 0;
        while (n2 < n4) {
            n5 = (int)((fArray[n2][0] - f3) * f5);
            n = 0;
            while (n < 3) {
                byArray[n][n5] = (byte)fArray[n2][n + 1];
                ++n;
            }
            ++n2;
        }
        n2 = 1;
        while (n2 < n3) {
            if (byArray[0][n2] + byArray[1][n2] + byArray[2][n2] == 0) {
                n = n2 + 1;
                while (byArray[0][n] + byArray[1][n] + byArray[2][n] == 0) {
                    if (++n < n3) continue;
                    return byArray;
                }
                byArray[0][n2] = (byte)((float)byArray[0][n2 - 1] + (float)(byArray[0][n] - byArray[0][n2 - 1]) / (float)(n - n2));
                byArray[1][n2] = (byte)((float)byArray[1][n2 - 1] + (float)(byArray[1][n] - byArray[1][n2 - 1]) / (float)(n - n2));
                byArray[2][n2] = (byte)((float)byArray[2][n2 - 1] + (float)(byArray[2][n] - byArray[2][n2 - 1]) / (float)(n - n2));
            }
            ++n2;
        }
        return byArray;
    }

    public static boolean hasAlpha(Image image) {
        if (image == null) {
            return false;
        }
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }

    public static Image createIndexedImage(byte[] byArray, byte[][] byArray2, int n, int n2) {
        Image image = null;
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, byArray2[0], byArray2[1], byArray2[2]);
        image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n2, (ColorModel)indexColorModel, byArray, 0, n));
        return image;
    }

    public static Image createTrueColorImage(byte[] byArray, boolean bl, int n, int n2) {
        Image image = null;
        int n3 = n * n2;
        int[] nArray = new int[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n2) {
            int n10 = 0;
            while (n10 < n) {
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n4 = 0;
                if (bl) {
                    n6 = byArray[n5];
                    n7 = byArray[n3 + n5];
                    n8 = byArray[n3 * 2 + n5];
                } else {
                    n6 = byArray[n5 * 3];
                    n7 = byArray[n5 * 3 + 1];
                    n8 = byArray[n5 * 3 + 2];
                }
                n6 = n6 << 16 & 0xFF0000;
                n7 = n7 << 8 & 0xFF00;
                n4 = 0xFF000000 | n6 | n7 | (n8 &= 0xFF);
                nArray[n5++] = n4;
                ++n10;
            }
            ++n9;
        }
        DirectColorModel directColorModel = (DirectColorModel)ColorModel.getRGBdefault();
        image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n2, (ColorModel)directColorModel, nArray, 0, n));
        nArray = null;
        return image;
    }

    public static byte[] getBytes(Object object, double[] dArray, byte[] byArray) {
        return Tools.getBytes(object, dArray, -1, -1, false, null, false, byArray);
    }

    public static byte[] getBytes(Object object, double[] dArray, int n, int n2, boolean bl, byte[] byArray) {
        return Tools.getBytes(object, dArray, n, n2, bl, null, false, byArray);
    }

    public static byte[] getBytes(Object object, double[] dArray, Object object2, byte[] byArray) {
        return Tools.getBytes(object, dArray, -1, -1, false, object2, false, byArray);
    }

    public static byte[] getBytes(Object object, double[] dArray, int n, int n2, boolean bl, Object object2, byte[] byArray) {
        return Tools.getBytes(object, dArray, n, n2, bl, object2, false, byArray);
    }

    public static byte[] getBytes(Object object, double[] dArray, int n, int n2, boolean bl, Object object2, boolean bl2, byte[] byArray) {
        if (object == null) {
            return null;
        }
        if (!object.getClass().isArray()) {
            return null;
        }
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double d3 = 1.0;
        String string = object.getClass().getName();
        char c = string.charAt(string.lastIndexOf("[") + 1);
        int n3 = Array.getLength(object);
        if (dArray == null) {
            dArray = new double[2];
            dArray[1] = 0.0;
            dArray[0] = 0.0;
        }
        if (c == 'B') {
            return Tools.convertByteData((byte[])object, dArray, n, n2, bl, object2, bl2, byArray);
        }
        if (byArray == null || n3 != byArray.length) {
            byArray = new byte[n3];
        }
        if (dArray[0] == dArray[1]) {
            Tools.findMinMax(object, dArray, object2);
        }
        d3 = (d = dArray[0]) == (d2 = dArray[1]) ? 1.0 : 255.0 / (d2 - d);
        switch (c) {
            case 'S': {
                int n4;
                int n5;
                short[] sArray = (short[])object;
                if (object2 != null && (n5 = ((short[])object2)[0]) != 0) {
                    n4 = 0;
                    while (n4 < n3) {
                        if (n5 == sArray[n4]) {
                            sArray[n4] = 0;
                        }
                        ++n4;
                    }
                }
                if (bl) {
                    n5 = 0;
                    while (n5 < n2) {
                        n4 = 0;
                        while (n4 < n) {
                            byArray[n5 * n + n4] = (double)sArray[n4 * n2 + n5] <= d ? 0 : ((double)sArray[n4 * n2 + n5] >= d2 ? -1 : (byte)(((double)sArray[n4 * n2 + n5] - d) * d3));
                            ++n4;
                        }
                        ++n5;
                    }
                } else {
                    n5 = 0;
                    while (n5 < n3) {
                        byArray[n5] = (double)sArray[n5] <= d ? 0 : ((double)sArray[n5] >= d2 ? -1 : (byte)(((double)sArray[n5] - d) * d3));
                        ++n5;
                    }
                }
                break;
            }
            case 'I': {
                int n6;
                int n7;
                int[] nArray = (int[])object;
                if (object2 != null && (n7 = ((int[])object2)[0]) != 0) {
                    n6 = 0;
                    while (n6 < n3) {
                        if (n7 == nArray[n6]) {
                            nArray[n6] = 0;
                        }
                        ++n6;
                    }
                }
                if (bl) {
                    n7 = 0;
                    while (n7 < n2) {
                        n6 = 0;
                        while (n6 < n) {
                            byArray[n7 * n + n6] = (double)nArray[n6 * n2 + n7] <= d ? 0 : ((double)nArray[n6 * n2 + n7] >= d2 ? -1 : (byte)(((double)nArray[n6 * n2 + n7] - d) * d3));
                            ++n6;
                        }
                        ++n7;
                    }
                } else {
                    n7 = 0;
                    while (n7 < n3) {
                        byArray[n7] = (double)nArray[n7] <= d ? 0 : ((double)nArray[n7] >= d2 ? -1 : (byte)(((double)nArray[n7] - d) * d3));
                        ++n7;
                    }
                }
                break;
            }
            case 'J': {
                long l;
                long[] lArray = (long[])object;
                if (object2 != null && (l = ((long[])object2)[0]) != 0L) {
                    int n8 = 0;
                    while (n8 < n3) {
                        if (l == lArray[n8]) {
                            lArray[n8] = 0L;
                        }
                        ++n8;
                    }
                }
                if (bl) {
                    int n9 = 0;
                    while (n9 < n2) {
                        int n10 = 0;
                        while (n10 < n) {
                            byArray[n9 * n + n10] = (double)lArray[n10 * n2 + n9] <= d ? 0 : ((double)lArray[n10 * n2 + n9] >= d2 ? -1 : (byte)(((double)lArray[n10 * n2 + n9] - d) * d3));
                            ++n10;
                        }
                        ++n9;
                    }
                } else {
                    int n11 = 0;
                    while (n11 < n3) {
                        byArray[n11] = (double)lArray[n11] <= d ? 0 : ((double)lArray[n11] >= d2 ? -1 : (byte)(((double)lArray[n11] - d) * d3));
                        ++n11;
                    }
                }
                break;
            }
            case 'F': {
                int n12;
                float f;
                float[] fArray = (float[])object;
                if (object2 != null && (f = ((float[])object2)[0]) != 0.0f) {
                    n12 = 0;
                    while (n12 < n3) {
                        if (f == fArray[n12]) {
                            fArray[n12] = 0.0f;
                        }
                        ++n12;
                    }
                }
                if (bl) {
                    int n13 = 0;
                    while (n13 < n2) {
                        n12 = 0;
                        while (n12 < n) {
                            byArray[n13 * n + n12] = (double)fArray[n12 * n2 + n13] <= d ? 0 : ((double)fArray[n12 * n2 + n13] >= d2 ? -1 : (byte)(((double)fArray[n12 * n2 + n13] - d) * d3));
                            ++n12;
                        }
                        ++n13;
                    }
                } else {
                    int n14 = 0;
                    while (n14 < n3) {
                        byArray[n14] = (double)fArray[n14] <= d ? 0 : ((double)fArray[n14] >= d2 ? -1 : (byte)(((double)fArray[n14] - d) * d3));
                        ++n14;
                    }
                }
                break;
            }
            case 'D': {
                double d4;
                double[] dArray2 = (double[])object;
                if (object2 != null && (d4 = ((double[])object2)[0]) != 0.0) {
                    int n15 = 0;
                    while (n15 < n3) {
                        if (d4 == dArray2[n15]) {
                            dArray2[n15] = 0.0;
                        }
                        ++n15;
                    }
                }
                if (bl) {
                    int n16 = 0;
                    while (n16 < n2) {
                        int n17 = 0;
                        while (n17 < n) {
                            byArray[n16 * n + n17] = dArray2[n17 * n2 + n16] <= d ? 0 : (dArray2[n17 * n2 + n16] >= d2 ? -1 : (byte)((dArray2[n17 * n2 + n16] - d) * d3));
                            ++n17;
                        }
                        ++n16;
                    }
                } else {
                    int n18 = 0;
                    while (n18 < n3) {
                        byArray[n18] = dArray2[n18] <= d ? 0 : (dArray2[n18] >= d2 ? -1 : (byte)((dArray2[n18] - d) * d3));
                        ++n18;
                    }
                }
                break;
            }
            default: {
                byArray = null;
            }
        }
        return byArray;
    }

    private static byte[] convertByteData(byte[] byArray, double[] dArray, int n, int n2, boolean bl, Object object, boolean bl2, byte[] byArray2) {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double d3 = 1.0;
        if (byArray == null) {
            return null;
        }
        if (bl2 && dArray[0] == dArray[1]) {
            Tools.findMinMax(byArray, dArray, object);
        }
        if (dArray[0] == 0.0 && dArray[1] == 255.0) {
            bl2 = false;
        }
        if (!bl2 && !bl) {
            return byArray;
        }
        if (byArray2 == null || byArray == byArray2) {
            byArray2 = new byte[byArray.length];
        }
        if (!bl2) {
            dArray[0] = 0.0;
            dArray[1] = 255.0;
            if (bl) {
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = 0;
                    while (n4 < n) {
                        byArray2[n3 * n + n4] = byArray[n4 * n2 + n3];
                        ++n4;
                    }
                    ++n3;
                }
            }
            return byArray2;
        }
        d = dArray[0];
        d2 = dArray[1];
        double d4 = d3 = d == d2 ? 1.0 : 255.0 / (d2 - d);
        if (bl) {
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < n) {
                    byArray2[n5 * n + n6] = (double)byArray[n6 * n2 + n5] >= d2 ? -1 : ((double)byArray[n6 * n2 + n5] <= d ? 0 : (int)((int)(((double)byArray[n6 * n2 + n5] - d) * d3)));
                    ++n6;
                }
                ++n5;
            }
        } else {
            int n7 = 0;
            while (n7 < byArray.length) {
                byArray2[n7] = (double)byArray[n7] >= d2 ? -1 : ((double)byArray[n7] <= d ? 0 : (int)((int)(((double)byArray[n7] - d) * d3)));
                ++n7;
            }
        }
        return byArray2;
    }

    public static Object newInstance(Class<?> clazz, Object[] objectArray) throws Exception {
        Object var2_2 = null;
        if (clazz == null) {
            return null;
        }
        if (objectArray == null || objectArray.length == 0) {
            var2_2 = clazz.newInstance();
        } else {
            Constructor<?>[] constructorArray = clazz.getConstructors();
            if (constructorArray == null || constructorArray.length == 0) {
                return null;
            }
            boolean bl = false;
            Constructor<?> constructor = null;
            Class[] classArray = null;
            int n = constructorArray.length;
            int n2 = objectArray.length;
            int n3 = 0;
            while (n3 < n) {
                constructor = constructorArray[n3];
                classArray = constructor.getParameterTypes();
                if (classArray.length == n2) {
                    bl = classArray[0].isInstance(objectArray[0]);
                    int n4 = 1;
                    while (n4 < n2) {
                        bl = bl && classArray[n4].isInstance(objectArray[n4]);
                        ++n4;
                    }
                    if (bl) {
                        var2_2 = constructor.newInstance(objectArray);
                        break;
                    }
                }
                ++n3;
            }
        }
        return var2_2;
    }

    public static int autoContrastCompute(Object object, double[] dArray, boolean bl) {
        int n = 1;
        long l = 255L;
        double[] dArray2 = new double[2];
        if (object == null || dArray == null || Array.getLength(object) <= 0 || dArray.length < 2) {
            return -1;
        }
        n = Tools.autoContrastComputeMinMax(object, dArray2);
        if (n < 0 || dArray2[1] - dArray2[0] < 10.0) {
            n = Tools.findMinMax(object, dArray2, null);
        }
        if (n < 0) {
            return -1;
        }
        String string = object.getClass().getName();
        char c = string.charAt(string.lastIndexOf("[") + 1);
        switch (c) {
            case 'B': {
                l = 127L;
                break;
            }
            case 'S': {
                l = 32767L;
                if (!bl) break;
                l = 255L;
                break;
            }
            case 'I': {
                l = Integer.MAX_VALUE;
                if (!bl) break;
                l = 65535L;
                break;
            }
            case 'J': {
                l = Long.MAX_VALUE;
                if (!bl) break;
                l = 0xFFFFFFFFL;
                break;
            }
            default: {
                n = -1;
            }
        }
        if (dArray2[0] == dArray2[1]) {
            dArray[0] = 1.0;
            dArray[1] = 0.0;
        } else {
            double d = dArray2[1] - dArray2[0];
            double d2 = dArray2[1] + d * 0.1;
            double d3 = dArray2[0] - d * 0.1;
            if (d2 <= (double)l) {
                dArray2[1] = d2;
            }
            if (d3 >= 0.0) {
                dArray2[0] = d3;
            }
            dArray[0] = (double)l / (dArray2[1] - dArray2[0]);
            dArray[1] = -dArray2[0];
        }
        return n;
    }

    public static Object autoContrastApply(Object object, Object object2, double[] dArray, boolean bl) {
        int n = 0;
        if (object == null || dArray == null || dArray.length < 2) {
            return null;
        }
        n = Array.getLength(object);
        if (object2 != null && n != Array.getLength(object2)) {
            return null;
        }
        double d = dArray[0];
        double d2 = dArray[1];
        String string = object.getClass().getName();
        char c = string.charAt(string.lastIndexOf("[") + 1);
        switch (c) {
            case 'B': {
                byte[] byArray = (byte[])object;
                if (object2 == null) {
                    object2 = new byte[n];
                }
                byte[] byArray2 = (byte[])object2;
                int n2 = 127;
                int n3 = 0;
                while (n3 < n) {
                    double d3 = ((double)byArray[n3] + d2) * d;
                    byArray2[n3] = d3 < 0.0 ? 0 : (d3 > (double)n2 ? n2 : (byte)d3);
                    ++n3;
                }
                break;
            }
            case 'S': {
                short[] sArray = (short[])object;
                if (object2 == null) {
                    object2 = new short[n];
                }
                short[] sArray2 = (short[])object2;
                int n4 = Short.MAX_VALUE;
                if (bl) {
                    n4 = 255;
                }
                int n5 = 0;
                while (n5 < n) {
                    double d4 = ((double)sArray[n5] + d2) * d;
                    sArray2[n5] = d4 < 0.0 ? 0 : (d4 > (double)n4 ? n4 : (short)d4);
                    ++n5;
                }
                break;
            }
            case 'I': {
                int[] nArray = (int[])object;
                if (object2 == null) {
                    object2 = new int[n];
                }
                int[] nArray2 = (int[])object2;
                int n6 = Integer.MAX_VALUE;
                if (bl) {
                    n6 = 65535;
                }
                int n7 = 0;
                while (n7 < n) {
                    double d5 = ((double)nArray[n7] + d2) * d;
                    nArray2[n7] = d5 < 0.0 ? 0 : (d5 > (double)n6 ? n6 : (int)d5);
                    ++n7;
                }
                break;
            }
            case 'J': {
                long[] lArray = (long[])object;
                if (object2 == null) {
                    object2 = new long[n];
                }
                long[] lArray2 = (long[])object2;
                long l = Long.MAX_VALUE;
                if (bl) {
                    l = 0xFFFFFFFFL;
                }
                int n8 = 0;
                while (n8 < n) {
                    double d6 = ((double)lArray[n8] + d2) * d;
                    lArray2[n8] = d6 < 0.0 ? 0L : (d6 > (double)l ? l : (long)d6);
                    ++n8;
                }
                break;
            }
        }
        return object2;
    }

    public static int autoContrastComputeSliderRange(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null || dArray2 == null || dArray3 == null || dArray.length < 2 || dArray2.length < 2 || dArray3.length < 2) {
            return -1;
        }
        dArray2[0] = 0.0;
        dArray2[1] = dArray[0] * 3.0;
        dArray3[1] = 256.0;
        if (dArray[1] >= 0.001 || dArray[1] <= -0.001) {
            dArray3[1] = Math.abs(dArray[1]) * 3.0;
        }
        dArray3[0] = -dArray3[1];
        return 1;
    }

    public static int autoContrastConvertImageBuffer(Object object, byte[] byArray, boolean bl) {
        int n = 0;
        if (object == null || byArray == null || byArray.length != Array.getLength(object)) {
            return -1;
        }
        int n2 = byArray.length;
        String string = object.getClass().getName();
        char c = string.charAt(string.lastIndexOf("[") + 1);
        switch (c) {
            case 'B': {
                byte[] byArray2 = (byte[])object;
                if (bl) {
                    int n3 = 0;
                    while (n3 < n2) {
                        byArray[n3] = byArray2[n3];
                        ++n3;
                    }
                } else {
                    int n4 = 0;
                    while (n4 < n2) {
                        byArray[n4] = (byte)((byArray2[n4] & 0x7F) << 1);
                        ++n4;
                    }
                }
                break;
            }
            case 'S': {
                short[] sArray = (short[])object;
                if (bl) {
                    int n5 = 0;
                    while (n5 < n2) {
                        byArray[n5] = (byte)sArray[n5];
                        ++n5;
                    }
                } else {
                    int n6 = 0;
                    while (n6 < n2) {
                        byArray[n6] = (byte)(sArray[n6] >> 7 & 0xFF);
                        ++n6;
                    }
                }
                break;
            }
            case 'I': {
                int[] nArray = (int[])object;
                if (bl) {
                    int n7 = 0;
                    while (n7 < n2) {
                        byArray[n7] = (byte)(nArray[n7] >> 8 & 0xFF);
                        ++n7;
                    }
                } else {
                    int n8 = 0;
                    while (n8 < n2) {
                        byArray[n8] = (byte)(nArray[n8] >> 23 & 0xFF);
                        ++n8;
                    }
                }
                break;
            }
            case 'J': {
                long[] lArray = (long[])object;
                if (bl) {
                    int n9 = 0;
                    while (n9 < n2) {
                        byArray[n9] = (byte)(lArray[n9] >> 24 & 0xFFL);
                        ++n9;
                    }
                } else {
                    int n10 = 0;
                    while (n10 < n2) {
                        byArray[n10] = (byte)(lArray[n10] >> 55 & 0xFFL);
                        ++n10;
                    }
                }
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    public static int autoContrastComputeMinMax(Object object, Object object2) {
        int n = 1;
        double[] dArray = new double[2];
        if (object == null || object2 == null || Array.getLength(object) <= 0 || Array.getLength(object2) < 2) {
            return -1;
        }
        n = Tools.computeStatistics(object, dArray, null);
        if (n < 0) {
            return n;
        }
        double d = dArray[0] - 3.0 * dArray[1];
        double d2 = dArray[0] + 3.0 * dArray[1];
        String string = object2.getClass().getName();
        char c = string.charAt(string.lastIndexOf("[") + 1);
        switch (c) {
            case 'B': {
                byte[] byArray = (byte[])object2;
                byArray[0] = (byte)d;
                byArray[1] = (byte)d2;
                break;
            }
            case 'S': {
                short[] sArray = (short[])object2;
                sArray[0] = (short)d;
                sArray[1] = (short)d2;
                break;
            }
            case 'I': {
                int[] nArray = (int[])object2;
                nArray[0] = (int)d;
                nArray[1] = (int)d2;
                break;
            }
            case 'J': {
                long[] lArray = (long[])object2;
                lArray[0] = (long)d;
                lArray[1] = (long)d2;
                break;
            }
            case 'F': {
                float[] fArray = (float[])object2;
                fArray[0] = (float)d;
                fArray[1] = (float)d2;
                break;
            }
            case 'D': {
                double[] dArray2 = (double[])object2;
                dArray2[0] = d;
                dArray2[1] = d2;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    public static int findMinMax(Object object, double[] dArray, Object object2) {
        int n = 1;
        if (object == null || dArray == null || Array.getLength(object) <= 0 || Array.getLength(dArray) < 2) {
            return -1;
        }
        int n2 = Array.getLength(object);
        double d = 0.0;
        boolean bl = object2 != null && object2.getClass().isArray();
        String string = object.getClass().getName();
        char c = string.charAt(string.lastIndexOf("[") + 1);
        dArray[0] = 3.4028234663852886E38;
        dArray[1] = -3.4028234663852886E38;
        switch (c) {
            case 'B': {
                byte[] byArray = (byte[])object;
                if (bl) {
                    d = ((byte[])object2)[0];
                }
                int n3 = 0;
                while (n3 < n2) {
                    if (!bl || (double)byArray[n3] != d) {
                        if (dArray[0] > (double)byArray[n3]) {
                            dArray[0] = byArray[n3];
                        }
                        if (dArray[1] < (double)byArray[n3]) {
                            dArray[1] = byArray[n3];
                        }
                    }
                    ++n3;
                }
                break;
            }
            case 'S': {
                short[] sArray = (short[])object;
                if (bl) {
                    d = ((short[])object2)[0];
                }
                int n4 = 0;
                while (n4 < n2) {
                    if (!bl || (double)sArray[n4] != d) {
                        if (dArray[0] > (double)sArray[n4]) {
                            dArray[0] = sArray[n4];
                        }
                        if (dArray[1] < (double)sArray[n4]) {
                            dArray[1] = sArray[n4];
                        }
                    }
                    ++n4;
                }
                break;
            }
            case 'I': {
                int[] nArray = (int[])object;
                if (bl) {
                    d = ((int[])object2)[0];
                }
                int n5 = 0;
                while (n5 < n2) {
                    if (!bl || (double)nArray[n5] != d) {
                        if (dArray[0] > (double)nArray[n5]) {
                            dArray[0] = nArray[n5];
                        }
                        if (dArray[1] < (double)nArray[n5]) {
                            dArray[1] = nArray[n5];
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 'J': {
                long[] lArray = (long[])object;
                if (bl) {
                    d = ((long[])object2)[0];
                }
                int n6 = 0;
                while (n6 < n2) {
                    if (!bl || (double)lArray[n6] != d) {
                        if (dArray[0] > (double)lArray[n6]) {
                            dArray[0] = lArray[n6];
                        }
                        if (dArray[1] < (double)lArray[n6]) {
                            dArray[1] = lArray[n6];
                        }
                    }
                    ++n6;
                }
                break;
            }
            case 'F': {
                float[] fArray = (float[])object;
                if (bl) {
                    d = ((float[])object2)[0];
                }
                int n7 = 0;
                while (n7 < n2) {
                    if (!bl || (double)fArray[n7] != d) {
                        if (dArray[0] > (double)fArray[n7]) {
                            dArray[0] = fArray[n7];
                        }
                        if (dArray[1] < (double)fArray[n7]) {
                            dArray[1] = fArray[n7];
                        }
                    }
                    ++n7;
                }
                break;
            }
            case 'D': {
                double[] dArray2 = (double[])object;
                if (bl) {
                    d = ((double[])object2)[0];
                }
                int n8 = 0;
                while (n8 < n2) {
                    if (!bl || dArray2[n8] != d) {
                        if (dArray[0] > dArray2[n8]) {
                            dArray[0] = dArray2[n8];
                        }
                        if (dArray[1] < dArray2[n8]) {
                            dArray[1] = dArray2[n8];
                        }
                    }
                    ++n8;
                }
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    public static int computeStatistics(Object object, double[] dArray, Object object2) {
        int n = 1;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (object == null || dArray == null || Array.getLength(object) <= 0 || Array.getLength(dArray) < 2) {
            return -1;
        }
        int n3 = Array.getLength(object);
        boolean bl = object2 != null && object2.getClass().isArray();
        String string = object.getClass().getName();
        char c = string.charAt(string.lastIndexOf("[") + 1);
        n2 = 0;
        switch (c) {
            case 'B': {
                byte[] byArray = (byte[])object;
                if (bl) {
                    d5 = ((byte[])object2)[0];
                }
                int n4 = 0;
                while (n4 < n3) {
                    if (!bl || (double)byArray[n4] != d5) {
                        d += (double)byArray[n4];
                        ++n2;
                    }
                    ++n4;
                }
                d2 = d / (double)n2;
                n4 = 0;
                while (n4 < n3) {
                    if (!bl || (double)byArray[n4] != d5) {
                        d4 = (double)byArray[n4] - d2;
                        d3 += d4 * d4;
                    }
                    ++n4;
                }
                break;
            }
            case 'S': {
                short[] sArray = (short[])object;
                if (bl) {
                    d5 = ((short[])object2)[0];
                }
                int n5 = 0;
                while (n5 < n3) {
                    if (!bl || (double)sArray[n5] != d5) {
                        d += (double)sArray[n5];
                        ++n2;
                    }
                    ++n5;
                }
                d2 = d / (double)n2;
                n5 = 0;
                while (n5 < n3) {
                    if (!bl || (double)sArray[n5] != d5) {
                        d4 = (double)sArray[n5] - d2;
                        d3 += d4 * d4;
                    }
                    ++n5;
                }
                break;
            }
            case 'I': {
                int[] nArray = (int[])object;
                if (bl) {
                    d5 = ((int[])object2)[0];
                }
                int n6 = 0;
                while (n6 < n3) {
                    if (!bl || (double)nArray[n6] != d5) {
                        d += (double)nArray[n6];
                        ++n2;
                    }
                    ++n6;
                }
                d2 = d / (double)n2;
                n6 = 0;
                while (n6 < n3) {
                    if (!bl || (double)nArray[n6] != d5) {
                        d4 = (double)nArray[n6] - d2;
                        d3 += d4 * d4;
                    }
                    ++n6;
                }
                break;
            }
            case 'J': {
                long[] lArray = (long[])object;
                if (bl) {
                    d5 = ((long[])object2)[0];
                }
                int n7 = 0;
                while (n7 < n3) {
                    if (!bl || (double)lArray[n7] != d5) {
                        d += (double)lArray[n7];
                        ++n2;
                    }
                    ++n7;
                }
                d2 = d / (double)n2;
                n7 = 0;
                while (n7 < n3) {
                    if (!bl || (double)lArray[n7] != d5) {
                        d4 = (double)lArray[n7] - d2;
                        d3 += d4 * d4;
                    }
                    ++n7;
                }
                break;
            }
            case 'F': {
                float[] fArray = (float[])object;
                if (bl) {
                    d5 = ((float[])object2)[0];
                }
                int n8 = 0;
                while (n8 < n3) {
                    if (!bl || (double)fArray[n8] != d5) {
                        d += (double)fArray[n8];
                        ++n2;
                    }
                    ++n8;
                }
                d2 = d / (double)n2;
                n8 = 0;
                while (n8 < n3) {
                    if (!bl || (double)fArray[n8] != d5) {
                        d4 = (double)fArray[n8] - d2;
                        d3 += d4 * d4;
                    }
                    ++n8;
                }
                break;
            }
            case 'D': {
                double[] dArray2 = (double[])object;
                if (bl) {
                    d5 = ((double[])object2)[0];
                }
                int n9 = 0;
                while (n9 < n3) {
                    if (!bl || dArray2[n9] != d5) {
                        d += dArray2[n9];
                        ++n2;
                    }
                    ++n9;
                }
                d2 = d / (double)n2;
                n9 = 0;
                while (n9 < n3) {
                    if (!bl || dArray2[n9] != d5) {
                        d4 = dArray2[n9] - d2;
                        d3 += d4 * d4;
                    }
                    ++n9;
                }
                break;
            }
            default: {
                n = -1;
            }
        }
        dArray[0] = d2;
        dArray[1] = Math.sqrt(d3 / (double)(n2 - 1));
        return n;
    }

    public static final String toBinaryString(long l, int n) {
        if (n <= 0) {
            return null;
        }
        int n2 = n * 2;
        short[] sArray = new short[n2];
        int n3 = 0;
        while (n3 < n2) {
            sArray[n3] = (short)(0xFL & l >> n3 * 4);
            ++n3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            if (bl) {
                stringBuffer.append(" ");
            }
            bl = !bl;
            switch (sArray[n4]) {
                case 0: {
                    stringBuffer.append("0000");
                    break;
                }
                case 1: {
                    stringBuffer.append("0001");
                    break;
                }
                case 2: {
                    stringBuffer.append("0010");
                    break;
                }
                case 3: {
                    stringBuffer.append("0011");
                    break;
                }
                case 4: {
                    stringBuffer.append("0100");
                    break;
                }
                case 5: {
                    stringBuffer.append("0101");
                    break;
                }
                case 6: {
                    stringBuffer.append("0110");
                    break;
                }
                case 7: {
                    stringBuffer.append("0111");
                    break;
                }
                case 8: {
                    stringBuffer.append("1000");
                    break;
                }
                case 9: {
                    stringBuffer.append("1001");
                    break;
                }
                case 10: {
                    stringBuffer.append("1010");
                    break;
                }
                case 11: {
                    stringBuffer.append("1011");
                    break;
                }
                case 12: {
                    stringBuffer.append("1100");
                    break;
                }
                case 13: {
                    stringBuffer.append("1101");
                    break;
                }
                case 14: {
                    stringBuffer.append("1110");
                    break;
                }
                case 15: {
                    stringBuffer.append("1111");
                }
            }
            --n4;
        }
        return stringBuffer.toString();
    }

    public static final boolean applyBitmask(Object object, BitSet bitSet) {
        if (object == null || Array.getLength(object) <= 0 || bitSet == null) {
            return false;
        }
        int n = 48;
        String string = object.getClass().getName();
        int n2 = string.lastIndexOf("[");
        if (n2 >= 0) {
            n = string.charAt(n2 + 1);
        }
        if (n != 66 && n != 83) {
            return false;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = bitSet.length();
        int n7 = 0;
        while (n7 < n6) {
            if (bitSet.get(n7)) {
                n3 += 1 << n7;
            }
            ++n7;
        }
        if (n == 66) {
            byte[] byArray = (byte[])object;
            int n8 = 0;
            while (n8 < byArray.length) {
                n4 = byArray[n8] & n3;
                n5 = 0;
                int n9 = n6 - 1;
                while (n9 >= 0) {
                    if (bitSet.get(n9)) {
                        if (n5 & true) {
                            n5 <<= 1;
                        }
                        n5 += n4 >> n9 & 1;
                    }
                    --n9;
                }
                byArray[n8] = (byte)n5;
                ++n8;
            }
        } else {
            short[] sArray = (short[])object;
            int n10 = 0;
            while (n10 < sArray.length) {
                n4 = sArray[n10] & n3;
                n5 = 0;
                int n11 = n6 - 1;
                while (n11 >= 0) {
                    if (bitSet.get(n11)) {
                        if (n5 & true) {
                            n5 <<= 1;
                        }
                        n5 += n4 >> n11 & 1;
                    }
                    --n11;
                }
                sArray[n10] = (short)n5;
                ++n10;
            }
        }
        return true;
    }

    public static final void launchBrowser(String string) throws Exception {
        String string2 = System.getProperty("os.name");
        Runtime runtime = Runtime.getRuntime();
        if (string2.startsWith("Windows")) {
            String string3 = "rundll32 url.dll,FileProtocolHandler " + string;
            if (new File(string).exists()) {
                string3 = "cmd /c start \"\" \"" + string + "\"";
            }
            runtime.exec(string3);
        } else if (string2.startsWith("Mac OS")) {
            Class<?> clazz = Class.forName("com.apple.eio.FileManager");
            Method method = clazz.getDeclaredMethod("openURL", String.class);
            if (new File(string).exists()) {
                string = "file://" + string;
            }
            method.invoke(null, string);
        } else {
            String[] stringArray = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
            String string4 = null;
            int n = 0;
            while (n < stringArray.length && string4 == null) {
                if (runtime.exec(new String[]{"which", stringArray[n]}).waitFor() == 0) {
                    string4 = stringArray[n];
                }
                ++n;
            }
            if (string4 == null) {
                throw new Exception("Could not find web browser");
            }
            runtime.exec(new String[]{string4, string});
        }
    }
}

