/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.DataFormat;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.view.DataView;
import ncsa.hdf.view.ViewProperties;

public class NewTableDataDialog
extends JDialog
implements ActionListener,
ItemListener {
    public static final long serialVersionUID = 240L;
    private static final String[] DATATYPE_NAMES = new String[]{"byte (8-bit)", "short (16-bit)", "int (32-bit)", "unsigned byte (8-bit)", "unsigned short (16-bit)", "unsigned int (32-bit)", "long (64-bit)", "float", "double", "string", "enum"};
    private FileFormat fileformat;
    private JComboBox parentChoice;
    private JComboBox nFieldBox;
    private JComboBox templateChoice;
    private boolean isH5;
    private Vector groupList;
    private Vector compoundDSList;
    private HObject newObject = null;
    private final Toolkit toolkit;
    private final DataView dataView = null;
    private int numberOfMembers = 2;
    private JTable table;
    private DefaultTableModel tableModel;
    private RowEditorModel rowEditorModel;
    private DefaultCellEditor cellEditor;
    private JTextField nameField;
    private JTextField currentSizeField;
    private JTextField maxSizeField;
    private JTextField chunkSizeField;
    private JComboBox compressionLevel;
    private JComboBox rankChoice;
    private JComboBox memberTypeChoice;
    private JCheckBox checkCompression;
    private JRadioButton checkContinguous;
    private JRadioButton checkChunked;

    public NewTableDataDialog(JFrame jFrame, Group group, List list) {
        super(jFrame, "New Compound Dataset...", true);
        Serializable serializable;
        this.fileformat = group.getFileFormat();
        this.memberTypeChoice = new JComboBox<String>(DATATYPE_NAMES);
        this.cellEditor = new DefaultCellEditor(this.memberTypeChoice);
        this.rowEditorModel = new RowEditorModel(this.numberOfMembers, this.cellEditor);
        Object[] objectArray = new String[]{"Name", "Datatype", "Array size / String length / Enum names"};
        this.tableModel = new DefaultTableModel(objectArray, this.numberOfMembers);
        this.table = new JTable(this.tableModel){
            public static final long serialVersionUID = 240L;
            RowEditorModel rm;
            {
                this.rm = NewTableDataDialog.this.rowEditorModel;
            }

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                TableCellEditor tableCellEditor = this.rm.getEditor(n);
                if (tableCellEditor == null || n2 != 1) {
                    tableCellEditor = super.getCellEditor(n, n2);
                }
                return tableCellEditor;
            }
        };
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        int n = Math.max(16, this.table.getFontMetrics(this.table.getFont()).getHeight());
        this.table.setRowHeight(n);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.isH5 = group.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5"));
        this.parentChoice = new JComboBox();
        String[] stringArray = new String[100];
        int n2 = 0;
        while (n2 < 100) {
            stringArray[n2] = String.valueOf(n2 + 1);
            ++n2;
        }
        this.nFieldBox = new JComboBox<String>(stringArray);
        this.nFieldBox.setEditable(true);
        this.nFieldBox.addActionListener(this);
        this.nFieldBox.setActionCommand("Change number of members");
        this.nFieldBox.setSelectedItem(String.valueOf(this.numberOfMembers));
        this.groupList = new Vector(list.size());
        Object e = null;
        Iterator iterator = list.iterator();
        this.compoundDSList = new Vector(list.size());
        while (iterator.hasNext()) {
            e = iterator.next();
            if (e instanceof Group) {
                serializable = (Group)e;
                this.groupList.add(e);
                if (((Group)serializable).isRoot()) {
                    this.parentChoice.addItem("/");
                    continue;
                }
                this.parentChoice.addItem(String.valueOf(((HObject)serializable).getPath()) + ((HObject)serializable).getName() + "/");
                continue;
            }
            if (!(e instanceof CompoundDS)) continue;
            this.compoundDSList.add(e);
        }
        this.templateChoice = new JComboBox(this.compoundDSList);
        this.templateChoice.setSelectedIndex(-1);
        this.templateChoice.addItemListener(this);
        if (group.isRoot()) {
            this.parentChoice.setSelectedItem("/");
        } else {
            this.parentChoice.setSelectedItem(String.valueOf(group.getPath()) + group.getName() + "/");
        }
        serializable = (JPanel)this.getContentPane();
        ((Container)serializable).setLayout(new BorderLayout(5, 5));
        ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int n3 = 700 + (ViewProperties.getFontSize() - 12) * 15;
        int n4 = 500 + (ViewProperties.getFontSize() - 12) * 10;
        ((JComponent)serializable).setPreferredSize(new Dimension(n3, n4));
        JButton jButton = new JButton("   Ok   ");
        jButton.setActionCommand("Ok");
        jButton.setMnemonic(79);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setMnemonic(67);
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1));
        jPanel2.add(new JLabel("   Dataset name: "));
        jPanel2.add(new JLabel("   Parent group: "));
        jPanel2.add(new JLabel("Import template: "));
        jPanel.add((Component)jPanel2, "West");
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1));
        this.nameField = new JTextField();
        jPanel2.add(this.nameField);
        jPanel2.add(this.parentChoice);
        jPanel2.add(this.templateChoice);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 3, 15, 3));
        TitledBorder titledBorder = new TitledBorder("Dataspace");
        titledBorder.setTitleColor(Color.blue);
        jPanel3.setBorder(titledBorder);
        this.rankChoice = new JComboBox();
        int n5 = 1;
        while (n5 < 33) {
            this.rankChoice.addItem(String.valueOf(n5));
            ++n5;
        }
        this.rankChoice.setSelectedIndex(0);
        this.currentSizeField = new JTextField("1");
        this.maxSizeField = new JTextField("0");
        jPanel3.add(new JLabel("No. of dimensions"));
        jPanel3.add(new JLabel("Current size"));
        jPanel3.add(new JLabel("Max size (-1 for unlimited)"));
        jPanel3.add(this.rankChoice);
        jPanel3.add(this.currentSizeField);
        jPanel3.add(this.maxSizeField);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        titledBorder = new TitledBorder("Data Layout and Compression");
        titledBorder.setTitleColor(Color.BLUE);
        jPanel4.setBorder(titledBorder);
        this.checkContinguous = new JRadioButton("Contiguous");
        this.checkContinguous.setSelected(true);
        this.checkChunked = new JRadioButton("Chunked");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.checkChunked);
        buttonGroup.add(this.checkContinguous);
        this.chunkSizeField = new JTextField("1");
        this.chunkSizeField.setEnabled(false);
        this.checkCompression = new JCheckBox("gzip");
        this.compressionLevel = new JComboBox();
        int n6 = 0;
        while (n6 < 10) {
            this.compressionLevel.addItem(String.valueOf(n6));
            ++n6;
        }
        this.compressionLevel.setSelectedIndex(6);
        this.compressionLevel.setEnabled(false);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(new JLabel("Storage layout:  "));
        jPanel2.add(new JLabel("Compression:  "));
        jPanel4.add((Component)jPanel2, "West");
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 2));
        jPanel5.add(this.checkContinguous);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(1, 3));
        jPanel6.add(this.checkChunked);
        jPanel6.add(new JLabel("          Size: "));
        jPanel6.add(this.chunkSizeField);
        jPanel5.add(jPanel6);
        jPanel2.add(jPanel5);
        jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 7));
        jPanel5.add(this.checkCompression);
        jPanel5.add(new JLabel("      Level: "));
        jPanel5.add(this.compressionLevel);
        jPanel5.add(new JLabel(""));
        jPanel5.add(new JLabel(""));
        jPanel5.add(new JLabel(""));
        jPanel5.add(new JLabel(""));
        jPanel2.add(jPanel5);
        jPanel4.add((Component)jPanel2, "Center");
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)jPanel3, "Center");
        jPanel2.add((Component)jPanel4, "South");
        ((Container)serializable).add(jPanel2, "North");
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(5, 5));
        jPanel5.add((Component)new JLabel(" Number of Members:"), "West");
        jPanel5.add((Component)this.nFieldBox, "Center");
        jPanel2.add((Component)jPanel5, "North");
        JScrollPane jScrollPane = new JScrollPane(this.table);
        titledBorder = new TitledBorder("Compound Datatype Properties");
        titledBorder.setTitleColor(Color.BLUE);
        jPanel2.setBorder(titledBorder);
        jPanel2.add((Component)jScrollPane, "Center");
        ((Container)serializable).add(jPanel2, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.add(jButton);
        jPanel7.add(jButton2);
        ((Container)serializable).add(jPanel7, "South");
        this.rankChoice.addItemListener(this);
        this.checkCompression.addItemListener(this);
        this.checkContinguous.addItemListener(this);
        this.checkChunked.addItemListener(this);
        this.memberTypeChoice.addItemListener(this);
        Point point = jFrame.getLocation();
        point.x += 250;
        point.y += 120;
        this.setLocation(point);
        this.validate();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Ok")) {
            try {
                this.newObject = this.createCompoundDS();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            }
            if (this.newObject != null) {
                this.dispose();
            }
        } else if (string.equals("Cancel")) {
            this.newObject = null;
            this.dispose();
            this.groupList.setSize(0);
        } else if (string.equals("Change number of members")) {
            int n = 0;
            try {
                n = Integer.valueOf((String)this.nFieldBox.getSelectedItem());
            }
            catch (Exception exception) {}
            if (n == this.numberOfMembers) {
                return;
            }
            this.tableModel.setRowCount(n);
            int n2 = this.numberOfMembers;
            while (n2 < n) {
                this.rowEditorModel.addEditorForRow(n2, this.cellEditor);
                ++n2;
            }
            this.numberOfMembers = n;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.rankChoice)) {
            int n = this.rankChoice.getSelectedIndex() + 1;
            String string = "1";
            String string2 = "0";
            int n2 = 1;
            while (n2 < n) {
                string = String.valueOf(string) + " x 1";
                string2 = String.valueOf(string2) + " x 0";
                ++n2;
            }
            this.currentSizeField.setText(string);
            this.maxSizeField.setText(string2);
            String string3 = this.currentSizeField.getText();
            int n3 = string3.lastIndexOf("x");
            String string4 = "1";
            if (n <= 1) {
                string4 = string3;
            } else {
                int n4 = 1;
                while (n4 < n - 1) {
                    string4 = String.valueOf(string4) + " x 1";
                    ++n4;
                }
                if (n3 > 0) {
                    string4 = String.valueOf(string4) + " x " + string3.substring(n3 + 1);
                }
            }
            this.chunkSizeField.setText(string4);
        } else if (object.equals(this.checkContinguous)) {
            this.chunkSizeField.setEnabled(false);
        } else if (object.equals(this.checkChunked)) {
            this.chunkSizeField.setEnabled(true);
            String string = this.currentSizeField.getText();
            int n = string.lastIndexOf("x");
            String string5 = "1";
            int n5 = this.rankChoice.getSelectedIndex() + 1;
            if (n5 <= 1) {
                string5 = string;
            } else {
                int n6 = 1;
                while (n6 < n5 - 1) {
                    string5 = String.valueOf(string5) + " x 1";
                    ++n6;
                }
                if (n > 0) {
                    string5 = String.valueOf(string5) + " x " + string.substring(n + 1);
                }
            }
            this.chunkSizeField.setText(string5);
        } else if (object.equals(this.checkCompression)) {
            boolean bl = this.checkCompression.isSelected();
            if (bl) {
                if (!this.checkChunked.isSelected()) {
                    String string = this.currentSizeField.getText();
                    int n = string.lastIndexOf("x");
                    String string6 = "1";
                    int n7 = this.rankChoice.getSelectedIndex() + 1;
                    if (n7 <= 1) {
                        string6 = string;
                    } else {
                        int n8 = 1;
                        while (n8 < n7 - 1) {
                            string6 = String.valueOf(string6) + " x 1";
                            ++n8;
                        }
                        if (n > 0) {
                            string6 = String.valueOf(string6) + " x " + string.substring(n + 1);
                        }
                    }
                    this.chunkSizeField.setText(string6);
                }
                this.compressionLevel.setEnabled(true);
                this.checkContinguous.setEnabled(false);
                this.checkChunked.setSelected(true);
                this.chunkSizeField.setEnabled(true);
            } else {
                this.compressionLevel.setEnabled(false);
                this.checkContinguous.setEnabled(true);
            }
        } else if (object.equals(this.memberTypeChoice)) {
            String string = (String)this.memberTypeChoice.getSelectedItem();
            if (string == null || !string.equals("enum")) {
                return;
            }
            int n = this.table.getSelectedRow();
            this.table.setValueAt("mb1=0,mb=1,...", n, 2);
        } else if (object.equals(this.templateChoice)) {
            int n;
            int n9;
            String string;
            Object object2 = this.templateChoice.getSelectedItem();
            if (!(object2 instanceof CompoundDS)) {
                return;
            }
            CompoundDS compoundDS = (CompoundDS)object2;
            int n10 = compoundDS.getRank();
            if (n10 < 1) {
                compoundDS.init();
            }
            n10 = compoundDS.getRank();
            this.rankChoice.setSelectedIndex(n10 - 1);
            long[] lArray = compoundDS.getDims();
            String[] stringArray = compoundDS.getMemberNames();
            int[] nArray = compoundDS.getMemberOrders();
            Datatype[] datatypeArray = compoundDS.getMemberTypes();
            String string7 = String.valueOf(lArray[0]);
            int n11 = 1;
            while (n11 < n10) {
                string7 = String.valueOf(string7) + "x" + lArray[n11];
                ++n11;
            }
            this.currentSizeField.setText(string7);
            try {
                compoundDS.getMetadata();
            }
            catch (Exception exception) {}
            long[] lArray2 = compoundDS.getChunkSize();
            if (lArray2 != null) {
                this.checkChunked.setSelected(true);
                string7 = String.valueOf(lArray2[0]);
                int n12 = 1;
                while (n12 < n10) {
                    string7 = String.valueOf(string7) + "x" + lArray2[n12];
                    ++n12;
                }
                this.chunkSizeField.setText(string7);
            }
            if ((string = compoundDS.getCompression()) != null) {
                n9 = string.indexOf("GZIP: level = ");
                n = -1;
                try {
                    n = Integer.parseInt(string.substring(n9 + 14, n9 + 15));
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                if (n > 0) {
                    this.checkCompression.setSelected(true);
                    this.compressionLevel.setSelectedIndex(n);
                }
            }
            this.numberOfMembers = compoundDS.getMemberCount();
            this.nFieldBox.setSelectedIndex(this.numberOfMembers - 1);
            this.tableModel.setRowCount(this.numberOfMembers);
            n9 = 0;
            while (n9 < this.numberOfMembers) {
                this.rowEditorModel.addEditorForRow(n9, this.cellEditor);
                this.tableModel.setValueAt(stringArray[n9], n9, 0);
                n = -1;
                int n13 = datatypeArray[n9].getDatatypeClass();
                int n14 = datatypeArray[n9].getDatatypeSize();
                if (n13 == 0) {
                    int n15 = datatypeArray[n9].getDatatypeSign();
                    if (n15 == 0) {
                        if (n14 == 1) {
                            n = 3;
                        } else if (n14 == 2) {
                            n = 4;
                        } else if (n14 == 4) {
                            n = 5;
                        }
                    } else {
                        n = n14 == 1 ? 0 : (n14 == 2 ? 1 : (n14 == 4 ? 2 : 6));
                    }
                } else if (n13 == 1) {
                    n = n14 == 4 ? 7 : 8;
                } else if (n13 == 3) {
                    n = 9;
                } else if (n13 == 8) {
                    n = 10;
                }
                if (n >= 0) {
                    this.memberTypeChoice.setSelectedIndex(n);
                    this.tableModel.setValueAt(this.memberTypeChoice.getSelectedItem(), n9, 1);
                    if (n13 == 3) {
                        this.tableModel.setValueAt(String.valueOf(n14), n9, 2);
                    } else if (n13 == 8) {
                        this.tableModel.setValueAt(datatypeArray[n9].getEnumMembers(), n9, 2);
                    } else {
                        this.tableModel.setValueAt(String.valueOf(nArray[n9]), n9, 2);
                    }
                }
                ++n9;
            }
        }
    }

    private HObject createCompoundDS() throws Exception {
        String string;
        long[] lArray;
        Object object;
        Dataset dataset = null;
        int n = this.table.getSelectedRow();
        int n2 = this.table.getSelectedColumn();
        if (n >= 0 && n2 > 0 && (object = this.table.getCellEditor(n, n2)) != null) {
            object.stopCellEditing();
        }
        long[] lArray2 = lArray = (long[])null;
        object = this.nameField.getText();
        if (object == null || ((String)object).length() <= 0) {
            throw new IllegalArgumentException("Dataset name is empty");
        }
        Group group = (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
        if (group == null) {
            throw new IllegalArgumentException("Invalid parent group");
        }
        int n3 = this.table.getRowCount();
        if (n3 <= 0) {
            return null;
        }
        String[] stringArray = new String[n3];
        Datatype[] datatypeArray = new Datatype[n3];
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            String string2 = (String)this.table.getValueAt(n4, 0);
            if (string2 == null || string2.length() <= 0) {
                throw new IllegalArgumentException("Member name is empty");
            }
            stringArray[n4] = string2;
            int n5 = 1;
            string = (String)this.table.getValueAt(n4, 2);
            if (string != null) {
                try {
                    n5 = Integer.parseInt(string);
                }
                catch (Exception exception) {}
            }
            nArray[n4] = n5;
            String string3 = (String)this.table.getValueAt(n4, 1);
            Datatype datatype = null;
            if (DATATYPE_NAMES[0].equals(string3)) {
                datatype = this.fileformat.createDatatype(0, 1, -1, -1);
            } else if (DATATYPE_NAMES[1].equals(string3)) {
                datatype = this.fileformat.createDatatype(0, 2, -1, -1);
            } else if (DATATYPE_NAMES[2].equals(string3)) {
                datatype = this.fileformat.createDatatype(0, 4, -1, -1);
            } else if (DATATYPE_NAMES[3].equals(string3)) {
                datatype = this.fileformat.createDatatype(0, 1, -1, 0);
            } else if (DATATYPE_NAMES[4].equals(string3)) {
                datatype = this.fileformat.createDatatype(0, 2, -1, 0);
            } else if (DATATYPE_NAMES[5].equals(string3)) {
                datatype = this.fileformat.createDatatype(0, 4, -1, 0);
            } else if (DATATYPE_NAMES[6].equals(string3)) {
                datatype = this.fileformat.createDatatype(0, 8, -1, -1);
            } else if (DATATYPE_NAMES[7].equals(string3)) {
                datatype = this.fileformat.createDatatype(1, 4, -1, -1);
            } else if (DATATYPE_NAMES[8].equals(string3)) {
                datatype = this.fileformat.createDatatype(1, 8, -1, -1);
            } else if (DATATYPE_NAMES[9].equals(string3)) {
                datatype = this.fileformat.createDatatype(3, n5, -1, -1);
            } else if (DATATYPE_NAMES[10].equals(string3)) {
                datatype = this.fileformat.createDatatype(8, 4, -1, -1);
                if (string == null || string.length() < 1 || string.endsWith("...")) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Invalid member values: " + string, this.getTitle(), 0);
                    return null;
                }
                datatype.setEnumMembers(string);
            } else {
                throw new IllegalArgumentException("Invalid data type.");
            }
            datatypeArray[n4] = datatype;
            ++n4;
        }
        int n6 = this.rankChoice.getSelectedIndex() + 1;
        StringTokenizer stringTokenizer = new StringTokenizer(this.currentSizeField.getText(), "x");
        if (stringTokenizer.countTokens() < n6) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Number of values in the current dimension size is less than " + n6, this.getTitle(), 0);
            return null;
        }
        long l = 0L;
        long[] lArray3 = new long[n6];
        string = null;
        int n7 = 0;
        while (n7 < n6) {
            string = stringTokenizer.nextToken().trim();
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Invalid dimension size: " + this.currentSizeField.getText(), this.getTitle(), 0);
                return null;
            }
            if (l <= 0L) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Dimension size must be greater than zero.", this.getTitle(), 0);
                return null;
            }
            lArray3[n7] = l;
            ++n7;
        }
        stringTokenizer = new StringTokenizer(this.maxSizeField.getText(), "x");
        if (stringTokenizer.countTokens() < n6) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Number of values in the max dimension size is less than " + n6, this.getTitle(), 0);
            return null;
        }
        l = 0L;
        lArray2 = new long[n6];
        n7 = 0;
        while (n7 < n6) {
            string = stringTokenizer.nextToken().trim();
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Invalid max dimension size: " + this.maxSizeField.getText(), this.getTitle(), 0);
                return null;
            }
            if (l < -1L) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Dimension size cannot be less than -1.", this.getTitle(), 0);
                return null;
            }
            if (l == 0L) {
                l = lArray3[n7];
            }
            lArray2[n7] = l;
            ++n7;
        }
        lArray = null;
        if (this.checkChunked.isSelected()) {
            stringTokenizer = new StringTokenizer(this.chunkSizeField.getText(), "x");
            if (stringTokenizer.countTokens() < n6) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Number of values in the chunk size is less than " + n6, this.getTitle(), 0);
                return null;
            }
            l = 0L;
            lArray = new long[n6];
            string = null;
            n7 = 0;
            while (n7 < n6) {
                string = stringTokenizer.nextToken().trim();
                try {
                    l = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Invalid chunk dimension size: " + this.chunkSizeField.getText(), this.getTitle(), 0);
                    return null;
                }
                if (l < 1L) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Chunk size cannot be less than 1.", this.getTitle(), 0);
                    return null;
                }
                lArray[n7] = l;
                ++n7;
            }
            long l2 = 1L;
            long l3 = 1L;
            int n8 = 0;
            while (n8 < n6) {
                l2 *= lArray[n8];
                l3 *= lArray3[n8];
                ++n8;
            }
            if (l2 >= l3) {
                this.toolkit.beep();
                n8 = JOptionPane.showConfirmDialog(this, "Chunk size is equal/greater than the current size. \nAre you sure you want to set chunk size to " + this.chunkSizeField.getText() + "?", this.getTitle(), 0);
                if (n8 == 1) {
                    return null;
                }
            }
            if (l2 == 1L) {
                this.toolkit.beep();
                n8 = JOptionPane.showConfirmDialog(this, "Chunk size is one, which may cause large memory overhead for large dataset.\nAre you sure you want to set chunk size to " + this.chunkSizeField.getText() + "?", this.getTitle(), 0);
                if (n8 == 1) {
                    return null;
                }
            }
        }
        int n9 = 0;
        if (this.checkCompression.isSelected()) {
            n9 = this.compressionLevel.getSelectedIndex();
        }
        dataset = this.checkChunked.isSelected() ? this.fileformat.createCompoundDS((String)object, group, lArray3, lArray2, lArray, n9, stringArray, datatypeArray, nArray, null) : this.fileformat.createCompoundDS((String)object, group, lArray3, lArray2, null, -1, stringArray, datatypeArray, nArray, null);
        return dataset;
    }

    public DataFormat getObject() {
        return this.newObject;
    }

    public Group getParentGroup() {
        return (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
    }

    private class RowEditorModel {
        private Hashtable data = new Hashtable();

        public RowEditorModel() {
        }

        public RowEditorModel(int n, TableCellEditor tableCellEditor) {
            int n2 = 0;
            while (n2 < n) {
                this.data.put(new Integer(n2), tableCellEditor);
                ++n2;
            }
        }

        public void addEditorForRow(int n, TableCellEditor tableCellEditor) {
            this.data.put(new Integer(n), tableCellEditor);
        }

        public void removeEditorForRow(int n) {
            this.data.remove(new Integer(n));
        }

        public TableCellEditor getEditor(int n) {
            return (TableCellEditor)this.data.get(new Integer(n));
        }
    }
}

