/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ncsa.hdf.object.DataFormat;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.view.ViewProperties;

public class NewImageDialog
extends JDialog
implements ActionListener,
ItemListener {
    public static final long serialVersionUID = 240L;
    private JTextField nameField;
    private JTextField widthField;
    private JTextField heightField;
    private JComboBox parentChoice;
    private JRadioButton checkIndex;
    private JRadioButton checkTrueColor;
    private JRadioButton checkInterlacePixel;
    private JRadioButton checkInterlacePlane;
    private List groupList;
    private boolean isH5;
    private HObject newObject = null;
    private FileFormat fileFormat;
    private final Toolkit toolkit;

    public NewImageDialog(Frame frame, Group group, List list) {
        super(frame, "New HDF Image...", true);
        Serializable serializable;
        this.isH5 = group.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5"));
        this.fileFormat = group.getFileFormat();
        this.toolkit = Toolkit.getDefaultToolkit();
        this.parentChoice = new JComboBox();
        this.groupList = new Vector();
        Object e2 = null;
        for (Object e2 : list) {
            if (!(e2 instanceof Group)) continue;
            this.groupList.add(e2);
            serializable = (Group)e2;
            if (((Group)serializable).isRoot()) {
                this.parentChoice.addItem("/");
                continue;
            }
            this.parentChoice.addItem(String.valueOf(((HObject)serializable).getPath()) + ((HObject)serializable).getName() + "/");
        }
        if (group.isRoot()) {
            this.parentChoice.setSelectedItem("/");
        } else {
            this.parentChoice.setSelectedItem(String.valueOf(group.getPath()) + group.getName() + "/");
        }
        serializable = (JPanel)this.getContentPane();
        ((Container)serializable).setLayout(new BorderLayout(5, 5));
        ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        int n = 400 + (ViewProperties.getFontSize() - 12) * 15;
        int n2 = 250 + (ViewProperties.getFontSize() - 12) * 10;
        ((JComponent)serializable).setPreferredSize(new Dimension(n, n2));
        JButton jButton = new JButton("   Ok   ");
        jButton.setActionCommand("Ok");
        jButton.setMnemonic(79);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setMnemonic(67);
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        ((Container)serializable).add(jPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(6, 1, 5, 5));
        jPanel3.add(new JLabel("Image name: "));
        jPanel3.add(new JLabel("Parent group: "));
        jPanel3.add(new JLabel("Height: "));
        jPanel3.add(new JLabel("Width: "));
        jPanel3.add(new JLabel("Image type: "));
        jPanel3.add(new JLabel("Data layout: "));
        jPanel2.add((Component)jPanel3, "West");
        jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(6, 1, 5, 5));
        this.nameField = new JTextField();
        jPanel3.add(this.nameField);
        jPanel3.add(this.parentChoice);
        this.heightField = new JTextField();
        jPanel3.add(this.heightField);
        this.widthField = new JTextField();
        jPanel3.add(this.widthField);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 2));
        this.checkIndex = new JRadioButton("Indexed colormap", true);
        jPanel4.add(this.checkIndex);
        this.checkTrueColor = new JRadioButton("24-bit truecolor");
        jPanel4.add(this.checkTrueColor);
        jPanel4.setBorder(new TitledBorder(""));
        jPanel3.add(jPanel4);
        jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 2));
        this.checkInterlacePixel = new JRadioButton("Pixel interlace");
        jPanel4.add(this.checkInterlacePixel);
        this.checkInterlacePlane = new JRadioButton("Plane interlace");
        jPanel4.add(this.checkInterlacePlane);
        jPanel4.setBorder(new TitledBorder(""));
        jPanel3.add(jPanel4);
        jPanel2.add((Component)jPanel3, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.checkInterlacePixel);
        buttonGroup.add(this.checkInterlacePlane);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.checkTrueColor);
        buttonGroup.add(this.checkIndex);
        this.checkIndex.addItemListener(this);
        this.checkTrueColor.addItemListener(this);
        this.checkInterlacePixel.setSelected(true);
        this.checkInterlacePixel.setEnabled(false);
        this.checkInterlacePlane.setEnabled(false);
        jPanel2.setBorder(new TitledBorder(""));
        ((Container)serializable).add(jPanel2, "Center");
        Point point = frame.getLocation();
        point.x += 250;
        point.y += 80;
        this.setLocation(point);
        this.validate();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Ok")) {
            this.newObject = this.createHDFimage();
            if (this.newObject != null) {
                this.dispose();
            }
        }
        if (string.equals("Cancel")) {
            this.newObject = null;
            this.dispose();
            ((Vector)this.groupList).setSize(0);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.checkIndex)) {
            this.checkInterlacePixel.setSelected(true);
            this.checkInterlacePixel.setEnabled(false);
            this.checkInterlacePlane.setEnabled(false);
        } else if (object.equals(this.checkTrueColor)) {
            this.checkInterlacePixel.setEnabled(true);
            this.checkInterlacePlane.setEnabled(true);
        }
    }

    private Dataset createHDFimage() {
        Object object;
        Dataset dataset = null;
        String string = this.nameField.getText();
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.length() <= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name is not specified.", this.getTitle(), 0);
            return null;
        }
        if (string.indexOf("/") >= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name cannot contain path.", this.getTitle(), 0);
            return null;
        }
        Group group = (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
        if (group == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Select a parent group.", this.getTitle(), 0);
            return null;
        }
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(this.widthField.getText());
            n2 = Integer.parseInt(this.heightField.getText());
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception.getMessage(), this.getTitle(), 0);
            return null;
        }
        long[] lArray = null;
        int n3 = 2;
        int n4 = 0;
        int n5 = 1;
        int n6 = -1;
        int n7 = 0;
        int n8 = 2;
        if (this.checkIndex.isSelected()) {
            if (this.isH5) {
                object = new long[]{n2, n};
                lArray = object;
            } else {
                object = new long[]{n, n2};
                lArray = object;
            }
        } else if (this.isH5) {
            if (this.checkInterlacePixel.isSelected()) {
                object = new long[]{n2, n, 3L};
                lArray = object;
            } else {
                n7 = 2;
                object = new long[]{3L, n2, n};
                lArray = object;
            }
        } else {
            n8 = 3;
            object = new long[]{n, n2};
            lArray = object;
            if (this.checkInterlacePlane.isSelected()) {
                n7 = 2;
            }
        }
        try {
            object = this.fileFormat.createDatatype(n3, n5, n6, n4);
            dataset = this.fileFormat.createImage(string, group, (Datatype)object, lArray, lArray, null, -1, n8, n7, null);
            dataset.init();
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception.getMessage(), this.getTitle(), 0);
            return null;
        }
        return dataset;
    }

    public DataFormat getObject() {
        return this.newObject;
    }

    public Group getParentGroup() {
        return (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
    }
}

