/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import ncsa.hdf.object.DataFormat;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.view.ViewProperties;

public class NewGroupDialog
extends JDialog
implements ActionListener,
ItemListener,
KeyListener {
    public static final long serialVersionUID = 240L;
    private JTextField nameField;
    private JTextField compactField;
    private JTextField indexedField;
    private JComboBox parentChoice;
    private JCheckBox useCreationOrder;
    private JCheckBox setLinkStorage;
    private JComboBox orderFlags;
    private List<Group> groupList;
    private HObject newObject = null;
    private FileFormat fileFormat;
    private final Toolkit toolkit;
    private int creationOrder;
    private JPanel useCreationOrderJPanel;
    private JPanel setLinkStorageJPanel;
    private JButton moreButton;
    private JPanel labelPanel;
    private JPanel textPanel;
    private JPanel contentPane;
    private JButton creationOrderHelpButton;
    private JButton storageTypeHelpButton;
    private boolean isH5;

    public NewGroupDialog(Frame frame, Group group, List<?> list) {
        super(frame, "New Group...", true);
        this.fileFormat = group.getFileFormat();
        this.isH5 = group.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5"));
        this.toolkit = Toolkit.getDefaultToolkit();
        this.parentChoice = new JComboBox();
        this.groupList = new Vector<Group>();
        Object var4_42 = null;
        for (Object var4_42 : list) {
            if (!(var4_42 instanceof Group)) continue;
            this.groupList.add(var4_42);
            Group group2 = var4_42;
            if (group2.isRoot()) {
                this.parentChoice.addItem("/");
                continue;
            }
            this.parentChoice.addItem(String.valueOf(group2.getPath()) + group2.getName() + "/");
        }
        if (group.isRoot()) {
            this.parentChoice.setSelectedItem("/");
        } else {
            this.parentChoice.setSelectedItem(String.valueOf(group.getPath()) + group.getName() + "/");
        }
        this.orderFlags = new JComboBox();
        this.orderFlags.addItem("Tracked");
        this.orderFlags.addItem("Tracked+Indexed");
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout(5, 5));
        this.contentPane.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int n = 400 + (ViewProperties.getFontSize() - 12) * 15;
        int n2 = 150 + (ViewProperties.getFontSize() - 12) * 10;
        this.contentPane.setPreferredSize(new Dimension(n, n2));
        JButton jButton = new JButton("   Ok   ");
        jButton.setActionCommand("Ok");
        jButton.setMnemonic(79);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setMnemonic(67);
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(this);
        this.moreButton = new JButton("More");
        this.moreButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.contentPane.add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        this.labelPanel = new JPanel();
        this.textPanel = new JPanel();
        if (!this.isH5) {
            this.labelPanel.setLayout(new GridLayout(2, 1));
            this.labelPanel.add(new JLabel("Group name: "));
            this.labelPanel.add(new JLabel("Parent group: "));
            this.textPanel.setLayout(new GridLayout(2, 1));
            this.nameField = new JTextField();
            this.textPanel.add(this.nameField);
            this.textPanel.add(this.parentChoice);
        } else {
            this.labelPanel.setLayout(new GridLayout(3, 1));
            this.labelPanel.add(new JLabel("Group name: "));
            this.labelPanel.add(new JLabel("Parent group: "));
            this.labelPanel.add(this.moreButton);
            this.textPanel.setLayout(new GridLayout(3, 1));
            this.nameField = new JTextField();
            this.textPanel.add(this.nameField);
            this.textPanel.add(this.parentChoice);
            this.textPanel.add(new JLabel(""));
        }
        this.creationOrderHelpButton = new JButton(ViewProperties.getHelpIcon());
        this.creationOrderHelpButton.setToolTipText("Help on Creation Order");
        this.creationOrderHelpButton.setMargin(new Insets(0, 0, 0, 0));
        this.creationOrderHelpButton.addActionListener(this);
        this.creationOrderHelpButton.setActionCommand("Help on Creation Order");
        this.storageTypeHelpButton = new JButton(ViewProperties.getHelpIcon());
        this.storageTypeHelpButton.setToolTipText("Help on set Link Storage");
        this.storageTypeHelpButton.setMargin(new Insets(0, 0, 0, 0));
        this.storageTypeHelpButton.addActionListener(this);
        this.storageTypeHelpButton.setActionCommand("Help on set Link Storage");
        jPanel2.add((Component)this.labelPanel, "West");
        this.useCreationOrderJPanel = new JPanel();
        this.useCreationOrderJPanel.setLayout(new GridLayout(1, 2));
        this.useCreationOrderJPanel.setBorder(new TitledBorder(""));
        this.useCreationOrder = new JCheckBox("Use Creation Order");
        this.useCreationOrderJPanel.add(this.useCreationOrder);
        this.useCreationOrder.addItemListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2));
        jPanel3.add(new JLabel("Order Flags: "));
        jPanel3.add(this.orderFlags);
        this.orderFlags.setEnabled(false);
        this.useCreationOrderJPanel.add(jPanel3);
        this.setLinkStorageJPanel = new JPanel();
        this.setLinkStorageJPanel.setLayout(new GridLayout(1, 2));
        this.setLinkStorageJPanel.setBorder(new TitledBorder(""));
        this.setLinkStorage = new JCheckBox("Set Link Storage");
        this.setLinkStorageJPanel.add(this.setLinkStorage);
        this.setLinkStorage.addItemListener(this);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 2));
        jPanel4.add(new JLabel("Min Indexed: "));
        jPanel4.add(new JLabel("Max Compact: "));
        this.indexedField = new JTextField();
        this.indexedField.addKeyListener(this);
        jPanel4.add(this.indexedField);
        this.indexedField.setDocument(new JTextFieldLimit(5));
        this.indexedField.setText("6");
        this.indexedField.setEnabled(false);
        this.compactField = new JTextField();
        jPanel4.add(this.compactField);
        this.compactField.addKeyListener(this);
        this.compactField.setDocument(new JTextFieldLimit(5));
        this.compactField.setText("8");
        this.compactField.setEnabled(false);
        this.setLinkStorageJPanel.add(jPanel4);
        jPanel2.add((Component)this.textPanel, "Center");
        this.contentPane.add((Component)jPanel2, "Center");
        Point point = frame.getLocation();
        point.x += 250;
        point.y += 80;
        this.setLocation(point);
        this.validate();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2;
        String string = actionEvent.getActionCommand();
        if (string.equals("More")) {
            this.moreButton.setText("Less");
            n2 = 500 + (ViewProperties.getFontSize() - 12) * 15;
            n = 280 + (ViewProperties.getFontSize() - 12) * 10;
            this.contentPane.setPreferredSize(new Dimension(n2, n));
            this.labelPanel.setLayout(new GridLayout(5, 1));
            this.labelPanel.add(this.creationOrderHelpButton);
            this.labelPanel.add(this.storageTypeHelpButton);
            this.textPanel.setLayout(new GridLayout(5, 1));
            this.textPanel.add(this.useCreationOrderJPanel);
            this.textPanel.add(this.setLinkStorageJPanel);
            this.validate();
            this.pack();
        }
        if (string.equals("Less")) {
            this.moreButton.setText("More");
            n2 = 400 + (ViewProperties.getFontSize() - 12) * 15;
            n = 150 + (ViewProperties.getFontSize() - 12) * 10;
            this.contentPane.setPreferredSize(new Dimension(n2, n));
            this.labelPanel.setLayout(new GridLayout(3, 1));
            this.labelPanel.remove(this.creationOrderHelpButton);
            this.labelPanel.remove(this.storageTypeHelpButton);
            this.textPanel.setLayout(new GridLayout(3, 1));
            this.textPanel.remove(this.useCreationOrderJPanel);
            this.textPanel.remove(this.setLinkStorageJPanel);
            this.useCreationOrder.setSelected(false);
            this.setLinkStorage.setSelected(false);
            this.validate();
            this.pack();
        }
        if (string.equals("Help on Creation Order")) {
            JOptionPane.showMessageDialog(this, "Use Creation Order allows the user to set the creation order \nof links in a group, so that tracking, indexing, and iterating over links\nin groups can be possible. \n\nIf the order flag Tracked is selected, links in a group can now \nbe explicitly tracked by the order that they were created. \n\nIf the order flag Tracked+Indexed is selected, links in a group can \nnow be explicitly tracked and indexed in the order that they were created. \n\nThe default order in which links in a group are listed is alphanumeric-by-name. \n\n\n");
        }
        if (string.equals("Help on set Link Storage")) {
            JOptionPane.showMessageDialog(this, "Set Link Storage allows the users to explicitly set the storage  \ntype of a group to be Compact or Indexed. \n\nCompact Storage: For groups with only a few links, compact link storage\nallows groups containing only a few links to take up much less space \nin the file. \n\nIndexed Storage: For groups with large number of links, indexed link storage  \nprovides a faster and more scalable method for storing and working with  \nlarge groups containing many links. \n\nThe threshold for switching between the compact and indexed storage   \nformats is either set to default values or can be set by the user. \n\n<html><b>Max Compact</b></html> \nMax Compact is the maximum number of links to store in the group in a  \ncompact format, before converting the group to the Indexed format. Groups \nthat are in compact format and in which the number of links rises above \n this threshold are automatically converted to indexed format. \n\n<html><b>Min Indexed</b></html> \nMin Indexed is the minimum number of links to store in the Indexed format.   \nGroups which are in indexed format and in which the number of links falls    \nbelow this threshold are automatically converted to compact format. \n\n\n");
        }
        if (string.equals("Ok")) {
            this.newObject = this.create();
            if (this.newObject != null) {
                this.dispose();
            }
        }
        if (string.equals("Cancel")) {
            this.newObject = null;
            this.dispose();
        }
    }

    private HObject create() {
        String string = null;
        Group group = null;
        int n = 0;
        string = this.nameField.getText();
        if (string == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Group name is not specified.", this.getTitle(), 0);
            return null;
        }
        if (string.indexOf("/") >= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Group name cannot contain path.", this.getTitle(), 0);
            return null;
        }
        group = this.groupList.get(this.parentChoice.getSelectedIndex());
        if (group == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Parent group is null.", this.getTitle(), 0);
            return null;
        }
        Group group2 = null;
        if (this.orderFlags.isEnabled()) {
            String string2 = (String)this.orderFlags.getSelectedItem();
            if (string2.equals("Tracked")) {
                this.creationOrder = 1;
            } else if (string2.equals("Tracked+Indexed")) {
                this.creationOrder = 2;
            }
        } else {
            this.creationOrder = 0;
        }
        if (this.orderFlags.isEnabled() || this.setLinkStorage.isSelected()) {
            int n2 = Integer.parseInt(this.compactField.getText());
            int n3 = Integer.parseInt(this.indexedField.getText());
            if (n2 <= 0 || n2 > 65536 || n3 > 65536) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Max Compact and Min Indexed should be > 0 and < 65536.", this.getTitle(), 0);
                return null;
            }
            if (n2 < n3) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Min Indexed should be <= Max Compact", this.getTitle(), 0);
                return null;
            }
            try {
                n = this.fileFormat.createGcpl(this.creationOrder, n2, n3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            group2 = this.isH5 ? this.fileFormat.createGroup(string, group, 0, n) : this.fileFormat.createGroup(string, group);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception.getMessage(), this.getTitle(), 0);
            return null;
        }
        return group2;
    }

    public DataFormat getObject() {
        return this.newObject;
    }

    public Group getParentGroup() {
        return this.groupList.get(this.parentChoice.getSelectedIndex());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getSource();
        if (object.equals(this.useCreationOrder)) {
            bl = this.useCreationOrder.isSelected();
            if (bl) {
                this.orderFlags.setEnabled(true);
            } else {
                this.orderFlags.setEnabled(false);
            }
        }
        if (object.equals(this.setLinkStorage)) {
            bl = this.setLinkStorage.isSelected();
            if (bl) {
                this.compactField.setEnabled(true);
                this.indexedField.setEnabled(true);
            } else {
                this.compactField.setText("8");
                this.compactField.setEnabled(false);
                this.indexedField.setText("6");
                this.indexedField.setEnabled(false);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!Character.isDigit(c)) {
            keyEvent.consume();
        }
    }

    class JTextFieldLimit
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private int limit;

        JTextFieldLimit(int n) {
            this.limit = n;
        }

        JTextFieldLimit(int n, boolean bl) {
            this.limit = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            if (this.getLength() + string.length() <= this.limit) {
                super.insertString(n, string, attributeSet);
            }
        }
    }
}

