/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.DataView;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.DefaultTreeView;
import ncsa.hdf.view.FileConversionDialog;
import ncsa.hdf.view.HelpView;
import ncsa.hdf.view.NewFileDialog;
import ncsa.hdf.view.TableView;
import ncsa.hdf.view.TextView;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.TreeView;
import ncsa.hdf.view.UserOptionsDialog;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class HDFView
extends JFrame
implements ViewManager,
ActionListener,
ChangeListener,
DropTargetListener {
    public static final long serialVersionUID = 240L;
    private static List<String> treeViews;
    private static List<String> imageViews;
    private static List tableViews;
    private static List textViews;
    private static List metaDataViews;
    private static List paletteViews;
    private static List helpViews;
    private static final String aboutHDFView;
    private static final String JAVA_COMPILER = "jdk 1.6";
    private String rootDir;
    private String currentDir;
    private String currentFile;
    private ViewProperties props;
    private TreeView treeView;
    private int frameOffset;
    private final JDesktopPane contentPane;
    private final JTextArea statusArea;
    private final JTextArea attributeArea;
    private final JTabbedPane infoTabbedPane;
    private JMenuBar menuBar;
    private final JMenu windowMenu;
    private final JMenu fileMenu;
    private final StringBuffer message;
    private final StringBuffer metadata;
    private final Toolkit toolkit;
    private final List editGUIs;
    private final List<JMenuItem> h5GUIs;
    private final List<JMenuItem> h4GUIs;
    private JComboBox urlBar;
    private UserOptionsDialog userOptionDialog;
    private Constructor ctrSrbFileDialog = null;
    private JDialog srbFileDialog = null;

    static {
        aboutHDFView = "HDF Viewer, Version 2.7\nFor " + System.getProperty("os.name") + "\n\n" + "Copyright " + '\u00a9' + " 2006-2011 The HDF Group.\n" + "All rights reserved.";
    }

    public HDFView(String string, List<File> list, int n, int n2, int n3, int n4) {
        super("HDFView");
        Object object;
        this.setName("hdfview");
        this.setDefaultCloseOperation(2);
        this.rootDir = string;
        this.currentFile = null;
        this.frameOffset = 0;
        this.userOptionDialog = null;
        this.ctrSrbFileDialog = null;
        this.toolkit = Toolkit.getDefaultToolkit();
        ViewProperties.loadIcons(this.rootDir);
        ViewProperties.loadExtClass();
        this.editGUIs = new Vector();
        this.h4GUIs = new Vector<JMenuItem>();
        this.h5GUIs = new Vector<JMenuItem>();
        this.props = new ViewProperties(this.rootDir);
        try {
            this.props.load();
        }
        catch (Exception exception) {}
        this.currentDir = ViewProperties.getWorkDir();
        if (this.currentDir == null) {
            this.currentDir = System.getProperty("user.dir");
        }
        treeViews = ViewProperties.getTreeViewList();
        metaDataViews = ViewProperties.getMetaDataViewList();
        textViews = ViewProperties.getTextViewList();
        tableViews = ViewProperties.getTableViewList();
        imageViews = ViewProperties.getImageViewList();
        paletteViews = ViewProperties.getPaletteViewList();
        helpViews = ViewProperties.getHelpViewList();
        this.statusArea = new JTextArea();
        this.statusArea.setEditable(false);
        this.statusArea.setBackground(new Color(240, 240, 240));
        this.statusArea.setLineWrap(true);
        this.statusArea.setName("status");
        this.message = new StringBuffer();
        this.metadata = new StringBuffer();
        this.showStatus("HDFView root - " + this.rootDir);
        this.showStatus("User property file - " + ViewProperties.getPropertyFile());
        this.attributeArea = new JTextArea();
        this.attributeArea.setEditable(false);
        this.attributeArea.setBackground(new Color(240, 240, 240));
        this.attributeArea.setLineWrap(true);
        this.attributeArea.setName("attributes");
        this.infoTabbedPane = new JTabbedPane(3);
        this.infoTabbedPane.addChangeListener(this);
        this.infoTabbedPane.setName("tabpane");
        this.contentPane = new JDesktopPane();
        this.contentPane.setName("contentpane");
        this.windowMenu = new JMenu("Window");
        this.windowMenu.setName("windowmenu");
        this.fileMenu = new JMenu("File");
        this.fileMenu.setName("filemenu");
        int n5 = treeViews.size();
        Class<?> clazz = null;
        int n6 = 0;
        while (n6 < n5) {
            object = treeViews.get(n6);
            try {
                clazz = Class.forName((String)object);
            }
            catch (Exception exception) {
                try {
                    clazz = ViewProperties.loadExtClass().loadClass((String)object);
                }
                catch (Exception exception2) {
                    clazz = null;
                }
            }
            if (clazz != null) break;
            ++n6;
        }
        if (clazz != null) {
            try {
                Class[] classArray = new Class[]{Class.forName("ncsa.hdf.view.ViewManager")};
                object = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{this};
                this.treeView = (TreeView)((Constructor)object).newInstance(objectArray);
            }
            catch (Exception exception) {
                this.treeView = null;
            }
        }
        if (this.treeView == null) {
            this.treeView = new DefaultTreeView(this);
        }
        this.createMainWindow(n, n2, n3, n4);
        try {
            Font font = null;
            object = ViewProperties.getFontType();
            int n7 = ViewProperties.getFontSize();
            try {
                font = new Font((String)object, 0, n7);
            }
            catch (Exception exception) {
                font = null;
            }
            if (font != null) {
                this.updateFontSize(font);
            }
        }
        catch (Exception exception) {}
        this.pack();
        new DropTarget(this, this);
        int n8 = list.size();
        object = null;
        int n9 = 0;
        while (n9 < n8) {
            object = list.get(n9);
            if (((File)object).isFile()) {
                this.currentDir = ((File)object).getParentFile().getAbsolutePath();
                this.currentFile = ((File)object).getAbsolutePath();
                try {
                    this.treeView.openFile(this.currentFile, 1);
                    try {
                        this.urlBar.removeItem(this.currentFile);
                        this.urlBar.insertItemAt(this.currentFile, 0);
                        this.urlBar.setSelectedIndex(0);
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception exception) {
                    this.showStatus(exception.toString());
                }
            } else {
                this.currentDir = ((File)object).getAbsolutePath();
            }
            ++n9;
        }
        if (FileFormat.getFileFormat("HDF4") == null) {
            HDFView.setEnabled(this.h4GUIs, false);
        }
        if (FileFormat.getFileFormat("HDF5") == null) {
            HDFView.setEnabled(this.h5GUIs, false);
        }
    }

    private void updateFontSize(Font font) {
        if (font == null) {
            return;
        }
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        for (Object k : uIDefaults.keySet()) {
            if (uIDefaults.getFont(k) == null) continue;
            UIManager.put(k, new FontUIResource(font));
        }
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void createMainWindow(int n, int n2, int n3, int n4) {
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.treeView));
        jScrollPane.setName("treescroller");
        JScrollPane jScrollPane2 = new JScrollPane(this.contentPane);
        jScrollPane2.setName("contentscroller");
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setName("topsplitpane");
        this.infoTabbedPane.addTab("Log Info", new JScrollPane(this.statusArea));
        this.infoTabbedPane.addTab("Metadata ", new JScrollPane(this.attributeArea));
        this.infoTabbedPane.setSelectedIndex(1);
        jSplitPane.setBorder(null);
        JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, this.infoTabbedPane);
        jSplitPane2.setName("splitpane");
        float f = 0.04f;
        Dimension dimension = this.toolkit.getScreenSize();
        dimension.height = n2 > 300 ? n2 : (int)((1.0f - 2.0f * f) * (float)dimension.height);
        dimension.width = n > 300 ? n : (int)(0.9 * (double)dimension.height);
        if (this.treeView.getClass().getName().startsWith("ext.erdc")) {
            jSplitPane.setDividerLocation(500);
            dimension.width = (int)(0.9 * (double)this.toolkit.getScreenSize().width);
            dimension.height = (int)((double)dimension.width * 0.618);
        }
        jSplitPane2.setDividerLocation(dimension.height - 180);
        this.setLocation(n3, n4);
        try {
            this.setIconImage(((ImageIcon)ViewProperties.getHdfIcon()).getImage());
        }
        catch (Exception exception) {}
        this.menuBar = this.createMenuBar();
        this.setJMenuBar(this.menuBar);
        JToolBar jToolBar = this.createToolBar();
        this.urlBar = new JComboBox<String>(ViewProperties.getMRF());
        this.urlBar.setMaximumRowCount(15);
        this.urlBar.setEditable(true);
        this.urlBar.addActionListener(this);
        this.urlBar.setActionCommand("Open file: from file bar");
        this.urlBar.setSelectedIndex(-1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setName("urlpane");
        JButton jButton = new JButton("Clear Text");
        jButton.setActionCommand("Clear current selection");
        jButton.setToolTipText("Clear current selection");
        jButton.setMargin(new Insets(1, 3, 1, 3));
        jButton.addActionListener(this);
        jPanel.add((Component)jButton, "East");
        jButton = new JButton("Recent Files");
        jButton.addActionListener(this);
        jButton.setActionCommand("Popup URL list");
        jButton.setToolTipText("List of recent files");
        jButton.setMargin(new Insets(1, 3, 1, 3));
        jPanel.add((Component)jButton, "West");
        jPanel.add((Component)this.urlBar, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1, 0, 0));
        jPanel2.add(jToolBar);
        jPanel2.add(jPanel);
        jPanel2.setName("toolpane");
        JPanel jPanel3 = (JPanel)this.getContentPane();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.add((Component)jSplitPane2, "Center");
        jPanel3.setPreferredSize(dimension);
        jPanel3.setName("mainpane");
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setName("mbar");
        JMenu jMenu = null;
        this.fileMenu.setMnemonic('f');
        jMenuBar.add(this.fileMenu);
        JMenuItem jMenuItem = new JMenuItem("Open");
        jMenuItem.setMnemonic(79);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Open file");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2, true));
        this.fileMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Open Read-Only");
        jMenuItem.setMnemonic(82);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Open file read-only");
        if (!ViewProperties.isReadOnly()) {
            this.fileMenu.add(jMenuItem);
        }
        this.fileMenu.addSeparator();
        JMenu jMenu2 = new JMenu("New");
        jMenuItem = new JMenuItem("HDF4");
        jMenuItem.setActionCommand("New HDF4 file");
        jMenuItem.setMnemonic(52);
        jMenuItem.addActionListener(this);
        this.h4GUIs.add(jMenuItem);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("HDF5");
        jMenuItem.setActionCommand("New HDF5 file");
        jMenuItem.setMnemonic(53);
        jMenuItem.addActionListener(this);
        this.h5GUIs.add(jMenuItem);
        jMenu2.add(jMenuItem);
        this.fileMenu.add(jMenu2);
        this.fileMenu.addSeparator();
        jMenuItem = new JMenuItem("Close");
        jMenuItem.setMnemonic(67);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Close file");
        this.fileMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close All");
        jMenuItem.setMnemonic(65);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Close all file");
        this.fileMenu.add(jMenuItem);
        this.fileMenu.addSeparator();
        jMenuItem = new JMenuItem("Save");
        jMenuItem.setMnemonic(83);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save current file");
        this.fileMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save As");
        jMenuItem.setMnemonic(65);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save current file as");
        this.fileMenu.add(jMenuItem);
        this.fileMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.setMnemonic(88);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Exit");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2, true));
        this.fileMenu.add(jMenuItem);
        this.fileMenu.addSeparator();
        this.windowMenu.setMnemonic('w');
        jMenuBar.add(this.windowMenu);
        jMenuItem = new JMenuItem("Cascade");
        jMenuItem.setMnemonic(67);
        jMenuItem.setActionCommand("Cascade all windows");
        jMenuItem.addActionListener(this);
        this.windowMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Tile");
        jMenuItem.setMnemonic(84);
        jMenuItem.setActionCommand("Tile all windows");
        jMenuItem.addActionListener(this);
        this.windowMenu.add(jMenuItem);
        this.windowMenu.addSeparator();
        jMenuItem = new JMenuItem("Close Window");
        jMenuItem.setMnemonic(87);
        jMenuItem.setActionCommand("Close a window");
        jMenuItem.addActionListener(this);
        this.windowMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close All");
        jMenuItem.setMnemonic(65);
        jMenuItem.setActionCommand("Close all windows");
        jMenuItem.addActionListener(this);
        this.windowMenu.add(jMenuItem);
        this.windowMenu.addSeparator();
        jMenu = new JMenu("Tools");
        jMenu.setMnemonic('T');
        jMenuBar.add(jMenu);
        JMenu jMenu3 = new JMenu("Convert Image To");
        jMenuItem = new JMenuItem("HDF4");
        jMenuItem.setActionCommand("Convert image file: Image to HDF4");
        jMenuItem.addActionListener(this);
        this.h4GUIs.add(jMenuItem);
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("HDF5");
        jMenuItem.setActionCommand("Convert image file: Image to HDF5");
        jMenuItem.addActionListener(this);
        this.h5GUIs.add(jMenuItem);
        jMenu3.add(jMenuItem);
        jMenu.add(jMenu3);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("User Options");
        jMenuItem.setMnemonic(79);
        jMenuItem.setActionCommand("User options");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Register File Format");
        jMenuItem.setMnemonic(82);
        jMenuItem.setActionCommand("Register file format");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Unregister File Format");
        jMenuItem.setMnemonic(85);
        jMenuItem.setActionCommand("Unregister file format");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Help");
        jMenu.setMnemonic('H');
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("User's Guide");
        jMenuItem.setMnemonic(85);
        jMenuItem.setActionCommand("Users guide");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        if (helpViews != null && helpViews.size() > 0) {
            int n = helpViews.size();
            int n2 = 0;
            while (n2 < n) {
                HelpView helpView = (HelpView)helpViews.get(n2);
                jMenuItem = new JMenuItem(helpView.getLabel());
                jMenuItem.setActionCommand(helpView.getActionCommand());
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
                ++n2;
            }
            jMenu.addSeparator();
        }
        jMenuItem = new JMenuItem("HDF4 Library Version");
        jMenuItem.setMnemonic(52);
        jMenuItem.setActionCommand("HDF4 library");
        jMenuItem.addActionListener(this);
        this.h4GUIs.add(jMenuItem);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("HDF5 Library Version");
        jMenuItem.setMnemonic(53);
        jMenuItem.setActionCommand("HDF5 library");
        jMenuItem.addActionListener(this);
        this.h5GUIs.add(jMenuItem);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Java Version");
        jMenuItem.setMnemonic(53);
        jMenuItem.setActionCommand("Java version");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Supported File Formats");
        jMenuItem.setMnemonic(76);
        jMenuItem.setActionCommand("File format list");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("About...");
        jMenuItem.setMnemonic(65);
        jMenuItem.setActionCommand("About");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        return jMenuBar;
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setName("tbar");
        JButton jButton = new JButton(ViewProperties.getFileopenIcon());
        jToolBar.add(jButton);
        jButton.setName("Open");
        jButton.setToolTipText("Open");
        jButton.addActionListener(this);
        jButton.setActionCommand("Open file");
        jButton = new JButton(ViewProperties.getFilecloseIcon());
        jToolBar.add(jButton);
        jButton.setName("Close");
        jButton.setToolTipText("Close");
        jButton.addActionListener(this);
        jButton.setActionCommand("Close file");
        jToolBar.addSeparator(new Dimension(20, 20));
        jButton = new JButton(ViewProperties.getHelpIcon());
        jToolBar.add(jButton);
        jButton.setName("Help");
        jButton.setToolTipText("Help");
        jButton.addActionListener(this);
        jButton.setActionCommand("Users guide");
        jButton = new JButton(ViewProperties.getH4Icon());
        jToolBar.add(jButton);
        jButton.setName("HDF4 library");
        jButton.setToolTipText("HDF4 Library Version");
        jButton.addActionListener(this);
        jButton.setActionCommand("HDF4 library");
        if (FileFormat.getFileFormat("HDF4") == null) {
            jButton.setEnabled(false);
        }
        jButton = new JButton(ViewProperties.getH5Icon());
        jToolBar.add(jButton);
        jButton.setName("HDF5 library");
        jButton.setToolTipText("HDF5 Library Version");
        jButton.addActionListener(this);
        jButton.setActionCommand("HDF5 library");
        if (FileFormat.getFileFormat("HDF5") == null) {
            jButton.setEnabled(false);
        }
        return jToolBar;
    }

    private void showWindow(String string) {
        int n = this.contentPane.getComponentCount();
        if (n <= 0) {
            return;
        }
        Component component = null;
        JInternalFrame jInternalFrame = null;
        int n2 = 0;
        while (n2 < n) {
            component = this.contentPane.getComponent(n2);
            if (component instanceof JInternalFrame && (jInternalFrame = (JInternalFrame)this.contentPane.getComponent(n2)).getName().equals(string)) {
                jInternalFrame.toFront();
                return;
            }
            ++n2;
        }
    }

    private void cascadeWindow() {
        int n = 2;
        int n2 = 2;
        JInternalFrame jInternalFrame = null;
        Component[] componentArray = this.contentPane.getComponents();
        if (componentArray == null || componentArray.length <= 0) {
            return;
        }
        Dimension dimension = this.contentPane.getSize();
        int n3 = Math.max(50, dimension.width - 100);
        int n4 = Math.max(50, dimension.height - 100);
        int n5 = 0;
        while (n5 < componentArray.length) {
            jInternalFrame = (JInternalFrame)componentArray[n5];
            jInternalFrame.setBounds(n2, n, n3, n4);
            this.contentPane.moveToFront(jInternalFrame);
            n2 += 20;
            n += 20;
            ++n5;
        }
    }

    private void tileWindow() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        JInternalFrame jInternalFrame = null;
        Component[] componentArray = this.contentPane.getComponents();
        if (componentArray == null || componentArray.length <= 0) {
            return;
        }
        int n4 = componentArray.length;
        int n5 = (int)Math.sqrt(n4);
        int n6 = (int)Math.ceil((double)n4 / (double)n5);
        Dimension dimension = this.contentPane.getSize();
        int n7 = dimension.width / n5;
        int n8 = dimension.height / n6;
        int n9 = 0;
        while (n9 < n6) {
            n2 = 0;
            int n10 = 0;
            while (n10 < n5) {
                n3 = n9 * n5 + n10;
                if (n3 >= n4) {
                    return;
                }
                jInternalFrame = (JInternalFrame)componentArray[n3];
                jInternalFrame.setBounds(n2, n, n7, n8);
                n2 += n7;
                ++n10;
            }
            n += n8;
            ++n9;
        }
    }

    private void closeAllWindow() {
        JInternalFrame jInternalFrame = null;
        Component[] componentArray = this.contentPane.getComponents();
        if (componentArray == null || componentArray.length <= 0) {
            return;
        }
        int n = 0;
        while (n < componentArray.length) {
            jInternalFrame = (JInternalFrame)componentArray[n];
            jInternalFrame.dispose();
            jInternalFrame = null;
            ++n;
        }
    }

    private static void setEnabled(List<JMenuItem> list, boolean bl) {
        Object component2 = null;
        for (Component component : list) {
            component.setEnabled(bl);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block107: {
            String string;
            block122: {
                block121: {
                    block120: {
                        block119: {
                            block118: {
                                block117: {
                                    block116: {
                                        block115: {
                                            block114: {
                                                block113: {
                                                    block112: {
                                                        block111: {
                                                            block110: {
                                                                block109: {
                                                                    block108: {
                                                                        string = actionEvent.getActionCommand();
                                                                        if (!string.equals("Exit")) break block108;
                                                                        this.dispose();
                                                                        break block107;
                                                                    }
                                                                    if (!string.startsWith("Open file")) break block109;
                                                                    int n = 1;
                                                                    String string2 = null;
                                                                    if (ViewProperties.isReadOnly()) {
                                                                        n = 0;
                                                                    }
                                                                    if (string.equals("Open file: from file bar")) {
                                                                        string2 = (String)this.urlBar.getSelectedItem();
                                                                        if (string2 == null || string2.length() < 1) {
                                                                            return;
                                                                        }
                                                                        if (!string2.startsWith("http://") && !string2.startsWith("ftp://")) {
                                                                            File file = new File(string2);
                                                                            if (!file.exists()) {
                                                                                return;
                                                                            }
                                                                            if (file.isDirectory()) {
                                                                                this.currentDir = string2;
                                                                                string2 = this.openLocalFile();
                                                                            }
                                                                        }
                                                                    } else if (string.equals("Open file read-only")) {
                                                                        n = 0;
                                                                        string2 = this.openLocalFile();
                                                                    } else {
                                                                        string2 = string.startsWith("Open file://") ? string.substring(12) : this.openLocalFile();
                                                                    }
                                                                    if (string2 == null) {
                                                                        return;
                                                                    }
                                                                    if (string2.startsWith("http://") || string2.startsWith("ftp://")) {
                                                                        string2 = this.openRemoteFile(string2);
                                                                    }
                                                                    if (string2 == null || string2.length() < 1 || string2.equals(this.currentFile)) {
                                                                        return;
                                                                    }
                                                                    this.currentFile = string2;
                                                                    try {
                                                                        this.urlBar.removeItem(string2);
                                                                        this.urlBar.insertItemAt(string2, 0);
                                                                        this.urlBar.setSelectedIndex(0);
                                                                    }
                                                                    catch (Exception exception) {}
                                                                    try {
                                                                        this.treeView.openFile(string2, n);
                                                                    }
                                                                    catch (Throwable throwable) {
                                                                        try {
                                                                            this.treeView.openFile(string2, 0);
                                                                            break block107;
                                                                        }
                                                                        catch (Throwable throwable2) {
                                                                            String string3 = "Failed to open file " + string2 + "\n" + throwable2;
                                                                            this.toolkit.beep();
                                                                            JOptionPane.showMessageDialog(this, string3, this.getTitle(), 0);
                                                                        }
                                                                    }
                                                                    break block107;
                                                                }
                                                                if (!string.equals("Open from irods")) break block110;
                                                                try {
                                                                    this.openFromSRB();
                                                                }
                                                                catch (Exception exception) {
                                                                    this.toolkit.beep();
                                                                    JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
                                                                }
                                                                break block107;
                                                            }
                                                            if (!string.startsWith("New HDF")) break block111;
                                                            String string4 = "HDF5";
                                                            if (string.equals("New HDF4 file")) {
                                                                string4 = "HDF4";
                                                            }
                                                            NewFileDialog newFileDialog = new NewFileDialog(this, this.currentDir, string4, this.treeView.getCurrentFiles());
                                                            newFileDialog.setName("newfiledialog");
                                                            if (!newFileDialog.isFileCreated()) {
                                                                return;
                                                            }
                                                            String string5 = newFileDialog.getFile();
                                                            if (string5 == null) {
                                                                return;
                                                            }
                                                            try {
                                                                this.treeView.openFile(string5, 1);
                                                                this.currentFile = string5;
                                                                try {
                                                                    this.urlBar.removeItem(string5);
                                                                    this.urlBar.insertItemAt(string5, 0);
                                                                    this.urlBar.setSelectedIndex(0);
                                                                    break block107;
                                                                }
                                                                catch (Exception exception) {
                                                                }
                                                            }
                                                            catch (Exception exception) {
                                                                this.toolkit.beep();
                                                                JOptionPane.showMessageDialog(this, String.valueOf(exception.getMessage()) + "\n" + string5, this.getTitle(), 0);
                                                            }
                                                            break block107;
                                                        }
                                                        if (!string.equals("Close file")) break block112;
                                                        FileFormat fileFormat = this.treeView.getSelectedFile();
                                                        if (fileFormat == null) {
                                                            this.toolkit.beep();
                                                            JOptionPane.showMessageDialog(this, "Select a file to close", this.getTitle(), 0);
                                                            return;
                                                        }
                                                        JInternalFrame[] jInternalFrameArray = this.contentPane.getAllFrames();
                                                        if (jInternalFrameArray != null) {
                                                            int n = 0;
                                                            while (n < jInternalFrameArray.length) {
                                                                HObject hObject = ((DataView)((Object)jInternalFrameArray[n])).getDataObject();
                                                                if (hObject != null && hObject.getFileFormat().equals(fileFormat)) {
                                                                    jInternalFrameArray[n].dispose();
                                                                    jInternalFrameArray[n] = null;
                                                                }
                                                                ++n;
                                                            }
                                                        }
                                                        String string6 = (String)this.urlBar.getSelectedItem();
                                                        if (fileFormat.getFilePath().equals(string6)) {
                                                            this.currentFile = null;
                                                            this.urlBar.setSelectedIndex(-1);
                                                        }
                                                        try {
                                                            this.treeView.closeFile(fileFormat);
                                                        }
                                                        catch (Exception exception) {}
                                                        fileFormat = null;
                                                        this.attributeArea.setText("");
                                                        System.gc();
                                                        break block107;
                                                    }
                                                    if (!string.equals("Close all file")) break block113;
                                                    this.closeAllWindow();
                                                    List<FileFormat> list = this.treeView.getCurrentFiles();
                                                    while (!list.isEmpty()) {
                                                        try {
                                                            this.treeView.closeFile(list.get(0));
                                                        }
                                                        catch (Exception exception) {}
                                                    }
                                                    this.currentFile = null;
                                                    this.attributeArea.setText("");
                                                    break block107;
                                                }
                                                if (!string.equals("Save current file as")) break block114;
                                                try {
                                                    this.treeView.saveFile(this.treeView.getSelectedFile());
                                                }
                                                catch (Exception exception) {
                                                    this.toolkit.beep();
                                                    JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
                                                }
                                                break block107;
                                            }
                                            if (!string.equals("Save current file")) break block115;
                                            try {
                                                FileFormat fileFormat = this.treeView.getSelectedFile();
                                                List<JInternalFrame> list = this.getDataViews();
                                                JInternalFrame jInternalFrame = null;
                                                TableView tableView = null;
                                                TextView textView = null;
                                                FileFormat fileFormat2 = null;
                                                if (list == null) break block107;
                                                int n = list.size();
                                                int n2 = 0;
                                                while (n2 < n) {
                                                    jInternalFrame = list.get(n2);
                                                    if (jInternalFrame instanceof TableView) {
                                                        tableView = (TableView)((Object)jInternalFrame);
                                                        fileFormat2 = tableView.getDataObject().getFileFormat();
                                                        if (fileFormat.equals(fileFormat2)) {
                                                            tableView.updateValueInFile();
                                                        }
                                                    } else if (jInternalFrame instanceof TextView && fileFormat.equals(fileFormat2 = (textView = (TextView)((Object)jInternalFrame)).getDataObject().getFileFormat())) {
                                                        textView.updateValueInFile();
                                                    }
                                                    ++n2;
                                                }
                                                break block107;
                                            }
                                            catch (Exception exception) {
                                                this.toolkit.beep();
                                                JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
                                            }
                                            break block107;
                                        }
                                        if (!string.equals("Cascade all windows")) break block116;
                                        this.cascadeWindow();
                                        break block107;
                                    }
                                    if (!string.equals("Tile all windows")) break block117;
                                    this.tileWindow();
                                    break block107;
                                }
                                if (!string.equals("Close a window")) break block118;
                                JInternalFrame jInternalFrame = this.contentPane.getSelectedFrame();
                                if (jInternalFrame != null) {
                                    jInternalFrame.dispose();
                                }
                                break block107;
                            }
                            if (!string.equals("Close all windows")) break block119;
                            this.closeAllWindow();
                            break block107;
                        }
                        if (!string.startsWith("SHOW WINDOW")) break block120;
                        this.showWindow(string);
                        break block107;
                    }
                    if (!string.startsWith("Convert image file:")) break block121;
                    String string7 = null;
                    String string8 = null;
                    if (string.equals("Convert image file: Image to HDF5")) {
                        string7 = "IMG";
                        string8 = "HDF5";
                    } else if (string.equals("Convert image file: Image to HDF4")) {
                        string7 = "IMG";
                        string8 = "HDF4";
                    } else {
                        return;
                    }
                    FileConversionDialog fileConversionDialog = new FileConversionDialog(this, string7, string8, this.currentDir, this.treeView.getCurrentFiles());
                    fileConversionDialog.setVisible(true);
                    if (fileConversionDialog.isFileConverted()) {
                        String string9 = fileConversionDialog.getConvertedFile();
                        File file = new File(string9);
                        if (!file.exists() || !file.exists()) {
                            return;
                        }
                        this.currentDir = file.getParentFile().getAbsolutePath();
                        this.currentFile = file.getAbsolutePath();
                        try {
                            this.treeView.openFile(string9, 1);
                            try {
                                this.urlBar.removeItem(string9);
                                this.urlBar.insertItemAt(string9, 0);
                                this.urlBar.setSelectedIndex(0);
                                break block107;
                            }
                            catch (Exception exception) {
                            }
                        }
                        catch (Exception exception) {
                            this.showStatus(exception.toString());
                        }
                    }
                    break block107;
                }
                if (!string.equals("User options")) break block122;
                if (this.userOptionDialog == null) {
                    this.userOptionDialog = new UserOptionsDialog(this, this.rootDir);
                }
                this.userOptionDialog.setVisible(true);
                if (this.userOptionDialog.isWorkDirChanged()) {
                    this.currentDir = ViewProperties.getWorkDir();
                }
                if (!this.userOptionDialog.isFontChanged()) break block107;
                Font font = null;
                try {
                    font = new Font(ViewProperties.getFontType(), 0, ViewProperties.getFontSize());
                }
                catch (Exception exception) {
                    font = null;
                }
                if (font == null) break block107;
                this.updateFontSize(font);
                break block107;
            }
            if (string.equals("Register file format")) {
                Object object;
                String string10 = "Register a new file format by \nKEY:FILE_FORMAT:FILE_EXTENSION\nwhere, KEY: the unique identifier for the file format\n           FILE_FORMAT: the full class name of the file format\n           FILE_EXTENSION: the file extension for the file format\n\nFor example, \n\t to add NetCDF, \"NetCDF:ncsa.hdf.object.nc2.NC2File:nc\"\n\t to add FITS, \"FITS:ncsa.hdf.object.fits.FitsFile:fits\"\n\n";
                String string11 = (String)JOptionPane.showInputDialog(this, string10, "Register a file format", -1, ViewProperties.getLargeHdfIcon(), null, null);
                if (string11 == null || string11.length() < 1) {
                    return;
                }
                int n = string11.indexOf(58);
                int n3 = string11.lastIndexOf(58);
                if (n < 0 || n3 <= n) {
                    JOptionPane.showMessageDialog(this, "Failed to register " + string11 + "\n\nMust in the form of KEY:FILE_FORMAT:FILE_EXTENSION", "Register File Format", 0);
                    return;
                }
                String string12 = string11.substring(0, n);
                String string13 = string11.substring(n + 1, n3);
                String string14 = string11.substring(n3 + 1);
                String string15 = null;
                String string16 = null;
                Enumeration enumeration = FileFormat.getFileFormatKeys();
                while (enumeration.hasMoreElements()) {
                    string15 = (String)enumeration.nextElement();
                    if (string15.endsWith(string12)) {
                        JOptionPane.showMessageDialog(this, "Invalid key: " + string12 + " is taken.", "Register File Format", 0);
                        return;
                    }
                    string16 = FileFormat.getFileFormat(string15).getClass().getName();
                    if (!string16.endsWith(string13)) continue;
                    JOptionPane.showMessageDialog(this, "The file format has already been registered: " + string13, "Register File Format", 0);
                    return;
                }
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(string13);
                }
                catch (Exception exception) {
                    try {
                        clazz = ViewProperties.loadExtClass().loadClass(string13);
                    }
                    catch (Exception exception2) {
                        clazz = null;
                    }
                }
                if (clazz == null) {
                    return;
                }
                try {
                    object = clazz.newInstance();
                    if (object instanceof FileFormat) {
                        FileFormat.addFileFormat(string12, (FileFormat)object);
                    }
                }
                catch (Throwable throwable) {
                    JOptionPane.showMessageDialog(this, "Failed to register " + string11 + "\n\n" + throwable, "Register File Format", 0);
                    return;
                }
                if (string14 != null && string14.length() > 0) {
                    string14 = string14.trim();
                    object = ViewProperties.getFileExtension();
                    object = String.valueOf(object) + ", " + string14;
                    ViewProperties.setFileExtension(object);
                }
            } else if (string.equals("Unregister file format")) {
                Enumeration enumeration = FileFormat.getFileFormatKeys();
                ArrayList arrayList = new ArrayList();
                while (enumeration.hasMoreElements()) {
                    arrayList.add(enumeration.nextElement());
                }
                String string17 = (String)JOptionPane.showInputDialog(this, "Unregister a file format", "Unregister a file format", 2, ViewProperties.getLargeHdfIcon(), arrayList.toArray(), null);
                if (string17 == null) {
                    return;
                }
                FileFormat.removeFileFormat(string17);
            } else if (string.equals("Users guide")) {
                String string18 = ViewProperties.getUsersGuide();
                if (string18 == null || !string18.startsWith("http://")) {
                    String string19 = File.separator;
                    File file = new File(string18);
                    if (!file.exists()) {
                        string18 = String.valueOf(this.rootDir) + string19 + "UsersGuide" + string19 + "index.html";
                        file = new File(string18);
                        if (!file.exists()) {
                            string18 = "http://www.hdfgroup.org/hdf-java-html/hdfview/UsersGuide/index.html";
                        }
                        ViewProperties.setUsersGuide(string18);
                    }
                }
                try {
                    Tools.launchBrowser(string18);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, exception.getMessage(), "HDFView", 0, ViewProperties.getLargeHdfIcon());
                }
            } else if (string.equals("HDF4 library")) {
                FileFormat fileFormat = FileFormat.getFileFormat("HDF4");
                if (fileFormat == null) {
                    return;
                }
                JOptionPane.showMessageDialog(this, fileFormat.getLibversion(), "HDFView", -1, ViewProperties.getLargeHdfIcon());
            } else if (string.equals("HDF5 library")) {
                FileFormat fileFormat = FileFormat.getFileFormat("HDF5");
                if (fileFormat == null) {
                    return;
                }
                JOptionPane.showMessageDialog(this, fileFormat.getLibversion(), "HDFView", -1, ViewProperties.getLargeHdfIcon());
            } else if (string.equals("Java version")) {
                String string20 = "Compiled at jdk 1.6\nRunning at " + System.getProperty("java.vm.version");
                JOptionPane.showMessageDialog(this, string20, "HDFView", -1, ViewProperties.getLargeHdfIcon());
            } else if (string.equals("File format list")) {
                Enumeration enumeration = FileFormat.getFileFormatKeys();
                String string21 = "\nSupported File Formats: \n";
                while (enumeration.hasMoreElements()) {
                    string21 = String.valueOf(string21) + "    " + enumeration.nextElement() + "\n";
                }
                string21 = String.valueOf(string21) + "\n";
                JOptionPane.showMessageDialog(this, string21, "HDFView", -1, ViewProperties.getLargeHdfIcon());
            } else if (string.equals("About")) {
                JOptionPane.showMessageDialog(this, aboutHDFView, "HDFView", -1, ViewProperties.getLargeHdfIcon());
            } else if (string.equals("Popup URL list")) {
                this.urlBar.setPopupVisible(true);
            } else if (string.equals("Clear current selection")) {
                this.urlBar.setSelectedIndex(-1);
            } else {
                if (helpViews == null || helpViews.size() <= 0) {
                    return;
                }
                int n = helpViews.size();
                int n4 = 0;
                while (n4 < n) {
                    HelpView helpView = (HelpView)helpViews.get(n4);
                    if (string.equals(helpView.getActionCommand())) {
                        helpView.show();
                        break;
                    }
                    ++n4;
                }
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        Object object = changeEvent.getSource();
        if (object.equals(this.infoTabbedPane) && (n = this.infoTabbedPane.getSelectedIndex()) == 1) {
            this.attributeArea.setText("");
            this.showMetaData(this.treeView.getCurrentObject());
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        block13: {
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDropEvent.acceptDrop(1);
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    int n = list.size();
                    int n2 = 0;
                    while (n2 < n) {
                        block12: {
                            File file = (File)list.get(n2);
                            if (!file.isDirectory()) {
                                String string;
                                this.currentFile = string = file.getAbsolutePath();
                                try {
                                    this.treeView.openFile(string, 1);
                                }
                                catch (Throwable throwable) {
                                    try {
                                        this.treeView.openFile(string, 0);
                                    }
                                    catch (Throwable throwable2) {
                                        String string2 = "Failed to open file " + string + "\n" + throwable2;
                                        this.toolkit.beep();
                                        JOptionPane.showMessageDialog(this, string2, this.getTitle(), 0);
                                        break block12;
                                    }
                                }
                                try {
                                    this.urlBar.removeItem(string);
                                    this.urlBar.insertItemAt(string, 0);
                                    this.urlBar.setSelectedIndex(0);
                                }
                                catch (Exception exception) {}
                            }
                        }
                        ++n2;
                    }
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    break block13;
                }
                dropTargetDropEvent.rejectDrop();
            }
            catch (IOException iOException) {
                dropTargetDropEvent.rejectDrop();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                dropTargetDropEvent.rejectDrop();
            }
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dispose() {
        block11: {
            try {
                this.props.save();
            }
            catch (Exception exception) {}
            try {
                this.closeAllWindow();
            }
            catch (Exception exception) {}
            try {
                List<FileFormat> list = this.treeView.getCurrentFiles();
                if (list == null || list.size() <= 0) break block11;
                Object[] objectArray = list.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    try {
                        this.treeView.closeFile((FileFormat)objectArray[n2]);
                    }
                    catch (Throwable throwable) {}
                    ++n2;
                }
            }
            catch (Exception exception) {}
        }
        try {
            super.dispose();
        }
        catch (Exception exception) {}
        System.exit(0);
    }

    @Override
    public void addDataView(DataView dataView) {
        Object object;
        if (dataView == null) {
            return;
        }
        if (!(dataView instanceof JInternalFrame)) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported DataView: the dataview is not a JInternalFrame.", this.getTitle(), 0);
            return;
        }
        JInternalFrame[] jInternalFrameArray = this.contentPane.getAllFrames();
        JInternalFrame jInternalFrame = null;
        if (jInternalFrameArray != null) {
            int n = 0;
            while (n < jInternalFrameArray.length) {
                if (dataView.equals(jInternalFrameArray[n])) {
                    jInternalFrame = jInternalFrameArray[n];
                    break;
                }
                ++n;
            }
        }
        if (jInternalFrame != null) {
            jInternalFrame.toFront();
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
            return;
        }
        JInternalFrame jInternalFrame2 = (JInternalFrame)((Object)dataView);
        this.contentPane.add(jInternalFrame2);
        HObject hObject = dataView.getDataObject();
        String string = String.valueOf(hObject.getPath()) + hObject.getName();
        String string2 = "SHOW WINDOW" + hObject.getFID() + string;
        jInternalFrame2.setName(string2);
        jInternalFrame2.setMaximizable(true);
        jInternalFrame2.setClosable(true);
        jInternalFrame2.setResizable(true);
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this);
        if (this.windowMenu.getMenuComponentCount() == 6) {
            object = this.windowMenu.getMenuComponents();
            int n = 0;
            while (n < 6) {
                object[n].setEnabled(true);
                ++n;
            }
        }
        this.windowMenu.add(jMenuItem);
        jInternalFrame2.setLocation(this.frameOffset, this.frameOffset);
        this.frameOffset = this.frameOffset < 60 ? (this.frameOffset += 15) : 0;
        object = this.contentPane.getSize();
        jInternalFrame2.setSize(object.width - 60, object.height - 60);
        jInternalFrame2.show();
    }

    @Override
    public void removeDataView(DataView dataView) {
        if (!(dataView instanceof JInternalFrame)) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "The dataview is not a JInternalFrame.", this.getTitle(), 0);
            return;
        }
        JInternalFrame jInternalFrame = (JInternalFrame)((Object)dataView);
        String string = jInternalFrame.getName();
        int n = this.windowMenu.getItemCount();
        JMenuItem jMenuItem = null;
        int n2 = 6;
        while (n2 < n) {
            jMenuItem = this.windowMenu.getItem(n2);
            if (jMenuItem != null && jMenuItem.getActionCommand().equals(string)) {
                this.windowMenu.remove(n2);
                jMenuItem = null;
                break;
            }
            ++n2;
        }
        if (this.windowMenu.getMenuComponentCount() == 6) {
            Component[] componentArray = this.windowMenu.getMenuComponents();
            int n3 = 0;
            while (n3 < 6) {
                componentArray[n3].setEnabled(false);
                ++n3;
            }
        }
    }

    @Override
    public TreeView getTreeView() {
        return this.treeView;
    }

    @Override
    public void mouseEventFired(MouseEvent mouseEvent) {
        HObject hObject = this.treeView.getCurrentObject();
        if (hObject == null) {
            return;
        }
        Object object = mouseEvent.getSource();
        if (object instanceof JComponent) {
            String string = hObject.getFile();
            this.urlBar.setSelectedItem(string);
            if (this.infoTabbedPane.getSelectedIndex() == 1) {
                this.showMetaData(hObject);
            }
        }
    }

    private void showMetaData(HObject hObject) {
        int n;
        if (hObject == null || this.currentFile == null) {
            return;
        }
        this.metadata.setLength(0);
        this.metadata.append(hObject.getName());
        String string = null;
        long[] lArray = hObject.getOID();
        if (lArray != null) {
            string = String.valueOf(lArray[0]);
            int n2 = 1;
            while (n2 < lArray.length) {
                string = String.valueOf(string) + ", " + lArray[n2];
                ++n2;
            }
        }
        this.metadata.append(" (");
        this.metadata.append(string);
        this.metadata.append(")");
        if (hObject instanceof Group) {
            Group group = (Group)hObject;
            this.metadata.append("\n    Group size = ");
            this.metadata.append(group.getMemberList().size());
        } else if (hObject instanceof Dataset) {
            Object object;
            Dataset dataset = (Dataset)hObject;
            if (dataset.getRank() <= 0) {
                dataset.init();
            }
            this.metadata.append("\n    ");
            if (dataset instanceof ScalarDS) {
                object = dataset.getDatatype();
                if (object != null) {
                    this.metadata.append(((Datatype)object).getDatatypeDescription());
                }
            } else if (dataset instanceof CompoundDS) {
                this.metadata.append("Compound/Vdata");
            }
            this.metadata.append(",    ");
            object = dataset.getDims();
            if (object != null) {
                this.metadata.append((long)object[0]);
                n = 1;
                while (n < ((Object)object).length) {
                    this.metadata.append(" x ");
                    this.metadata.append((long)object[n]);
                    ++n;
                }
            }
        }
        List list = null;
        try {
            list = hObject.getMetadata();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (list == null) {
            this.metadata.append("\n    Number of attributes = 0");
        } else {
            int n3 = list.size();
            this.metadata.append("\n    Number of attributes = ");
            this.metadata.append(n3);
            n = 0;
            while (n < n3) {
                Object e = list.get(n);
                if (e instanceof Attribute) {
                    Attribute attribute = (Attribute)e;
                    this.metadata.append("\n        ");
                    this.metadata.append(attribute.getName());
                    this.metadata.append(" = ");
                    this.metadata.append(attribute.toString(","));
                }
                ++n;
            }
        }
        this.attributeArea.setText(this.metadata.toString());
        this.attributeArea.setCaretPosition(0);
    }

    @Override
    public DataView getDataView(HObject hObject) {
        if (hObject == null) {
            return null;
        }
        JInternalFrame[] jInternalFrameArray = this.contentPane.getAllFrames();
        JInternalFrame jInternalFrame = null;
        if (jInternalFrameArray == null) {
            return null;
        }
        HObject hObject2 = null;
        int n = 0;
        while (n < jInternalFrameArray.length) {
            if (jInternalFrameArray[n] instanceof DataView && hObject.equals(hObject2 = ((DataView)((Object)jInternalFrameArray[n])).getDataObject())) {
                jInternalFrame = jInternalFrameArray[n];
                break;
            }
            ++n;
        }
        return (DataView)((Object)jInternalFrame);
    }

    public List<JInternalFrame> getDataViews() {
        JInternalFrame[] jInternalFrameArray = this.contentPane.getAllFrames();
        if (jInternalFrameArray == null || jInternalFrameArray.length <= 0) {
            return null;
        }
        Vector<JInternalFrame> vector = new Vector<JInternalFrame>(jInternalFrameArray.length);
        int n = 0;
        while (n < jInternalFrameArray.length) {
            if (jInternalFrameArray[n] instanceof DataView) {
                vector.add(jInternalFrameArray[n]);
            }
            ++n;
        }
        return vector;
    }

    public static final List<String> getListOfTreeView() {
        return treeViews;
    }

    public static final List<String> getListOfImageView() {
        return imageViews;
    }

    public static final List getListOfTableView() {
        return tableViews;
    }

    public static final List getListOfTextView() {
        return textViews;
    }

    public static final List getListOfMetaDataView() {
        return metaDataViews;
    }

    public static final List getListOfPaletteView() {
        return paletteViews;
    }

    @Override
    public void showStatus(String string) {
        this.message.append(string);
        this.message.append("\n");
        this.statusArea.setText(this.message.toString());
    }

    private String openLocalFile() {
        JFileChooser jFileChooser = new JFileChooser(this.currentDir);
        jFileChooser.setFileFilter(DefaultFileFilter.getFileFilter());
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return null;
        }
        this.currentDir = file.isDirectory() ? file.getPath() : file.getParent();
        return file.getAbsolutePath();
    }

    private String openRemoteFile(String string) {
        String string2 = null;
        if (string == null) {
            return null;
        }
        if (string.startsWith("http://")) {
            string2 = string.substring(7);
        } else if (string.startsWith("ftp://")) {
            string2 = string.substring(6);
        } else {
            return null;
        }
        string2 = string2.replace('/', '@');
        string2 = string2.replace('\\', '@');
        String string3 = System.getProperty("java.io.tmpdir");
        File file = new File(string3);
        if (!file.canWrite()) {
            string3 = System.getProperty("user.home");
        }
        if ((file = new File(string2 = String.valueOf(string3) + string2)).exists()) {
            return string2;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            uRL = null;
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            return null;
        }
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (Exception exception) {
            bufferedInputStream = null;
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception2) {}
            try {
                bufferedOutputStream.close();
            }
            catch (Exception exception3) {}
            return null;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        byte[] byArray = new byte[512];
        try {
            int n = 0;
            while ((n = bufferedInputStream.read(byArray)) > 0) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {}
        try {
            bufferedInputStream.close();
        }
        catch (Exception exception) {}
        try {
            bufferedOutputStream.close();
        }
        catch (Exception exception) {}
        this.setCursor(Cursor.getPredefinedCursor(0));
        return string2;
    }

    private void openFromSRB() throws Exception {
        Object[] objectArray;
        if (this.ctrSrbFileDialog == null) {
            objectArray = null;
            try {
                objectArray = Class.forName("ncsa.hdf.srb.SRBFileDialog");
            }
            catch (Exception exception) {
                objectArray = null;
                this.showStatus(exception.toString());
                throw new ClassNotFoundException("Cannot find SRBFileDialog");
            }
            try {
                Class[] classArray = new Class[]{Class.forName("java.awt.Frame")};
                this.ctrSrbFileDialog = objectArray.getConstructor(classArray);
            }
            catch (Exception exception) {
                this.ctrSrbFileDialog = null;
                throw new InstantiationException("Cannot construct SRBFileDialog");
            }
        }
        if (this.srbFileDialog == null) {
            objectArray = new Object[]{this};
            this.srbFileDialog = (JDialog)this.ctrSrbFileDialog.newInstance(objectArray);
        } else {
            this.srbFileDialog.setVisible(true);
        }
        this.currentFile = this.srbFileDialog.getName();
    }

    private static final void loadExtModules() throws Exception {
        ClassLoader classLoader = ViewProperties.loadExtClass();
        Vector<String> vector = ViewProperties.getTreeViewList();
        Vector<String> vector2 = ViewProperties.getImageViewList();
        if (classLoader == null || vector == null || vector2 == null) {
            return;
        }
        String[] stringArray = new String[]{"ext.erdc.TreeViewERDC", "ext.npoess.TreeViewNPOESS"};
        String[] stringArray2 = new String[]{"ext.erdc.ImageViewERDC"};
        int n = 0;
        while (n < stringArray.length) {
            if (!vector.contains(stringArray[n])) {
                try {
                    classLoader.loadClass(stringArray[n]);
                    vector.add(stringArray[n]);
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        n = 0;
        while (n < stringArray2.length) {
            if (!vector2.contains(stringArray2[n])) {
                try {
                    classLoader.loadClass(stringArray2[n]);
                    vector2.add(stringArray2[n]);
                }
                catch (Exception exception) {}
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        int n;
        Object object;
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {}
        String string = System.getProperty("user.dir");
        File file = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        n2 = 0;
        while (n2 < stringArray.length) {
            if ("-root".equalsIgnoreCase(stringArray[n2])) {
                try {
                    file = new File(stringArray[++n2]);
                    n3 = n2;
                    if (file.isDirectory()) {
                        string = file.getPath();
                    } else if (file.isFile()) {
                        string = file.getParent();
                    }
                }
                catch (Exception exception) {}
            } else if ("-g".equalsIgnoreCase(stringArray[n2]) || "-geometry".equalsIgnoreCase(stringArray[n2])) {
                try {
                    object = stringArray[++n2];
                    n3 = n2;
                    int n8 = 0;
                    int n9 = ((String)object).lastIndexOf(45);
                    n = ((String)object).lastIndexOf(43);
                    n8 = Math.max(n9, n);
                    if (n8 > 0) {
                        n7 = Integer.parseInt(((String)object).substring(n8 + 1));
                        if (n8 == n9) {
                            n7 = -n7;
                        }
                        if ((n8 = Math.max(n9 = ((String)(object = ((String)object).substring(0, n8))).lastIndexOf(45), n = ((String)object).lastIndexOf(43))) > 0) {
                            n6 = Integer.parseInt(((String)object).substring(n8 + 1));
                            if (n8 == n9) {
                                n6 = -n6;
                            }
                            object = ((String)object).substring(0, n8);
                        }
                    }
                    if ((n8 = ((String)object).indexOf(120)) > 0) {
                        n4 = Integer.parseInt(((String)object).substring(0, n8));
                        n5 = Integer.parseInt(((String)object).substring(n8 + 1));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if ("-java.vm.version".equalsIgnoreCase(stringArray[n2])) {
                object = "Compiled at jdk 1.6\nRunning at " + System.getProperty("java.vm.version");
                JOptionPane.showMessageDialog(new JFrame(), object, "HDFView", -1, ViewProperties.getLargeHdfIcon());
                System.exit(0);
            }
            ++n2;
        }
        object = new Vector();
        file = null;
        if (n3 >= 0) {
            n2 = n3;
            while (n2 < stringArray.length) {
                file = new File(stringArray[n2]);
                if (file.exists() && file.isFile()) {
                    ((Vector)object).add(new File(file.getAbsolutePath()));
                }
                ++n2;
            }
        }
        final Vector vector = object;
        final String string2 = string;
        n = n6;
        final int n10 = n7;
        final int n11 = n4;
        final int n12 = n5;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HDFView hDFView = new HDFView(string2, vector, n11, n12, n, n10);
                hDFView.setVisible(true);
            }
        });
    }
}

