/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.ViewProperties;

public class FileConversionDialog
extends JDialog
implements ActionListener {
    public static final long serialVersionUID = 240L;
    private String fileTypeFrom;
    private String fileTypeTo;
    private JTextField srcFileField;
    private JTextField dstFileField;
    private boolean isConverted;
    private boolean isConvertedFromImage;
    private String convertedFile;
    private String toFileExtension;
    private List fileList;
    private String currentDir;
    private final Toolkit toolkit;

    public FileConversionDialog(Frame frame, String string, String string2, String string3, List list) {
        super(frame, "Convert File...", true);
        this.fileTypeFrom = string;
        this.fileTypeTo = string2;
        this.isConverted = false;
        this.isConvertedFromImage = false;
        this.fileList = list;
        this.toFileExtension = "";
        this.currentDir = string3;
        this.toolkit = Toolkit.getDefaultToolkit();
        String string4 = "Source";
        if (this.fileTypeTo.equals("HDF5")) {
            this.toFileExtension = ".h5";
            this.setTitle("Convert Image to HDF5 ...");
            string4 = "IMAGE";
            this.isConvertedFromImage = true;
        } else if (this.fileTypeTo.equals("HDF4")) {
            this.toFileExtension = ".hdf";
            this.setTitle("Convert Image to HDF4 ...");
            string4 = "IMAGE";
            this.isConvertedFromImage = true;
        }
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int n = 450 + (ViewProperties.getFontSize() - 12) * 15;
        int n2 = 120 + (ViewProperties.getFontSize() - 12) * 10;
        jPanel.setPreferredSize(new Dimension(n, n2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1, 5, 5));
        jPanel3.add(new JLabel(String.valueOf(string4) + " File: "));
        jPanel3.add(new JLabel("HDF File: "));
        jPanel2.add((Component)jPanel3, "West");
        jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1, 5, 5));
        this.srcFileField = new JTextField();
        jPanel3.add(this.srcFileField);
        this.dstFileField = new JTextField();
        jPanel3.add(this.dstFileField);
        jPanel2.add((Component)jPanel3, "Center");
        jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1, 5, 5));
        JButton jButton = new JButton("Browse...");
        jButton.setActionCommand("Browse source file");
        jButton.addActionListener(this);
        jPanel3.add(jButton);
        jButton = new JButton("Browse...");
        jButton.setActionCommand("Browse target file");
        jButton.addActionListener(this);
        jPanel3.add(jButton);
        jPanel2.add((Component)jPanel3, "East");
        jPanel.add((Component)jPanel2, "Center");
        JButton jButton2 = new JButton("   Ok   ");
        jButton2.setMnemonic(79);
        jButton2.setActionCommand("Ok");
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton("Cancel");
        jButton3.setMnemonic(67);
        jButton3.setActionCommand("Cancel");
        jButton3.addActionListener(this);
        jPanel2 = new JPanel();
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jPanel.add((Component)jPanel2, "South");
        Point point = frame.getLocation();
        point.x += 250;
        point.y += 80;
        this.setLocation(point);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Ok")) {
            this.isConverted = this.convert();
            if (this.isConverted) {
                this.dispose();
            }
        } else if (string.equals("Cancel")) {
            this.isConverted = false;
            this.convertedFile = null;
            this.dispose();
        } else if (string.equals("Browse source file")) {
            int n;
            JFileChooser jFileChooser = new JFileChooser(this.currentDir);
            if (this.isConvertedFromImage) {
                jFileChooser.setFileFilter(DefaultFileFilter.getImageFileFilter());
            }
            if ((n = jFileChooser.showOpenDialog(this)) != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String string2 = file.getAbsolutePath();
            if (string2 == null) {
                return;
            }
            this.currentDir = file.getParent();
            this.srcFileField.setText(string2);
            this.dstFileField.setText(String.valueOf(string2) + this.toFileExtension);
        } else if (string.equals("Browse target file")) {
            JFileChooser jFileChooser = new JFileChooser();
            int n = jFileChooser.showOpenDialog(this);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String string3 = file.getAbsolutePath();
            if (string3 == null) {
                return;
            }
            this.dstFileField.setText(string3);
        }
    }

    private boolean convert() {
        boolean bl = false;
        String string = this.srcFileField.getText();
        String string2 = this.dstFileField.getText();
        if (string == null || string2 == null) {
            return false;
        }
        string = string.trim();
        string2 = string2.trim();
        if (string == null || string.length() <= 0 || string2 == null || string2.length() <= 0) {
            return false;
        }
        File file = new File(string);
        if (!file.exists()) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Source file does not exist.", this.getTitle(), 0);
            return false;
        }
        if (file.isDirectory()) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Source file is a directory.", this.getTitle(), 0);
            return false;
        }
        String string3 = file.getParent();
        file = new File(string2);
        File file2 = file.getParentFile();
        if (file2 == null) {
            string2 = String.valueOf(string3) + File.separator + string2;
            file = new File(string2);
        } else if (!file2.exists()) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Destination file path does not exist at\n" + file2.getPath(), this.getTitle(), 0);
            return false;
        }
        if (this.fileList != null) {
            FileFormat fileFormat2 = null;
            for (FileFormat fileFormat2 : this.fileList) {
                if (!fileFormat2.getFilePath().equals(string2)) continue;
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "The destination file is being used.", this.getTitle(), 0);
                return false;
            }
        }
        int n = -1;
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this, "Destination file exists. Do you want to replace it ?", this.getTitle(), 0)) == 1) {
            return false;
        }
        try {
            Tools.convertImageToHDF(string, string2, this.fileTypeFrom, this.fileTypeTo);
            this.convertedFile = string2;
            bl = true;
        }
        catch (Exception exception) {
            this.convertedFile = null;
            bl = false;
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception.getMessage(), this.getTitle(), 0);
            return false;
        }
        return bl;
    }

    public boolean isFileConverted() {
        return this.isConverted;
    }

    public String getConvertedFile() {
        return this.convertedFile;
    }
}

