/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.DataOptionDialog;
import ncsa.hdf.view.DataView;
import ncsa.hdf.view.HDFView;
import ncsa.hdf.view.MetaDataView;
import ncsa.hdf.view.NewDatasetDialog;
import ncsa.hdf.view.NewDatatypeDialog;
import ncsa.hdf.view.NewFileDialog;
import ncsa.hdf.view.NewGroupDialog;
import ncsa.hdf.view.NewImageDialog;
import ncsa.hdf.view.NewLinkDialog;
import ncsa.hdf.view.NewTableDataDialog;
import ncsa.hdf.view.TableView;
import ncsa.hdf.view.TextView;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.TreeView;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DefaultTreeView
extends JPanel
implements TreeView,
ActionListener {
    public static final long serialVersionUID = 240L;
    private ViewManager viewer;
    private final DefaultMutableTreeNode root;
    private final JTree tree;
    private final DefaultTreeModel treeModel;
    private final List<FileFormat> fileList;
    private final Toolkit toolkit;
    private FileFormat selectedFile;
    private DefaultMutableTreeNode selectedNode;
    private TreePath selectedTreePath;
    private HObject selectedObject;
    private boolean isDefaultDisplay;
    private final JPopupMenu popupMenu;
    private JSeparator separator;
    private List<JMenuItem> editGUIs;
    private List<Object> objectsToCopy;
    private JMenuItem addTableMenuItem;
    private JMenuItem addDatasetMenuItem;
    private JMenuItem addDatatypeMenuItem;
    private JMenuItem addLinkMenuItem;
    private JMenuItem setLibVerBoundsItem;
    private String currentSearchPhrase = null;
    private boolean moveFlag;
    private TreePath[] currentSelectionsForMove;

    public DefaultTreeView(ViewManager viewManager) {
        this.viewer = viewManager;
        this.root = new DefaultMutableTreeNode(){
            public static final long serialVersionUID = 240L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        this.fileList = new Vector<FileFormat>();
        this.toolkit = Toolkit.getDefaultToolkit();
        this.editGUIs = new Vector<JMenuItem>();
        this.objectsToCopy = null;
        this.isDefaultDisplay = true;
        this.selectedTreePath = null;
        this.selectedNode = null;
        this.moveFlag = false;
        this.currentSelectionsForMove = null;
        this.addDatasetMenuItem = new JMenuItem("Dataset", ViewProperties.getDatasetIcon());
        this.addDatasetMenuItem.addActionListener(this);
        this.addDatasetMenuItem.setActionCommand("Add dataset");
        this.addTableMenuItem = new JMenuItem("Compound DS", ViewProperties.getTableIcon());
        this.addTableMenuItem.addActionListener(this);
        this.addTableMenuItem.setActionCommand("Add table");
        this.addDatatypeMenuItem = new JMenuItem("Datatype", ViewProperties.getDatatypeIcon());
        this.addDatatypeMenuItem.addActionListener(this);
        this.addDatatypeMenuItem.setActionCommand("Add datatype");
        this.addLinkMenuItem = new JMenuItem("Link", ViewProperties.getLinkIcon());
        this.addLinkMenuItem.addActionListener(this);
        this.addLinkMenuItem.setActionCommand("Add link");
        this.setLibVerBoundsItem = new JMenuItem("Set Lib version bounds");
        this.setLibVerBoundsItem.addActionListener(this);
        this.setLibVerBoundsItem.setActionCommand("Set Lib version bounds");
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setLargeModel(true);
        this.tree.setCellRenderer(new HTreeCellRenderer());
        this.tree.addMouseListener(new HTreeMouseAdapter());
        this.tree.setRootVisible(false);
        int n = 23 + (int)((double)(this.tree.getFont().getSize() - 12) * 0.5);
        this.tree.setRowHeight(n);
        this.separator = new JPopupMenu.Separator();
        this.popupMenu = this.createPopupMenu();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tree, "Center");
    }

    private void insertNode(TreeNode treeNode, TreeNode treeNode2) {
        if (treeNode == null || treeNode2 == null) {
            return;
        }
        this.treeModel.insertNodeInto((DefaultMutableTreeNode)treeNode, (DefaultMutableTreeNode)treeNode2, treeNode2.getChildCount());
    }

    private boolean isFileOpen(String string) {
        boolean bl = false;
        FileFormat fileFormat2 = null;
        for (FileFormat fileFormat2 : this.fileList) {
            if (!fileFormat2.getFilePath().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Open");
        jMenuItem.setMnemonic(79);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Open data");
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Open As");
        jMenuItem.setMnemonic(65);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Open data as");
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        JMenu jMenu = new JMenu("New");
        jPopupMenu.add(jMenu);
        this.editGUIs.add(jMenu);
        jMenuItem = new JMenuItem("Group", ViewProperties.getFoldercloseIcon());
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Add group");
        jMenu.add(jMenuItem);
        jMenu.add(this.addDatasetMenuItem);
        jMenuItem = new JMenuItem("Image", ViewProperties.getImageIcon());
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Add image");
        jMenu.add(jMenuItem);
        jMenu.add(this.addTableMenuItem);
        jMenu.add(this.addDatatypeMenuItem);
        jMenu.add(this.addLinkMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Copy");
        jMenuItem.setMnemonic(67);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Copy object");
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Paste");
        jMenuItem.setMnemonic(80);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Paste object");
        jPopupMenu.add(jMenuItem);
        this.editGUIs.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.setMnemonic(68);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Cut object");
        jPopupMenu.add(jMenuItem);
        this.editGUIs.add(jMenuItem);
        jMenuItem = new JMenuItem("Cut");
        jMenuItem.setMnemonic(84);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Move object");
        jPopupMenu.add(jMenuItem);
        this.editGUIs.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Save to");
        jMenuItem.setMnemonic(83);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Save object to file");
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Rename");
        jMenuItem.setMnemonic(82);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Rename object");
        jPopupMenu.add(jMenuItem);
        this.editGUIs.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Show Properties");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show object properties");
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Properties As");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Show object properties as");
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Find");
        jMenuItem.setMnemonic(70);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Find");
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Expand All");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Expand all");
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Collapse All");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Collapse all");
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Close File");
        jMenuItem.setMnemonic(69);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Close file");
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(this.separator);
        jPopupMenu.add(this.setLibVerBoundsItem);
        return jPopupMenu;
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        HObject hObject = (HObject)this.selectedNode.getUserObject();
        boolean bl3 = hObject.getFileFormat().isReadOnly();
        DefaultTreeView.setEnabled(this.editGUIs, !bl3);
        boolean bl4 = bl2 = !hObject.getFileFormat().isReadOnly();
        if (hObject instanceof Group) {
            this.popupMenu.getComponent(0).setEnabled(false);
            this.popupMenu.getComponent(1).setEnabled(false);
            bl = !((Group)hObject).isRoot();
            this.popupMenu.getComponent(5).setEnabled(bl);
            this.popupMenu.getComponent(6).setEnabled(bl2);
            this.popupMenu.getComponent(7).setEnabled(bl && bl2);
            this.popupMenu.getComponent(10).setEnabled(bl);
            this.popupMenu.getComponent(11).setEnabled(bl && bl2);
            this.popupMenu.getComponent(8).setEnabled(hObject.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5")) && bl && bl2);
        } else {
            this.popupMenu.getComponent(0).setEnabled(true);
            this.popupMenu.getComponent(1).setEnabled(true);
            this.popupMenu.getComponent(5).setEnabled(true);
            this.popupMenu.getComponent(6).setEnabled(bl2);
            this.popupMenu.getComponent(7).setEnabled(bl2);
            this.popupMenu.getComponent(10).setEnabled(true);
            this.popupMenu.getComponent(11).setEnabled(bl2);
            this.popupMenu.getComponent(8).setEnabled(hObject.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5")) && bl2);
        }
        if (this.selectedFile != null && this.selectedFile.isThisType(FileFormat.getFileFormat("HDF5"))) {
            this.addDatasetMenuItem.setText("Dataset");
            this.addTableMenuItem.setVisible(true);
            this.addDatatypeMenuItem.setVisible(true);
            this.addLinkMenuItem.setVisible(true);
            if (hObject instanceof Group) {
                bl = ((Group)hObject).isRoot();
                this.separator.setVisible(bl2 && bl);
                this.setLibVerBoundsItem.setVisible(bl2 && bl);
            } else {
                this.separator.setVisible(false);
                this.setLibVerBoundsItem.setVisible(false);
            }
        } else {
            this.addDatasetMenuItem.setText("SDS");
            this.addTableMenuItem.setVisible(false);
            this.addDatatypeMenuItem.setVisible(false);
            this.addLinkMenuItem.setVisible(false);
            this.separator.setVisible(false);
            this.setLibVerBoundsItem.setVisible(false);
        }
        this.popupMenu.show((JComponent)mouseEvent.getSource(), n, n2);
    }

    private static void setEnabled(List<JMenuItem> list, boolean bl) {
        Object component2 = null;
        for (Component component : list) {
            component.setEnabled(bl);
        }
    }

    private final void saveAsHDF4(FileFormat fileFormat) {
        String string;
        if (fileFormat == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Select a file to save.", "HDFView", 0);
            return;
        }
        JFrame jFrame = this.viewer == null ? new JFrame() : (JFrame)((Object)this.viewer);
        NewFileDialog newFileDialog = new NewFileDialog(jFrame, string = fileFormat.getParent(), "HDF4", this.getCurrentFiles());
        if (!newFileDialog.isFileCreated()) {
            return;
        }
        String string2 = newFileDialog.getFile();
        int n = 0;
        int n2 = 512;
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(fileFormat.getFilePath()));
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, String.valueOf(exception.getMessage()) + "\n" + string2, "HDFView", 0);
            return;
        }
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
        }
        catch (Exception exception) {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception2) {}
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
            return;
        }
        byte[] byArray = new byte[n2];
        try {
            n = bufferedInputStream.read(byArray, 0, n2);
        }
        catch (Exception exception) {
            n = 0;
        }
        while (n > 0) {
            try {
                bufferedOutputStream.write(byArray, 0, n);
                n = bufferedInputStream.read(byArray, 0, n2);
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        try {
            bufferedOutputStream.flush();
        }
        catch (Exception exception) {}
        try {
            bufferedInputStream.close();
        }
        catch (Exception exception) {}
        try {
            bufferedOutputStream.close();
        }
        catch (Exception exception) {}
        try {
            this.openFile(string2, 1);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, String.valueOf(exception.getMessage()) + "\n" + string2, "HDFView", 0);
        }
    }

    private void saveAsHDF5(FileFormat fileFormat) {
        if (fileFormat == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Select a file to save.", "HDFView", 0);
            return;
        }
        TreeNode treeNode = fileFormat.getRootNode();
        if (treeNode == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "The file is empty.", "HDFView", 0);
            return;
        }
        JFrame jFrame = this.viewer == null ? new JFrame() : (JFrame)((Object)this.viewer);
        NewFileDialog newFileDialog = new NewFileDialog(jFrame, fileFormat.getParent(), "HDF5", this.getCurrentFiles());
        if (!newFileDialog.isFileCreated()) {
            return;
        }
        String string = newFileDialog.getFile();
        int n = treeNode.getChildCount();
        Vector<Object> vector = new Vector<Object>(n);
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        int n2 = 0;
        while (n2 < n) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode.getChildAt(n2);
            vector.add(defaultMutableTreeNode.getUserObject());
            ++n2;
        }
        FileFormat fileFormat2 = null;
        try {
            fileFormat2 = this.openFile(string, 1);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, String.valueOf(exception.getMessage()) + "\n" + string, "HDFView", 0);
            return;
        }
        if (fileFormat2 == null) {
            return;
        }
        TreeNode treeNode2 = fileFormat2.getRootNode();
        this.pasteObject(vector, treeNode2, fileFormat2);
        vector.setSize(0);
        Group group = (Group)((DefaultMutableTreeNode)treeNode).getUserObject();
        Group group2 = (Group)((DefaultMutableTreeNode)fileFormat2.getRootNode()).getUserObject();
        Object[] objectArray = new Object[2];
        Class<?> clazz = null;
        Class[] classArray = new Class[2];
        Method method = null;
        try {
            objectArray[0] = group;
            objectArray[1] = group2;
            classArray[0] = classArray[1] = (clazz = Class.forName("ncsa.hdf.object.HObject"));
            method = fileFormat2.getClass().getMethod("copyAttributes", classArray);
            method.invoke((Object)fileFormat2, objectArray);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
        }
        objectArray[0] = group.getFileFormat();
        objectArray[1] = fileFormat2;
        classArray[0] = classArray[1] = objectArray[0].getClass();
        try {
            method = fileFormat2.getClass().getMethod("updateReferenceDataset", classArray);
            method.invoke((Object)fileFormat2, objectArray);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
        }
    }

    private void copyObject() {
        this.objectsToCopy = this.getSelectedObjects();
        this.moveFlag = false;
    }

    private void moveObject() {
        this.objectsToCopy = this.getSelectedObjects();
        this.moveFlag = true;
        this.currentSelectionsForMove = this.tree.getSelectionPaths();
    }

    private void pasteObject() {
        Serializable serializable;
        Object object;
        if (this.moveFlag) {
            object = null;
            int n = 0;
            while (n < this.currentSelectionsForMove.length) {
                serializable = (DefaultMutableTreeNode)this.currentSelectionsForMove[n].getLastPathComponent();
                object = (HObject)((DefaultMutableTreeNode)serializable).getUserObject();
                if (this.isObjectOpen((HObject)object)) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Cannot move the selected object: " + object + "\nThe dataset or dataset in the group is in use." + "\n\nPlease close the dataset(s) and try again.\n", "HDFView", 0);
                    this.moveFlag = false;
                    this.currentSelectionsForMove = null;
                    this.objectsToCopy = null;
                    return;
                }
                ++n;
            }
        }
        object = this.selectedNode;
        if (this.objectsToCopy == null || this.objectsToCopy.size() <= 0 || object == null) {
            return;
        }
        FileFormat fileFormat = ((HObject)this.objectsToCopy.get(0)).getFileFormat();
        serializable = this.getSelectedFile();
        FileFormat fileFormat2 = FileFormat.getFileFormat("HDF5");
        FileFormat fileFormat3 = FileFormat.getFileFormat("HDF4");
        if (fileFormat == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Source file is null.", "HDFView", 0);
            return;
        }
        if (serializable == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Destination file is null.", "HDFView", 0);
            return;
        }
        if (fileFormat.isThisType(fileFormat3) && ((FileFormat)serializable).isThisType(fileFormat2)) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported operation: cannot copy HDF4 object to HDF5 file", "HDFView", 0);
            return;
        }
        if (fileFormat.isThisType(fileFormat2) && ((FileFormat)serializable).isThisType(fileFormat3)) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported operation: cannot copy HDF5 object to HDF4 file", "HDFView", 0);
            return;
        }
        if (this.moveFlag && fileFormat != serializable) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Cannot move the selected object to different file", "HDFView", 0);
            this.moveFlag = false;
            this.currentSelectionsForMove = null;
            this.objectsToCopy = null;
            return;
        }
        if (object.isLeaf()) {
            object = object.getParent();
        }
        Group group = (Group)((DefaultMutableTreeNode)object).getUserObject();
        String string = String.valueOf(group.getPath()) + group.getName();
        if (group.isRoot()) {
            string = "/";
        }
        String string2 = "";
        int n = 3;
        if (fileFormat.isThisType(fileFormat3)) {
            string2 = "WARNING: object can not be deleted after it is copied.\n\n";
            n = 2;
        }
        string2 = String.valueOf(string2) + "Do you want to copy the selected object(s) to \nGroup: " + string + "\nFile: " + ((FileFormat)serializable).getFilePath();
        int n2 = -1;
        if (this.moveFlag) {
            String string3 = "Do you want to paste the selected object(s) to \nGroup: " + string + "\nFile: " + ((FileFormat)serializable).getFilePath();
            n2 = JOptionPane.showConfirmDialog(this, string3, "Copy object", 0, n);
        } else {
            n2 = JOptionPane.showConfirmDialog(this, string2, "Copy object", 0, n);
        }
        if (n2 == 1) {
            return;
        }
        this.pasteObject(this.objectsToCopy, (TreeNode)object, (FileFormat)serializable);
        if (this.moveFlag) {
            this.removeSelectedObjects();
            this.moveFlag = false;
            this.currentSelectionsForMove = null;
            this.objectsToCopy = null;
        }
    }

    private void pasteObject(List<Object> list, TreeNode treeNode, FileFormat fileFormat) {
        if (list == null || list.size() <= 0 || treeNode == null) {
            return;
        }
        ((HObject)list.get(0)).getFileFormat();
        Group group = (Group)((DefaultMutableTreeNode)treeNode).getUserObject();
        HObject hObject = null;
        TreeNode treeNode2 = null;
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            treeNode2 = null;
            hObject = (HObject)iterator.next();
            if (hObject instanceof Group && ((Group)hObject).isRoot()) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Unsupported operation: cannot copy the root group", "HDFView", 0);
                return;
            }
            Group group2 = group;
            while (!group2.isRoot()) {
                if (hObject.equals(group2)) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Unsupported operation: cannot copy a group to itself.", "HDFView", 0);
                    return;
                }
                group2 = group2.getParent();
            }
            try {
                treeNode2 = fileFormat.copy(hObject, group);
            }
            catch (Exception exception) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
            }
            if (treeNode2 == null) continue;
            this.insertNode(treeNode2, treeNode);
        }
    }

    private void removeSelectedObjects() {
        int n;
        FileFormat fileFormat = this.getSelectedFile();
        if (fileFormat.isThisType(FileFormat.getFileFormat("HDF4"))) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported operation: cannot delete HDF4 object.", "HDFView", 0);
            return;
        }
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (this.moveFlag) {
            treePathArray = this.currentSelectionsForMove;
        }
        if (treePathArray == null || treePathArray.length <= 0) {
            return;
        }
        if (!this.moveFlag && (n = JOptionPane.showConfirmDialog(this, "Do you want to remove all the selected object(s) ?", "Remove object", 0)) == 1) {
            return;
        }
        HObject hObject = null;
        int n2 = 0;
        while (n2 < treePathArray.length) {
            block11: {
                Group group;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[n2].getLastPathComponent();
                hObject = (HObject)defaultMutableTreeNode.getUserObject();
                if (hObject instanceof Group && (group = (Group)hObject).isRoot()) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Unsupported operation: cannot delete the file root.", "HDFView", 0);
                    return;
                }
                if (!this.moveFlag && this.isObjectOpen(hObject)) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Cannot delete the selected object: " + hObject + "\nThe dataset or dataset in the group is in use." + "\n\nPlease close the dataset(s) and try again.\n", "HDFView", 0);
                } else {
                    try {
                        fileFormat.delete(hObject);
                    }
                    catch (Exception exception) {
                        this.toolkit.beep();
                        JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
                        break block11;
                    }
                    if (hObject.equals(this.selectedObject)) {
                        this.selectedObject = null;
                    }
                    this.removeNode(defaultMutableTreeNode);
                }
            }
            ++n2;
        }
    }

    private void removeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        if (defaultMutableTreeNode2 != null) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
            Group group = (Group)defaultMutableTreeNode2.getUserObject();
            group.removeFromMemberList((HObject)defaultMutableTreeNode.getUserObject());
            if (defaultMutableTreeNode.equals(this.selectedNode)) {
                this.selectedNode = null;
                this.selectedFile = null;
            }
        }
    }

    private boolean isObjectOpen(HObject hObject) {
        boolean bl = false;
        if (hObject instanceof Group) {
            Group group = (Group)hObject;
            List<HObject> list = group.getMemberList();
            if (list == null || list.size() == 0) {
                bl = false;
            } else {
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    HObject hObject2 = list.get(n2);
                    boolean bl2 = bl = this.viewer.getDataView(hObject2) != null;
                    if (!bl) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            bl = this.viewer.getDataView(hObject) != null;
        }
        return bl;
    }

    private final List<Object> breadthFirstUserObjects(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)treeNode).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            vector.add(defaultMutableTreeNode.getUserObject());
        }
        return vector;
    }

    private static final HObject find(String string, TreePath treePath, JTree jTree) {
        HObject hObject = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (string == null || string.length() <= 0 || treePath == null) {
            return null;
        }
        if (string.equals("*")) {
            return null;
        }
        if (string.startsWith("*")) {
            bl3 = true;
            string = string.substring(1, string.length());
        }
        if (string.endsWith("*")) {
            bl2 = true;
            string = string.substring(0, string.length() - 1);
        }
        if (bl2 && bl3) {
            bl4 = true;
            bl3 = false;
            bl2 = false;
        }
        if (string == null || string.length() <= 0) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        HObject hObject2 = null;
        String string2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            hObject2 = (HObject)defaultMutableTreeNode2.getUserObject();
            if (hObject2 == null || (string2 = hObject2.getName()) == null || !(bl = bl2 ? string2.startsWith(string) : (bl3 ? string2.endsWith(string) : (bl4 ? string2.contains(string) : string2.equals(string))))) continue;
            hObject = hObject2;
            break;
        }
        if (hObject != null) {
            TreePath treePath2 = DefaultTreeView.getTreePath(treePath, defaultMutableTreeNode2, 0);
            jTree.setSelectionPath(treePath2);
            jTree.scrollPathToVisible(treePath2);
        }
        return hObject;
    }

    private static TreePath getTreePath(TreePath treePath, TreeNode treeNode, int n) {
        if (treeNode == null || treePath == null || n < 0) {
            return null;
        }
        TreeNode treeNode2 = (TreeNode)treePath.getLastPathComponent();
        if (treeNode == treeNode2) {
            return treePath;
        }
        if (treeNode2.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode2.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode3 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode3);
                TreePath treePath3 = DefaultTreeView.getTreePath(treePath2, treeNode, n + 1);
                if (treePath3 == null) continue;
                return treePath3;
            }
        }
        return null;
    }

    private void addGroup() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group group = null;
        group = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewGroupDialog newGroupDialog = new NewGroupDialog((Frame)((JFrame)((Object)this.viewer)), group, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        newGroupDialog.setVisible(true);
        HObject hObject = (HObject)newGroupDialog.getObject();
        if (hObject == null) {
            return;
        }
        Group group2 = newGroupDialog.getParentGroup();
        try {
            this.addObject(hObject, group2);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
            return;
        }
    }

    private void addDataset() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group group = null;
        group = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewDatasetDialog newDatasetDialog = new NewDatasetDialog((JFrame)((Object)this.viewer), group, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        newDatasetDialog.setVisible(true);
        HObject hObject = (HObject)newDatasetDialog.getObject();
        if (hObject == null) {
            return;
        }
        Group group2 = newDatasetDialog.getParentGroup();
        try {
            this.addObject(hObject, group2);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
            return;
        }
    }

    private void addImage() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group group = null;
        group = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewImageDialog newImageDialog = new NewImageDialog((Frame)((JFrame)((Object)this.viewer)), group, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        newImageDialog.setVisible(true);
        HObject hObject = (HObject)newImageDialog.getObject();
        if (hObject == null) {
            return;
        }
        Group group2 = newImageDialog.getParentGroup();
        try {
            this.addObject(hObject, group2);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
            return;
        }
    }

    private void addTable() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group group = null;
        group = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewTableDataDialog newTableDataDialog = new NewTableDataDialog((JFrame)((Object)this.viewer), group, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        newTableDataDialog.setVisible(true);
        HObject hObject = (HObject)newTableDataDialog.getObject();
        if (hObject == null) {
            return;
        }
        Group group2 = newTableDataDialog.getParentGroup();
        try {
            this.addObject(hObject, group2);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
            return;
        }
    }

    private void addDatatype() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group group = null;
        group = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewDatatypeDialog newDatatypeDialog = new NewDatatypeDialog((JFrame)((Object)this.viewer), group, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        newDatatypeDialog.setVisible(true);
        HObject hObject = (HObject)newDatatypeDialog.getObject();
        if (hObject == null) {
            return;
        }
        Group group2 = newDatatypeDialog.getParentGroup();
        try {
            this.addObject(hObject, group2);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
            return;
        }
    }

    private void addLink() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group group = null;
        group = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewLinkDialog newLinkDialog = new NewLinkDialog((JFrame)((Object)this.viewer), group, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        newLinkDialog.setVisible(true);
        HObject hObject = (HObject)newLinkDialog.getObject();
        if (hObject == null) {
            return;
        }
        Group group2 = newLinkDialog.getParentGroup();
        try {
            this.addObject(hObject, group2);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
            return;
        }
    }

    private void renameObject() {
        if (this.selectedObject == null) {
            return;
        }
        if (this.selectedObject instanceof Group && ((Group)this.selectedObject).isRoot()) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Cannot rename the root.", "HDFView", 0);
            return;
        }
        boolean bl = this.selectedObject.getFileFormat().isThisType(FileFormat.getFileFormat("HDF4"));
        if (bl) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Cannot rename HDF4 object.", "HDFView", 0);
            return;
        }
        String string = this.selectedObject.getName();
        String string2 = JOptionPane.showInputDialog(this, "Rename \"" + string + "\" to:", "Rename...", 1);
        if (string2 == null) {
            return;
        }
        if ((string2 = string2.trim()) == null || string2.length() == 0 || string2.equals(string)) {
            return;
        }
        try {
            this.selectedObject.setName(string2);
        }
        catch (Exception exception) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, exception.getMessage(), "HDFView", 0);
        }
    }

    private void setLibVersionBounds() {
        Object[] objectArray = new Object[]{"Earliest", "Latest"};
        Object[] objectArray2 = new Object[]{"Latest"};
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        JComboBox<Object> jComboBox2 = new JComboBox<Object>(objectArray2);
        Object[] objectArray3 = new Object[]{"Earliest Version:", jComboBox, "Latest Version:", jComboBox2};
        Object[] objectArray4 = new Object[]{"Ok", "Cancel"};
        JOptionPane jOptionPane = new JOptionPane(objectArray3, -1, 2, null, objectArray4);
        JDialog jDialog = jOptionPane.createDialog(this, "Set the library version bounds: ");
        jDialog.setVisible(true);
        String string = null;
        try {
            string = (String)jOptionPane.getValue();
        }
        catch (Exception exception) {}
        if (string != null && string.equals("Ok")) {
            int n = -1;
            int n2 = 1;
            n = jComboBox.getSelectedItem().equals("Earliest") ? 0 : 1;
            try {
                this.selectedObject.getFileFormat().setLibBounds(n, n2);
            }
            catch (Throwable throwable) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, throwable, "Error when setting lib version bounds", 0);
                return;
            }
        } else {
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Close file")) {
            ((HDFView)this.viewer).actionPerformed(actionEvent);
        } else if (string.equals("Add group")) {
            this.addGroup();
        } else if (string.equals("Add dataset")) {
            this.addDataset();
        } else if (string.equals("Add image")) {
            this.addImage();
        } else if (string.equals("Add table")) {
            this.addTable();
        } else if (string.equals("Add datatype")) {
            this.addDatatype();
        } else if (string.equals("Add link")) {
            this.addLink();
        } else {
            if (string.startsWith("Open data")) {
                this.isDefaultDisplay = string.equals("Open data");
                try {
                    this.showDataContent(this.selectedObject);
                }
                catch (Throwable throwable) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, throwable, "HDFView", 0);
                    return;
                }
            }
            if (string.equals("Copy object")) {
                this.copyObject();
            } else if (string.equals("Paste object")) {
                this.pasteObject();
            } else if (string.equals("Cut object")) {
                this.removeSelectedObjects();
            } else if (string.equals("Move object")) {
                this.moveObject();
            } else if (string.equals("Save object to file")) {
                NewFileDialog newFileDialog;
                if (this.selectedObject == null) {
                    return;
                }
                if (this.selectedObject instanceof Group && ((Group)this.selectedObject).isRoot()) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Cannot save the root group.\nUse \"Save As\" from file menu to save the whole file", "HDFView", 0);
                    return;
                }
                String string2 = "HDF4";
                boolean bl = this.selectedObject.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5"));
                if (bl) {
                    string2 = "HDF5";
                }
                if (!(newFileDialog = new NewFileDialog((JFrame)((Object)this.viewer), this.selectedObject.getFileFormat().getParent(), string2, this.fileList)).isFileCreated()) {
                    return;
                }
                String string3 = newFileDialog.getFile();
                FileFormat fileFormat = null;
                try {
                    fileFormat = this.openFile(string3, 1);
                }
                catch (Exception exception) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, String.valueOf(exception.getMessage()) + "\n" + string3, "HDFView", 0);
                }
                Vector<Object> vector = new Vector<Object>(2);
                vector.add(this.selectedObject);
                this.pasteObject(vector, fileFormat.getRootNode(), fileFormat);
            } else if (string.equals("Rename object")) {
                this.renameObject();
            } else if (string.startsWith("Show object properties")) {
                this.isDefaultDisplay = string.equals("Show object properties");
                try {
                    this.showMetaData(this.selectedObject);
                }
                catch (Exception exception) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, exception, "HDFView", 0);
                }
            } else if (string.startsWith("Find")) {
                if (string.equals("Find")) {
                    String string4 = this.currentSearchPhrase;
                    if (string4 == null) {
                        string4 = "";
                    }
                    if ((string4 = (String)JOptionPane.showInputDialog(this, "Find (e.g. O3Quality, O3*, or *Quality):", "Find Object by Name", -1, null, null, string4)) != null && string4.length() > 0) {
                        this.currentSearchPhrase = string4;
                    }
                }
                DefaultTreeView.find(this.currentSearchPhrase, this.selectedTreePath, this.tree);
            } else if (string.startsWith("Expand all")) {
                int n = 0;
                while (n < this.tree.getRowCount()) {
                    this.tree.expandRow(n);
                    ++n;
                }
            } else if (string.startsWith("Collapse all")) {
                int n = this.tree.getRowCount() - 1;
                while (n >= 0) {
                    this.tree.collapseRow(n);
                    --n;
                }
            } else if (string.startsWith("Set Lib version bounds")) {
                this.setLibVersionBounds();
            }
        }
    }

    @Override
    public FileFormat openFile(String string, int n) throws Exception {
        FileFormat fileFormat = null;
        MutableTreeNode mutableTreeNode = null;
        if (this.isFileOpen(string)) {
            this.viewer.showStatus("File is in use");
            return null;
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new UnsupportedOperationException("File does not exist.");
        }
        if (!file.canWrite()) {
            n = 0;
        }
        Enumeration enumeration = FileFormat.getFileFormatKeys();
        String string2 = null;
        while (enumeration.hasMoreElements()) {
            FileFormat fileFormat2;
            string2 = (String)enumeration.nextElement();
            if (string2.equals("HDF4")) {
                try {
                    fileFormat2 = FileFormat.getFileFormat("HDF4");
                    if (fileFormat2 == null || !fileFormat2.isThisType(string)) continue;
                    fileFormat = fileFormat2.open(string, n);
                    break;
                }
                catch (Throwable throwable) {
                    continue;
                }
            }
            if (string2.equals("HDF5")) {
                try {
                    fileFormat2 = FileFormat.getFileFormat("HDF5");
                    if (fileFormat2 == null || !fileFormat2.isThisType(string)) continue;
                    fileFormat = fileFormat2.open(string, n);
                    break;
                }
                catch (Throwable throwable) {
                    continue;
                }
            }
            try {
                fileFormat2 = FileFormat.getFileFormat(string2);
                if (!fileFormat2.isThisType(string)) continue;
                fileFormat = fileFormat2.open(string, n);
                break;
            }
            catch (Throwable throwable) {}
        }
        if (fileFormat == null) {
            throw new IOException("Unsupported fileformat - " + string);
        }
        ((JFrame)((Object)this.viewer)).setCursor(Cursor.getPredefinedCursor(3));
        try {
            fileFormat.setMaxMembers(ViewProperties.getMaxMembers());
            fileFormat.setStartMembers(ViewProperties.getStartMembers());
            fileFormat.open();
        }
        finally {
            ((JFrame)((Object)this.viewer)).setCursor(Cursor.getPredefinedCursor(0));
        }
        mutableTreeNode = (MutableTreeNode)fileFormat.getRootNode();
        if (mutableTreeNode != null) {
            this.insertNode(mutableTreeNode, this.root);
            int n2 = this.tree.getRowCount();
            if (n2 > 0) {
                this.tree.expandRow(this.tree.getRowCount() - 1);
            }
            this.fileList.add(fileFormat);
        }
        return fileFormat;
    }

    @Override
    public void closeFile(FileFormat fileFormat) throws Exception {
        if (fileFormat == null) {
            return;
        }
        FileFormat fileFormat2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Enumeration<TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            Group group = (Group)defaultMutableTreeNode.getUserObject();
            fileFormat2 = group.getFileFormat();
            if (!fileFormat2.equals(fileFormat)) continue;
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
            try {
                fileFormat2.close();
            }
            catch (Exception exception) {}
            this.fileList.remove(fileFormat2);
            if (!fileFormat2.equals(this.selectedFile)) break;
            this.selectedFile = null;
            this.selectedNode = null;
            break;
        }
    }

    @Override
    public void saveFile(FileFormat fileFormat) throws Exception {
        if (fileFormat == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Select a file to save.", "HDFView", 0);
            return;
        }
        boolean bl = fileFormat.isThisType(FileFormat.getFileFormat("HDF4"));
        boolean bl2 = fileFormat.isThisType(FileFormat.getFileFormat("HDF5"));
        if (!bl && !bl2) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Saving file is not supported for this file type", "HDFView", 0);
            return;
        }
        List<JInternalFrame> list = ((HDFView)this.viewer).getDataViews();
        JInternalFrame jInternalFrame = null;
        TableView tableView = null;
        TextView textView = null;
        FileFormat fileFormat2 = null;
        if (list != null) {
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                jInternalFrame = list.get(n2);
                if (jInternalFrame instanceof TableView) {
                    tableView = (TableView)((Object)jInternalFrame);
                    fileFormat2 = tableView.getDataObject().getFileFormat();
                    if (fileFormat.equals(fileFormat2)) {
                        tableView.updateValueInFile();
                    }
                } else if (jInternalFrame instanceof TextView && fileFormat.equals(fileFormat2 = (textView = (TextView)((Object)jInternalFrame)).getDataObject().getFileFormat())) {
                    textView.updateValueInFile();
                }
                ++n2;
            }
        }
        if (bl2) {
            this.saveAsHDF5(fileFormat);
        } else if (bl) {
            this.saveAsHDF4(fileFormat);
        }
    }

    @Override
    public FileFormat getSelectedFile() {
        return this.selectedFile;
    }

    public List<Object> getSelectedObjects() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length <= 0) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>(treePathArray.length);
        HObject hObject = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int n = 0;
        while (n < treePathArray.length) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[n].getLastPathComponent();
            hObject = (HObject)defaultMutableTreeNode.getUserObject();
            if (hObject != null) {
                vector.add(hObject);
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                HObject hObject2 = (HObject)defaultMutableTreeNode2.getUserObject();
                vector.remove(hObject2);
            }
            ++n;
        }
        return vector;
    }

    @Override
    public HObject getCurrentObject() {
        return this.selectedObject;
    }

    @Override
    public DataView showDataContent(HObject hObject) throws Exception {
        Object[] objectArray;
        Serializable serializable;
        if (hObject == null || !(hObject instanceof Dataset)) {
            return null;
        }
        Dataset dataset = (Dataset)hObject;
        if (dataset.getRank() <= 0) {
            dataset.init();
        }
        boolean bl = dataset instanceof ScalarDS && ((ScalarDS)dataset).isText();
        boolean bl2 = dataset instanceof ScalarDS && ((ScalarDS)dataset).isImage();
        boolean bl3 = false;
        boolean bl4 = false;
        BitSet bitSet = null;
        String string = null;
        JInternalFrame jInternalFrame = (JInternalFrame)((Object)this.viewer.getDataView(dataset));
        if (this.isDefaultDisplay) {
            if (jInternalFrame != null) {
                jInternalFrame.toFront();
                return null;
            }
            string = bl ? (String)HDFView.getListOfTextView().get(0) : (bl2 ? HDFView.getListOfImageView().get(0) : (String)HDFView.getListOfTableView().get(0));
        } else {
            serializable = new DataOptionDialog(this.viewer, dataset);
            ((Dialog)serializable).setVisible(true);
            if (((DataOptionDialog)serializable).isCancelled()) {
                return null;
            }
            bl2 = ((DataOptionDialog)serializable).isImageDisplay();
            bl3 = ((DataOptionDialog)serializable).isDisplayTypeChar();
            string = ((DataOptionDialog)serializable).getDataViewName();
            bl4 = ((DataOptionDialog)serializable).isTransposed();
            bitSet = ((DataOptionDialog)serializable).getBitmask();
        }
        serializable = null;
        try {
            serializable = Class.forName(string);
        }
        catch (Exception exception) {
            try {
                serializable = ViewProperties.loadExtClass().loadClass(string);
            }
            catch (Exception exception2) {
                serializable = null;
            }
        }
        if (serializable == null) {
            string = bl ? "ncsa.hdf.view.DefaultTextView" : (bl2 ? "ncsa.hdf.view.DefaultImageView" : "ncsa.hdf.view.DefaultTableView");
            try {
                serializable = Class.forName(string);
            }
            catch (Exception exception) {}
        }
        Object object = null;
        Object[] objectArray2 = new Object[]{this.viewer};
        HashMap<ViewProperties.DATA_VIEW_KEY, Object> hashMap = new HashMap<ViewProperties.DATA_VIEW_KEY, Object>(4);
        if (bitSet != null) {
            hashMap.put(ViewProperties.DATA_VIEW_KEY.BITMASK, bitSet);
            objectArray = null;
            Constructor<?> constructor = null;
            Object[] objectArray3 = null;
            try {
                Class[] classArray = new Class[]{FileFormat.class, String.class, String.class, long[].class};
                constructor = dataset.getClass().getConstructor(classArray);
                objectArray3 = new Object[]{dataset.getFileFormat(), dataset.getName(), dataset.getPath(), dataset.getOID()};
            }
            catch (Exception exception) {
                constructor = null;
            }
            try {
                objectArray = (Object[])constructor.newInstance(objectArray3);
            }
            catch (Exception exception) {
                objectArray = null;
            }
            if (objectArray != null) {
                try {
                    objectArray.init();
                    int n = dataset.getRank();
                    System.arraycopy(dataset.getDims(), 0, objectArray.getDims(), 0, n);
                    System.arraycopy(dataset.getStartDims(), 0, objectArray.getStartDims(), 0, n);
                    System.arraycopy(dataset.getSelectedDims(), 0, objectArray.getSelectedDims(), 0, n);
                    System.arraycopy(dataset.getStride(), 0, objectArray.getStride(), 0, n);
                    System.arraycopy(dataset.getSelectedIndex(), 0, objectArray.getSelectedIndex(), 0, 3);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                hashMap.put(ViewProperties.DATA_VIEW_KEY.OBJECT, objectArray);
            }
        }
        if (string.startsWith("ncsa.hdf.view.DefaultTableView")) {
            hashMap.put(ViewProperties.DATA_VIEW_KEY.CHAR, new Boolean(bl3));
            hashMap.put(ViewProperties.DATA_VIEW_KEY.TRANSPOSED, new Boolean(bl4));
            objectArray = new Object[]{this.viewer, hashMap};
            objectArray2 = objectArray;
        } else if (string.startsWith("ncsa.hdf.view.DefaultImageView")) {
            hashMap.put(ViewProperties.DATA_VIEW_KEY.CONVERTBYTE, new Boolean(bitSet != null));
            objectArray = new Object[]{this.viewer, hashMap};
            objectArray2 = objectArray;
        }
        ((JFrame)((Object)this.viewer)).setCursor(Cursor.getPredefinedCursor(3));
        try {
            object = Tools.newInstance(serializable, objectArray2);
            this.viewer.addDataView((DataView)object);
        }
        finally {
            ((JFrame)((Object)this.viewer)).setCursor(Cursor.getPredefinedCursor(0));
        }
        return (DataView)object;
    }

    @Override
    public MetaDataView showMetaData(HObject hObject) throws Exception {
        if (hObject == null) {
            return null;
        }
        List list = HDFView.getListOfMetaDataView();
        if (list == null || list.size() <= 0) {
            return null;
        }
        int n = list.size();
        String string = (String)list.get(0);
        if (!this.isDefaultDisplay && n > 1) {
            string = (String)JOptionPane.showInputDialog(this, "Select MetaDataView", "HDFView", 1, null, list.toArray(), string);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            clazz = ViewProperties.loadExtClass().loadClass(string);
        }
        Object[] objectArray = new Object[]{this.viewer};
        MetaDataView metaDataView = (MetaDataView)Tools.newInstance(clazz, objectArray);
        return metaDataView;
    }

    @Override
    public void addObject(HObject hObject, Group group) throws Exception {
        if (hObject == null || group == null) {
            return;
        }
        TreeNode treeNode = this.findTreeNode(group);
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        defaultMutableTreeNode = hObject instanceof Group ? new DefaultMutableTreeNode(hObject){
            public static final long serialVersionUID = 240L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        } : new DefaultMutableTreeNode(hObject);
        this.treeModel.insertNodeInto(defaultMutableTreeNode, (DefaultMutableTreeNode)treeNode, treeNode.getChildCount());
    }

    @Override
    public JTree getTree() {
        return this.tree;
    }

    @Override
    public List<FileFormat> getCurrentFiles() {
        return this.fileList;
    }

    @Override
    public TreeNode findTreeNode(HObject hObject) {
        if (hObject == null) {
            return null;
        }
        TreeNode treeNode = hObject.getFileFormat().getRootNode();
        if (treeNode == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        HObject hObject2 = null;
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)treeNode).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            hObject2 = (HObject)defaultMutableTreeNode.getUserObject();
            if (hObject2 == null || !hObject2.equals(hObject)) continue;
            return defaultMutableTreeNode;
        }
        return null;
    }

    private class HTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public static final long serialVersionUID = 240L;
        private Icon h4Icon;
        private Icon h5Icon;
        private Icon datasetIcon;
        private Icon imageIcon;
        private Icon tableIcon;
        private Icon textIcon;
        private Icon openFolder = ViewProperties.getFolderopenIcon();
        private Icon closeFolder = ViewProperties.getFoldercloseIcon();
        private Icon datasetIconA;
        private Icon imageIconA;
        private Icon tableIconA;
        private Icon textIconA;
        private Icon openFolderA;
        private Icon closeFolderA;
        private Icon datatypeIcon;
        private Icon datatypeIconA;
        private Icon questionIcon;

        private HTreeCellRenderer() {
            this.datasetIcon = ViewProperties.getDatasetIcon();
            this.imageIcon = ViewProperties.getImageIcon();
            this.h4Icon = ViewProperties.getH4Icon();
            this.h5Icon = ViewProperties.getH5Icon();
            this.tableIcon = ViewProperties.getTableIcon();
            this.textIcon = ViewProperties.getTextIcon();
            this.openFolderA = ViewProperties.getFolderopenIconA();
            this.closeFolderA = ViewProperties.getFoldercloseIconA();
            this.datasetIconA = ViewProperties.getDatasetIconA();
            this.imageIconA = ViewProperties.getImageIconA();
            this.tableIconA = ViewProperties.getTableIconA();
            this.textIconA = ViewProperties.getTextIconA();
            this.datatypeIcon = ViewProperties.getDatatypeIcon();
            this.datatypeIconA = ViewProperties.getDatatypeIconA();
            this.questionIcon = ViewProperties.getQuestionIcon();
            if (this.openFolder != null) {
                this.openIcon = this.openFolder;
            } else {
                this.openFolder = this.openIcon;
            }
            if (this.closeFolder != null) {
                this.closedIcon = this.closeFolder;
            } else {
                this.closeFolder = this.closedIcon;
            }
            if (this.datasetIcon == null) {
                this.datasetIcon = this.leafIcon;
            }
            if (this.imageIcon == null) {
                this.imageIcon = this.leafIcon;
            }
            if (this.tableIcon == null) {
                this.tableIcon = this.leafIcon;
            }
            if (this.textIcon == null) {
                this.textIcon = this.leafIcon;
            }
            if (this.h4Icon == null) {
                this.h4Icon = this.leafIcon;
            }
            if (this.h5Icon == null) {
                this.h5Icon = this.leafIcon;
            }
            if (this.datatypeIcon == null) {
                this.datatypeIcon = this.leafIcon;
            }
            if (this.questionIcon == null) {
                this.questionIcon = this.leafIcon;
            }
            if (this.openFolderA == null) {
                this.openFolderA = this.openFolder;
            }
            if (this.closeFolderA == null) {
                this.closeFolderA = this.closeFolder;
            }
            if (this.datasetIconA == null) {
                this.datasetIconA = this.datasetIcon;
            }
            if (this.imageIconA == null) {
                this.imageIconA = this.imageIcon;
            }
            if (this.tableIconA == null) {
                this.tableIconA = this.tableIcon;
            }
            if (this.textIconA == null) {
                this.textIconA = this.textIcon;
            }
            if (this.datatypeIconA == null) {
                this.datatypeIconA = this.datatypeIcon;
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            HObject hObject = (HObject)((DefaultMutableTreeNode)object).getUserObject();
            boolean bl5 = false;
            if (hObject instanceof Dataset) {
                if (hObject instanceof ScalarDS) {
                    ScalarDS scalarDS = (ScalarDS)hObject;
                    bl5 = scalarDS.hasAttribute();
                    this.leafIcon = scalarDS.isImage() ? (bl5 ? this.imageIconA : this.imageIcon) : (scalarDS.isText() ? (bl5 ? this.textIconA : this.textIcon) : (bl5 ? this.datasetIconA : this.datasetIcon));
                } else if (hObject instanceof CompoundDS) {
                    this.leafIcon = hObject.hasAttribute() ? this.tableIconA : this.tableIcon;
                }
            } else if (hObject instanceof Group) {
                Group group = (Group)hObject;
                if (group.hasAttribute()) {
                    this.openIcon = this.openFolderA;
                    this.closedIcon = this.closeFolderA;
                } else {
                    this.openIcon = this.openFolder;
                    this.closedIcon = this.closeFolder;
                }
                if (group.isRoot()) {
                    if (group.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5"))) {
                        this.openIcon = this.closedIcon = this.h5Icon;
                    } else if (group.getFileFormat().isThisType(FileFormat.getFileFormat("HDF4"))) {
                        this.openIcon = this.closedIcon = this.h4Icon;
                    }
                }
            } else {
                Datatype datatype;
                this.leafIcon = hObject instanceof Datatype ? ((datatype = (Datatype)hObject).hasAttribute() ? this.datatypeIconA : this.datatypeIcon) : this.questionIcon;
            }
            return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }
    }

    private class HTreeMouseAdapter
    extends MouseAdapter {
        private HTreeMouseAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            TreePath treePath = DefaultTreeView.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (!defaultMutableTreeNode.equals(DefaultTreeView.this.selectedNode)) {
                DefaultTreeView.this.selectedTreePath = treePath;
                DefaultTreeView.this.selectedNode = defaultMutableTreeNode;
                DefaultTreeView.this.selectedObject = (HObject)DefaultTreeView.this.selectedNode.getUserObject();
                FileFormat fileFormat = DefaultTreeView.this.selectedObject.getFileFormat();
                if (fileFormat != null && !fileFormat.equals(DefaultTreeView.this.selectedFile)) {
                    DefaultTreeView.this.selectedFile = fileFormat;
                    DefaultTreeView.this.tree.clearSelection();
                    DefaultTreeView.this.tree.setSelectionPath(treePath);
                }
                DefaultTreeView.this.viewer.mouseEventFired(mouseEvent);
            }
            int n = mouseEvent.getModifiers();
            if (mouseEvent.isPopupTrigger() || n == 4 || System.getProperty("os.name").startsWith("Mac") && n == 18) {
                int n2 = DefaultTreeView.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (!DefaultTreeView.this.tree.isRowSelected(n2)) {
                    DefaultTreeView.this.tree.clearSelection();
                    DefaultTreeView.this.tree.setSelectionRow(n2);
                }
                DefaultTreeView.this.showPopupMenu(mouseEvent);
            } else if (mouseEvent.getClickCount() == 2) {
                DefaultTreeView.this.isDefaultDisplay = true;
                try {
                    DefaultTreeView.this.showDataContent(DefaultTreeView.this.selectedObject);
                }
                catch (Exception exception) {}
            }
        }
    }
}

