/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.CellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.ImageView;
import ncsa.hdf.view.PaletteView;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DefaultPaletteView
extends JDialog
implements PaletteView,
MouseListener,
MouseMotionListener,
ActionListener,
ItemListener {
    public static final long serialVersionUID = 240L;
    private final Color[] lineColors = new Color[]{Color.red, Color.green, Color.blue};
    private final String[] lineLabels = new String[]{"Red", "Green", "Blue"};
    private static String PALETTE_GRAY = "Gray";
    private static String PALETTE_DEFAULT = "Default";
    private static String PALETTE_REVERSE_GRAY = "Reverse Gray";
    private static String PALETTE_GRAY_WAVE = "GrayWave";
    private static String PALETTE_RAINBOW = "Rainbow";
    private static String PALETTE_NATURE = "Nature";
    private static String PALETTE_WAVE = "Wave";
    private JRadioButton checkRed;
    private JRadioButton checkGreen;
    private JRadioButton checkBlue;
    private ChartPanel chartP;
    private int x0;
    private int y0;
    private Image originalImage;
    private Image currentImage;
    boolean isPaletteChanged = false;
    byte[][] palette;
    private ScalarDS dataset;
    private ImageView imageView;
    private int[][] paletteData;
    private JComboBox choicePalette;
    private PaletteValueTable paletteValueTable;
    private int numberOfPalettes;

    public DefaultPaletteView(ImageView imageView) {
        this(null, imageView);
    }

    public DefaultPaletteView(ViewManager viewManager, ImageView imageView) {
        super((Frame)((JFrame)((Object)viewManager)), true);
        byte[] byArray;
        this.setDefaultCloseOperation(2);
        this.imageView = imageView;
        this.dataset = (ScalarDS)this.imageView.getDataObject();
        this.numberOfPalettes = 1;
        this.choicePalette = new JComboBox();
        this.choicePalette.addItemListener(this);
        this.choicePalette.addItem("Select palette");
        String string = this.dataset.getPaletteName(0);
        this.choicePalette.addItem(string);
        boolean bl = this.dataset.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5"));
        if (bl && this.dataset instanceof ScalarDS && (byArray = this.dataset.getPaletteRefs()) != null && byArray.length > 8) {
            this.numberOfPalettes = byArray.length / 8;
        }
        int n = 2;
        while (n <= this.numberOfPalettes) {
            string = this.dataset.getPaletteName(n - 1);
            this.choicePalette.addItem(string);
            ++n;
        }
        this.choicePalette.addItem(PALETTE_GRAY);
        this.choicePalette.addItem(PALETTE_GRAY_WAVE);
        this.choicePalette.addItem(PALETTE_RAINBOW);
        this.choicePalette.addItem(PALETTE_NATURE);
        this.choicePalette.addItem(PALETTE_WAVE);
        Vector<String> vector = ViewProperties.getPaletteList();
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            this.choicePalette.addItem(vector.get(n3));
            ++n3;
        }
        this.chartP = new ChartPanel();
        this.chartP.setBackground(Color.white);
        this.paletteData = new int[3][256];
        byte[][] byArray2 = this.imageView.getPalette();
        this.setTitle("Image Palette for - " + this.dataset.getPath() + this.dataset.getName());
        int n4 = 0;
        int n5 = 0;
        while (n5 < 3) {
            int n6 = 0;
            while (n6 < 256) {
                n4 = byArray2[n5][n6];
                if (n4 < 0) {
                    n4 += 256;
                }
                this.paletteData[n5][n6] = n4;
                ++n6;
            }
            ++n5;
        }
        this.imageView = imageView;
        this.chartP.addMouseListener(this);
        this.chartP.addMouseMotionListener(this);
        this.y0 = 0;
        this.x0 = 0;
        this.originalImage = this.currentImage = this.imageView.getImage();
        this.palette = new byte[3][256];
        this.createUI();
        this.setVisible(true);
    }

    @Override
    public HObject getDataObject() {
        return this.dataset;
    }

    private void createUI() {
        Window window = this.getOwner();
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        int n = 700 + (ViewProperties.getFontSize() - 12) * 15;
        int n2 = 500 + (ViewProperties.getFontSize() - 12) * 10;
        jPanel.setPreferredSize(new Dimension(n, n2));
        jPanel.add((Component)this.chartP, "Center");
        JButton jButton = new JButton("  Ok  ");
        jButton.addActionListener(this);
        jButton.setActionCommand("Ok");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new LineBorder(Color.GRAY));
        jPanel2.add(jButton);
        jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        jButton.setActionCommand("Cancel");
        jPanel2.add(jButton);
        jButton = new JButton("Preview");
        jButton.addActionListener(this);
        jButton.setActionCommand("Preview");
        jPanel2.add(jButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(20, 2));
        jPanel3.add((Component)jPanel2, "East");
        this.checkRed = new JRadioButton("Red");
        this.checkRed.setForeground(Color.red);
        this.checkGreen = new JRadioButton("Green");
        this.checkGreen.setForeground(Color.green);
        this.checkBlue = new JRadioButton("Blue");
        this.checkBlue.setForeground(Color.blue);
        this.checkRed.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.checkRed);
        buttonGroup.add(this.checkGreen);
        buttonGroup.add(this.checkBlue);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(new LineBorder(Color.GRAY));
        jPanel4.add(this.checkRed);
        jPanel4.add(this.checkGreen);
        jPanel4.add(this.checkBlue);
        jPanel3.add((Component)jPanel4, "West");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 2));
        jPanel5.setBorder(new LineBorder(Color.GRAY));
        JButton jButton2 = new JButton("Show Values");
        jButton2.setActionCommand("Show palette values");
        jButton2.addActionListener(this);
        jPanel5.add(this.choicePalette);
        jPanel5.add(jButton2);
        jPanel3.add((Component)jPanel5, "Center");
        jPanel.add((Component)jPanel3, "South");
        Point point = window.getLocation();
        point.x += 350;
        point.y += 200;
        this.setLocation(point);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Ok")) {
            if (this.isPaletteChanged) {
                this.updatePalette();
                this.isPaletteChanged = false;
                this.imageView.setPalette(this.palette);
                this.imageView.setImage(this.currentImage);
            }
            super.dispose();
        } else if (string.equals("Cancel")) {
            this.imageView.setImage(this.originalImage);
            super.dispose();
        } else if (string.equals("Preview")) {
            this.updatePalette();
            this.imageView.setImage(this.currentImage);
        } else if (string.equals("Show palette values")) {
            if (this.paletteValueTable == null) {
                this.paletteValueTable = new PaletteValueTable(this);
            }
            this.paletteValueTable.refresh();
            this.paletteValueTable.setVisible(true);
        } else if (string.equals("Hide palette values") && this.paletteValueTable != null) {
            this.paletteValueTable.setVisible(false);
        }
    }

    @Override
    public void dispose() {
        this.imageView.setImage(this.originalImage);
        super.dispose();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (!object.equals(this.choicePalette)) {
            return;
        }
        int n = this.choicePalette.getSelectedIndex();
        if (n <= 0) {
            return;
        }
        byte[][] byArray = null;
        Object object2 = this.choicePalette.getSelectedItem();
        if (object2.equals(PALETTE_DEFAULT)) {
            byArray = this.dataset.getPalette();
        } else if (object2.equals(PALETTE_GRAY)) {
            byArray = Tools.createGrayPalette();
        } else if (object2.equals(PALETTE_REVERSE_GRAY)) {
            byArray = Tools.createReverseGrayPalette();
        } else if (object2.equals(PALETTE_GRAY_WAVE)) {
            byArray = Tools.createGrayWavePalette();
        } else if (object2.equals(PALETTE_RAINBOW)) {
            byArray = Tools.createRainbowPalette();
        } else if (object2.equals(PALETTE_NATURE)) {
            byArray = Tools.createNaturePalette();
        } else if (object2.equals(PALETTE_WAVE)) {
            byArray = Tools.createWavePalette();
        } else {
            byte[][] byArray2 = null;
            if (n > 0 && n <= this.numberOfPalettes) {
                byArray2 = this.dataset.readPalette(n - 1);
            }
            if (byArray2 != null) {
                byArray = byArray2;
            }
        }
        if (byArray == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < 3) {
            int n4 = 0;
            while (n4 < 256) {
                n2 = byArray[n3][n4];
                if (n2 < 0) {
                    n2 += 256;
                }
                this.paletteData[n3][n4] = n2;
                ++n4;
            }
            ++n3;
        }
        this.chartP.repaint();
        this.isPaletteChanged = true;
    }

    private void updatePalette() {
        int n = 0;
        while (n < 256) {
            this.palette[0][n] = (byte)this.paletteData[0][n];
            this.palette[1][n] = (byte)this.paletteData[1][n];
            this.palette[2][n] = (byte)this.paletteData[2][n];
            ++n;
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, this.palette[0], this.palette[1], this.palette[2]);
        int n2 = this.dataset.getWidth();
        int n3 = this.dataset.getHeight();
        MemoryImageSource memoryImageSource = null;
        try {
            memoryImageSource = (MemoryImageSource)this.originalImage.getSource();
        }
        catch (Throwable throwable) {
            memoryImageSource = null;
        }
        if (memoryImageSource == null) {
            memoryImageSource = new MemoryImageSource(n2, n3, (ColorModel)indexColorModel, this.imageView.getImageByteData(), 0, n2);
        } else {
            memoryImageSource.newPixels(this.imageView.getImageByteData(), (ColorModel)indexColorModel, 0, n2);
        }
        this.currentImage = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.paletteValueTable != null && this.paletteValueTable.isVisible()) {
            this.paletteValueTable.refresh();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - 40;
        if (n < 0) {
            n = 0;
        }
        int n2 = mouseEvent.getY() + 20;
        Dimension dimension = this.chartP.getSize();
        double d = 255.0 / (double)dimension.height;
        double d2 = 255.0 / (double)dimension.width;
        int n3 = 0;
        if (this.checkGreen.isSelected()) {
            n3 = 1;
        } else if (this.checkBlue.isSelected()) {
            n3 = 2;
        }
        int n4 = 0;
        double d3 = (double)(n2 - this.y0) / (double)(n - this.x0);
        double d4 = (double)this.y0 - d3 * (double)this.x0;
        double d5 = (double)this.y0 * d;
        int n5 = Math.min(this.x0, n);
        int n6 = Math.max(this.x0, n);
        int n7 = n5;
        while (n7 < n6) {
            n4 = (int)(d2 * (double)n7);
            if (n4 <= 255) {
                d5 = 255.0 - (d4 + d3 * (double)n7) * d;
                if (d5 < 0.0) {
                    d5 = 0.0;
                } else if (d5 > 255.0) {
                    d5 = 255.0;
                }
                this.paletteData[n3][n4] = (int)d5;
            }
            ++n7;
        }
        this.chartP.repaint();
        this.isPaletteChanged = true;
    }

    private final class ChartPanel
    extends JComponent {
        public static final long serialVersionUID = 240L;

        private ChartPanel() {
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = 20;
            int n2 = 60;
            int n3 = dimension.height - n;
            int n4 = dimension.width - 3 * n - n2;
            graphics.drawLine(2 * n, n3, n4 + 2 * n, n3);
            graphics.drawLine(2 * n, n3, 2 * n, 0);
            int n5 = n3 / 10;
            int n6 = n4 / 10;
            int n7 = 25;
            double d = 25.0;
            int n8 = 2 * n;
            int n9 = 0;
            int n10 = 0;
            double d2 = 0.0;
            graphics.drawString(String.valueOf((int)d2), 0, n3 + 8);
            graphics.drawString(String.valueOf(n10), n8 - 5, n3 + n);
            int n11 = 0;
            while (n11 < 10) {
                graphics.drawLine(n8 += n6, n3, n8, n3 - 5);
                graphics.drawLine(2 * n, n3 - (n9 += n5), 2 * n + 5, n3 - n9);
                graphics.drawString(String.valueOf((int)(d2 += d)), 0, n3 - n9 + 8);
                graphics.drawString(String.valueOf(n10 += n7), n8 - 5, n3 + n);
                ++n11;
            }
            Color color = graphics.getColor();
            int n12 = 0;
            while (n12 < 3) {
                int n13;
                int n14;
                graphics.setColor(DefaultPaletteView.this.lineColors[n12]);
                int n15 = 0;
                while (n15 < 255) {
                    n14 = n4 * n15 / 255 + 2 * n;
                    n13 = n3 - n3 * DefaultPaletteView.this.paletteData[n12][n15] / 255;
                    int n16 = n4 * (n15 + 1) / 255 + 2 * n;
                    int n17 = n3 - n3 * DefaultPaletteView.this.paletteData[n12][n15 + 1] / 255;
                    graphics.drawLine(n14, n13, n16, n17);
                    ++n15;
                }
                n14 = n4 + n2;
                n13 = n + n * n12;
                graphics.drawLine(n14, n13, n14 + 7, n13);
                graphics.drawString(DefaultPaletteView.this.lineLabels[n12], n14 + 10, n13 + 3);
                ++n12;
            }
            graphics.setColor(color);
            graphics.drawRect(n4 + n2 - 10, 10, n2, 10 * n);
        }
    }

    private final class PaletteValueTable
    extends JDialog {
        public static final long serialVersionUID = 240L;
        private JTable valueTable;
        private DefaultTableModel valueTableModel;
        String rgbName;
        String idxName;
        private final boolean[] startEditing;

        public PaletteValueTable(DefaultPaletteView defaultPaletteView2) {
            super(defaultPaletteView2);
            this.rgbName = "Color";
            this.idxName = "Index";
            this.startEditing = new boolean[1];
            Object[] objectArray = new String[]{this.idxName, "Red", "Green", "Blue", this.rgbName};
            this.valueTableModel = new DefaultTableModel(objectArray, 256);
            this.valueTable = new JTable(this.valueTableModel){
                public static final long serialVersionUID = 240L;

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return n2 > 0 && n2 < 4;
                }

                @Override
                public Object getValueAt(int n, int n2) {
                    if (PaletteValueTable.this.startEditing[0]) {
                        return "";
                    }
                    if (n2 == 0) {
                        return String.valueOf(n);
                    }
                    if (n2 < 4) {
                        return String.valueOf(DefaultPaletteView.this.paletteData[n2 - 1][n]);
                    }
                    return "";
                }

                @Override
                public boolean editCellAt(int n, int n2, EventObject eventObject) {
                    KeyEvent keyEvent;
                    if (!this.isCellEditable(n, n2)) {
                        return super.editCellAt(n, n2, eventObject);
                    }
                    if (eventObject instanceof KeyEvent && (keyEvent = (KeyEvent)eventObject).getID() == 401) {
                        ((PaletteValueTable)PaletteValueTable.this).startEditing[0] = true;
                    }
                    return super.editCellAt(n, n2, eventObject);
                }

                @Override
                public void editingStopped(ChangeEvent changeEvent) {
                    int n;
                    int n2 = this.getEditingRow();
                    if (!this.isCellEditable(n2, n = this.getEditingColumn())) {
                        return;
                    }
                    String string = (String)this.getValueAt(n2, n);
                    super.editingStopped(changeEvent);
                    ((PaletteValueTable)PaletteValueTable.this).startEditing[0] = false;
                    Object object = changeEvent.getSource();
                    if (object instanceof CellEditor) {
                        CellEditor cellEditor = (CellEditor)object;
                        String string2 = (String)cellEditor.getCellEditorValue();
                        this.setValueAt(string, n2, n);
                        PaletteValueTable.this.updatePaletteValue(string2, n2, n - 1);
                    }
                }
            };
            this.valueTable.getColumn(this.rgbName).setCellRenderer(new DefaultTableCellRenderer(){
                public static final long serialVersionUID = 240L;
                Color color = Color.white;

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    this.color = new Color(DefaultPaletteView.this.paletteData[0][n], DefaultPaletteView.this.paletteData[1][n], DefaultPaletteView.this.paletteData[2][n]);
                    component.setBackground(this.color);
                    return component;
                }
            });
            this.valueTable.getColumn(this.idxName).setCellRenderer(new DefaultTableCellRenderer(){
                public static final long serialVersionUID = 240L;

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    component.setBackground(Color.LIGHT_GRAY);
                    return component;
                }
            });
            this.valueTable.setRowSelectionAllowed(false);
            this.valueTable.setCellSelectionEnabled(true);
            this.valueTable.getTableHeader().setReorderingAllowed(false);
            this.valueTable.setSelectionMode(0);
            int n = Math.max(16, this.valueTable.getFontMetrics(this.valueTable.getFont()).getHeight());
            this.valueTable.setRowHeight(n);
            JScrollPane jScrollPane = new JScrollPane(this.valueTable);
            JPanel jPanel = (JPanel)this.getContentPane();
            int n2 = 300 + (ViewProperties.getFontSize() - 12) * 10;
            int n3 = 600 + (ViewProperties.getFontSize() - 12) * 15;
            jPanel.setPreferredSize(new Dimension(n2, n3));
            jPanel.setLayout(new BorderLayout(5, 5));
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel.add((Component)jScrollPane, "Center");
            JButton jButton = new JButton("  Ok  ");
            jButton.addActionListener(defaultPaletteView2);
            jButton.setActionCommand("Hide palette values");
            JPanel jPanel2 = new JPanel();
            jPanel2.add(jButton);
            jPanel.add((Component)jPanel2, "South");
            Point point = defaultPaletteView2.getLocation();
            point.x += 100;
            point.y += 100;
            this.setLocation(point);
            this.pack();
        }

        private void updatePaletteValue(String string, int n, int n2) {
            if (string == null) {
                return;
            }
            int n3 = 0;
            try {
                n3 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                return;
            }
            if (n3 < 0 || n3 > 255) {
                JOptionPane.showMessageDialog(this, "Value is out of range [0, 255]\n", this.getTitle(), 0);
                return;
            }
            ((DefaultPaletteView)DefaultPaletteView.this).paletteData[n2][n] = n3;
            DefaultPaletteView.this.chartP.repaint();
            DefaultPaletteView.this.isPaletteChanged = true;
        }

        public void refresh() {
            this.valueTable.editingStopped(new ChangeEvent(this.valueTable));
            this.valueTable.updateUI();
        }
    }
}

