/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.CellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.HDFView;
import ncsa.hdf.view.MetaDataView;
import ncsa.hdf.view.NewAttributeDialog;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DefaultMetaDataView
extends JDialog
implements ActionListener,
MetaDataView {
    public static final long serialVersionUID = 240L;
    private ViewManager viewer;
    private HObject hObject;
    private JTabbedPane tabbedPane = null;
    private JTextArea attrContentArea;
    private JTable attrTable;
    private DefaultTableModel attrTableModel;
    private JLabel attrNumberLabel;
    private int numAttributes;
    private boolean isH5;
    private boolean isH4;
    private byte[] userBlock;
    private JTextArea userBlockArea;
    private JButton jamButton;
    private JTextField linkField = null;
    private FileFormat fileFormat;
    private String LinkTObjName;
    private int[] libver;

    public DefaultMetaDataView(ViewManager viewManager) {
        super((Frame)((JFrame)((Object)viewManager)), false);
        boolean bl;
        this.setDefaultCloseOperation(2);
        this.viewer = viewManager;
        this.hObject = this.viewer.getTreeView().getCurrentObject();
        this.fileFormat = this.hObject.getFileFormat();
        this.numAttributes = 0;
        this.userBlock = null;
        this.userBlockArea = null;
        this.libver = new int[2];
        if (this.hObject == null) {
            this.dispose();
        } else if (this.hObject.getPath() == null) {
            this.setTitle("Properties - " + this.hObject.getName());
        } else {
            this.setTitle("Properties - " + this.hObject.getPath() + this.hObject.getName());
        }
        this.isH5 = this.hObject.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5"));
        this.isH4 = this.hObject.getFileFormat().isThisType(FileFormat.getFileFormat("HDF4"));
        this.tabbedPane = new JTabbedPane();
        try {
            this.hObject.getMetadata();
        }
        catch (Exception exception) {}
        this.tabbedPane.addTab("General", this.createGeneralPropertyPanel());
        this.tabbedPane.addTab("Attributes", this.createAttributePanel());
        boolean bl2 = bl = this.hObject instanceof Group && ((Group)this.hObject).isRoot();
        if (this.isH5 && bl) {
            this.tabbedPane.addTab("User Block", this.createUserBlockPanel());
        }
        this.tabbedPane.setSelectedIndex(0);
        if (this.isH5 && this.hObject.getLinkTargetObjName() != null) {
            this.LinkTObjName = this.hObject.getLinkTargetObjName();
        }
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("  Close  ");
        jButton.setMnemonic(67);
        jButton.setActionCommand("Close");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        JPanel jPanel2 = (JPanel)this.getContentPane();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.setPreferredSize(new Dimension(620, 400));
        jPanel2.add("Center", this.tabbedPane);
        jPanel2.add("South", jPanel);
        Point point = this.getParent().getLocation();
        point.x += 250;
        point.y += 80;
        this.setLocation(point);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Close")) {
            if (this.isH5 && this.linkField != null) {
                this.checkLinkTargetChanged();
            }
            this.dispose();
        } else if (string.equals("Add attribute")) {
            this.addAttribute(this.hObject);
        } else if (string.equals("Delete attribute")) {
            this.deleteAttribute(this.hObject);
        } else if (string.equals("Jam user block")) {
            this.writeUserBlock();
        } else if (string.equals("Display user block as")) {
            int n = 0;
            String string2 = (String)((JComboBox)object).getSelectedItem();
            this.jamButton.setEnabled(false);
            this.userBlockArea.setEditable(false);
            if (string2.equalsIgnoreCase("Text")) {
                n = 0;
                this.jamButton.setEnabled(true);
                this.userBlockArea.setEditable(true);
            } else if (string2.equalsIgnoreCase("Binary")) {
                n = 2;
            } else if (string2.equalsIgnoreCase("Octal")) {
                n = 8;
            } else if (string2.equalsIgnoreCase("Hexadecimal")) {
                n = 16;
            } else if (string2.equalsIgnoreCase("Decimal")) {
                n = 10;
            }
            this.showUserBlockAs(n);
        }
    }

    private final void checkLinkTargetChanged() {
        Group group = null;
        try {
            group = (Group)this.hObject.getFileFormat().get(this.hObject.getPath());
        }
        catch (Exception exception) {}
        if (group == null) {
            JOptionPane.showMessageDialog(this, "Parent group is null.", this.getTitle(), 0);
            return;
        }
        String string = this.linkField.getText();
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.length() < 1 || string.equals("/") || string.endsWith(":///") || string.equals(this.hObject.getLinkTargetObjName())) {
            return;
        }
        int n = 1;
        if (this.LinkTObjName.contains("://")) {
            n = 64;
        }
        try {
            this.fileFormat.createLink(group, this.hObject.getName(), string, n);
            this.hObject.setLinkTargetObjName(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception, this.getTitle(), 0);
        }
    }

    @Override
    public HObject getDataObject() {
        return this.hObject;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public Attribute addAttribute(HObject hObject) {
        if (hObject == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)hObject.getFileFormat().getRootNode();
        NewAttributeDialog newAttributeDialog = new NewAttributeDialog((Dialog)this, hObject, defaultMutableTreeNode.breadthFirstEnumeration());
        newAttributeDialog.setVisible(true);
        Attribute attribute = newAttributeDialog.getAttribute();
        if (attribute == null) {
            return null;
        }
        Object[] objectArray = new String[4];
        objectArray[0] = attribute.getName();
        objectArray[2] = attribute.getType().getDatatypeDescription();
        objectArray[1] = attribute.toString(", ");
        long[] lArray = attribute.getDataDims();
        objectArray[3] = String.valueOf(lArray[0]);
        int n = 1;
        while (n < lArray.length) {
            objectArray[3] = String.valueOf(objectArray[3]) + " x " + lArray[n];
            ++n;
        }
        this.attrTableModel.addRow(objectArray);
        this.attrTableModel.fireTableRowsInserted(this.attrTableModel.getRowCount() - 1, this.attrTableModel.getRowCount() - 1);
        ++this.numAttributes;
        this.attrContentArea.setText("");
        this.attrNumberLabel.setText("Number of attributes = " + this.numAttributes);
        return attribute;
    }

    @Override
    public Attribute deleteAttribute(HObject hObject) {
        if (hObject == null) {
            return null;
        }
        int n = this.attrTable.getSelectedRow();
        if (n < 0) {
            JOptionPane.showMessageDialog(this.getOwner(), "No attribute is selected.", this.getTitle(), 0);
            return null;
        }
        int n2 = JOptionPane.showConfirmDialog(this, "Do you want to delete the selected attribute?", this.getTitle(), 0, 2);
        if (n2 == 1) {
            return null;
        }
        List list = null;
        try {
            list = hObject.getMetadata();
        }
        catch (Exception exception) {
            list = null;
        }
        if (list == null) {
            return null;
        }
        Attribute attribute = (Attribute)list.get(n);
        try {
            hObject.removeMetadata(attribute);
        }
        catch (Exception exception) {}
        this.attrTableModel.removeRow(n);
        --this.numAttributes;
        this.attrTableModel.fireTableRowsDeleted(n, n);
        this.attrContentArea.setText("");
        this.attrNumberLabel.setText("Number of attributes = " + this.numAttributes);
        return attribute;
    }

    private JPanel createGeneralPropertyPanel() {
        String string;
        Serializable serializable;
        int n;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        boolean bl = this.hObject instanceof Group && ((Group)this.hObject).isRoot();
        FileFormat fileFormat = this.hObject.getFileFormat();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(5, 1));
        if (bl) {
            jPanel3.add(new JLabel("File Name: "));
            jPanel3.add(new JLabel("File Path: "));
            jPanel3.add(new JLabel("File Type: "));
            if (this.isH5) {
                try {
                    this.libver = this.hObject.getFileFormat().getLibBounds();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if ((this.libver[0] == 0 || this.libver[0] == 1) && this.libver[1] == 1) {
                    jPanel3.add(new JLabel("Library version: "));
                }
            }
        } else {
            jPanel3.add(new JLabel("Name: "));
            if (this.isH5 && this.hObject.getLinkTargetObjName() != null) {
                jPanel3.add(new JLabel("Link To Target: "));
            }
            jPanel3.add(new JLabel("Path: "));
            jPanel3.add(new JLabel("Type: "));
            if (this.isH4) {
                jPanel3.add(new JLabel("Tag, Ref:        "));
            } else {
                jPanel3.add(new JLabel("Object Ref:       "));
            }
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(5, 1));
        JLabel jLabel = new JLabel(this.hObject.getName());
        jPanel4.add(jLabel);
        JPanel jPanel5 = new JPanel();
        JButton jButton = new JButton("Change");
        jButton.setActionCommand("Change link target");
        jButton.addActionListener(this);
        if (this.isH5 && this.hObject.getLinkTargetObjName() != null) {
            this.linkField = new JTextField(this.hObject.getLinkTargetObjName());
            jPanel5.setLayout(new BorderLayout());
            jPanel5.add((Component)this.linkField, "Center");
            jPanel4.add(jPanel5);
        }
        JLabel jLabel2 = new JLabel();
        if (bl) {
            jLabel2.setText(new File(this.hObject.getFile()).getParent());
        } else {
            jLabel2.setText(this.hObject.getPath());
        }
        jPanel4.add(jLabel2);
        String string2 = "Unknown";
        String string3 = "";
        if (bl) {
            long l = 0L;
            try {
                l = new File(this.hObject.getFile()).length();
            }
            catch (Exception exception) {
                l = -1L;
            }
            l /= 1024L;
            int n2 = 0;
            n = 0;
            serializable = (DefaultMutableTreeNode)fileFormat.getRootNode();
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            Enumeration<TreeNode> enumeration = serializable.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                if (defaultMutableTreeNode.getUserObject() instanceof Group) {
                    ++n2;
                    continue;
                }
                ++n;
            }
            string3 = "size=" + l + "K,  groups=" + n2 + ",  datasets=" + n;
        }
        if (bl) {
            string2 = this.isH5 ? "HDF5,  " + string3 : (this.isH4 ? "HDF4,  " + string3 : string3);
        } else if (this.isH5) {
            if (this.hObject instanceof Group) {
                string2 = "HDF5 Group";
            } else if (this.hObject instanceof ScalarDS) {
                string2 = "HDF5 Scalar Dataset";
            } else if (this.hObject instanceof CompoundDS) {
                string2 = "HDF5 Compound Dataset";
            } else if (this.hObject instanceof Datatype) {
                string2 = "HDF5 Named Datatype";
            }
        } else if (this.isH4) {
            if (this.hObject instanceof Group) {
                string2 = "HDF4 Group";
            } else if (this.hObject instanceof ScalarDS) {
                ScalarDS scalarDS = (ScalarDS)this.hObject;
                string2 = scalarDS.isImage() ? "HDF4 Raster Image" : "HDF4 SDS";
            } else if (this.hObject instanceof CompoundDS) {
                string2 = "HDF4 Vdata";
            }
        } else if (this.hObject instanceof Group) {
            string2 = "Group";
        } else if (this.hObject instanceof ScalarDS) {
            string2 = "Scalar Dataset";
        } else if (this.hObject instanceof CompoundDS) {
            string2 = "Compound Dataset";
        }
        JLabel jLabel3 = new JLabel(string2);
        jPanel4.add(jLabel3);
        if (bl && this.isH5) {
            string = null;
            if (this.libver[0] == 0 && this.libver[1] == 1) {
                string = "Earliest and Latest";
            } else if (this.libver[0] == 1 && this.libver[1] == 1) {
                string = "Latest and Latest";
            }
            JLabel jLabel4 = new JLabel(string);
            jPanel4.add(jLabel4);
        }
        string = null;
        long[] lArray = this.hObject.getOID();
        if (lArray != null) {
            string = String.valueOf(lArray[0]);
            n = 1;
            while (n < lArray.length) {
                string = String.valueOf(string) + ", " + lArray[n];
                ++n;
            }
        }
        if (!bl) {
            JLabel jLabel5 = new JLabel(string);
            jPanel4.add(jLabel5);
        }
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add("West", jPanel3);
        jPanel6.add("Center", jPanel4);
        jPanel6.setBorder(new TitledBorder(""));
        jPanel2.add("North", new JLabel(""));
        jPanel2.add("Center", jPanel6);
        serializable = null;
        if (this.hObject instanceof Group) {
            serializable = this.createGroupInfoPanel((Group)this.hObject);
        } else if (this.hObject instanceof Dataset) {
            serializable = this.createDatasetInfoPanel((Dataset)this.hObject);
        } else if (this.hObject instanceof Datatype) {
            serializable = this.createNamedDatatypeInfoPanel((Datatype)this.hObject);
        }
        jPanel.add((Component)jPanel2, "North");
        if (serializable != null) {
            jPanel.add((Component)serializable, "Center");
        }
        return jPanel;
    }

    private JPanel createGroupInfoPanel(Group group) {
        Serializable serializable;
        JPanel jPanel = new JPanel();
        List<HObject> list = group.getMemberList();
        if (list == null) {
            return jPanel;
        }
        int n = list.size();
        if (n <= 0) {
            return jPanel;
        }
        Object[][] objectArray = new String[n][2];
        int n2 = 0;
        while (n2 < n) {
            serializable = list.get(n2);
            objectArray[n2][0] = ((HObject)serializable).getName();
            if (serializable instanceof Group) {
                objectArray[n2][1] = "Group";
            } else if (serializable instanceof Dataset) {
                objectArray[n2][1] = "Dataset";
            }
            ++n2;
        }
        Object[] objectArray2 = new String[]{"Name", "Type"};
        serializable = new JTable(objectArray, objectArray2){
            public static final long serialVersionUID = 240L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        ((JTable)serializable).setCellSelectionEnabled(false);
        int n3 = Math.max(16, ((JComponent)serializable).getFontMetrics(((Component)serializable).getFont()).getHeight());
        ((JTable)serializable).setRowHeight(n3);
        ((JTable)serializable).getTableHeader().setReorderingAllowed(false);
        JScrollPane jScrollPane = new JScrollPane((Component)serializable);
        jPanel.setLayout(new BorderLayout());
        if (group.getNumberOfMembersInFile() < ViewProperties.getMaxMembers()) {
            jPanel.add((Component)new JLabel("Number of members: " + n), "North");
        } else {
            jPanel.add((Component)new JLabel("Number of members: " + n + " (in memory), " + group.getNumberOfMembersInFile() + " (in file)"), "North");
        }
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setBorder(new TitledBorder("Group Members"));
        return jPanel;
    }

    private JPanel createNamedDatatypeInfoPanel(Datatype datatype) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JTextArea jTextArea = new JTextArea(datatype.getDatatypeDescription());
        jTextArea.setEditable(false);
        jPanel.add((Component)jTextArea, "Center");
        return jPanel;
    }

    private JPanel createDatasetInfoPanel(Dataset dataset) {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object object4;
        Serializable serializable;
        Object object5;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 1));
        jPanel.add(new JLabel("No. of Dimension(s): "));
        jPanel.add(new JLabel("Dimension Size(s): "));
        jPanel.add(new JLabel("Max Dimension Size(s): "));
        jPanel.add(new JLabel("Data Type: "));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 1));
        if (dataset.getRank() <= 0) {
            dataset.init();
        }
        JTextField jTextField = new JTextField("" + dataset.getRank());
        jTextField.setEditable(false);
        jPanel2.add(jTextField);
        String string = null;
        String string2 = null;
        long[] lArray = dataset.getDims();
        long[] lArray2 = dataset.getMaxDims();
        if (lArray != null) {
            object5 = dataset.getDimNames();
            boolean bl = object5 != null && ((String[])object5).length == lArray.length;
            serializable = new StringBuffer();
            object4 = new StringBuffer();
            ((StringBuffer)serializable).append(lArray[0]);
            if (bl) {
                ((StringBuffer)serializable).append(" (");
                ((StringBuffer)serializable).append(object5[0]);
                ((StringBuffer)serializable).append(")");
            }
            if (lArray2[0] < 0L) {
                ((StringBuffer)object4).append("Unlimited");
            } else {
                ((StringBuffer)object4).append(lArray2[0]);
            }
            n = 1;
            while (n < lArray.length) {
                ((StringBuffer)serializable).append(" x ");
                ((StringBuffer)serializable).append(lArray[n]);
                if (bl) {
                    ((StringBuffer)serializable).append(" (");
                    ((StringBuffer)serializable).append(object5[n]);
                    ((StringBuffer)serializable).append(")");
                }
                ((StringBuffer)object4).append(" x ");
                if (lArray2[n] < 0L) {
                    ((StringBuffer)object4).append("Unlimited");
                } else {
                    ((StringBuffer)object4).append(lArray2[n]);
                }
                ++n;
            }
            string = ((StringBuffer)serializable).toString();
            string2 = ((StringBuffer)object4).toString();
        }
        jTextField = new JTextField(string);
        jTextField.setEditable(false);
        jPanel2.add(jTextField);
        jTextField = new JTextField(string2);
        jTextField.setEditable(false);
        jPanel2.add(jTextField);
        object5 = null;
        if (dataset instanceof ScalarDS) {
            ScalarDS scalarDS = (ScalarDS)dataset;
            object5 = scalarDS.getDatatype().getDatatypeDescription();
        } else if (dataset instanceof CompoundDS) {
            object5 = this.isH4 ? "Vdata" : "Compound";
        }
        jTextField = new JTextField((String)object5);
        jTextField.setEditable(false);
        jPanel2.add(jTextField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel, "West");
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.setBorder(new TitledBorder(""));
        serializable = new JPanel();
        ((Container)serializable).setLayout(new BorderLayout());
        ((Container)serializable).add(jPanel3, "North");
        ((JComponent)serializable).setBorder(new TitledBorder("Dataspace and Datatype"));
        if (dataset instanceof CompoundDS && (n = ((CompoundDS)(object4 = (CompoundDS)dataset)).getMemberCount()) > 0) {
            Object object6;
            object3 = new String[n][3];
            object2 = ((CompoundDS)object4).getMemberNames();
            object = ((CompoundDS)object4).getMemberTypes();
            int[] nArray = ((CompoundDS)object4).getMemberOrders();
            int n2 = 0;
            while (n2 < n) {
                object3[n2][0] = object2[n2];
                object6 = ((CompoundDS)object4).getMemeberDims(n2);
                if (object6 == null) {
                    object3[n2][2] = String.valueOf(nArray[n2]);
                    if (this.isH4 && object[n2].getDatatypeClass() == 3) {
                        object3[n2][2] = String.valueOf(object[n2].getDatatypeSize());
                    }
                } else {
                    String string3 = String.valueOf(object6[0]);
                    int n3 = ((int[])object6).length;
                    int n4 = 1;
                    while (n4 < n3) {
                        string3 = String.valueOf(string3) + " x " + (int)object6[n4];
                        ++n4;
                    }
                    object3[n2][2] = string3;
                }
                object3[n2][1] = object[n2].getDatatypeDescription();
                ++n2;
            }
            Object[] objectArray = new String[]{"Name", "Type", "Array Size"};
            object6 = new JTable((Object[][])object3, objectArray){
                public static final long serialVersionUID = 240L;

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            object6.setCellSelectionEnabled(false);
            object6.getTableHeader().setReorderingAllowed(false);
            ((Container)serializable).add(new JScrollPane((Component)object6), "Center");
            int n5 = Math.max(16, object6.getFontMetrics(object6.getFont()).getHeight());
            object6.setRowHeight(n5);
        }
        object4 = "";
        long[] lArray3 = dataset.getChunkSize();
        if (lArray3 == null) {
            object4 = "NONE";
        } else {
            int n6 = lArray3.length;
            object4 = String.valueOf(lArray3[0]);
            int n7 = 1;
            while (n7 < n6) {
                object4 = String.valueOf(object4) + " X " + lArray3[n7];
                ++n7;
            }
        }
        object3 = new JPanel();
        ((JComponent)object3).setBorder(new TitledBorder(""));
        ((Container)object3).setLayout(new BorderLayout());
        jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1));
        jPanel.add(new JLabel("Chunking: "));
        jPanel.add(new JLabel("Compression: "));
        jPanel.add(new JLabel("Fill value: "));
        ((Container)object3).add((Component)jPanel, "West");
        object2 = null;
        object = "NONE";
        if (dataset instanceof ScalarDS) {
            object2 = ((ScalarDS)dataset).getFillValue();
        }
        if (object2 != null) {
            if (object2.getClass().isArray()) {
                int n8 = Array.getLength(object2);
                object = Array.get(object2, 0).toString();
                int n9 = 1;
                while (n9 < n8) {
                    object = String.valueOf(object) + ", ";
                    object = String.valueOf(object) + Array.get(object2, n9).toString();
                    ++n9;
                }
            } else {
                object = object2.toString();
            }
        }
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1));
        jPanel2.add(new JLabel((String)object4));
        jPanel2.add(new JLabel(dataset.getCompression()));
        jPanel2.add(new JLabel((String)object));
        ((Container)object3).add((Component)jPanel2, "Center");
        ((Container)serializable).add((Component)object3, "South");
        return serializable;
    }

    private JPanel createAttributePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.attrNumberLabel = new JLabel("Number of attributes = 0");
        jPanel2.add((Component)this.attrNumberLabel, "West");
        FileFormat fileFormat = this.hObject.getFileFormat();
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton(" Add ");
        jButton.setMnemonic('A');
        jButton.addActionListener(this);
        jButton.setActionCommand("Add attribute");
        jPanel3.add(jButton);
        jButton.setEnabled(!fileFormat.isReadOnly());
        if (this.isH5) {
            jButton = new JButton("Delete");
            jButton.setMnemonic('D');
            jButton.addActionListener(this);
            jButton.setActionCommand("Delete attribute");
            jPanel3.add(jButton);
            jButton.setEnabled(!fileFormat.isReadOnly());
        }
        jPanel2.add((Component)jPanel3, "East");
        jPanel.add((Component)jPanel2, "North");
        List list = null;
        try {
            list = this.hObject.getMetadata();
        }
        catch (Exception exception) {
            list = null;
        }
        if (list != null) {
            this.numAttributes = list.size();
        }
        Object[] objectArray = new String[]{"Name", "Value", "Type", "Array Size"};
        this.attrTableModel = new DefaultTableModel(objectArray, this.numAttributes);
        this.attrTable = new JTable(this.attrTableModel){
            public static final long serialVersionUID = 240L;
            int lastSelectedRow;
            int lastSelectedCol;
            {
                this.lastSelectedRow = -1;
                this.lastSelectedCol = -1;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 1 || DefaultMetaDataView.this.isH5 && n2 == 0;
            }

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                int n = this.getEditingRow();
                int n2 = this.getEditingColumn();
                String string = (String)this.getValueAt(n, n2);
                super.editingStopped(changeEvent);
                Object object = changeEvent.getSource();
                if (object instanceof CellEditor) {
                    CellEditor cellEditor = (CellEditor)object;
                    String string2 = (String)cellEditor.getCellEditorValue();
                    this.setValueAt(string, n, n2);
                    DefaultMetaDataView.this.updateAttributeValue(string2, n, n2);
                }
            }

            @Override
            public boolean isCellSelected(int n, int n2) {
                if (this.getSelectedRow() == n && this.getSelectedColumn() == n2 && (this.lastSelectedRow != n || this.lastSelectedCol != n2)) {
                    Object object = this.getValueAt(n, n2);
                    if (object != null) {
                        DefaultMetaDataView.this.attrContentArea.setText(object.toString());
                    }
                    this.lastSelectedRow = n;
                    this.lastSelectedCol = n2;
                }
                return super.isCellSelected(n, n2);
            }
        };
        this.attrTable.setRowSelectionAllowed(false);
        this.attrTable.setCellSelectionEnabled(true);
        this.attrTable.getTableHeader().setReorderingAllowed(false);
        this.attrTable.setSelectionMode(0);
        int n = Math.max(16, this.attrTable.getFontMetrics(this.attrTable.getFont()).getHeight());
        this.attrTable.setRowHeight(n);
        JScrollPane jScrollPane = new JScrollPane(this.attrTable);
        this.attrContentArea = new JTextArea();
        this.attrContentArea.setLineWrap(true);
        this.attrContentArea.setEditable(false);
        Insets insets = new Insets(5, 5, 5, 5);
        this.attrContentArea.setMargin(insets);
        JScrollPane jScrollPane2 = new JScrollPane(this.attrContentArea);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        int n2 = Math.min((this.numAttributes + 2) * this.attrTable.getRowHeight(), jScrollPane.getPreferredSize().height - 40);
        jSplitPane.setDividerLocation(n2);
        jPanel.add((Component)jSplitPane, "Center");
        if (list == null) {
            return jPanel;
        }
        Attribute attribute = null;
        this.attrNumberLabel.setText("Number of attributes = " + this.numAttributes);
        int n3 = 0;
        while (n3 < this.numAttributes) {
            attribute = (Attribute)list.get(n3);
            String string = attribute.getName();
            String string2 = attribute.getType().getDatatypeDescription();
            long[] lArray = attribute.getDataDims();
            String string3 = String.valueOf(lArray[0]);
            int n4 = 1;
            while (n4 < lArray.length) {
                string3 = String.valueOf(string3) + " x " + lArray[n4];
                ++n4;
            }
            this.attrTable.setValueAt(string, n3, 0);
            this.attrTable.setValueAt(attribute.toString(", "), n3, 1);
            this.attrTable.setValueAt(string2, n3, 2);
            this.attrTable.setValueAt(string3, n3, 3);
            ++n3;
        }
        return jPanel;
    }

    private JPanel createUserBlockPanel() {
        JPanel jPanel = new JPanel();
        this.userBlock = DefaultFileFilter.getHDF5UserBlock(this.hObject.getFile());
        jPanel.setLayout(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.userBlockArea = new JTextArea();
        this.userBlockArea.setEditable(true);
        this.userBlockArea.setLineWrap(true);
        Insets insets = new Insets(5, 5, 5, 5);
        this.userBlockArea.setMargin(insets);
        String[] stringArray = new String[]{"Text", "Binary", "Octal", "Hexadecimal", "Decimal"};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedIndex(0);
        jComboBox.addActionListener(this);
        jComboBox.setEditable(false);
        jComboBox.setActionCommand("Display user block as");
        JLabel jLabel = new JLabel("Header Size (Bytes): 0");
        this.jamButton = new JButton("Save User Block");
        this.jamButton.setActionCommand("Jam user block");
        this.jamButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(10, 5));
        jPanel2.add((Component)new JLabel("Display As:"), "West");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2, 10, 5));
        jPanel3.add(jComboBox);
        jPanel3.add(jLabel);
        jPanel2.add((Component)jPanel3, "Center");
        jPanel2.add((Component)this.jamButton, "East");
        JScrollPane jScrollPane = new JScrollPane(this.userBlockArea);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jScrollPane, "Center");
        int n = 0;
        if (this.userBlock != null) {
            n = this.showUserBlockAs(0);
            jLabel.setText("Header Size (Bytes): " + n);
        } else {
            jComboBox.setEnabled(false);
        }
        return jPanel;
    }

    private int showUserBlockAs(int n) {
        int n2 = 0;
        if (this.userBlock == null) {
            return 0;
        }
        String string = null;
        if (n == 2 || n == 8 || n == 16 || n == 10) {
            StringBuffer stringBuffer = new StringBuffer();
            n2 = 0;
            while (n2 < this.userBlock.length) {
                int n3 = this.userBlock[n2];
                if (n3 < 0) {
                    n3 += 256;
                } else if (n3 == 0) break;
                stringBuffer.append(Integer.toString(n3, n));
                stringBuffer.append(" ");
                ++n2;
            }
            string = stringBuffer.toString();
        } else {
            string = new String(this.userBlock).trim();
            if (string != null) {
                n2 = string.length();
            }
        }
        this.userBlockArea.setText(string);
        return n2;
    }

    private void updateAttributeValue(String string, int n, int n2) {
        String string2 = (String)this.attrTable.getValueAt(n, 0);
        List list = null;
        try {
            list = this.hObject.getMetadata();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.getOwner(), exception.getMessage(), this.getTitle(), 0);
            return;
        }
        Attribute attribute = (Attribute)list.get(n);
        if (n2 == 1) {
            Object object = attribute.getValue();
            if (object == null) {
                return;
            }
            int n3 = Array.getLength(object);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            if (stringTokenizer.countTokens() < n3) {
                JOptionPane.showMessageDialog(this.getOwner(), "More data value needed: " + string, this.getTitle(), 0);
                return;
            }
            int n4 = 32;
            String string3 = object.getClass().getName();
            int n5 = string3.lastIndexOf("[");
            if (n5 >= 0) {
                n4 = string3.charAt(n5 + 1);
            }
            boolean bl = attribute.isUnsigned();
            double d = 0.0;
            String string4 = null;
            long l = 0L;
            long l2 = 0L;
            int n6 = 0;
            while (n6 < n3) {
                l2 = 0L;
                l = 0L;
                string4 = stringTokenizer.nextToken().trim();
                try {
                    if (!(Array.get(object, n6) instanceof String)) {
                        d = Double.parseDouble(string4);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this.getOwner(), numberFormatException.getMessage(), this.getTitle(), 0);
                    return;
                }
                if (bl && d < 0.0) {
                    JOptionPane.showMessageDialog(this.getOwner(), "Negative value for unsigned integer: " + string, this.getTitle(), 0);
                    return;
                }
                switch (n4) {
                    case 66: {
                        if (bl) {
                            l2 = 0L;
                            l = 255L;
                        } else {
                            l2 = -128L;
                            l = 127L;
                        }
                        if (d > (double)l || d < (double)l2) {
                            JOptionPane.showMessageDialog(this.getOwner(), "Data is out of range[" + l2 + ", " + l + "]: " + string, this.getTitle(), 0);
                            break;
                        }
                        Array.setByte(object, n6, (byte)d);
                        break;
                    }
                    case 83: {
                        if (bl) {
                            l2 = 0L;
                            l = 65535L;
                        } else {
                            l2 = -32768L;
                            l = 32767L;
                        }
                        if (d > (double)l || d < (double)l2) {
                            JOptionPane.showMessageDialog(this.getOwner(), "Data is out of range[" + l2 + ", " + l + "]: " + string, this.getTitle(), 0);
                            break;
                        }
                        Array.setShort(object, n6, (short)d);
                        break;
                    }
                    case 73: {
                        if (bl) {
                            l2 = 0L;
                            l = 0xFFFFFFFFL;
                        } else {
                            l2 = Integer.MIN_VALUE;
                            l = Integer.MAX_VALUE;
                        }
                        if (d > (double)l || d < (double)l2) {
                            JOptionPane.showMessageDialog(this.getOwner(), "Data is out of range[" + l2 + ", " + l + "]: " + string, this.getTitle(), 0);
                            break;
                        }
                        Array.setInt(object, n6, (int)d);
                        break;
                    }
                    case 74: {
                        Array.setLong(object, n6, (long)d);
                        break;
                    }
                    case 70: {
                        Array.setFloat(object, n6, (float)d);
                        break;
                    }
                    default: {
                        Array.set(object, n6, string);
                    }
                }
                ++n6;
            }
            try {
                this.hObject.getFileFormat().writeAttribute(this.hObject, attribute, true);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.getOwner(), exception.getMessage(), this.getTitle(), 0);
                return;
            }
            this.attrTable.setValueAt(attribute.toString(", "), n, 1);
        }
        if (n2 == 0 && this.isH5) {
            try {
                this.hObject.getFileFormat().renameAttribute(this.hObject, string2, string);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.getOwner(), exception.getMessage(), this.getTitle(), 0);
                return;
            }
            this.attrTable.setValueAt(string, n, 0);
        }
    }

    private void writeUserBlock() {
        int n;
        if (!this.isH5) {
            return;
        }
        int n2 = 0;
        if (this.userBlock != null && (n2 = this.userBlock.length) > 0) {
            n = 512;
            while (n < n2) {
                n *= 2;
            }
            n2 = n;
        }
        n = 0;
        String string = this.userBlockArea.getText();
        if (string == null) {
            if (n2 <= 0) {
                return;
            }
            string = " ";
        }
        byte[] byArray = null;
        byArray = string.getBytes();
        n = byArray.length;
        if (n <= n2) {
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(this.hObject.getFile(), "rw");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Can't open output file: " + this.hObject.getFile(), this.getTitle(), 0);
                return;
            }
            try {
                randomAccessFile.seek(0L);
                randomAccessFile.write(byArray, 0, byArray.length);
                randomAccessFile.seek(byArray.length);
                if (n2 > byArray.length) {
                    byte[] byArray2 = new byte[n2 - byArray.length];
                    randomAccessFile.write(byArray2, 0, byArray2.length);
                }
            }
            catch (Exception exception) {}
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {}
            JOptionPane.showMessageDialog(this, "Saving user block is successful.", this.getTitle(), 1);
        } else {
            Serializable serializable;
            int n3 = JOptionPane.showConfirmDialog(this, "The user block to write is " + n + " (bytes),\n" + "which is larger than the user block space in file " + n2 + " (bytes).\n" + "To expand the user block, the file must be rewriten.\n\n" + "Do you want to replace the current file? Click " + "\n\"Yes\" to replace the current file," + "\n\"No\" to save to a different file, " + "\n\"Cancel\" to quit without saving the change.\n\n ", this.getTitle(), 1, 2);
            if (n3 == 2) {
                return;
            }
            String string2 = this.hObject.getFile();
            String string3 = String.valueOf(string2) + "~copy.h5";
            if (string2.endsWith(".h5")) {
                string3 = String.valueOf(string2.substring(0, string2.length() - 3)) + "~copy.h5";
            } else if (string2.endsWith(".hdf5")) {
                string3 = String.valueOf(string2.substring(0, string2.length() - 5)) + "~copy.h5";
            }
            File file = null;
            if (n3 == 1) {
                serializable = new JFileChooser();
                ((JFileChooser)serializable).setFileFilter(DefaultFileFilter.getFileFilterHDF5());
                ((JFileChooser)serializable).setSelectedFile(new File(string3));
                int n4 = ((JFileChooser)serializable).showSaveDialog(this);
                if (n4 != 0) {
                    return;
                }
                File file2 = ((JFileChooser)serializable).getSelectedFile();
                if (file2 == null) {
                    return;
                }
                file = file2;
                string3 = file.getAbsolutePath();
            } else {
                file = new File(string3);
            }
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Fail to write user block into file. ", this.getTitle(), 0);
                    return;
                }
            }
            serializable = new ActionEvent(this, 1001, "Close file");
            ((HDFView)this.viewer).actionPerformed((ActionEvent)serializable);
            if (DefaultFileFilter.setHDF5UserBlock(string2, string3, byArray)) {
                if (n3 == 1) {
                    string2 = string3;
                } else {
                    File file3 = new File(string2);
                    boolean bl = file3.delete();
                    if (bl) {
                        file.renameTo(file3);
                    } else {
                        JOptionPane.showMessageDialog(this, "Cannot replace the current file.\nPlease save to a different file.", this.getTitle(), 0);
                        file.delete();
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this, "Fail to write user block into file. ", this.getTitle(), 0);
                file.delete();
            }
            this.dispose();
            serializable = new ActionEvent(this, 1001, "Open file://" + string2);
            ((HDFView)this.viewer).actionPerformed((ActionEvent)serializable);
        }
    }
}

