/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;
import ncsa.hdf.view.ViewProperties;

public class DefaultFileFilter
extends FileFilter {
    private static FileFilter FILE_FILTER_HDF = null;
    private static FileFilter FILE_FILTER_HDF4 = null;
    private static FileFilter FILE_FILTER_HDF5 = null;
    private static FileFilter FILE_FILTER_JPEG = null;
    private static FileFilter FILE_FILTER_TIFF = null;
    private static FileFilter FILE_FILTER_PNG = null;
    private static FileFilter FILE_FILTER_GIF = null;
    private static FileFilter FILE_FILTER_BMP = null;
    private static FileFilter FILE_FILTER_IMG = null;
    private static FileFilter FILE_FILTER_TEXT = null;
    private static FileFilter FILE_FILTER_BINARY = null;
    private static String fileExtension = ViewProperties.getFileExtension();
    private Hashtable<String, DefaultFileFilter> filters = new Hashtable();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public DefaultFileFilter() {
    }

    public DefaultFileFilter(String string) {
        this(string, null);
    }

    public DefaultFileFilter(String string, String string2) {
        this();
        if (string != null) {
            this.addExtension(string);
        }
        if (string2 != null) {
            this.setDescription(string2);
        }
    }

    public DefaultFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public DefaultFileFilter(String[] stringArray, String string) {
        this();
        int n = 0;
        while (n < stringArray.length) {
            this.addExtension(stringArray[n]);
            ++n;
        }
        if (string != null) {
            this.setDescription(string);
        }
    }

    @Override
    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null && this.filters.get(this.getExtension(file)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File file) {
        String string;
        int n;
        if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String string) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken().trim();
            this.filters.put(string2.toLowerCase(), this);
        }
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : String.valueOf(this.description) + " (";
                Enumeration<String> enumeration = this.filters.keys();
                if (enumeration != null) {
                    if (!enumeration.hasMoreElements()) {
                        this.fullDescription = null;
                        return null;
                    }
                    this.fullDescription = String.valueOf(this.fullDescription) + "." + enumeration.nextElement();
                    while (enumeration.hasMoreElements()) {
                        this.fullDescription = String.valueOf(this.fullDescription) + ", " + enumeration.nextElement();
                    }
                }
                this.fullDescription = String.valueOf(this.fullDescription) + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String string) {
        this.description = string;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean bl) {
        this.useExtensionsInDescription = bl;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public static FileFilter getFileFilter() {
        boolean bl = fileExtension.equalsIgnoreCase(ViewProperties.getFileExtension());
        if (FILE_FILTER_HDF != null && bl) {
            return FILE_FILTER_HDF;
        }
        fileExtension = ViewProperties.getFileExtension();
        DefaultFileFilter defaultFileFilter = new DefaultFileFilter();
        defaultFileFilter.setDescription("HDF & more");
        defaultFileFilter.addExtension(fileExtension);
        FILE_FILTER_HDF = defaultFileFilter;
        return FILE_FILTER_HDF;
    }

    public static FileFilter getFileFilterHDF4() {
        if (FILE_FILTER_HDF4 != null) {
            return FILE_FILTER_HDF4;
        }
        DefaultFileFilter defaultFileFilter = new DefaultFileFilter();
        defaultFileFilter.addExtension("hdf");
        defaultFileFilter.addExtension("h4");
        defaultFileFilter.addExtension("hdf4");
        defaultFileFilter.setDescription("HDF4 files");
        FILE_FILTER_HDF4 = defaultFileFilter;
        return FILE_FILTER_HDF4;
    }

    public static FileFilter getFileFilterHDF5() {
        if (FILE_FILTER_HDF5 != null) {
            return FILE_FILTER_HDF5;
        }
        DefaultFileFilter defaultFileFilter = new DefaultFileFilter();
        defaultFileFilter.addExtension("h5");
        defaultFileFilter.addExtension("hdf5");
        defaultFileFilter.setDescription("HDF5 files");
        FILE_FILTER_HDF5 = defaultFileFilter;
        return FILE_FILTER_HDF5;
    }

    public static FileFilter getFileFilterJPEG() {
        if (FILE_FILTER_JPEG != null) {
            return FILE_FILTER_JPEG;
        }
        DefaultFileFilter defaultFileFilter = new DefaultFileFilter();
        defaultFileFilter.addExtension("jpg");
        defaultFileFilter.addExtension("jpeg");
        defaultFileFilter.addExtension("jpe");
        defaultFileFilter.addExtension("jif");
        defaultFileFilter.addExtension("jfif");
        defaultFileFilter.addExtension("jfi");
        defaultFileFilter.setDescription("JPEG images");
        FILE_FILTER_JPEG = defaultFileFilter;
        return FILE_FILTER_JPEG;
    }

    public static FileFilter getFileFilterTIFF() {
        if (FILE_FILTER_TIFF != null) {
            return FILE_FILTER_TIFF;
        }
        DefaultFileFilter defaultFileFilter = new DefaultFileFilter();
        defaultFileFilter.addExtension("tif");
        defaultFileFilter.addExtension("tiff");
        defaultFileFilter.setDescription("TIFF images");
        FILE_FILTER_TIFF = defaultFileFilter;
        return FILE_FILTER_TIFF;
    }

    public static FileFilter getFileFilterPNG() {
        if (FILE_FILTER_PNG != null) {
            return FILE_FILTER_PNG;
        }
        DefaultFileFilter defaultFileFilter = new DefaultFileFilter();
        defaultFileFilter.addExtension("png");
        defaultFileFilter.setDescription("PNG images");
        FILE_FILTER_PNG = defaultFileFilter;
        return FILE_FILTER_PNG;
    }

    public static FileFilter getFileFilterBMP() {
        if (FILE_FILTER_BMP != null) {
            return FILE_FILTER_BMP;
        }
        DefaultFileFilter defaultFileFilter = new DefaultFileFilter();
        defaultFileFilter.addExtension("bmp");
        defaultFileFilter.addExtension("dib");
        defaultFileFilter.setDescription("BMP images");
        FILE_FILTER_BMP = defaultFileFilter;
        return FILE_FILTER_BMP;
    }

    public static FileFilter getFileFilterGIF() {
        if (FILE_FILTER_GIF != null) {
            return FILE_FILTER_GIF;
        }
        DefaultFileFilter defaultFileFilter = new DefaultFileFilter();
        defaultFileFilter.addExtension("gif");
        defaultFileFilter.setDescription("GIF images");
        FILE_FILTER_GIF = defaultFileFilter;
        return FILE_FILTER_GIF;
    }

    public static FileFilter getImageFileFilter() {
        if (FILE_FILTER_IMG != null) {
            return FILE_FILTER_IMG;
        }
        DefaultFileFilter defaultFileFilter = new DefaultFileFilter();
        defaultFileFilter.addExtension("jpg");
        defaultFileFilter.addExtension("jpeg");
        defaultFileFilter.addExtension("jpe");
        defaultFileFilter.addExtension("jif");
        defaultFileFilter.addExtension("jfif");
        defaultFileFilter.addExtension("jfi");
        defaultFileFilter.addExtension("png");
        defaultFileFilter.addExtension("gif");
        defaultFileFilter.addExtension("bmp");
        defaultFileFilter.addExtension("dib");
        defaultFileFilter.setDescription("GIF, JPEG, BMP, or PNG images");
        FILE_FILTER_IMG = defaultFileFilter;
        return FILE_FILTER_IMG;
    }

    public static FileFilter getFileFilterText() {
        if (FILE_FILTER_TEXT != null) {
            return FILE_FILTER_TEXT;
        }
        DefaultFileFilter defaultFileFilter = new DefaultFileFilter();
        defaultFileFilter.addExtension("txt");
        defaultFileFilter.addExtension("text");
        defaultFileFilter.setDescription("Text");
        FILE_FILTER_TEXT = defaultFileFilter;
        return FILE_FILTER_TEXT;
    }

    public static FileFilter getFileFilterBinary() {
        if (FILE_FILTER_BINARY != null) {
            return FILE_FILTER_BINARY;
        }
        DefaultFileFilter defaultFileFilter = new DefaultFileFilter();
        defaultFileFilter.addExtension("bin");
        defaultFileFilter.setDescription("Binary");
        FILE_FILTER_BINARY = defaultFileFilter;
        return FILE_FILTER_BINARY;
    }

    public static boolean isHDF4(String string) {
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
        }
        catch (Exception exception) {
            randomAccessFile = null;
        }
        if (randomAccessFile == null) {
            return false;
        }
        byte[] byArray = new byte[4];
        try {
            randomAccessFile.read(byArray);
        }
        catch (Exception exception) {
            byArray = null;
        }
        if (byArray != null) {
            bl = byArray[0] == 14 && byArray[1] == 3 && byArray[2] == 19 && byArray[3] == 1;
        }
        try {
            randomAccessFile.close();
        }
        catch (Exception exception) {}
        return bl;
    }

    public static boolean isHDF5(String string) {
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
        }
        catch (Exception exception) {
            randomAccessFile = null;
        }
        if (randomAccessFile == null) {
            return false;
        }
        byte[] byArray = new byte[8];
        long l = 0L;
        try {
            l = randomAccessFile.length();
        }
        catch (Exception exception) {}
        long l2 = 0L;
        while (!bl && l2 < l) {
            try {
                randomAccessFile.seek(l2);
                randomAccessFile.read(byArray);
            }
            catch (Exception exception) {
                byArray = null;
            }
            if (byArray[0] == -119 && byArray[1] == 72 && byArray[2] == 68 && byArray[3] == 70 && byArray[4] == 13 && byArray[5] == 10 && byArray[6] == 26 && byArray[7] == 10) {
                bl = true;
                continue;
            }
            bl = false;
            if (l2 == 0L) {
                l2 = 512L;
                continue;
            }
            l2 *= 2L;
        }
        try {
            randomAccessFile.close();
        }
        catch (Exception exception) {}
        return bl;
    }

    public static boolean isNetcdf(String string) {
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
        }
        catch (Exception exception) {
            randomAccessFile = null;
        }
        if (randomAccessFile == null) {
            return false;
        }
        byte[] byArray = new byte[4];
        try {
            randomAccessFile.read(byArray);
        }
        catch (Exception exception) {
            byArray = null;
        }
        if (byArray != null) {
            bl = byArray[0] == 67 && byArray[1] == 68 && byArray[2] == 70 && byArray[3] == 1;
        }
        try {
            randomAccessFile.close();
        }
        catch (Exception exception) {}
        return bl;
    }

    public static byte[] getHDF5UserBlock(String string) {
        byte[] byArray = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
        }
        catch (Exception exception) {
            try {
                randomAccessFile.close();
            }
            catch (Throwable throwable) {}
            randomAccessFile = null;
        }
        if (randomAccessFile == null) {
            return null;
        }
        byte[] byArray2 = new byte[8];
        long l = 0L;
        try {
            l = randomAccessFile.length();
        }
        catch (Exception exception) {
            l = 0L;
        }
        if (l <= 0L) {
            try {
                randomAccessFile.close();
            }
            catch (Throwable throwable) {}
            return null;
        }
        long l2 = 0L;
        boolean bl = false;
        while (l2 < l) {
            try {
                randomAccessFile.seek(l2);
                randomAccessFile.read(byArray2);
            }
            catch (Exception exception) {
                byArray2 = null;
            }
            if (byArray2[0] == -119 && byArray2[1] == 72 && byArray2[2] == 68 && byArray2[3] == 70 && byArray2[4] == 13 && byArray2[5] == 10 && byArray2[6] == 26 && byArray2[7] == 10) {
                bl = true;
                break;
            }
            bl = false;
            if (l2 == 0L) {
                l2 = 512L;
                continue;
            }
            l2 *= 2L;
        }
        if (!bl || l2 == 0L) {
            try {
                randomAccessFile.close();
            }
            catch (Throwable throwable) {}
            return null;
        }
        int n = (int)l2;
        byArray = new byte[n];
        try {
            randomAccessFile.seek(0L);
            randomAccessFile.read(byArray, 0, n);
        }
        catch (Exception exception) {
            byArray = null;
        }
        try {
            randomAccessFile.close();
        }
        catch (Exception exception) {}
        return byArray;
    }

    public static boolean setHDF5UserBlock(String string, String string2, byte[] byArray) {
        boolean bl = false;
        if (byArray == null || byArray.length <= 0) {
            return false;
        }
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
        }
        catch (Exception exception) {
            randomAccessFile = null;
        }
        if (randomAccessFile == null) {
            return false;
        }
        byte[] byArray2 = new byte[8];
        long l = 0L;
        try {
            l = randomAccessFile.length();
        }
        catch (Exception exception) {
            l = 0L;
        }
        try {
            l = randomAccessFile.length();
        }
        catch (Exception exception) {
            l = 0L;
        }
        if (l <= 0L) {
            try {
                randomAccessFile.close();
            }
            catch (Throwable throwable) {}
            return false;
        }
        long l2 = 0L;
        while (l2 < l) {
            try {
                randomAccessFile.seek(l2);
                randomAccessFile.read(byArray2);
            }
            catch (Exception exception) {
                byArray2 = null;
            }
            if (byArray2[0] == -119 && byArray2[1] == 72 && byArray2[2] == 68 && byArray2[3] == 70 && byArray2[4] == 13 && byArray2[5] == 10 && byArray2[6] == 26 && byArray2[7] == 10) {
                bl = true;
                break;
            }
            bl = false;
            if (l2 == 0L) {
                l2 = 512L;
                continue;
            }
            l2 *= 2L;
        }
        try {
            randomAccessFile.close();
        }
        catch (Throwable throwable) {}
        if (!bl) {
            return false;
        }
        int n = 0;
        int n2 = 1024;
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        }
        catch (Exception exception) {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception2) {}
            return false;
        }
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
        }
        catch (Exception exception) {
            try {
                filterOutputStream.close();
            }
            catch (Exception exception3) {}
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception4) {}
            return false;
        }
        try {
            bufferedInputStream.skip(l2);
        }
        catch (Exception exception) {}
        try {
            ((BufferedOutputStream)filterOutputStream).write(byArray, 0, byArray.length);
        }
        catch (Exception exception) {}
        l2 = 512L;
        while (l2 < (long)byArray.length) {
            l2 *= 2L;
        }
        int n3 = (int)(l2 - (long)byArray.length);
        if (n3 > 0) {
            byte[] byArray3 = new byte[n3];
            try {
                ((BufferedOutputStream)filterOutputStream).write(byArray3, 0, n3);
            }
            catch (Exception exception) {}
        }
        byte[] byArray4 = new byte[n2];
        try {
            n = bufferedInputStream.read(byArray4, 0, n2);
        }
        catch (Exception exception) {
            n = 0;
        }
        while (n > 0) {
            try {
                ((BufferedOutputStream)filterOutputStream).write(byArray4, 0, n);
                n = bufferedInputStream.read(byArray4, 0, n2);
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        try {
            ((BufferedOutputStream)filterOutputStream).flush();
        }
        catch (Exception exception) {}
        try {
            bufferedInputStream.close();
        }
        catch (Exception exception) {}
        try {
            filterOutputStream.close();
        }
        catch (Exception exception) {}
        return true;
    }
}

