/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.BitSet;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.HDFView;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DataOptionDialog
extends JDialog
implements ActionListener,
ItemListener {
    public static final long serialVersionUID = 240L;
    private final ViewManager viewer;
    private Dataset dataset;
    private int rank;
    private long[] start;
    private long[] dims;
    private long[] selected;
    private long[] stride;
    private int[] selectedIndex;
    private int[] currentIndex;
    private JRadioButton spreadsheetButton;
    private JRadioButton imageButton;
    private JRadioButton[] bitmaskButtons;
    private JCheckBox charCheckbox;
    private JCheckBox bitmaskCheckbox;
    private BitSet bitmask;
    private JButton bitmaskHelp;
    private JComboBox choiceTextView;
    private JComboBox choiceTableView;
    private JComboBox choiceImageView;
    private JComboBox choicePalette;
    private JComboBox[] choices;
    private JComboBox transposeChoice;
    private boolean isSelectionCancelled;
    private boolean isTrueColorImage;
    private boolean isText;
    private boolean isH5;
    private JLabel[] maxLabels;
    private JLabel selLabel;
    private JTextField[] startFields;
    private JTextField[] endFields;
    private JTextField[] strideFields;
    private JList fieldList;
    private final Toolkit toolkit;
    private final PreviewNavigator navigator;
    private int numberOfPalettes;
    private boolean performJComboBoxEvent = false;

    public DataOptionDialog(ViewManager viewManager, Dataset dataset) {
        super((Frame)((JFrame)((Object)viewManager)), true);
        Serializable serializable;
        JPanel jPanel;
        JComponent jComponent;
        JLabel[] jLabelArray;
        Object object;
        Serializable serializable2;
        int n;
        Object object2;
        byte[] byArray;
        this.setDefaultCloseOperation(2);
        this.viewer = viewManager;
        this.dataset = dataset;
        this.isSelectionCancelled = true;
        this.isTrueColorImage = false;
        this.isText = false;
        this.bitmask = null;
        this.numberOfPalettes = 1;
        this.toolkit = Toolkit.getDefaultToolkit();
        if (this.dataset == null) {
            this.dispose();
        } else {
            this.setTitle("Dataset Selection - " + this.dataset.getPath() + this.dataset.getName());
        }
        this.isH5 = this.dataset.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5"));
        this.rank = this.dataset.getRank();
        if (this.rank <= 0) {
            this.dataset.init();
        }
        if (this.isH5 && this.dataset instanceof ScalarDS && (byArray = ((ScalarDS)this.dataset).getPaletteRefs()) != null && byArray.length > 8) {
            this.numberOfPalettes = byArray.length / 8;
        }
        this.rank = this.dataset.getRank();
        this.dims = this.dataset.getDims();
        this.selected = this.dataset.getSelectedDims();
        this.start = this.dataset.getStartDims();
        this.selectedIndex = this.dataset.getSelectedIndex();
        this.stride = this.dataset.getStride();
        this.fieldList = null;
        int n2 = 1;
        int n3 = 1;
        n2 = (int)this.dims[this.selectedIndex[0]];
        if (this.rank > 1) {
            n3 = (int)this.dims[this.selectedIndex[1]];
        }
        this.transposeChoice = new JComboBox();
        this.transposeChoice.addItem("Reshape");
        this.transposeChoice.addItem("Transpose");
        this.selLabel = new JLabel("", 0);
        this.navigator = new PreviewNavigator(n3, n2);
        this.currentIndex = new int[Math.min(3, this.rank)];
        this.choicePalette = new JComboBox();
        this.choiceTextView = new JComboBox((Vector)HDFView.getListOfTextView());
        this.choiceImageView = new JComboBox((Vector)HDFView.getListOfImageView());
        this.choiceTableView = new JComboBox((Vector)HDFView.getListOfTableView());
        this.choicePalette.addItem("Select palette");
        if (this.dataset instanceof ScalarDS) {
            object2 = ((ScalarDS)this.dataset).getPaletteName(0);
            if (object2 == null) {
                object2 = "Default";
            }
            this.choicePalette.addItem(object2);
            n = 2;
            while (n <= this.numberOfPalettes) {
                object2 = ((ScalarDS)this.dataset).getPaletteName(n - 1);
                this.choicePalette.addItem(object2);
                ++n;
            }
        }
        this.choicePalette.addItem("Gray");
        this.choicePalette.addItem("ReverseGray");
        this.choicePalette.addItem("GrayWave");
        this.choicePalette.addItem("Rainbow");
        this.choicePalette.addItem("Nature");
        this.choicePalette.addItem("Wave");
        this.spreadsheetButton = new JRadioButton("Spreadsheet ", true);
        this.spreadsheetButton.setMnemonic(83);
        this.imageButton = new JRadioButton("Image ");
        this.imageButton.setMnemonic(73);
        this.charCheckbox = new JCheckBox("Show As Char", false);
        this.charCheckbox.setMnemonic(67);
        this.charCheckbox.setEnabled(false);
        this.charCheckbox.addItemListener(this);
        this.bitmaskCheckbox = new JCheckBox("Apply Bitmask", false);
        this.bitmaskCheckbox.setMnemonic(66);
        this.bitmaskCheckbox.setEnabled(false);
        this.bitmaskCheckbox.addItemListener(this);
        this.bitmaskHelp = new JButton(ViewProperties.getHelpIcon());
        this.bitmaskHelp.setToolTipText("Help on how to set bitmask");
        this.bitmaskHelp.setMargin(new Insets(0, 0, 0, 0));
        this.bitmaskHelp.addActionListener(this);
        this.bitmaskHelp.setActionCommand("Help on how to set bitmask");
        object2 = (JPanel)this.getContentPane();
        ((Container)object2).setLayout(new BorderLayout(5, 5));
        ((JComponent)object2).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        n = 700 + (ViewProperties.getFontSize() - 12) * 15;
        int n4 = 350 + (ViewProperties.getFontSize() - 12) * 10;
        ((JComponent)object2).setPreferredSize(new Dimension(n, n4));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new TitledBorder("Dimension and Subset Selection"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this.navigator, "Center");
        jPanel3.add((Component)this.selLabel, "South");
        jPanel3.setBorder(new EtchedBorder(1));
        this.performJComboBoxEvent = true;
        if (this.dataset instanceof CompoundDS) {
            serializable2 = (CompoundDS)this.dataset;
            object = ((CompoundDS)serializable2).getMemberNames();
            this.fieldList = new JList<String>((E[])object);
            this.fieldList.addSelectionInterval(0, ((String[])object).length - 1);
            jLabelArray = new JPanel();
            jLabelArray.setLayout(new BorderLayout());
            n = 150 + (ViewProperties.getFontSize() - 12) * 10;
            n4 = 250 + (ViewProperties.getFontSize() - 12) * 15;
            jLabelArray.setPreferredSize(new Dimension(n, n4));
            jComponent = new JScrollPane(this.fieldList);
            jLabelArray.add(jComponent);
            jLabelArray.setBorder(new TitledBorder("Select Members"));
            ((Container)object2).add((Component)jLabelArray, "West");
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)new JLabel("        TableView:  "), "West");
            jPanel4.add((Component)this.choiceTableView, "Center");
            jPanel4.setBorder(new LineBorder(Color.LIGHT_GRAY));
            jPanel2.add((Component)jPanel4, "South");
        } else if (this.dataset instanceof ScalarDS) {
            serializable2 = (ScalarDS)this.dataset;
            this.isText = ((ScalarDS)serializable2).isText();
            if (this.isText) {
                n = 700 + (ViewProperties.getFontSize() - 12) * 15;
                n4 = 280 + (ViewProperties.getFontSize() - 12) * 10;
                ((JComponent)object2).setPreferredSize(new Dimension(n, n4));
                object = new JPanel();
                ((Container)object).setLayout(new BorderLayout());
                ((Container)object).add((Component)new JLabel("          TextView:  "), "West");
                ((Container)object).add((Component)this.choiceTextView, "Center");
                ((JComponent)object).setBorder(new LineBorder(Color.LIGHT_GRAY));
                jPanel2.add((Component)object, "South");
            } else {
                n = 680 + (ViewProperties.getFontSize() - 12) * 15;
                n4 = 400 + (ViewProperties.getFontSize() - 12) * 10;
                ((JComponent)object2).setPreferredSize(new Dimension(n, n4));
                if (this.rank > 1) {
                    jPanel2.add((Component)jPanel3, "West");
                }
                this.imageButton.addItemListener(this);
                this.spreadsheetButton.addItemListener(this);
                object = new ButtonGroup();
                ((ButtonGroup)object).add(this.spreadsheetButton);
                ((ButtonGroup)object).add(this.imageButton);
                jLabelArray = new JPanel();
                jLabelArray.setLayout(new GridLayout(2, 1, 5, 5));
                jLabelArray.setBorder(new TitledBorder("Display As"));
                jComponent = new JPanel();
                jComponent.setLayout(new GridLayout(1, 2, 25, 5));
                jComponent.add(this.spreadsheetButton);
                int n5 = ((Dataset)serializable2).getDatatype().getDatatypeClass();
                if (n5 == 2 || n5 == 0 && ((Dataset)serializable2).getDatatype().getDatatypeSize() == 1) {
                    jComponent.add(this.charCheckbox);
                }
                jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)new JLabel("TableView:   "), "West");
                jPanel.add((Component)this.choiceTableView, "Center");
                serializable = new JPanel();
                serializable.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
                serializable.setLayout(new GridLayout(2, 1, 5, 5));
                serializable.add(jComponent);
                serializable.add(jPanel);
                jLabelArray.add((Component)serializable);
                JPanel jPanel5 = new JPanel();
                jPanel5.setLayout(new BorderLayout(5, 5));
                jPanel5.add((Component)this.imageButton, "West");
                jPanel5.add((Component)this.choicePalette, "Center");
                JPanel jPanel6 = new JPanel();
                jPanel6.setLayout(new BorderLayout());
                jPanel6.add((Component)new JLabel("ImageView: "), "West");
                jPanel6.add((Component)this.choiceImageView, "Center");
                JPanel jPanel7 = new JPanel();
                jPanel7.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
                jPanel7.setLayout(new GridLayout(2, 1, 5, 5));
                jPanel7.add(jPanel5);
                jPanel7.add(jPanel6);
                jLabelArray.add(jPanel7);
                JPanel jPanel8 = new JPanel();
                jPanel8.setLayout(new GridLayout(1, 2, 5, 5));
                jPanel8.add((Component)jLabelArray);
                if (n5 == 2 || n5 == 0 && ((Dataset)serializable2).getDatatype().getDatatypeSize() <= 2) {
                    int n6;
                    this.bitmaskButtons = new JRadioButton[8 * ((Dataset)serializable2).getDatatype().getDatatypeSize()];
                    int n7 = 0;
                    while (n7 < this.bitmaskButtons.length) {
                        this.bitmaskButtons[n7] = new JRadioButton(String.valueOf(n7));
                        this.bitmaskButtons[n7].setEnabled(false);
                        ++n7;
                    }
                    JPanel jPanel9 = new JPanel();
                    jPanel8.add(jPanel9);
                    jPanel9.setBorder(new TitledBorder("Set Bitmask"));
                    JPanel jPanel10 = new JPanel();
                    if (this.bitmaskButtons.length <= 8) {
                        jPanel10.setLayout(new GridLayout(1, this.bitmaskButtons.length));
                        n6 = 0;
                        while (n6 <= this.bitmaskButtons.length - 1) {
                            jPanel10.add(this.bitmaskButtons[n6]);
                            ++n6;
                        }
                    } else {
                        jPanel10.setLayout(new GridLayout(2, this.bitmaskButtons.length / 2));
                        n6 = 0;
                        while (n6 <= this.bitmaskButtons.length / 2 - 1) {
                            jPanel10.add(this.bitmaskButtons[n6]);
                            ++n6;
                        }
                        n6 = this.bitmaskButtons.length / 2;
                        while (n6 <= this.bitmaskButtons.length - 1) {
                            jPanel10.add(this.bitmaskButtons[n6]);
                            ++n6;
                        }
                    }
                    jPanel9.setLayout(new BorderLayout(10, 10));
                    jPanel9.add((Component)jPanel10, "Center");
                    jPanel10 = new JPanel();
                    jPanel10.setLayout(new BorderLayout());
                    jPanel10.add((Component)this.bitmaskCheckbox, "West");
                    jPanel10.add((Component)this.bitmaskHelp, "East");
                    jPanel9.add((Component)jPanel10, "North");
                }
                ((Container)object2).add((Component)jPanel8, "North");
            }
        }
        serializable2 = new JPanel();
        ((Container)serializable2).setLayout(new GridLayout(5, 6, 10, 3));
        ((JComponent)serializable2).setBorder(new EtchedBorder(1));
        jPanel2.add((Component)serializable2, "Center");
        ((Container)object2).add((Component)jPanel2, "Center");
        ((Container)serializable2).add(new JLabel(" "));
        if (this.rank > 1) {
            ((Container)serializable2).add(this.transposeChoice);
        } else {
            ((Container)serializable2).add(new JLabel(" "));
        }
        object = new JLabel("Start:");
        ((Container)serializable2).add((Component)object);
        object = new JLabel("End: ");
        ((Container)serializable2).add((Component)object);
        object = new JLabel("Stride:");
        ((Container)serializable2).add((Component)object);
        object = new JLabel("Max Size");
        ((Container)serializable2).add((Component)object);
        this.choices = new JComboBox[3];
        this.maxLabels = new JLabel[3];
        this.startFields = new JTextField[3];
        this.endFields = new JTextField[3];
        this.strideFields = new JTextField[3];
        jLabelArray = new JLabel[]{new JLabel("Height", 4), new JLabel("Width", 4), new JLabel("Depth", 4)};
        jComponent = this.dataset.getDimNames();
        int n8 = 0;
        while (n8 < 3) {
            this.choices[n8] = new JComboBox();
            this.choices[n8].addItemListener(this);
            int n9 = 0;
            while (n9 < this.rank) {
                if (jComponent == null) {
                    this.choices[n8].addItem("dim " + n9);
                } else {
                    this.choices[n8].addItem(jComponent[n9]);
                }
                ++n9;
            }
            this.maxLabels[n8] = new JLabel("1");
            this.startFields[n8] = new JTextField("0");
            this.endFields[n8] = new JTextField("0");
            this.strideFields[n8] = new JTextField("1");
            ((Container)serializable2).add(jLabelArray[n8]);
            ((Container)serializable2).add(this.choices[n8]);
            ((Container)serializable2).add(this.startFields[n8]);
            ((Container)serializable2).add(this.endFields[n8]);
            ((Container)serializable2).add(this.strideFields[n8]);
            ((Container)serializable2).add(this.maxLabels[n8]);
            this.choices[n8].setEnabled(false);
            this.startFields[n8].setEnabled(false);
            this.endFields[n8].setEnabled(false);
            this.strideFields[n8].setEnabled(false);
            this.maxLabels[n8].setEnabled(false);
            ++n8;
        }
        JButton jButton = new JButton("dims...");
        ((Container)serializable2).add(new JLabel("", 4));
        ((Container)serializable2).add(jButton);
        jButton.setActionCommand("Select more dimensions");
        jButton.addActionListener(this);
        jButton.setEnabled(this.rank > 3);
        ((Container)serializable2).add(new JLabel(" "));
        ((Container)serializable2).add(new JLabel(" "));
        jButton = new JButton("Reset");
        jButton.setActionCommand("Reset data range");
        jButton.addActionListener(this);
        ((Container)serializable2).add(jButton);
        ((Container)serializable2).add(new JLabel(" "));
        jPanel = new JPanel();
        ((Container)object2).add((Component)jPanel, "South");
        jButton = new JButton("   Ok   ");
        jButton.setMnemonic(79);
        jButton.setActionCommand("Ok");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        jButton = new JButton("Cancel");
        jButton.setMnemonic(67);
        jButton.setActionCommand("Cancel");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        this.init();
        serializable = this.getParent().getLocation();
        ((Point)serializable).x += 250;
        ((Point)serializable).y += 80;
        this.setLocation((Point)serializable);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Ok")) {
            if (this.dataset instanceof ScalarDS && this.imageButton.isSelected()) {
                this.setPalette();
            }
            boolean bl = this.isSelectionCancelled = !this.setSelection();
            if (this.isSelectionCancelled) {
                return;
            }
            if (this.dataset instanceof ScalarDS) {
                ((ScalarDS)this.dataset).setIsImageDisplay(this.imageButton.isSelected());
            }
            this.dispose();
        } else if (string.equals("Cancel")) {
            this.dispose();
        } else if (string.equals("Reset data range")) {
            int n = this.startFields.length;
            int n2 = 0;
            while (n2 < n) {
                this.startFields[n2].setText("0");
                this.strideFields[n2].setText("1");
                long l = Long.valueOf(this.maxLabels[n2].getText()) - 1L;
                this.endFields[n2].setText(String.valueOf(l));
                ++n2;
            }
        } else if (string.equals("Select more dimensions")) {
            if (this.rank < 4) {
                return;
            }
            int n = 0;
            Vector vector = new Vector(this.rank);
            int[] nArray = new int[this.rank - 3];
            int n3 = 0;
            while (n3 < this.rank) {
                if (n3 != this.currentIndex[0] && n3 != this.currentIndex[1] && n3 != this.currentIndex[2]) {
                    vector.add(this.choices[0].getItemAt(n3));
                    nArray[n++] = n3;
                }
                ++n3;
            }
            String string2 = "Select slice location for dimension(s):\n\"" + vector.get(0) + " [0 .. " + (this.dims[nArray[0]] - 1L) + "]\"";
            String string3 = String.valueOf(this.start[nArray[0]]);
            int n4 = vector.size();
            int n5 = 1;
            while (n5 < n4) {
                string2 = String.valueOf(string2) + " x \"" + vector.get(n5) + " [0 .. " + (this.dims[nArray[n5]] - 1L) + "]\"";
                string3 = String.valueOf(string3) + " x " + String.valueOf(this.start[nArray[n5]]);
                ++n5;
            }
            String string4 = JOptionPane.showInputDialog(this, string2, string3);
            if (string4 == null || (string4 = string4.trim()) == null || string4.length() < 1) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "x");
            if (stringTokenizer.countTokens() < n4) {
                JOptionPane.showMessageDialog(this, "Number of dimension(s) is less than " + n4 + "\n" + string4, "Select Slice Location", 0);
                return;
            }
            long[] lArray = new long[n4];
            int n6 = 0;
            while (n6 < n4) {
                try {
                    lArray[n6] = Long.parseLong(stringTokenizer.nextToken().trim());
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, exception.getMessage(), "Select Slice Location", 0);
                    return;
                }
                if (lArray[n6] < 0L || lArray[n6] >= this.dims[nArray[n6]]) {
                    JOptionPane.showMessageDialog(this, "Slice location is out of range.\n" + lArray[n6] + " >= " + this.dims[nArray[n6]], "Select Slice Location", 0);
                    return;
                }
                ++n6;
            }
            n6 = 0;
            while (n6 < n4) {
                this.start[nArray[n6]] = lArray[n6];
                ++n6;
            }
        } else if (string.equals("Help on how to set bitmask")) {
            String string5 = "The bitmask is used to extract the value(s) of specific bit(s) from a byte data.\nThe bitwise AND is used to perform the bit mask operation. This operation is used\nto isolate part of a string of bits, or to determine whether a particular bit is 1 or 0.\n\nFor example, \n        bit pattern \"00100000\"  determines whether the third bit is 1.\n        bit pattern \"00000011\"  determines whether the last two bits are 1.\n\nA valid bitmask MUST be a string of 8 or less bits of 1's and 0's. For example,\n        00000001\n        10000001\n         1 (same as 00000001)\n        11 (same as 00000011)\n\n";
            JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), string5);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n;
        int n2;
        Serializable serializable;
        Object object = itemEvent.getSource();
        if (object.equals(this.imageButton) || object.equals(this.spreadsheetButton)) {
            this.choicePalette.setEnabled(this.imageButton.isSelected() && !this.isTrueColorImage);
            if (this.imageButton.isSelected()) {
                this.choiceImageView.setEnabled(true);
                this.choiceTableView.setEnabled(false);
            } else {
                this.choiceImageView.setEnabled(false);
                this.choiceTableView.setEnabled(true);
            }
            serializable = this.dataset.getDatatype();
            n2 = ((Datatype)serializable).getDatatypeClass();
            if (n2 == 2 || n2 == 0) {
                n = ((Datatype)serializable).getDatatypeSize();
                this.charCheckbox.setEnabled(this.spreadsheetButton.isSelected() && n == 1);
                this.bitmaskCheckbox.setEnabled(n <= 2);
            } else {
                this.charCheckbox.setEnabled(false);
                this.charCheckbox.setSelected(false);
                this.bitmaskCheckbox.setEnabled(false);
                this.bitmaskCheckbox.setSelected(false);
            }
            if (this.bitmaskCheckbox.isEnabled()) {
                this.setEnableBitmask(this.bitmaskCheckbox.isEnabled() && this.bitmaskCheckbox.isSelected());
            }
        }
        if (object.equals(this.bitmaskCheckbox)) {
            if (this.bitmaskCheckbox.isSelected()) {
                this.charCheckbox.setSelected(false);
            }
            this.setEnableBitmask(this.bitmaskCheckbox.isSelected());
        }
        if (object.equals(this.charCheckbox)) {
            if (this.charCheckbox.isSelected()) {
                this.bitmaskCheckbox.setSelected(false);
            }
            this.setEnableBitmask(this.bitmaskCheckbox.isSelected());
        } else if (object instanceof JComboBox) {
            if (!this.performJComboBoxEvent) {
                return;
            }
            if (itemEvent.getStateChange() == 2) {
                return;
            }
            serializable = (JComboBox)object;
            n2 = -1;
            n = Math.min(3, this.rank);
            int n3 = 0;
            while (n3 < n) {
                if (serializable.equals(this.choices[n3])) {
                    n2 = n3;
                }
                ++n3;
            }
            if (n2 < 0) {
                return;
            }
            n3 = ((JComboBox)serializable).getSelectedIndex();
            if (n3 == this.currentIndex[n2]) {
                return;
            }
            this.start[this.currentIndex[n2]] = 0L;
            this.startFields[n2].setText("0");
            this.endFields[n2].setText(String.valueOf(this.dims[n3] - 1L));
            this.strideFields[n2].setText("1");
            this.maxLabels[n2].setText(String.valueOf(this.dims[n3]));
            int n4 = 0;
            while (n4 < n) {
                if (n4 != n2 && n3 == this.choices[n4].getSelectedIndex()) {
                    this.setJComboBoxSelectedIndex(this.choices[n4], this.currentIndex[n2]);
                    this.startFields[n4].setText("0");
                    this.endFields[n4].setText(String.valueOf(this.dims[this.currentIndex[n2]] - 1L));
                    this.strideFields[n4].setText("1");
                    this.maxLabels[n4].setText(String.valueOf(this.dims[this.currentIndex[n2]]));
                }
                ++n4;
            }
            n4 = 0;
            while (n4 < n) {
                this.currentIndex[n4] = this.choices[n4].getSelectedIndex();
                ++n4;
            }
            if (this.rank > 1) {
                if (this.isText) {
                    this.endFields[1].setText(this.startFields[1].getText());
                } else {
                    n4 = this.choices[0].getSelectedIndex();
                    int n5 = this.choices[1].getSelectedIndex();
                    this.transposeChoice.setSelectedIndex(0);
                    if (n4 < n5) {
                        this.transposeChoice.setEnabled(false);
                    } else {
                        this.transposeChoice.setEnabled(true);
                    }
                    long[] lArray = this.dataset.getDims();
                    int n6 = (int)lArray[n5];
                    int n7 = (int)lArray[n4];
                    this.navigator.setDimensionSize(n6, n7);
                    this.navigator.updateUI();
                }
            }
            if (this.rank > 2) {
                this.endFields[2].setText(this.startFields[2].getText());
            }
        }
    }

    public boolean isCancelled() {
        return this.isSelectionCancelled;
    }

    public boolean isImageDisplay() {
        return this.imageButton.isSelected();
    }

    private void setEnableBitmask(boolean bl) {
        int n = 0;
        while (n < this.bitmaskButtons.length) {
            this.bitmaskButtons[n].setEnabled(bl);
            ++n;
        }
    }

    private void init() {
        int n;
        boolean bl = false;
        if (this.dataset instanceof ScalarDS) {
            ScalarDS scalarDS = (ScalarDS)this.dataset;
            bl = scalarDS.isImageDisplay();
            this.isTrueColorImage = scalarDS.isTrueColor();
        } else if (this.dataset instanceof CompoundDS) {
            this.imageButton.setEnabled(false);
        }
        this.choiceTableView.setEnabled(!bl);
        this.choiceImageView.setEnabled(bl);
        this.imageButton.setSelected(bl);
        this.choicePalette.setEnabled(bl && !this.isTrueColorImage);
        int n2 = Math.min(3, this.rank);
        long l = 0L;
        int n3 = 0;
        while (n3 < n2) {
            this.choices[n3].setEnabled(true);
            this.startFields[n3].setEnabled(true);
            this.endFields[n3].setEnabled(true);
            this.strideFields[n3].setEnabled(true);
            this.maxLabels[n3].setEnabled(true);
            n = this.selectedIndex[n3];
            l = this.start[n] + this.selected[n] * this.stride[n];
            if (l >= this.dims[n]) {
                l = this.dims[n];
            }
            this.setJComboBoxSelectedIndex(this.choices[n3], n);
            this.maxLabels[n3].setText(String.valueOf(this.dims[n]));
            this.startFields[n3].setText(String.valueOf(this.start[n]));
            this.endFields[n3].setText(String.valueOf(l - 1L));
            if (!this.isH5 && this.dataset instanceof CompoundDS) {
                this.strideFields[n3].setEnabled(false);
            } else {
                this.strideFields[n3].setText(String.valueOf(this.stride[n]));
            }
            ++n3;
        }
        if (this.rank > 1) {
            this.transposeChoice.setEnabled(this.choices[0].getSelectedIndex() > this.choices[1].getSelectedIndex());
            if (this.isText) {
                this.endFields[1].setEnabled(false);
                this.endFields[1].setText(this.startFields[1].getText());
            }
        }
        if (this.rank > 2) {
            this.endFields[2].setEnabled(false);
            this.strideFields[2].setEnabled(false);
            if (this.isTrueColorImage && this.imageButton.isSelected()) {
                this.choices[0].setEnabled(false);
                this.choices[1].setEnabled(false);
                this.choices[2].setEnabled(false);
                this.startFields[2].setEnabled(false);
                this.startFields[2].setText("0");
                this.endFields[2].setText("0");
            } else {
                this.choices[0].setEnabled(true);
                this.choices[1].setEnabled(true);
                this.choices[2].setEnabled(true);
                this.startFields[2].setEnabled(true);
                this.startFields[2].setText(String.valueOf(this.start[this.selectedIndex[2]]));
                this.endFields[2].setText(this.startFields[2].getText());
            }
        }
        n3 = 0;
        while (n3 < n2) {
            this.currentIndex[n3] = this.choices[n3].getSelectedIndex();
            ++n3;
        }
        Datatype datatype = this.dataset.getDatatype();
        n = datatype.getDatatypeClass();
        if (n == 2 || n == 0) {
            int n4 = datatype.getDatatypeSize();
            this.charCheckbox.setEnabled(n4 == 1 && this.spreadsheetButton.isSelected());
            this.bitmaskCheckbox.setEnabled(n4 <= 2);
        } else {
            this.charCheckbox.setEnabled(false);
            this.charCheckbox.setSelected(false);
            this.bitmaskCheckbox.setEnabled(false);
        }
    }

    private void setJComboBoxSelectedIndex(JComboBox jComboBox, int n) {
        this.performJComboBoxEvent = false;
        jComboBox.setSelectedIndex(n);
        this.performJComboBoxEvent = true;
    }

    private void setPalette() {
        if (!(this.dataset instanceof ScalarDS)) {
            return;
        }
        byte[][] byArray = null;
        int n = this.choicePalette.getSelectedIndex();
        if (n == 0) {
            return;
        }
        if (n == this.numberOfPalettes + 1) {
            byArray = Tools.createGrayPalette();
        } else if (n == this.numberOfPalettes + 2) {
            byArray = Tools.createReverseGrayPalette();
        } else if (n == this.numberOfPalettes + 3) {
            byArray = Tools.createGrayWavePalette();
        } else if (n == this.numberOfPalettes + 4) {
            byArray = Tools.createRainbowPalette();
        } else if (n == this.numberOfPalettes + 5) {
            byArray = Tools.createNaturePalette();
        } else if (n == this.numberOfPalettes + 6) {
            byArray = Tools.createWavePalette();
        } else if (n > 0 && n <= this.numberOfPalettes) {
            byArray = ((ScalarDS)this.dataset).readPalette(n - 1);
        }
        ((ScalarDS)this.dataset).setPalette(byArray);
    }

    private boolean setSelection() {
        long[] lArray = new long[3];
        long[] lArray2 = new long[3];
        long[] lArray3 = new long[]{1L, 1L, 1L};
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] nArray2 = nArray;
        boolean bl = true;
        int n = Math.min(3, this.rank);
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = this.choices[n2].getSelectedIndex();
            try {
                lArray[n2] = Long.parseLong(this.startFields[n2].getText());
                if (n2 < 2) {
                    lArray2[n2] = Long.parseLong(this.endFields[n2].getText());
                    lArray3[n2] = Long.parseLong(this.strideFields[n2].getText());
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), numberFormatException.getMessage(), this.getTitle(), 0);
                return false;
            }
            if (lArray[n2] < 0L) {
                lArray[n2] = 0L;
            }
            if (lArray[n2] >= this.dims[nArray2[n2]]) {
                lArray[n2] = this.dims[nArray2[n2]] - 1L;
            }
            if (lArray2[n2] < 0L) {
                lArray2[n2] = 0L;
            }
            if (lArray2[n2] >= this.dims[nArray2[n2]]) {
                lArray2[n2] = this.dims[nArray2[n2]] - 1L;
            }
            if (lArray[n2] > lArray2[n2]) {
                lArray2[n2] = lArray[n2];
            }
            if (lArray3[n2] > this.dims[nArray2[n2]]) {
                lArray3[n2] = this.dims[nArray2[n2]];
            }
            if (lArray3[n2] <= 0L) {
                lArray3[n2] = 1L;
            }
            ++n2;
        }
        if (this.dataset instanceof CompoundDS) {
            CompoundDS compoundDS = (CompoundDS)this.dataset;
            int[] nArray3 = this.fieldList.getSelectedIndices();
            if (nArray3 == null || nArray3.length < 1) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), "No member/field is selected.", this.getTitle(), 0);
                return false;
            }
            compoundDS.setMemberSelection(false);
            int n3 = 0;
            while (n3 < nArray3.length) {
                compoundDS.selectMember(nArray3[n3]);
                ++n3;
            }
        }
        int n4 = 0;
        while (n4 < this.rank) {
            this.selected[n4] = 1L;
            this.stride[n4] = 1L;
            ++n4;
        }
        n4 = 0;
        while (n4 < n) {
            this.selectedIndex[n4] = nArray2[n4];
            this.start[this.selectedIndex[n4]] = lArray[n4];
            if (n4 < 2) {
                this.selected[this.selectedIndex[n4]] = (int)((lArray2[n4] - lArray[n4] + 1L) / lArray3[n4]);
                this.stride[this.selectedIndex[n4]] = lArray3[n4];
            }
            ++n4;
        }
        if (this.rank > 1 && this.isText) {
            this.selected[this.selectedIndex[1]] = 1L;
            this.stride[this.selectedIndex[1]] = 1L;
        } else if (this.rank > 2 && this.isTrueColorImage && this.imageButton.isSelected()) {
            this.start[this.selectedIndex[2]] = 0L;
            this.selected[this.selectedIndex[2]] = 3L;
        }
        this.dataset.clearData();
        bl = this.setBitmask();
        return bl;
    }

    private boolean setBitmask() {
        if (!this.bitmaskCheckbox.isVisible() || !this.bitmaskCheckbox.isSelected() || this.bitmaskButtons == null) {
            this.bitmask = null;
            return true;
        }
        int n = this.bitmaskButtons.length;
        if (this.bitmask == null) {
            this.bitmask = new BitSet(n);
        }
        int n2 = 0;
        while (n2 < n) {
            this.bitmask.set(n2, this.bitmaskButtons[n2].isSelected());
            ++n2;
        }
        if (this.bitmask.isEmpty()) {
            JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), "The bitmask is empty. It will not be applied to the data.", this.getTitle(), 2);
            this.bitmask = null;
        } else {
            n2 = 1;
            int n3 = this.bitmask.size();
            int n4 = 0;
            while (n4 < n3) {
                n2 = this.bitmask.get(n4) && n2 != 0 ? 1 : 0;
                ++n4;
            }
            if (n2 != 0) {
                JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), "The bitmask is empty. It will not be applied to the data.", this.getTitle(), 2);
                this.bitmask = null;
            }
        }
        return true;
    }

    public boolean isDisplayTypeChar() {
        return this.charCheckbox.isSelected();
    }

    public BitSet getBitmask() {
        if (!this.bitmaskCheckbox.isEnabled() || !this.bitmaskCheckbox.isSelected()) {
            return null;
        }
        if (this.bitmask == null) {
            return null;
        }
        if (this.bitmask.isEmpty()) {
            return null;
        }
        boolean bl = true;
        int n = this.bitmask.size();
        int n2 = 0;
        while (n2 < n) {
            bl = this.bitmask.get(n2) && bl;
            ++n2;
        }
        if (bl) {
            return null;
        }
        return this.bitmask;
    }

    public boolean isTransposed() {
        return this.transposeChoice.getSelectedIndex() == 1;
    }

    public String getDataViewName() {
        String string = null;
        string = this.isText ? (String)this.choiceTextView.getSelectedItem() : (this.isImageDisplay() ? (String)this.choiceImageView.getSelectedItem() : (String)this.choiceTableView.getSelectedItem());
        return string;
    }

    private class PreviewNavigator
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        public static final long serialVersionUID = 240L;
        private final int NAVIGATOR_SIZE = 150;
        private int dimX;
        private int dimY;
        private int x;
        private int y;
        private double r;
        private Point startPosition;
        private Rectangle selectedArea;
        private Image previewImage = null;

        private PreviewNavigator(int n, int n2) {
            this.dimX = n;
            this.dimY = n2;
            if (this.dimX > this.dimY) {
                this.x = 150;
                this.r = (double)this.dimX / (double)this.x;
                this.y = (int)((double)this.dimY / this.r);
            } else {
                this.y = 150;
                this.r = (double)this.dimY / (double)this.y;
                this.x = (int)((double)this.dimX / this.r);
            }
            this.selectedArea = new Rectangle();
            this.setPreferredSize(new Dimension(150, 150));
            try {
                this.previewImage = this.createPreviewImage();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        private Image createPreviewImage() throws Exception {
            if (DataOptionDialog.this.rank <= 1 || !(DataOptionDialog.this.dataset instanceof ScalarDS)) {
                return null;
            }
            Image image = null;
            ScalarDS scalarDS = (ScalarDS)DataOptionDialog.this.dataset;
            if (scalarDS.isText()) {
                return null;
            }
            long[] lArray = new long[DataOptionDialog.this.rank];
            long[] lArray2 = new long[DataOptionDialog.this.rank];
            long[] lArray3 = new long[DataOptionDialog.this.rank];
            int[] nArray = new int[3];
            System.arraycopy(DataOptionDialog.this.stride, 0, lArray, 0, DataOptionDialog.this.rank);
            System.arraycopy(DataOptionDialog.this.selected, 0, lArray2, 0, DataOptionDialog.this.rank);
            System.arraycopy(DataOptionDialog.this.start, 0, lArray3, 0, DataOptionDialog.this.rank);
            System.arraycopy(DataOptionDialog.this.selectedIndex, 0, nArray, 0, 3);
            int n = 0;
            while (n < DataOptionDialog.this.rank) {
                ((DataOptionDialog)DataOptionDialog.this).start[n] = 0L;
                ((DataOptionDialog)DataOptionDialog.this).stride[n] = 1L;
                ((DataOptionDialog)DataOptionDialog.this).selected[n] = 1L;
                ++n;
            }
            if (DataOptionDialog.this.choices != null) {
                ((DataOptionDialog)DataOptionDialog.this).selectedIndex[0] = DataOptionDialog.this.choices[0].getSelectedIndex();
                ((DataOptionDialog)DataOptionDialog.this).selectedIndex[1] = DataOptionDialog.this.choices[1].getSelectedIndex();
            }
            long l = (long)Math.ceil(this.r);
            ((DataOptionDialog)DataOptionDialog.this).selected[((DataOptionDialog)DataOptionDialog.this).selectedIndex[0]] = DataOptionDialog.this.dims[DataOptionDialog.this.selectedIndex[0]] / l;
            ((DataOptionDialog)DataOptionDialog.this).selected[((DataOptionDialog)DataOptionDialog.this).selectedIndex[1]] = DataOptionDialog.this.dims[DataOptionDialog.this.selectedIndex[1]] / l;
            long l2 = l;
            ((DataOptionDialog)DataOptionDialog.this).stride[((DataOptionDialog)DataOptionDialog.this).selectedIndex[1]] = l2;
            ((DataOptionDialog)DataOptionDialog.this).stride[((DataOptionDialog)DataOptionDialog.this).selectedIndex[0]] = l2;
            if (DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[0]] == 0L) {
                ((DataOptionDialog)DataOptionDialog.this).selected[((DataOptionDialog)DataOptionDialog.this).selectedIndex[0]] = 1L;
            }
            if (DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[1]] == 0L) {
                ((DataOptionDialog)DataOptionDialog.this).selected[((DataOptionDialog)DataOptionDialog.this).selectedIndex[1]] = 1L;
            }
            if (DataOptionDialog.this.isTrueColorImage && DataOptionDialog.this.start.length > 2) {
                ((DataOptionDialog)DataOptionDialog.this).start[((DataOptionDialog)DataOptionDialog.this).selectedIndex[2]] = 0L;
                ((DataOptionDialog)DataOptionDialog.this).selected[((DataOptionDialog)DataOptionDialog.this).selectedIndex[2]] = 3L;
                ((DataOptionDialog)DataOptionDialog.this).stride[((DataOptionDialog)DataOptionDialog.this).selectedIndex[2]] = 1L;
            }
            this.y = (int)DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[0]];
            this.x = (int)DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[1]];
            this.r = Math.min((double)DataOptionDialog.this.dims[DataOptionDialog.this.selectedIndex[0]] / (double)DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[0]], (double)DataOptionDialog.this.dims[DataOptionDialog.this.selectedIndex[1]] / (double)DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[1]]);
            try {
                Object object = scalarDS.read();
                Object object2 = scalarDS.getFillValue();
                if (object2 != null && scalarDS.isFillValueConverted) {
                    object2 = ScalarDS.convertToUnsignedC(object2, null);
                }
                byte[] byArray = Tools.getBytes(object, scalarDS.getImageDataRange(), object2, null);
                int n2 = scalarDS.getHeight();
                int n3 = scalarDS.getWidth();
                if (DataOptionDialog.this.isTrueColorImage) {
                    boolean bl = scalarDS.getInterlace() == 2;
                    image = Tools.createTrueColorImage(byArray, bl, n3, n2);
                } else {
                    int n4;
                    int n5;
                    byte[] byArray2;
                    int n6;
                    byte[][] byArray3 = scalarDS.getPalette();
                    if (byArray3 == null) {
                        byArray3 = Tools.createGrayPalette();
                    }
                    if ((DataOptionDialog.this.isH5 || DataOptionDialog.this.rank > 2) && DataOptionDialog.this.selectedIndex[0] > DataOptionDialog.this.selectedIndex[1]) {
                        n6 = byArray.length;
                        byArray2 = new byte[n6];
                        System.arraycopy(byArray, 0, byArray2, 0, n6);
                        n5 = 0;
                        while (n5 < n2) {
                            n4 = 0;
                            while (n4 < n3) {
                                byArray[n5 * n3 + n4] = byArray2[n4 * n2 + n5];
                                ++n4;
                            }
                            ++n5;
                        }
                    }
                    if (!DataOptionDialog.this.isH5 && !scalarDS.isDefaultImageOrder() && DataOptionDialog.this.selectedIndex[1] > DataOptionDialog.this.selectedIndex[0]) {
                        n6 = byArray.length;
                        byArray2 = new byte[n6];
                        System.arraycopy(byArray, 0, byArray2, 0, n6);
                        n5 = 0;
                        while (n5 < n2) {
                            n4 = 0;
                            while (n4 < n3) {
                                byArray[n5 * n3 + n4] = byArray2[n4 * n2 + n5];
                                ++n4;
                            }
                            ++n5;
                        }
                    }
                    image = Tools.createIndexedImage(byArray, byArray3, n3, n2);
                }
            }
            finally {
                System.arraycopy(lArray, 0, DataOptionDialog.this.stride, 0, DataOptionDialog.this.rank);
                System.arraycopy(lArray2, 0, DataOptionDialog.this.selected, 0, DataOptionDialog.this.rank);
                System.arraycopy(lArray3, 0, DataOptionDialog.this.start, 0, DataOptionDialog.this.rank);
                System.arraycopy(nArray, 0, DataOptionDialog.this.selectedIndex, 0, 3);
            }
            return image;
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor(Color.blue);
            if (this.previewImage != null) {
                graphics.drawImage(this.previewImage, 0, 0, this);
            } else {
                graphics.fillRect(0, 0, this.x, this.y);
            }
            int n = this.selectedArea.width;
            int n2 = this.selectedArea.height;
            if (n > 0 && n2 > 0) {
                graphics.setColor(Color.red);
                graphics.drawRect(this.selectedArea.x, this.selectedArea.y, n, n2);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.startPosition = mouseEvent.getPoint();
            this.selectedArea.setBounds(this.startPosition.x, this.startPosition.y, 0, 0);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.startPosition = mouseEvent.getPoint();
            this.selectedArea.setBounds(this.startPosition.x, this.startPosition.y, 0, 0);
            this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = this.startPosition;
            Point point2 = mouseEvent.getPoint();
            int n = Math.max(0, Math.min(point.x, point2.x));
            int n2 = Math.max(0, Math.min(point.y, point2.y));
            int n3 = Math.min(this.x, Math.max(point.x, point2.x));
            int n4 = Math.min(this.y, Math.max(point.y, point2.y));
            int n5 = n3 - n;
            int n6 = n4 - n2;
            this.selectedArea.setBounds(n, n2, n5, n6);
            try {
                this.updateSelection(n, n2, n5, n6);
            }
            catch (Exception exception) {}
            this.repaint();
        }

        private void updateSelection(int n, int n2, int n3, int n4) {
            int n5 = 0;
            int n6 = 0;
            n5 = (int)((double)n2 * this.r);
            if ((long)n5 > DataOptionDialog.this.dims[DataOptionDialog.this.currentIndex[0]]) {
                n5 = (int)DataOptionDialog.this.dims[DataOptionDialog.this.currentIndex[0]];
            }
            DataOptionDialog.this.startFields[0].setText(String.valueOf(n5));
            n6 = (int)((double)(n2 + n4) * this.r);
            if (n6 < n5) {
                n6 = n5;
            }
            DataOptionDialog.this.endFields[0].setText(String.valueOf(n6));
            String string = String.valueOf((int)((double)n4 * this.r));
            if (DataOptionDialog.this.rank > 1) {
                n5 = (int)((double)n * this.r);
                if ((long)n5 > DataOptionDialog.this.dims[DataOptionDialog.this.currentIndex[1]]) {
                    n5 = (int)DataOptionDialog.this.dims[DataOptionDialog.this.currentIndex[1]];
                }
                DataOptionDialog.this.startFields[1].setText(String.valueOf(n5));
                n6 = (int)((double)(n + n3) * this.r);
                if (n6 < n5) {
                    n6 = n5;
                }
                DataOptionDialog.this.endFields[1].setText(String.valueOf(n6));
                string = String.valueOf(string) + " x " + (int)((double)n3 * this.r);
            }
            DataOptionDialog.this.selLabel.setText(string);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private void setDimensionSize(int n, int n2) {
            this.dimX = n;
            this.dimY = n2;
            if (this.dimX > this.dimY) {
                this.x = 150;
                this.r = (double)this.dimX / (double)this.x;
                this.y = (int)((double)this.dimY / this.r);
            } else {
                this.y = 150;
                this.r = (double)this.dimY / (double)this.y;
                this.x = (int)((double)this.dimX / this.r);
            }
            this.setPreferredSize(new Dimension(150, 150));
            this.selectedArea.setSize(0, 0);
            try {
                this.previewImage = this.createPreviewImage();
            }
            catch (Exception exception) {}
            this.repaint();
        }
    }
}

