/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.nc2;

import java.util.List;
import ncsa.hdf.object.Datatype;
import ucar.ma2.DataType;

public class NC2Datatype
extends Datatype {
    public static final long serialVersionUID = 240L;
    DataType nativeType = null;

    public NC2Datatype(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    @Override
    public boolean hasAttribute() {
        return false;
    }

    public NC2Datatype(DataType dataType) {
        super(-1);
        this.nativeType = dataType;
        this.fromNative(0);
    }

    public static Object allocateArray(DataType dataType, int n) throws OutOfMemoryError {
        Object[] objectArray = null;
        if (n <= 0 || dataType == null) {
            return null;
        }
        if (dataType.equals((Object)DataType.BYTE)) {
            objectArray = new byte[n];
        } else if (dataType.equals((Object)DataType.SHORT)) {
            objectArray = new short[n];
        } else if (dataType.equals((Object)DataType.INT)) {
            objectArray = new int[n];
        } else if (dataType.equals((Object)DataType.LONG)) {
            objectArray = new long[n];
        } else if (dataType.equals((Object)DataType.FLOAT)) {
            objectArray = new float[n];
        } else if (dataType.equals((Object)DataType.DOUBLE)) {
            objectArray = new double[n];
        } else if (dataType.equals((Object)DataType.STRING)) {
            objectArray = new String[n];
        }
        return objectArray;
    }

    @Override
    public void fromNative(int n) {
        if (this.nativeType == null) {
            return;
        }
        this.datatypeOrder = -1;
        if (this.nativeType.equals((Object)DataType.BYTE)) {
            this.datatypeClass = 0;
            this.datatypeSize = 1;
        } else if (this.nativeType.equals((Object)DataType.SHORT)) {
            this.datatypeClass = 0;
            this.datatypeSize = 2;
        } else if (this.nativeType.equals((Object)DataType.INT)) {
            this.datatypeClass = 0;
            this.datatypeSize = 4;
        } else if (this.nativeType.equals((Object)DataType.LONG)) {
            this.datatypeClass = 0;
            this.datatypeSize = 8;
        } else if (this.nativeType.equals((Object)DataType.FLOAT)) {
            this.datatypeClass = 1;
            this.datatypeSize = 4;
        } else if (this.nativeType.equals((Object)DataType.DOUBLE)) {
            this.datatypeClass = 1;
            this.datatypeSize = 8;
        } else if (this.nativeType.equals((Object)DataType.STRING)) {
            this.datatypeClass = 3;
            this.datatypeSize = 80;
        }
    }

    @Override
    public String getDatatypeDescription() {
        if (this.nativeType == null) {
            return "Unknown data type.";
        }
        return this.nativeType.toString();
    }

    @Override
    public boolean isUnsigned() {
        return false;
    }

    @Override
    public int toNative() {
        if (this.datatypeClass == 0) {
            if (this.datatypeSize == 1) {
                this.nativeType = DataType.BYTE;
            } else if (this.datatypeSize == 2) {
                this.nativeType = DataType.SHORT;
            } else if (this.datatypeSize == 4) {
                this.nativeType = DataType.INT;
            } else if (this.datatypeSize == 8) {
                this.nativeType = DataType.LONG;
            }
        } else if (this.datatypeClass == 1) {
            if (this.datatypeSize == 4) {
                this.nativeType = DataType.FLOAT;
            } else if (this.datatypeSize == 8) {
                this.nativeType = DataType.DOUBLE;
            }
        } else if (this.datatypeClass == 3) {
            this.nativeType = DataType.STRING;
        }
        return -1;
    }

    @Override
    public void close(int n) {
    }

    public List getMetadata(int ... nArray) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

