/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5File;

public class H5ScalarDS
extends ScalarDS {
    public static final long serialVersionUID = 240L;
    private List attributeList;
    private byte[] paletteRefs;
    private boolean isVLEN = false;
    private boolean isEnum = false;
    private boolean isExternal = false;
    private boolean isNativeDatatype = true;
    private boolean isRegRef = false;
    private int nAttributes = -1;
    private H5O_info_t obj_info;

    public H5ScalarDS(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    @Deprecated
    public H5ScalarDS(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        this.unsignedConverted = false;
        this.paletteRefs = null;
        this.obj_info = new H5O_info_t(-1L, -1L, 0, 0, -1L, 0L, 0L, 0L, 0L, null, null, null);
        if (lArray == null && fileFormat != null) {
            try {
                byte[] byArray = H5.H5Rcreate(fileFormat.getFID(), this.getFullName(), HDF5Constants.H5R_OBJECT, -1);
                this.oid = new long[1];
                this.oid[0] = HDFNativeData.byteToLong(byArray, 0);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean hasAttribute() {
        this.obj_info.num_attrs = this.nAttributes;
        if (this.obj_info.num_attrs < 0L) {
            int n;
            block56: {
                int n2;
                int n3;
                int n4;
                block55: {
                    int n5;
                    block54: {
                        n = this.open();
                        this.obj_info.num_attrs = 0L;
                        n4 = -1;
                        n3 = -1;
                        int n6 = 0;
                        try {
                            try {
                                this.obj_info = H5.H5Oget_info(n);
                                n6 = H5.H5Dget_type(n);
                                n2 = H5.H5Tget_class(n6);
                                this.isText = n2 == HDF5Constants.H5T_STRING;
                                this.isVLEN = n2 == HDF5Constants.H5T_VLEN || H5.H5Tis_variable_str(n6);
                                this.isEnum = n2 == HDF5Constants.H5T_ENUM;
                                n4 = H5.H5Aopen_by_name(n, ".", "CLASS", HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                                n3 = H5.H5Aget_type(n4);
                                n5 = H5.H5Tget_class(n3);
                                if (n5 == HDF5Constants.H5T_STRING) {
                                    int n7 = H5.H5Tget_size(n3);
                                    byte[] byArray = new byte[n7];
                                    H5.H5Aread(n4, n3, byArray);
                                    String string = new String(byArray).trim();
                                    this.isImageDisplay = this.isImage = string.equalsIgnoreCase("IMAGE");
                                }
                            }
                            catch (Exception exception) {
                                try {
                                    H5.H5Tclose(n3);
                                }
                                catch (HDF5Exception hDF5Exception) {}
                                try {
                                    H5.H5Aclose(n4);
                                }
                                catch (HDF5Exception hDF5Exception) {}
                                try {
                                    H5.H5Tclose(n6);
                                }
                                catch (HDF5Exception hDF5Exception) {}
                                break block54;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                H5.H5Tclose(n3);
                            }
                            catch (HDF5Exception hDF5Exception) {}
                            try {
                                H5.H5Aclose(n4);
                            }
                            catch (HDF5Exception hDF5Exception) {}
                            try {
                                H5.H5Tclose(n6);
                            }
                            catch (HDF5Exception hDF5Exception) {}
                            throw throwable;
                        }
                        try {
                            H5.H5Tclose(n3);
                        }
                        catch (HDF5Exception hDF5Exception) {}
                        try {
                            H5.H5Aclose(n4);
                        }
                        catch (HDF5Exception hDF5Exception) {}
                        try {
                            H5.H5Tclose(n6);
                        }
                        catch (HDF5Exception hDF5Exception) {}
                    }
                    n2 = -1;
                    try {
                        try {
                            n4 = H5.H5Aopen_by_name(n, ".", "IMAGE_MINMAXRANGE", HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                            if (n4 <= 0) break block55;
                            n5 = n3 = H5.H5Aget_type(n4);
                            n3 = H5.H5Tget_native_type(n5);
                            try {
                                H5.H5Tclose(n5);
                            }
                            catch (Exception exception) {}
                            n2 = H5.H5Aget_space(n4);
                            long[] lArray = null;
                            int n8 = H5.H5Sget_simple_extent_ndims(n2);
                            if (n8 > 0) {
                                lArray = new long[n8];
                                H5.H5Sget_simple_extent_dims(n2, lArray, null);
                            }
                            long l = 1L;
                            int n9 = 0;
                            while (n9 < lArray.length) {
                                l *= lArray[n9];
                                ++n9;
                            }
                            Object object = H5Datatype.allocateArray(n3, (int)l);
                            if (object == null) break block55;
                            H5.H5Aread(n4, n3, object);
                            double d = 0.0;
                            double d2 = 0.0;
                            try {
                                d = Double.valueOf(Array.get(object, 0).toString());
                                d2 = Double.valueOf(Array.get(object, 1).toString());
                            }
                            catch (Exception exception) {
                                d2 = 0.0;
                                d = 0.0;
                            }
                            if (d2 > d) {
                                this.imageDataRange = new double[2];
                                this.imageDataRange[0] = d;
                                this.imageDataRange[1] = d2;
                            }
                        }
                        catch (Exception exception) {
                            try {
                                H5.H5Tclose(n3);
                            }
                            catch (HDF5Exception hDF5Exception) {}
                            try {
                                H5.H5Sclose(n2);
                            }
                            catch (HDF5Exception hDF5Exception) {}
                            try {
                                H5.H5Aclose(n4);
                            }
                            catch (HDF5Exception hDF5Exception) {}
                            break block56;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            H5.H5Tclose(n3);
                        }
                        catch (HDF5Exception hDF5Exception) {}
                        try {
                            H5.H5Sclose(n2);
                        }
                        catch (HDF5Exception hDF5Exception) {}
                        try {
                            H5.H5Aclose(n4);
                        }
                        catch (HDF5Exception hDF5Exception) {}
                        throw throwable;
                    }
                }
                try {
                    H5.H5Tclose(n3);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Sclose(n2);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Aclose(n4);
                }
                catch (HDF5Exception hDF5Exception) {}
            }
            this.close(n);
        }
        return this.obj_info.num_attrs > 0L;
    }

    @Override
    public void init() {
        int n;
        block46: {
            if (this.rank > 0) {
                this.resetSelection();
                return;
            }
            n = -1;
            int n2 = -1;
            int n3 = -1;
            n = this.open();
            this.paletteRefs = this.getPaletteRefs(n);
            int n4 = -1;
            try {
                try {
                    block44: {
                        int n5;
                        n2 = H5.H5Dget_space(n);
                        n3 = H5.H5Dget_type(n);
                        int n6 = H5.H5Tget_class(n3);
                        this.rank = H5.H5Sget_simple_extent_ndims(n2);
                        this.isText = n6 == HDF5Constants.H5T_STRING;
                        this.isVLEN = n6 == HDF5Constants.H5T_VLEN || H5.H5Tis_variable_str(n3);
                        this.isEnum = n6 == HDF5Constants.H5T_ENUM;
                        this.isUnsigned = H5Datatype.isUnsigned(n3);
                        this.isRegRef = H5.H5Tequal(n3, HDF5Constants.H5T_STD_REF_DSETREG);
                        try {
                            n4 = H5.H5Dget_create_plist(n);
                            n5 = H5.H5Pget_external_count(n4);
                            this.isExternal = n5 > 0;
                        }
                        catch (Exception exception) {}
                        n5 = 0;
                        try {
                            try {
                                n5 = H5.H5Tget_native_type(n3);
                                this.isNativeDatatype = H5.H5Tequal(n3, n5);
                                int[] nArray = new int[1];
                                if (H5.H5Pfill_value_defined(n4, nArray) >= 0 && nArray[0] == HDF5Constants.H5D_FILL_VALUE_USER_DEFINED) {
                                    this.fillValue = H5Datatype.allocateArray(n5, 1);
                                    try {
                                        H5.H5Pget_fill_value(n4, n5, this.fillValue);
                                    }
                                    catch (Exception exception) {
                                        this.fillValue = null;
                                    }
                                }
                            }
                            catch (HDF5Exception hDF5Exception) {
                                try {
                                    H5.H5Tclose(n5);
                                }
                                catch (HDF5Exception hDF5Exception2) {}
                                try {
                                    H5.H5Pclose(n4);
                                }
                                catch (Exception exception) {}
                                break block44;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                H5.H5Tclose(n5);
                            }
                            catch (HDF5Exception hDF5Exception) {}
                            try {
                                H5.H5Pclose(n4);
                            }
                            catch (Exception exception) {}
                            throw throwable;
                        }
                        try {
                            H5.H5Tclose(n5);
                        }
                        catch (HDF5Exception hDF5Exception) {}
                        try {
                            H5.H5Pclose(n4);
                        }
                        catch (Exception exception) {}
                    }
                    if (this.rank == 0) {
                        this.rank = 1;
                        this.dims = new long[1];
                        this.dims[0] = 1L;
                    } else {
                        this.dims = new long[this.rank];
                        this.maxDims = new long[this.rank];
                        H5.H5Sget_simple_extent_dims(n2, this.dims, this.maxDims);
                    }
                }
                catch (HDF5Exception hDF5Exception) {
                    try {
                        H5.H5Tclose(n3);
                    }
                    catch (HDF5Exception hDF5Exception3) {}
                    try {
                        H5.H5Sclose(n2);
                    }
                    catch (HDF5Exception hDF5Exception4) {}
                    break block46;
                }
            }
            catch (Throwable throwable) {
                try {
                    H5.H5Tclose(n3);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Sclose(n2);
                }
                catch (HDF5Exception hDF5Exception) {}
                throw throwable;
            }
            try {
                H5.H5Tclose(n3);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Sclose(n2);
            }
            catch (HDF5Exception hDF5Exception) {}
        }
        if (this.rank >= 3 && this.isImage) {
            this.interlace = -1;
            this.isTrueColor = this.isStringAttributeOf(n, "IMAGE_SUBCLASS", "IMAGE_TRUECOLOR");
            if (this.isTrueColor) {
                this.interlace = 0;
                if (this.isStringAttributeOf(n, "INTERLACE_MODE", "INTERLACE_PLANE")) {
                    this.interlace = 2;
                }
            }
        }
        this.close(n);
        this.startDims = new long[this.rank];
        this.selectedDims = new long[this.rank];
        this.resetSelection();
    }

    private boolean isStringAttributeOf(int n, String string, String string2) {
        boolean bl;
        block17: {
            bl = false;
            int n2 = -1;
            int n3 = -1;
            try {
                try {
                    n2 = H5.H5Aopen_by_name(n, ".", string, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                    n3 = H5.H5Aget_type(n2);
                    int n4 = H5.H5Tget_size(n3);
                    byte[] byArray = new byte[n4];
                    H5.H5Aread(n2, n3, byArray);
                    String string3 = new String(byArray).trim();
                    bl = string3.equalsIgnoreCase(string2);
                }
                catch (Exception exception) {
                    try {
                        H5.H5Tclose(n3);
                    }
                    catch (HDF5Exception hDF5Exception) {}
                    try {
                        H5.H5Aclose(n2);
                    }
                    catch (HDF5Exception hDF5Exception) {}
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    H5.H5Tclose(n3);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Aclose(n2);
                }
                catch (HDF5Exception hDF5Exception) {}
                throw throwable;
            }
            try {
                H5.H5Tclose(n3);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Aclose(n2);
            }
            catch (HDF5Exception hDF5Exception) {}
        }
        return bl;
    }

    private void resetSelection() {
        int n = 0;
        while (n < this.rank) {
            this.startDims[n] = 0L;
            this.selectedDims[n] = 1L;
            if (this.selectedStride != null) {
                this.selectedStride[n] = 1L;
            }
            ++n;
        }
        if (this.interlace == 0) {
            this.selectedDims[2] = 3L;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedIndex[2] = 2;
        } else if (this.interlace == 2) {
            this.selectedDims[0] = 3L;
            this.selectedDims[1] = this.dims[1];
            this.selectedDims[2] = this.dims[2];
            this.selectedIndex[0] = 1;
            this.selectedIndex[1] = 2;
            this.selectedIndex[2] = 0;
        } else if (this.rank == 1) {
            this.selectedIndex[0] = 0;
            this.selectedDims[0] = this.dims[0];
        } else if (this.rank == 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        } else if (this.rank > 2) {
            if (this.isImage) {
                this.selectedIndex[1] = this.rank - 1;
                this.selectedIndex[0] = this.rank - 2;
                this.selectedIndex[2] = this.rank - 3;
            } else {
                this.selectedIndex[0] = 0;
                this.selectedIndex[1] = 1;
                this.selectedIndex[2] = 2;
            }
            this.selectedDims[this.selectedIndex[0]] = this.dims[this.selectedIndex[0]];
            this.selectedDims[this.selectedIndex[1]] = this.dims[this.selectedIndex[1]];
        }
        if (this.rank > 1 && this.isText) {
            this.selectedIndex[0] = this.rank - 1;
            this.selectedIndex[1] = 0;
            this.selectedDims[0] = 1L;
            this.selectedDims[this.selectedIndex[0]] = this.dims[this.selectedIndex[0]];
        }
        this.isDataLoaded = false;
        this.isDefaultImageOrder = true;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.attributeList != null) {
            ((Vector)this.attributeList).setSize(0);
        }
    }

    @Override
    public Dataset copy(Group group, String string, long[] lArray, Object object) throws Exception {
        if (group == null) {
            return null;
        }
        H5ScalarDS h5ScalarDS = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        String string2 = null;
        String string3 = null;
        string3 = group.isRoot() ? "/" : String.valueOf(group.getPath()) + group.getName() + "/";
        string2 = String.valueOf(string3) + string;
        try {
            block40: {
                n = this.open();
                n3 = H5.H5Dget_type(n);
                n4 = H5.H5Screate_simple(lArray.length, lArray, null);
                n5 = H5.H5Dget_create_plist(n);
                long[] lArray2 = new long[lArray.length];
                boolean bl = false;
                try {
                    H5.H5Pget_chunk(n5, lArray.length, lArray2);
                    int n6 = 0;
                    while (n6 < lArray.length) {
                        if (lArray[n6] < lArray2[n6]) {
                            bl = true;
                            lArray2[n6] = lArray[n6] == 1L ? 1L : lArray[n6] / 2L;
                        }
                        ++n6;
                    }
                }
                catch (Exception exception) {}
                if (bl) {
                    H5.H5Pset_chunk(n5, lArray.length, lArray2);
                }
                try {
                    try {
                        n2 = H5.H5Dcreate(group.getFID(), string2, n3, n4, HDF5Constants.H5P_DEFAULT, n5, HDF5Constants.H5P_DEFAULT);
                    }
                    catch (Exception exception) {
                        try {
                            H5.H5Dclose(n2);
                        }
                        catch (Exception exception2) {}
                        break block40;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        H5.H5Dclose(n2);
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    H5.H5Dclose(n2);
                }
                catch (Exception exception) {}
            }
            h5ScalarDS = new H5ScalarDS(group.getFileFormat(), string, string3);
            if (object != null) {
                ((Dataset)h5ScalarDS).init();
                ((Dataset)h5ScalarDS).write(object);
            }
            n2 = ((HObject)h5ScalarDS).open();
            H5File.copyAttributes(n, n2);
        }
        catch (Throwable throwable) {
            try {
                H5.H5Pclose(n5);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose(n4);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose(n3);
            }
            catch (Exception exception) {}
            try {
                H5.H5Dclose(n);
            }
            catch (Exception exception) {}
            try {
                H5.H5Dclose(n2);
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            H5.H5Pclose(n5);
        }
        catch (Exception exception) {}
        try {
            H5.H5Sclose(n4);
        }
        catch (Exception exception) {}
        try {
            H5.H5Tclose(n3);
        }
        catch (Exception exception) {}
        try {
            H5.H5Dclose(n);
        }
        catch (Exception exception) {}
        try {
            H5.H5Dclose(n2);
        }
        catch (Exception exception) {}
        group.addToMemberList(h5ScalarDS);
        ((ScalarDS)h5ScalarDS).setIsImage(this.isImage);
        return h5ScalarDS;
    }

    @Override
    public byte[] readBytes() throws HDF5Exception {
        byte[] byArray = null;
        if (this.rank <= 0) {
            this.init();
        }
        int n = this.open();
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        try {
            long[] lArray = new long[]{1L};
            int n5 = 0;
            while (n5 < this.selectedDims.length) {
                lArray[0] = lArray[0] * this.selectedDims[n5];
                ++n5;
            }
            n2 = H5.H5Dget_space(n);
            n3 = H5.H5Screate_simple(this.rank, this.selectedDims, null);
            if ((long)this.rank * this.dims[0] > 1L) {
                H5.H5Sselect_hyperslab(n2, HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
            }
            n4 = H5.H5Dget_type(n);
            n5 = H5.H5Tget_size(n4) * (int)lArray[0];
            byArray = new byte[n5];
            H5.H5Dread(n, n4, n3, n2, HDF5Constants.H5P_DEFAULT, byArray);
        }
        catch (Throwable throwable) {
            try {
                H5.H5Sclose(n2);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose(n3);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose(n4);
            }
            catch (HDF5Exception hDF5Exception) {}
            this.close(n);
            throw throwable;
        }
        try {
            H5.H5Sclose(n2);
        }
        catch (Exception exception) {}
        try {
            H5.H5Sclose(n3);
        }
        catch (Exception exception) {}
        try {
            H5.H5Tclose(n4);
        }
        catch (HDF5Exception hDF5Exception) {}
        this.close(n);
        return byArray;
    }

    @Override
    public Object read() throws HDF5Exception {
        Object object;
        String[] stringArray = null;
        int n = -1;
        int n2 = -1;
        int[] nArray = new int[]{-1, -1};
        if (this.rank <= 0) {
            this.init();
        }
        if (this.isExternal) {
            object = this.getFileFormat().getAbsoluteFile().getParent();
            if (object == null) {
                object = ".";
            }
            H5.H5Dchdir_ext((String)object);
        }
        object = new long[]{1L};
        try {
            n = this.open();
            object[0] = this.selectHyperslab(n, nArray);
            if (object[0] == 0L) {
                throw new HDF5Exception("No data to read.\nEither the dataset or the selected subset is empty.");
            }
            try {
                long l = H5.H5Dget_storage_size(n);
                if (l <= 0L) {
                    throw new HDF5Exception("Storage space is not allocated.");
                }
            }
            catch (Exception exception) {}
            n2 = H5.H5Dget_type(n);
            if (!this.isNativeDatatype) {
                int n3 = -1;
                try {
                    n3 = n2;
                    n2 = H5.H5Tget_native_type(n3);
                }
                catch (Throwable throwable) {
                    try {
                        H5.H5Tclose(n3);
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    H5.H5Tclose(n3);
                }
                catch (Exception exception) {}
            }
            boolean bl = H5.H5Tequal(n2, HDF5Constants.H5T_STD_REF_OBJ);
            if (this.originalBuf == null || this.isText || bl || this.originalBuf != null && object[0] != this.nPoints) {
                try {
                    stringArray = H5Datatype.allocateArray(n2, (int)object[0]);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw new HDF5Exception("Out Of Memory.");
                }
            } else {
                stringArray = this.originalBuf;
            }
            if (stringArray != null) {
                if (this.isVLEN) {
                    H5.H5DreadVL(n, n2, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, stringArray);
                } else {
                    H5.H5Dread(n, n2, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, stringArray);
                    if (this.isText && this.convertByteToString) {
                        stringArray = H5ScalarDS.byteToString((byte[])stringArray, H5.H5Tget_size(n2));
                    } else if (bl) {
                        stringArray = (String[])HDFNativeData.byteToLong((byte[])stringArray);
                    } else if (this.isEnum && this.isEnumConverted()) {
                        stringArray = H5Datatype.convertEnumValueToName(n2, stringArray, null);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            try {
                H5.H5Sclose(nArray[0]);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose(nArray[1]);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose(n2);
            }
            catch (Exception exception) {}
            this.close(n);
            throw throwable;
        }
        try {
            H5.H5Sclose(nArray[0]);
        }
        catch (Exception exception) {}
        try {
            H5.H5Sclose(nArray[1]);
        }
        catch (Exception exception) {}
        try {
            H5.H5Tclose(n2);
        }
        catch (Exception exception) {}
        this.close(n);
        return stringArray;
    }

    @Override
    public void write(Object object) throws HDF5Exception {
        int n = -1;
        int n2 = -1;
        int[] nArray = new int[]{-1, -1};
        Object object2 = null;
        if (object == null) {
            return;
        }
        if (this.isVLEN && !this.isText) {
            throw new HDF5Exception("Writing non-string variable-length data is not supported");
        }
        if (this.isRegRef) {
            throw new HDF5Exception("Writing region references data is not supported");
        }
        long[] lArray = new long[]{1L};
        try {
            int n3;
            n = this.open();
            lArray[0] = this.selectHyperslab(n, nArray);
            n2 = H5.H5Dget_type(n);
            if (!this.isNativeDatatype) {
                n3 = -1;
                try {
                    n3 = n2;
                    n2 = H5.H5Tget_native_type(n3);
                }
                catch (Throwable throwable) {
                    try {
                        H5.H5Tclose(n3);
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    H5.H5Tclose(n3);
                }
                catch (Exception exception) {}
            }
            this.isText = H5.H5Tget_class(n2) == HDF5Constants.H5T_STRING;
            n3 = H5.H5Tget_size(n2);
            String string = object.getClass().getName();
            char c = string.charAt(string.lastIndexOf("[") + 1);
            boolean bl = n3 == 1 && c == 'S' || n3 == 2 && c == 'I' || n3 == 4 && c == 'J' || this.isUnsigned && this.unsignedConverted;
            object2 = object;
            if (bl) {
                object2 = H5ScalarDS.convertToUnsignedC(object, null);
            } else if (this.isText && this.convertByteToString && !H5.H5Tis_variable_str(n2)) {
                object2 = H5ScalarDS.stringToByte((String[])object, H5.H5Tget_size(n2));
            } else if (this.isEnum && Array.get(object, 0) instanceof String) {
                object2 = H5Datatype.convertEnumNameToValue(n2, (String[])object, null);
            }
            H5.H5Dwrite(n, n2, nArray[0], nArray[1], HDF5Constants.H5P_DEFAULT, object2);
        }
        catch (Throwable throwable) {
            object2 = null;
            try {
                H5.H5Sclose(nArray[0]);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose(nArray[1]);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose(n2);
            }
            catch (Exception exception) {}
            this.close(n);
            throw throwable;
        }
        object2 = null;
        try {
            H5.H5Sclose(nArray[0]);
        }
        catch (Exception exception) {}
        try {
            H5.H5Sclose(nArray[1]);
        }
        catch (Exception exception) {}
        try {
            H5.H5Tclose(n2);
        }
        catch (Exception exception) {}
        this.close(n);
    }

    private long selectHyperslab(int n, int[] nArray) throws HDF5Exception {
        long l = 1L;
        boolean bl = true;
        int n2 = 0;
        while (n2 < this.rank) {
            l *= this.selectedDims[n2];
            if (this.selectedDims[n2] < this.dims[n2]) {
                bl = false;
            }
            ++n2;
        }
        if (bl) {
            nArray[0] = HDF5Constants.H5S_ALL;
            nArray[1] = HDF5Constants.H5S_ALL;
        } else {
            nArray[1] = H5.H5Dget_space(n);
            nArray[0] = H5.H5Screate_simple(this.rank, this.selectedDims, null);
            H5.H5Sselect_hyperslab(nArray[1], HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
        }
        this.isDefaultImageOrder = this.rank <= 1 || this.selectedIndex[0] <= this.selectedIndex[1];
        return l;
    }

    @Override
    public List getMetadata() throws HDF5Exception {
        return this.getMetadata(HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_INC);
    }

    public List getMetadata(int ... nArray) throws HDF5Exception {
        if (this.rank <= 0) {
            this.init();
        }
        try {
            this.linkTargetObjName = H5File.getLinkTargetName(this);
        }
        catch (Exception exception) {}
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int n = -1;
        int n2 = -1;
        int n3 = HDF5Constants.H5_INDEX_NAME;
        int n4 = HDF5Constants.H5_ITER_INC;
        if (nArray.length > 0) {
            n3 = nArray[0];
            if (nArray.length > 1) {
                n4 = nArray[1];
            }
        }
        try {
            n = this.open();
            this.attributeList = H5File.getAttribute(n, n3, n4);
            n2 = H5.H5Dget_create_plist(n);
            if (H5.H5Pget_layout(n2) == HDF5Constants.H5D_CHUNKED) {
                this.chunkSize = new long[this.rank];
                H5.H5Pget_chunk(n2, this.rank, this.chunkSize);
            } else {
                this.chunkSize = null;
            }
            int[] nArray2 = new int[2];
            int[] nArray3 = new int[]{2};
            int[] nArray4 = new int[2];
            String[] stringArray = new String[]{"", ""};
            int n5 = H5.H5Pget_nfilters(n2);
            int n6 = -1;
            int[] nArray5 = new int[]{1};
            this.compression = "";
            int n7 = 0;
            while (n7 < n5) {
                block38: {
                    if (n7 > 0) {
                        this.compression = String.valueOf(this.compression) + ", ";
                    }
                    try {
                        n6 = H5.H5Pget_filter(n2, n7, nArray2, nArray3, nArray4, 120, stringArray, nArray5);
                    }
                    catch (Throwable throwable) {
                        this.compression = String.valueOf(this.compression) + "ERROR";
                        break block38;
                    }
                    if (n6 == HDF5Constants.H5Z_FILTER_DEFLATE) {
                        this.compression = String.valueOf(this.compression) + "GZIP: level = " + nArray4[0];
                    } else if (n6 == HDF5Constants.H5Z_FILTER_FLETCHER32) {
                        this.compression = String.valueOf(this.compression) + "Error detection filter";
                    } else if (n6 == HDF5Constants.H5Z_FILTER_SHUFFLE) {
                        this.compression = String.valueOf(this.compression) + "SHUFFLE: Nbytes = " + nArray4[0];
                    } else if (n6 == HDF5Constants.H5Z_FILTER_SZIP) {
                        this.compression = String.valueOf(this.compression) + "SZIP: Pixels per block = " + nArray4[1];
                        int n8 = -1;
                        try {
                            n8 = H5.H5Zget_filter_info(n6);
                        }
                        catch (Exception exception) {
                            n8 = -1;
                        }
                        if (n8 == HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) {
                            this.compression = String.valueOf(this.compression) + ": H5Z_FILTER_CONFIG_DECODE_ENABLED";
                        } else if (n8 == HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED || n8 >= HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED + HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) {
                            this.compression = String.valueOf(this.compression) + ": H5Z_FILTER_CONFIG_ENCODE_ENABLED";
                        }
                    }
                }
                ++n7;
            }
            if (this.compression.length() == 0) {
                this.compression = "NONE";
            }
            try {
                int[] nArray6 = new int[1];
                H5.H5Pget_alloc_time(n2, nArray6);
                this.compression = String.valueOf(this.compression) + ",         Storage allocation time: ";
                if (nArray6[0] == HDF5Constants.H5D_ALLOC_TIME_EARLY) {
                    this.compression = String.valueOf(this.compression) + "Early";
                } else if (nArray6[0] == HDF5Constants.H5D_ALLOC_TIME_INCR) {
                    this.compression = String.valueOf(this.compression) + "Incremental";
                } else if (nArray6[0] == HDF5Constants.H5D_ALLOC_TIME_LATE) {
                    this.compression = String.valueOf(this.compression) + "Late";
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            try {
                H5.H5Pclose(n2);
            }
            catch (Exception exception) {}
            this.close(n);
            throw throwable;
        }
        try {
            H5.H5Pclose(n2);
        }
        catch (Exception exception) {}
        this.close(n);
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        boolean bl = false;
        Attribute attribute = (Attribute)object;
        attribute.getName();
        if (this.attributeList == null) {
            this.getMetadata();
        }
        if (this.attributeList != null) {
            bl = this.attributeList.contains(attribute);
        }
        this.getFileFormat().writeAttribute(this, attribute, bl);
        if (!bl) {
            this.attributeList.add(attribute);
            this.nAttributes = this.attributeList.size();
        }
    }

    @Override
    public void removeMetadata(Object object) throws HDF5Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        Attribute attribute = (Attribute)object;
        int n = this.open();
        try {
            H5.H5Adelete(n, attribute.getName());
            List list = this.getMetadata();
            list.remove(attribute);
            this.nAttributes = this.attributeList.size();
        }
        finally {
            this.close(n);
        }
    }

    @Override
    public int open() {
        int n = -1;
        try {
            n = H5.H5Dopen(this.getFID(), String.valueOf(this.getPath()) + this.getName(), HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5Exception hDF5Exception) {
            n = -1;
        }
        return n;
    }

    @Override
    public void close(int n) {
        try {
            H5.H5Fflush(n, HDF5Constants.H5F_SCOPE_LOCAL);
        }
        catch (Exception exception) {}
        try {
            H5.H5Dclose(n);
        }
        catch (HDF5Exception hDF5Exception) {}
    }

    @Override
    public byte[][] getPalette() {
        if (this.palette == null) {
            this.palette = this.readPalette(0);
        }
        return this.palette;
    }

    @Override
    public String getPaletteName(int n) {
        String[] stringArray;
        block8: {
            byte[] byArray = this.getPaletteRefs();
            int n2 = -1;
            int n3 = -1;
            stringArray = new String[]{""};
            long l = 100L;
            if (byArray == null) {
                return null;
            }
            byte[] byArray2 = new byte[8];
            try {
                System.arraycopy(byArray, n * 8, byArray2, 0, 8);
            }
            catch (Throwable throwable) {
                return null;
            }
            try {
                try {
                    n2 = this.open();
                    n3 = H5.H5Rdereference(this.getFID(), HDF5Constants.H5R_OBJECT, byArray2);
                    H5.H5Iget_name(n3, stringArray, l);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.close(n3);
                    this.close(n2);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.close(n3);
                this.close(n2);
                throw throwable;
            }
            this.close(n3);
            this.close(n2);
        }
        return stringArray[0];
    }

    @Override
    public byte[][] readPalette(int n) {
        byte[] byArray;
        byte[][] byArray2;
        block17: {
            byArray2 = null;
            byte[] byArray3 = this.getPaletteRefs();
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            if (byArray3 == null) {
                return null;
            }
            byArray = null;
            byte[] byArray4 = new byte[8];
            try {
                System.arraycopy(byArray3, n * 8, byArray4, 0, 8);
            }
            catch (Throwable throwable) {
                return null;
            }
            try {
                try {
                    n2 = this.open();
                    n3 = H5.H5Rdereference(this.getFID(), HDF5Constants.H5R_OBJECT, byArray4);
                    n4 = H5.H5Dget_type(n3);
                    if (H5.H5Dget_storage_size(n3) <= 768L) {
                        byArray = new byte[768];
                        H5.H5Dread(n3, n4, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, byArray);
                    }
                }
                catch (HDF5Exception hDF5Exception) {
                    byArray = null;
                    try {
                        H5.H5Tclose(n4);
                    }
                    catch (HDF5Exception hDF5Exception2) {}
                    this.close(n3);
                    this.close(n2);
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    H5.H5Tclose(n4);
                }
                catch (HDF5Exception hDF5Exception) {}
                this.close(n3);
                this.close(n2);
                throw throwable;
            }
            try {
                H5.H5Tclose(n4);
            }
            catch (HDF5Exception hDF5Exception) {}
            this.close(n3);
            this.close(n2);
        }
        if (byArray != null) {
            byArray2 = new byte[3][256];
            int n5 = 0;
            while (n5 < 256) {
                byArray2[0][n5] = byArray[n5 * 3];
                byArray2[1][n5] = byArray[n5 * 3 + 1];
                byArray2[2][n5] = byArray[n5 * 3 + 2];
                ++n5;
            }
        }
        return byArray2;
    }

    public static H5ScalarDS create(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object) throws Exception {
        int n2;
        int n3;
        H5ScalarDS h5ScalarDS = null;
        String string2 = null;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        if (group == null || string == null || lArray == null || n > 0 && lArray3 == null) {
            return null;
        }
        H5File h5File = (H5File)group.getFileFormat();
        if (h5File == null) {
            return null;
        }
        String string3 = "/";
        if (!group.isRoot()) {
            string3 = String.valueOf(group.getPath()) + group.getName() + "/";
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if ((n3 = string.lastIndexOf("/")) >= 0) {
                string = string.substring(n3 + 1);
            }
        }
        string2 = String.valueOf(string3) + string;
        n3 = 0;
        if (lArray2 != null) {
            n2 = 0;
            while (n2 < lArray2.length) {
                if (lArray2[n2] == 0L) {
                    lArray2[n2] = lArray[n2];
                } else if (lArray2[n2] < 0L) {
                    lArray2[n2] = HDF5Constants.H5S_UNLIMITED;
                }
                if (lArray2[n2] != lArray[n2]) {
                    n3 = 1;
                }
                ++n2;
            }
        }
        if (lArray3 == null && n3 != 0) {
            lArray3 = new long[lArray.length];
            n2 = 0;
            while (n2 < lArray.length) {
                lArray3[n2] = Math.min(lArray[n2], 64L);
                ++n2;
            }
        }
        n2 = lArray.length;
        try {
            n5 = datatype.toNative();
            n6 = H5.H5Screate_simple(n2, lArray, lArray2);
            n7 = HDF5Constants.H5P_DEFAULT;
            if (lArray3 != null) {
                n7 = H5.H5Pcreate(HDF5Constants.H5P_DATASET_CREATE);
                H5.H5Pset_layout(n7, HDF5Constants.H5D_CHUNKED);
                H5.H5Pset_chunk(n7, n2, lArray3);
            }
            if (n > 0) {
                H5.H5Pset_deflate(n7, n);
            }
            int n8 = h5File.getFID();
            n4 = H5.H5Dcreate(n8, string2, n5, n6, HDF5Constants.H5P_DEFAULT, n7, HDF5Constants.H5P_DEFAULT);
            byte[] byArray = H5.H5Rcreate(n8, string2, HDF5Constants.H5R_OBJECT, -1);
            long l = HDFNativeData.byteToLong(byArray, 0);
            long[] lArray4 = new long[]{l};
            h5ScalarDS = new H5ScalarDS(h5File, string, string3, lArray4);
        }
        catch (Throwable throwable) {
            try {
                H5.H5Pclose(n7);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Sclose(n6);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Tclose(n5);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Dclose(n4);
            }
            catch (HDF5Exception hDF5Exception) {}
            throw throwable;
        }
        try {
            H5.H5Pclose(n7);
        }
        catch (HDF5Exception hDF5Exception) {}
        try {
            H5.H5Sclose(n6);
        }
        catch (HDF5Exception hDF5Exception) {}
        try {
            H5.H5Tclose(n5);
        }
        catch (HDF5Exception hDF5Exception) {}
        try {
            H5.H5Dclose(n4);
        }
        catch (HDF5Exception hDF5Exception) {}
        if (h5ScalarDS != null) {
            group.addToMemberList(h5ScalarDS);
            if (object != null) {
                h5ScalarDS.write(object);
            }
        }
        return h5ScalarDS;
    }

    @Override
    public byte[] getPaletteRefs() {
        if (this.rank <= 0) {
            this.init();
        }
        return this.paletteRefs;
    }

    private byte[] getPaletteRefs(int n) {
        byte[] byArray;
        block25: {
            int n2 = -1;
            int n3 = -1;
            int n4 = 0;
            int n5 = 0;
            int n6 = -1;
            byArray = null;
            try {
                try {
                    n2 = H5.H5Aopen_by_name(n, ".", "PALETTE", HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                    n3 = H5.H5Aget_space(n2);
                    n5 = H5.H5Sget_simple_extent_ndims(n3);
                    n4 = 1;
                    if (n5 > 0) {
                        long[] lArray = new long[n5];
                        H5.H5Sget_simple_extent_dims(n3, lArray, null);
                        int n7 = 0;
                        while (n7 < n5) {
                            n4 *= (int)lArray[n7];
                            ++n7;
                        }
                    }
                    byArray = new byte[n4 * 8];
                    n6 = H5.H5Aget_type(n2);
                    H5.H5Aread(n2, n6, byArray);
                }
                catch (HDF5Exception hDF5Exception) {
                    byArray = null;
                    try {
                        H5.H5Tclose(n6);
                    }
                    catch (HDF5Exception hDF5Exception2) {}
                    try {
                        H5.H5Sclose(n3);
                    }
                    catch (HDF5Exception hDF5Exception3) {}
                    try {
                        H5.H5Aclose(n2);
                    }
                    catch (HDF5Exception hDF5Exception4) {}
                    break block25;
                }
            }
            catch (Throwable throwable) {
                try {
                    H5.H5Tclose(n6);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Sclose(n3);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Aclose(n2);
                }
                catch (HDF5Exception hDF5Exception) {}
                throw throwable;
            }
            try {
                H5.H5Tclose(n6);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Sclose(n3);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Aclose(n2);
            }
            catch (HDF5Exception hDF5Exception) {}
        }
        return byArray;
    }

    @Override
    public Datatype getDatatype() {
        block25: {
            if (this.datatype == null) {
                int n = -1;
                int n2 = -1;
                n = this.open();
                try {
                    try {
                        n2 = H5.H5Dget_type(n);
                        if (!this.isNativeDatatype) {
                            int n3 = -1;
                            try {
                                n3 = n2;
                                n2 = H5.H5Tget_native_type(n3);
                            }
                            catch (Throwable throwable) {
                                try {
                                    H5.H5Tclose(n3);
                                }
                                catch (Exception exception) {}
                                throw throwable;
                            }
                            try {
                                H5.H5Tclose(n3);
                            }
                            catch (Exception exception) {}
                        }
                        this.datatype = new H5Datatype(n2);
                    }
                    catch (Exception exception) {
                        try {
                            H5.H5Tclose(n2);
                        }
                        catch (HDF5Exception hDF5Exception) {}
                        try {
                            H5.H5Dclose(n);
                        }
                        catch (HDF5Exception hDF5Exception) {}
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        H5.H5Tclose(n2);
                    }
                    catch (HDF5Exception hDF5Exception) {}
                    try {
                        H5.H5Dclose(n);
                    }
                    catch (HDF5Exception hDF5Exception) {}
                    throw throwable;
                }
                try {
                    H5.H5Tclose(n2);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Dclose(n);
                }
                catch (HDF5Exception hDF5Exception) {}
            }
        }
        return this.datatype;
    }

    @Override
    public void setName(String string) throws Exception {
        String string2 = String.valueOf(this.getPath()) + this.getName();
        String string3 = String.valueOf(this.getPath()) + string;
        string2 = string2.replaceAll("//", "/");
        string3 = string3.replaceAll("//", "/");
        if (string2.equals("/")) {
            throw new HDF5Exception("Can't rename the root group.");
        }
        if (string2.equals(string3)) {
            throw new HDF5Exception("The new name is the same as the current name.");
        }
        H5.H5Lmove(this.getFID(), string2, this.getFID(), string3, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        super.setName(string);
    }

    public void extend(long[] lArray) throws HDF5Exception {
        int n = -1;
        int n2 = -1;
        n = this.open();
        try {
            try {
                H5.H5Dset_extent(n, lArray);
                H5.H5Fflush(n, HDF5Constants.H5F_SCOPE_GLOBAL);
                n2 = H5.H5Dget_space(n);
                long[] lArray2 = new long[this.rank];
                H5.H5Sget_simple_extent_dims(n2, lArray2, null);
                int n3 = 0;
                while (n3 < this.rank) {
                    if (lArray2[n3] != lArray[n3]) {
                        throw new HDF5Exception("error extending dataset " + this.getName());
                    }
                    ++n3;
                }
                this.dims = lArray2;
            }
            catch (Exception exception) {
                throw new HDF5Exception(exception.getMessage());
            }
        }
        finally {
            if (n2 > 0) {
                H5.H5Sclose(n2);
            }
            this.close(n);
        }
    }
}

