/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.structs.H5G_info_t;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h5.H5File;

public class H5Group
extends Group {
    public static final long serialVersionUID = 240L;
    protected List attributeList;
    private int nAttributes = -1;
    private H5O_info_t obj_info;

    public H5Group(FileFormat fileFormat, String string, String string2, Group group) {
        this(fileFormat, string, string2, group, null);
    }

    @Deprecated
    public H5Group(FileFormat fileFormat, String string, String string2, Group group, long[] lArray) {
        super(fileFormat, string, string2, group, lArray);
        this.nMembersInFile = -1;
        this.obj_info = new H5O_info_t(-1L, -1L, 0, 0, -1L, 0L, 0L, 0L, 0L, null, null, null);
        if (lArray == null && fileFormat != null) {
            try {
                byte[] byArray = H5.H5Rcreate(fileFormat.getFID(), this.getFullName(), HDF5Constants.H5R_OBJECT, -1);
                this.oid = new long[1];
                this.oid[0] = HDFNativeData.byteToLong(byArray, 0);
            }
            catch (Exception exception) {
                this.oid = new long[1];
                this.oid[0] = 0L;
            }
        }
    }

    @Override
    public boolean hasAttribute() {
        int n;
        this.obj_info.num_attrs = this.nAttributes;
        if (this.obj_info.num_attrs < 0L && (n = this.open()) > 0) {
            try {
                this.obj_info = H5.H5Oget_info(n);
            }
            catch (Exception exception) {
                this.obj_info.num_attrs = 0L;
            }
            this.close(n);
        }
        return this.obj_info.num_attrs > 0L;
    }

    @Override
    public int getNumberOfMembersInFile() {
        int n;
        if (this.nMembersInFile < 0 && (n = this.open()) > 0) {
            try {
                H5G_info_t h5G_info_t = null;
                h5G_info_t = H5.H5Gget_info(n);
                this.nMembersInFile = (int)h5G_info_t.nlinks;
            }
            catch (Exception exception) {
                this.nMembersInFile = 0;
            }
            this.close(n);
        }
        return this.nMembersInFile;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.attributeList != null) {
            ((Vector)this.attributeList).setSize(0);
        }
    }

    @Override
    public List getMetadata() throws HDF5Exception {
        return this.getMetadata(HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_INC);
    }

    public List getMetadata(int ... nArray) throws HDF5Exception {
        if (this.attributeList == null) {
            int n = this.open();
            int n2 = HDF5Constants.H5_INDEX_NAME;
            int n3 = HDF5Constants.H5_ITER_INC;
            if (nArray.length > 0) {
                n2 = nArray[0];
                if (nArray.length > 1) {
                    n3 = nArray[1];
                }
            }
            try {
                this.attributeList = H5File.getAttribute(n, n2, n3);
            }
            finally {
                this.close(n);
            }
        }
        try {
            this.linkTargetObjName = H5File.getLinkTargetName(this);
        }
        catch (Exception exception) {}
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        boolean bl = false;
        Attribute attribute = (Attribute)object;
        attribute.getName();
        if (this.attributeList == null) {
            this.getMetadata();
        }
        if (this.attributeList != null) {
            bl = this.attributeList.contains(attribute);
        }
        this.getFileFormat().writeAttribute(this, attribute, bl);
        if (!bl) {
            this.attributeList.add(attribute);
            this.nAttributes = this.attributeList.size();
        }
    }

    @Override
    public void removeMetadata(Object object) throws HDF5Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        Attribute attribute = (Attribute)object;
        int n = this.open();
        try {
            H5.H5Adelete(n, attribute.getName());
            List list = this.getMetadata();
            list.remove(attribute);
            this.nAttributes = this.attributeList.size();
        }
        finally {
            this.close(n);
        }
    }

    @Override
    public int open() {
        int n = -1;
        try {
            n = this.isRoot() ? H5.H5Gopen(this.getFID(), "/", HDF5Constants.H5P_DEFAULT) : H5.H5Gopen(this.getFID(), String.valueOf(this.getPath()) + this.getName(), HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5Exception hDF5Exception) {
            n = -1;
        }
        return n;
    }

    @Override
    public void close(int n) {
        try {
            H5.H5Gclose(n);
        }
        catch (HDF5Exception hDF5Exception) {}
    }

    public static H5Group create(String string, Group group, int ... nArray) throws Exception {
        int n;
        H5Group h5Group = null;
        String string2 = null;
        int n2 = HDF5Constants.H5P_DEFAULT;
        int n3 = HDF5Constants.H5P_DEFAULT;
        int n4 = HDF5Constants.H5P_DEFAULT;
        if (nArray.length > 0) {
            n2 = nArray[0];
            if (nArray.length > 1) {
                n3 = nArray[1];
                if (nArray.length > 2) {
                    n4 = nArray[2];
                }
            }
        }
        if (string == null) {
            return null;
        }
        H5File h5File = (H5File)group.getFileFormat();
        if (h5File == null) {
            return null;
        }
        if (group == null) {
            group = (Group)h5File.get("/");
        }
        String string3 = "/";
        if (!group.isRoot()) {
            string3 = String.valueOf(group.getPath()) + group.getName() + "/";
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if ((n = string.lastIndexOf("/")) >= 0) {
                string = string.substring(n + 1);
            }
        }
        string2 = String.valueOf(string3) + string;
        n = H5.H5Gcreate(h5File.open(), string2, n2, n3, n4);
        try {
            H5.H5Gclose(n);
        }
        catch (Exception exception) {}
        byte[] byArray = H5.H5Rcreate(h5File.open(), string2, HDF5Constants.H5R_OBJECT, -1);
        long l = HDFNativeData.byteToLong(byArray, 0);
        long[] lArray = new long[]{l};
        h5Group = new H5Group(h5File, string, string3, group, lArray);
        if (h5Group != null) {
            group.addToMemberList(h5Group);
        }
        if (n3 > 0) {
            try {
                H5.H5Pclose(n3);
            }
            catch (Exception exception) {}
        }
        return h5Group;
    }

    @Override
    public void setName(String string) throws Exception {
        String string2 = String.valueOf(this.getPath()) + this.getName();
        String string3 = String.valueOf(this.getPath()) + string;
        string2 = string2.replaceAll("//", "/");
        string3 = string3.replaceAll("//", "/");
        if (string2.equals("/")) {
            throw new HDF5Exception("Can't rename the root group.");
        }
        if (string2.equals(string3)) {
            throw new HDF5Exception("The new name is the same as the current name.");
        }
        H5.H5Lmove(this.getFID(), string2, this.getFID(), string3, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        super.setName(string);
    }

    @Override
    public void setPath(String string) throws Exception {
        super.setPath(string);
        List<HObject> list = this.getMemberList();
        if (list == null) {
            return;
        }
        int n = list.size();
        HObject hObject = null;
        int n2 = 0;
        while (n2 < n) {
            hObject = list.get(n2);
            hObject.setPath(String.valueOf(this.getPath()) + this.getName() + "/");
            ++n2;
        }
    }
}

