/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.structs.H5G_info_t;
import ncsa.hdf.hdf5lib.structs.H5L_info_t;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.h5.H5CompoundDS;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5Group;
import ncsa.hdf.object.h5.H5Link;
import ncsa.hdf.object.h5.H5ScalarDS;

public class H5File
extends FileFormat {
    public static final long serialVersionUID = 240L;
    private int flag;
    private int indexType;
    private DefaultMutableTreeNode rootNode = null;
    private static final int attrNameLen = 256;
    private int[] libver = new int[2];
    private boolean attrFlag = false;

    public H5File() {
        this("", 0);
    }

    public H5File(String string) {
        this(string, 1);
    }

    public H5File(String string, int n) {
        super(string);
        this.fid = -1;
        boolean bl = this.isReadOnly = n == 0;
        this.flag = n == 0 ? HDF5Constants.H5F_ACC_RDONLY : (n == 1 ? HDF5Constants.H5F_ACC_RDWR : (n == 2 ? HDF5Constants.H5F_ACC_CREAT : n));
    }

    public static final void copyAttributes(HObject hObject, HObject hObject2) {
        if (hObject != null && hObject2 != null) {
            int n = hObject.open();
            int n2 = hObject2.open();
            if (n >= 0 && n2 >= 0) {
                H5File.copyAttributes(n, n2);
            }
            if (n >= 0) {
                hObject.close(n);
            }
            if (n2 >= 0) {
                hObject2.close(n2);
            }
        }
    }

    public static final void copyAttributes(int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        String[] stringArray = new String[]{""};
        H5O_info_t h5O_info_t = null;
        try {
            h5O_info_t = H5.H5Oget_info(n);
        }
        catch (Exception exception) {
            h5O_info_t.num_attrs = -1L;
        }
        if (h5O_info_t.num_attrs < 0L) {
            return;
        }
        int n7 = 0;
        while ((long)n7 < h5O_info_t.num_attrs) {
            stringArray[0] = new String("");
            try {
                n3 = H5.H5Aopen_by_idx(n, ".", HDF5Constants.H5_INDEX_CRT_ORDER, HDF5Constants.H5_ITER_INC, n7, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                H5.H5Aget_name(n3, 256L, stringArray);
                n5 = H5.H5Aget_type(n3);
                n6 = H5.H5Aget_space(n3);
                n4 = H5.H5Acreate(n2, stringArray[0], n5, n6, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                H5.H5Acopy(n3, n4);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose(n6);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose(n5);
            }
            catch (Exception exception) {}
            try {
                H5.H5Aclose(n3);
            }
            catch (Exception exception) {}
            try {
                H5.H5Aclose(n4);
            }
            catch (Exception exception) {}
            ++n7;
        }
    }

    public static final List<Attribute> getAttribute(int n) throws HDF5Exception {
        return H5File.getAttribute(n, HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_INC);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final List<Attribute> getAttribute(int var0, int var1_1, int var2_2) throws HDF5Exception {
        var3_3 = null;
        var4_4 = -1;
        var5_5 = -1;
        var6_6 = -1;
        var7_7 = null;
        try {
            var7_7 = H5.H5Oget_info(var0);
        }
        catch (Exception v0) {}
        if (var7_7.num_attrs <= 0L) {
            var3_3 = new Vector<Attribute>();
            return var3_3;
        }
        var8_8 = (int)var7_7.num_attrs;
        var3_3 = new Vector<E>(var8_8);
        var9_9 = 0;
        while (var9_9 < var8_8) {
            block82: {
                block78: {
                    block83: {
                        block77: {
                            var4_4 = H5.H5Aopen_by_idx(var0, ".", var1_1, var2_2, var9_9, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                            var5_5 = H5.H5Aget_space(var4_4);
                            var10_10 = null;
                            var11_11 = H5.H5Sget_simple_extent_ndims(var5_5);
                            if (var11_11 == 0) {
                                var11_11 = 1;
                                var10_10 = new long[]{1L};
                            } else {
                                var10_10 = new long[var11_11];
                                H5.H5Sget_simple_extent_dims(var5_5, var10_10, null);
                            }
                            var12_12 = new String[]{""};
                            H5.H5Aget_name(var4_4, 256L, var12_12);
                            var13_13 = -1;
                            try {
                                var13_13 = H5.H5Aget_type(var4_4);
                                var6_6 = H5.H5Tget_native_type(var13_13);
                            }
                            catch (Throwable var14_15) {
                                try {
                                    H5.H5Tclose(var13_13);
                                }
                                catch (Exception v1) {}
                                throw var14_15;
                            }
                            try {
                                H5.H5Tclose(var13_13);
                            }
                            catch (Exception v2) {}
                            var14_14 = new H5Datatype(var6_6);
                            var15_16 = new Attribute(var12_12[0], var14_14, var10_10);
                            var3_3.add(var15_16);
                            var16_17 = false;
                            var17_18 = false;
                            var18_19 = false;
                            try {
                                var16_17 = H5.H5Tis_variable_str(var6_6);
                            }
                            catch (Exception v3) {}
                            try {
                                var17_18 = H5.H5Tget_class(var6_6) == HDF5Constants.H5T_VLEN;
                            }
                            catch (Exception v4) {}
                            try {
                                var18_19 = H5.H5Tget_class(var6_6) == HDF5Constants.H5T_COMPOUND;
                            }
                            catch (Exception v5) {}
                            var19_20 = 1L;
                            var21_21 = 0;
                            while (var21_21 < var10_10.length) {
                                var19_20 *= var10_10[var21_21];
                                ++var21_21;
                            }
                            if (var19_20 > 0L) break block77;
                            try {
                                H5.H5Tclose(var6_6);
                            }
                            catch (HDF5Exception v6) {}
                            try {
                                H5.H5Sclose(var5_5);
                            }
                            catch (HDF5Exception v7) {}
                            try {
                                H5.H5Aclose(var4_4);
                            }
                            catch (HDF5Exception v8) {}
                            break block82;
                        }
                        var21_22 /* !! */  = null;
                        if (!var17_18 && !var16_17 && !var18_19) break block83;
                        var22_23 = new String[(int)var19_20];
                        var23_26 = 0;
                        while ((long)var23_26 < var19_20) {
                            var22_23[var23_26] = "";
                            ++var23_26;
                        }
                        H5.H5AreadVL(var4_4, var6_6, var22_23);
                        var21_22 /* !! */  = var22_23;
                        ** GOTO lbl182
                    }
                    var21_22 /* !! */  = H5Datatype.allocateArray(var6_6, (int)var19_20);
                    if (var21_22 /* !! */  != null) break block78;
                    try {
                        H5.H5Tclose(var6_6);
                    }
                    catch (HDF5Exception v9) {}
                    try {
                        H5.H5Sclose(var5_5);
                    }
                    catch (HDF5Exception v10) {}
                    try {
                        H5.H5Aclose(var4_4);
                    }
                    catch (HDF5Exception v11) {}
                    break block82;
                }
                try {
                    try {
                        block80: {
                            if (H5.H5Tget_class(var6_6) == HDF5Constants.H5T_ARRAY) {
                                var22_24 = -1;
                                var23_26 = -1;
                                try {
                                    try {
                                        var22_24 = H5.H5Tget_super(var6_6);
                                        var23_26 = H5.H5Tget_native_type(var22_24);
                                        H5.H5Aread(var4_4, var23_26, var21_22 /* !! */ );
                                    }
                                    catch (Exception v12) {
                                        try {
                                            H5.H5Tclose(var22_24);
                                        }
                                        catch (Exception v13) {}
                                        try {
                                            H5.H5Tclose(var23_26);
                                        }
                                        catch (Exception v14) {}
                                        break block80;
                                    }
                                }
                                catch (Throwable var24_27) {
                                    try {
                                        H5.H5Tclose(var22_24);
                                    }
                                    catch (Exception v15) {}
                                    try {
                                        H5.H5Tclose(var23_26);
                                    }
                                    catch (Exception v16) {}
                                    throw var24_27;
                                }
                                try {
                                    H5.H5Tclose(var22_24);
                                }
                                catch (Exception v17) {}
                                try {
                                    H5.H5Tclose(var23_26);
                                }
                                catch (Exception v18) {}
                            } else {
                                H5.H5Aread(var4_4, var6_6, var21_22 /* !! */ );
                            }
                        }
                        var22_25 = H5.H5Tget_class(var6_6);
                        if (var22_25 == HDF5Constants.H5T_STRING) {
                            var21_22 /* !! */  = Dataset.byteToString((byte[])var21_22 /* !! */ , H5.H5Tget_size(var6_6));
                        } else if (var22_25 == HDF5Constants.H5T_REFERENCE) {
                            var21_22 /* !! */  = (String[])HDFNativeData.byteToLong((byte[])var21_22 /* !! */ );
                        }
lbl182:
                        // 5 sources

                        var15_16.setValue(var21_22 /* !! */ );
                    }
                    catch (HDF5Exception v19) {
                        try {
                            H5.H5Tclose(var6_6);
                        }
                        catch (HDF5Exception v20) {}
                        try {
                            H5.H5Sclose(var5_5);
                        }
                        catch (HDF5Exception v21) {}
                        try {
                            H5.H5Aclose(var4_4);
                        }
                        catch (HDF5Exception v22) {}
                    }
                }
                catch (Throwable var25_28) {
                    try {
                        H5.H5Tclose(var6_6);
                    }
                    catch (HDF5Exception v23) {}
                    try {
                        H5.H5Sclose(var5_5);
                    }
                    catch (HDF5Exception v24) {}
                    try {
                        H5.H5Aclose(var4_4);
                    }
                    catch (HDF5Exception v25) {}
                    throw var25_28;
                }
                try {
                    H5.H5Tclose(var6_6);
                }
                catch (HDF5Exception v26) {}
                try {
                    H5.H5Sclose(var5_5);
                }
                catch (HDF5Exception v27) {}
                try {
                    H5.H5Aclose(var4_4);
                }
                catch (HDF5Exception v28) {}
            }
            ++var9_9;
        }
        return var3_3;
    }

    private static final void createImageAttributes(Dataset dataset, int n) throws Exception {
        String string = null;
        String string2 = null;
        if (n == 0) {
            string = "IMAGE_TRUECOLOR";
            string2 = "INTERLACE_PIXEL";
        } else if (n == 2) {
            string = "IMAGE_TRUECOLOR";
            string2 = "INTERLACE_PLANE";
        } else if (n == -1) {
            string = "IMAGE_INDEXED";
        } else {
            throw new HDF5Exception("The selectionFlag is invalid.");
        }
        long[] lArray = new long[]{1L};
        String string3 = "CLASS";
        String[] stringArray = new String[]{"IMAGE"};
        H5Datatype h5Datatype = new H5Datatype(3, stringArray[0].length() + 1, -1, -1);
        Attribute attribute = new Attribute(string3, h5Datatype, lArray);
        attribute.setValue(stringArray);
        dataset.writeMetadata(attribute);
        string3 = "IMAGE_VERSION";
        String[] stringArray2 = new String[]{"1.2"};
        h5Datatype = new H5Datatype(3, stringArray2[0].length() + 1, -1, -1);
        attribute = new Attribute(string3, h5Datatype, lArray);
        attribute.setValue(stringArray2);
        dataset.writeMetadata(attribute);
        lArray[0] = 2L;
        string3 = "IMAGE_MINMAXRANGE";
        byte[] byArray = new byte[2];
        byArray[1] = -1;
        byte[] byArray2 = byArray;
        h5Datatype = new H5Datatype(2, 1, -1, 0);
        attribute = new Attribute(string3, h5Datatype, lArray);
        attribute.setValue(byArray2);
        dataset.writeMetadata(attribute);
        lArray[0] = 1L;
        string3 = "IMAGE_SUBCLASS";
        String[] stringArray3 = new String[]{string};
        h5Datatype = new H5Datatype(3, stringArray3[0].length() + 1, -1, -1);
        attribute = new Attribute(string3, h5Datatype, lArray);
        attribute.setValue(stringArray3);
        dataset.writeMetadata(attribute);
        if (n == 0 || n == 2) {
            string3 = "INTERLACE_MODE";
            String[] stringArray4 = new String[]{string2};
            h5Datatype = new H5Datatype(3, stringArray4[0].length() + 1, -1, -1);
            attribute = new Attribute(string3, h5Datatype, lArray);
            attribute.setValue(stringArray4);
            dataset.writeMetadata(attribute);
        } else {
            string3 = "PALETTE";
            long[] lArray2 = new long[]{-1L};
            h5Datatype = new H5Datatype(7, 1, -1, 0);
            attribute = new Attribute(string3, h5Datatype, lArray);
            attribute.setValue(lArray2);
            dataset.writeMetadata(attribute);
        }
    }

    public static final void updateReferenceDataset(H5File h5File, H5File h5File2) throws Exception {
        ScalarDS scalarDS;
        if (h5File == null || h5File2 == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)h5File.getRootNode();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)h5File2.getRootNode();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        Enumeration<TreeNode> enumeration2 = defaultMutableTreeNode2.breadthFirstEnumeration();
        int n = -1;
        int n2 = -1;
        Hashtable<String, long[]> hashtable = new Hashtable<String, long[]>();
        Vector<ScalarDS> vector = new Vector<ScalarDS>();
        while (enumeration2.hasMoreElements() && enumeration.hasMoreElements()) {
            block42: {
                HObject hObject = (HObject)((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject();
                HObject hObject2 = (HObject)((DefaultMutableTreeNode)enumeration2.nextElement()).getUserObject();
                hashtable.put(String.valueOf(hObject.getOID()[0]), hObject2.getOID());
                n = -1;
                n2 = -1;
                if (!(hObject2 instanceof ScalarDS)) continue;
                scalarDS = (ScalarDS)hObject2;
                n = scalarDS.open();
                if (n > 0) {
                    try {
                        try {
                            n2 = H5.H5Dget_type(n);
                            if (H5.H5Tequal(n2, HDF5Constants.H5T_STD_REF_OBJ)) {
                                vector.add(scalarDS);
                            }
                        }
                        catch (Exception exception) {
                            try {
                                H5.H5Tclose(n2);
                            }
                            catch (Exception exception2) {}
                            break block42;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            H5.H5Tclose(n2);
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        H5.H5Tclose(n2);
                    }
                    catch (Exception exception) {}
                }
            }
            scalarDS.close(n);
        }
        scalarDS = null;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        int n6 = vector.size();
        int n7 = 0;
        while (n7 < n6) {
            block44: {
                scalarDS = (H5ScalarDS)vector.get(n7);
                byte[] byArray = null;
                long[] lArray = null;
                try {
                    try {
                        n = ((H5ScalarDS)scalarDS).open();
                        n2 = H5.H5Dget_type(n);
                        n3 = H5.H5Dget_space(n);
                        n5 = H5.H5Sget_simple_extent_ndims(n3);
                        n4 = 1;
                        if (n5 > 0) {
                            long[] lArray2 = new long[n5];
                            H5.H5Sget_simple_extent_dims(n3, lArray2, null);
                            int n8 = 0;
                            while (n8 < n5) {
                                n4 *= (int)lArray2[n8];
                                ++n8;
                            }
                            lArray2 = null;
                        }
                        byArray = new byte[n4 * 8];
                        H5.H5Dread(n, n2, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, byArray);
                        lArray = HDFNativeData.byteToLong(byArray);
                        n4 = lArray.length;
                        int n9 = 0;
                        while (n9 < n4) {
                            long[] lArray3 = (long[])hashtable.get(String.valueOf(lArray[n9]));
                            if (lArray3 != null) {
                                lArray[n9] = lArray3[0];
                            }
                            ++n9;
                        }
                        H5.H5Dwrite(n, n2, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, lArray);
                    }
                    catch (Exception exception) {
                        try {
                            H5.H5Tclose(n2);
                        }
                        catch (Exception exception3) {}
                        try {
                            H5.H5Sclose(n3);
                        }
                        catch (Exception exception4) {}
                        try {
                            H5.H5Dclose(n);
                        }
                        catch (Exception exception5) {}
                        break block44;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        H5.H5Tclose(n2);
                    }
                    catch (Exception exception) {}
                    try {
                        H5.H5Sclose(n3);
                    }
                    catch (Exception exception) {}
                    try {
                        H5.H5Dclose(n);
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    H5.H5Tclose(n2);
                }
                catch (Exception exception) {}
                try {
                    H5.H5Sclose(n3);
                }
                catch (Exception exception) {}
                try {
                    H5.H5Dclose(n);
                }
                catch (Exception exception) {}
                lArray = null;
                byArray = null;
            }
            ++n7;
        }
    }

    @Override
    public String getLibversion() {
        int[] nArray = new int[3];
        String string = "HDF5 ";
        try {
            H5.H5get_libversion(nArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        string = String.valueOf(string) + nArray[0] + "." + nArray[1] + "." + nArray[2];
        return string;
    }

    @Override
    public boolean isThisType(FileFormat fileFormat) {
        return fileFormat instanceof H5File;
    }

    @Override
    public boolean isThisType(String string) {
        boolean bl = false;
        try {
            bl = H5.H5Fis_hdf5(string);
        }
        catch (HDF5Exception hDF5Exception) {
            bl = false;
        }
        return bl;
    }

    @Override
    public FileFormat createFile(String string, int n) throws Exception {
        File file;
        Boolean bl = true;
        if (n == 11 && (file = new File(string)).exists()) {
            bl = false;
        }
        if (bl.booleanValue()) {
            int n2 = H5.H5Fcreate(string, HDF5Constants.H5F_ACC_TRUNC, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            try {
                H5.H5Fclose(n2);
            }
            catch (HDF5Exception hDF5Exception) {}
        }
        return new H5File(string, 1);
    }

    @Override
    public FileFormat createInstance(String string, int n) throws Exception {
        return new H5File(string, n);
    }

    @Override
    public int open() throws Exception {
        return this.open(true);
    }

    @Override
    public int open(int ... nArray) throws Exception {
        this.indexType = nArray[0];
        return this.open(true);
    }

    @Override
    public void setLibBounds(int n, int n2) throws Exception {
        int n3 = HDF5Constants.H5P_DEFAULT;
        if (this.fid < 0) {
            return;
        }
        n3 = H5.H5Fget_access_plist(this.fid);
        try {
            if (n < 0) {
                n = HDF5Constants.H5F_LIBVER_EARLIEST;
            }
            if (n2 < 0) {
                n2 = HDF5Constants.H5F_LIBVER_LATEST;
            }
            H5.H5Pset_libver_bounds(n3, n, n2);
            H5.H5Pget_libver_bounds(n3, this.libver);
        }
        catch (Throwable throwable) {
            try {
                H5.H5Pclose(n3);
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            H5.H5Pclose(n3);
        }
        catch (Exception exception) {}
    }

    @Override
    public int[] getLibBounds() throws Exception {
        return this.libver;
    }

    @Override
    public void close() throws HDF5Exception {
        block25: {
            Object object;
            H5.H5Dchdir_ext(System.getProperty("user.dir"));
            if (this.rootNode != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                HObject hObject = null;
                object = this.rootNode.breadthFirstEnumeration();
                while (object.hasMoreElements()) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)object.nextElement();
                    hObject = (HObject)defaultMutableTreeNode.getUserObject();
                    if (hObject instanceof Dataset) {
                        ((Dataset)hObject).clear();
                        continue;
                    }
                    if (!(hObject instanceof Group)) continue;
                    ((Group)hObject).clear();
                }
            }
            try {
                int n = 0;
                int n2 = -1;
                n = H5.H5Fget_obj_count(this.fid, HDF5Constants.H5F_OBJ_ALL);
                if (n <= 0) break block25;
                object = new int[n];
                H5.H5Fget_obj_ids(this.fid, HDF5Constants.H5F_OBJ_ALL, n, (int[])object);
                int n3 = 0;
                while (n3 < n) {
                    n2 = H5.H5Iget_type((int)object[n3]);
                    if (HDF5Constants.H5I_DATASET == n2) {
                        try {
                            H5.H5Dclose((int)object[n3]);
                        }
                        catch (Exception exception) {}
                    } else if (HDF5Constants.H5I_GROUP == n2) {
                        try {
                            H5.H5Gclose((int)object[n3]);
                        }
                        catch (Exception exception) {}
                    } else if (HDF5Constants.H5I_DATATYPE == n2) {
                        try {
                            H5.H5Tclose((int)object[n3]);
                        }
                        catch (Exception exception) {}
                    } else if (HDF5Constants.H5I_ATTR == n2) {
                        try {
                            H5.H5Aclose((int)object[n3]);
                        }
                        catch (Exception exception) {}
                    }
                    ++n3;
                }
            }
            catch (Exception exception) {}
        }
        try {
            H5.H5Fflush(this.fid, HDF5Constants.H5F_SCOPE_GLOBAL);
        }
        catch (Exception exception) {}
        try {
            H5.H5Fclose(this.fid);
        }
        catch (Exception exception) {}
        this.fid = -1;
    }

    @Override
    public TreeNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public HObject get(String string) throws Exception {
        HObject hObject;
        block42: {
            int n;
            hObject = null;
            if (string == null || string.length() <= 0) {
                return null;
            }
            string = string.replace('\\', '/');
            string = "/" + string;
            string = string.replaceAll("//", "/");
            if (this.rootNode != null) {
                hObject = H5File.findObject((FileFormat)this, string);
            }
            if (hObject != null) {
                return hObject;
            }
            String string2 = null;
            String string3 = null;
            if (string.equals("/")) {
                string2 = "/";
            } else {
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 2);
                }
                n = string.lastIndexOf(47);
                string2 = string.substring(n + 1);
                string3 = n == 0 ? "/" : string.substring(0, n);
            }
            n = this.fid;
            this.fid = this.open(false);
            if (this.fid < 0) {
                return null;
            }
            try {
                try {
                    int n2 = H5.H5Oopen(this.fid, string, HDF5Constants.H5P_DEFAULT);
                    if (n2 >= 0) {
                        int n3;
                        H5O_info_t h5O_info_t = H5.H5Oget_info(n2);
                        int n4 = h5O_info_t.type;
                        if (n4 == HDF5Constants.H5O_TYPE_DATASET) {
                            n3 = -1;
                            try {
                                n3 = H5.H5Dopen(this.fid, string, HDF5Constants.H5P_DEFAULT);
                                hObject = this.getDataset(n3, string2, string3);
                            }
                            catch (Throwable throwable) {
                                try {
                                    H5.H5Dclose(n3);
                                }
                                catch (Exception exception) {}
                                throw throwable;
                            }
                            try {
                                H5.H5Dclose(n3);
                            }
                            catch (Exception exception) {}
                        } else if (n4 == HDF5Constants.H5O_TYPE_GROUP) {
                            n3 = -1;
                            try {
                                n3 = H5.H5Gopen(this.fid, string, HDF5Constants.H5P_DEFAULT);
                                H5Group h5Group = null;
                                if (string3 != null) {
                                    h5Group = new H5Group((FileFormat)this, null, string3, null);
                                    hObject = this.getGroup(n3, string2, h5Group);
                                    h5Group.addToMemberList(hObject);
                                } else {
                                    hObject = this.getGroup(n3, string2, h5Group);
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    H5.H5Gclose(n3);
                                }
                                catch (Exception exception) {}
                                throw throwable;
                            }
                            try {
                                H5.H5Gclose(n3);
                            }
                            catch (Exception exception) {}
                        } else if (n4 == HDF5Constants.H5O_TYPE_NAMED_DATATYPE) {
                            hObject = new H5Datatype(this, string2, string3);
                        }
                    }
                    try {
                        H5.H5Oclose(n2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    hObject = null;
                    if (n > 0 || hObject != null) break block42;
                    try {
                        H5.H5Fclose(this.fid);
                    }
                    catch (Exception exception2) {}
                    this.fid = n;
                    break block42;
                }
            }
            catch (Throwable throwable) {
                if (n <= 0 && hObject == null) {
                    try {
                        H5.H5Fclose(this.fid);
                    }
                    catch (Exception exception) {}
                    this.fid = n;
                }
                throw throwable;
            }
            if (n <= 0 && hObject == null) {
                try {
                    H5.H5Fclose(this.fid);
                }
                catch (Exception exception) {}
                this.fid = n;
            }
        }
        return hObject;
    }

    @Override
    public Datatype createDatatype(int n, int n2, int n3, int n4, String string) throws Exception {
        int n5 = -1;
        H5Datatype h5Datatype = null;
        try {
            H5Datatype h5Datatype2 = (H5Datatype)this.createDatatype(n, n2, n3, n4);
            n5 = h5Datatype2.toNative();
            H5.H5Tcommit(this.fid, string, n5, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            byte[] byArray = H5.H5Rcreate(this.fid, string, HDF5Constants.H5R_OBJECT, -1);
            long l = HDFNativeData.byteToLong(byArray, 0);
            long[] lArray = new long[]{l};
            h5Datatype = new H5Datatype(this, null, string);
        }
        finally {
            if (n5 > 0) {
                H5.H5Tclose(n5);
            }
        }
        return h5Datatype;
    }

    @Override
    public Datatype createDatatype(int n, int n2, int n3, int n4) throws Exception {
        return new H5Datatype(n, n2, n3, n4);
    }

    @Override
    public Dataset createScalarDS(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object) throws Exception {
        if (group == null) {
            group = (Group)this.get("/");
        }
        return H5ScalarDS.create(string, group, datatype, lArray, lArray2, lArray3, n, object);
    }

    @Override
    public Dataset createCompoundDS(String string, Group group, long[] lArray, long[] lArray2, long[] lArray3, int n, String[] stringArray, Datatype[] datatypeArray, int[] nArray, Object object) throws Exception {
        int n2 = stringArray.length;
        int[] nArray2 = new int[n2];
        long[][] lArray4 = new long[n2][1];
        Dataset dataset = null;
        int n3 = 0;
        while (n3 < n2) {
            nArray2[n3] = 1;
            lArray4[n3][0] = nArray == null ? 1L : (long)nArray[n3];
            ++n3;
        }
        if (group == null) {
            group = (Group)this.get("/");
        }
        dataset = H5CompoundDS.create(string, group, lArray, lArray2, lArray3, n, stringArray, datatypeArray, nArray2, lArray4, object);
        return dataset;
    }

    @Override
    public Dataset createImage(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, Object object) throws Exception {
        if (group == null) {
            group = (Group)this.get("/");
        }
        H5ScalarDS h5ScalarDS = H5ScalarDS.create(string, group, datatype, lArray, lArray2, lArray3, n, object);
        try {
            H5File.createImageAttributes(h5ScalarDS, n3);
            h5ScalarDS.setIsImage(true);
        }
        catch (Exception exception) {}
        return h5ScalarDS;
    }

    @Override
    public Group createGroup(String string, Group group) throws Exception {
        return this.createGroup(string, group, HDF5Constants.H5P_DEFAULT);
    }

    @Override
    public Group createGroup(String string, Group group, int ... nArray) throws Exception {
        if (group == null) {
            group = (Group)this.get("/");
        }
        return H5Group.create(string, group, nArray);
    }

    @Override
    public int createGcpl(int n, int n2, int n3) throws Exception {
        int n4 = -1;
        try {
            n4 = H5.H5Pcreate(HDF5Constants.H5P_GROUP_CREATE);
            if (n4 >= 0) {
                if (n == 1) {
                    H5.H5Pset_link_creation_order(n4, HDF5Constants.H5P_CRT_ORDER_TRACKED);
                } else if (n == 2) {
                    H5.H5Pset_link_creation_order(n4, HDF5Constants.H5P_CRT_ORDER_TRACKED + HDF5Constants.H5P_CRT_ORDER_INDEXED);
                }
                H5.H5Pset_link_phase_change(n4, n2, n3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n4;
    }

    @Override
    public HObject createLink(Group group, String string, Object object) throws Exception {
        if (object instanceof HObject) {
            return this.createLink(group, string, (HObject)object, 0);
        }
        return this.createLink(group, string, (String)object, 0);
    }

    @Override
    public HObject createLink(Group group, String string, HObject hObject, int n) throws Exception {
        HObject hObject2 = null;
        int n2 = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (hObject == null) {
            throw new HDF5Exception("The object pointed by the link cannot be null.");
        }
        string4 = group == null || group.isRoot() ? "/" : String.valueOf(group.getPath()) + "/" + group.getName() + "/";
        string3 = String.valueOf(string4) + string;
        if (n == 0) {
            n2 = HDF5Constants.H5L_TYPE_HARD;
        } else if (n == 1) {
            n2 = HDF5Constants.H5L_TYPE_SOFT;
        } else if (n == 64) {
            n2 = HDF5Constants.H5L_TYPE_EXTERNAL;
        }
        if (H5.H5Lexists(this.fid, string3, HDF5Constants.H5P_DEFAULT)) {
            H5.H5Ldelete(this.fid, string3, HDF5Constants.H5P_DEFAULT);
        }
        if (n2 == HDF5Constants.H5L_TYPE_HARD) {
            if (hObject instanceof Group && ((Group)hObject).isRoot()) {
                throw new HDF5Exception("Cannot make a link to the root group.");
            }
            string2 = String.valueOf(hObject.getPath()) + "/" + hObject.getName();
            H5.H5Lcreate_hard(this.fid, string2, this.fid, string3, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        } else if (n2 == HDF5Constants.H5L_TYPE_SOFT) {
            H5.H5Lcreate_soft(hObject.getFullName(), this.fid, string3, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        } else if (n2 == HDF5Constants.H5L_TYPE_EXTERNAL) {
            H5.H5Lcreate_external(hObject.getFile(), hObject.getFullName(), this.fid, string3, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        }
        if (hObject instanceof Group) {
            hObject2 = new H5Group((FileFormat)this, string, string4, group);
        } else if (hObject instanceof H5Datatype) {
            hObject2 = new H5Datatype(this, string, string4);
        } else if (hObject instanceof H5CompoundDS) {
            hObject2 = new H5CompoundDS(this, string, string4);
        } else if (hObject instanceof H5ScalarDS) {
            hObject2 = new H5ScalarDS(this, string, string4);
        }
        return hObject2;
    }

    @Override
    public HObject createLink(Group group, String string, String string2, int n) throws Exception {
        H5Link h5Link = null;
        int n2 = 0;
        String string3 = null;
        String string4 = null;
        if (string2 == null) {
            throw new HDF5Exception("The object pointed by the link cannot be null.");
        }
        string4 = group == null || group.isRoot() ? "/" : String.valueOf(group.getPath()) + "/" + group.getName() + "/";
        string3 = String.valueOf(string4) + string;
        if (n == 0) {
            n2 = HDF5Constants.H5L_TYPE_HARD;
        } else if (n == 1) {
            n2 = HDF5Constants.H5L_TYPE_SOFT;
        } else if (n == 64) {
            n2 = HDF5Constants.H5L_TYPE_EXTERNAL;
        }
        if (H5.H5Lexists(this.fid, string3, HDF5Constants.H5P_DEFAULT)) {
            H5.H5Ldelete(this.fid, string3, HDF5Constants.H5P_DEFAULT);
        }
        if (n2 == HDF5Constants.H5L_TYPE_SOFT) {
            H5.H5Lcreate_soft(string2, this.fid, string3, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        } else if (n2 == HDF5Constants.H5L_TYPE_EXTERNAL) {
            String string5 = null;
            String string6 = null;
            string5 = string2.substring(0, string2.lastIndexOf("://"));
            string6 = string2.substring(string2.indexOf("://"));
            string6 = string6.substring(3);
            H5.H5Lcreate_external(string5, string6, this.fid, string3, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        h5Link = new H5Link(this, string, string4);
        return h5Link;
    }

    public void reloadTree(Group group) {
        if (this.fid < 0 || this.rootNode == null || group == null) {
            return;
        }
        HObject hObject = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (group.equals(this.rootNode.getUserObject())) {
            defaultMutableTreeNode = this.rootNode;
        } else {
            Enumeration<TreeNode> enumeration = this.rootNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                hObject = (HObject)defaultMutableTreeNode.getUserObject();
                if (group.equals(hObject)) break;
            }
        }
        defaultMutableTreeNode.removeAllChildren();
        this.depth_first(defaultMutableTreeNode);
    }

    @Override
    public TreeNode copy(HObject hObject, Group group, String string) throws Exception {
        TreeNode treeNode = null;
        if (hObject == null || group == null) {
            return null;
        }
        if (string == null) {
            string = hObject.getName();
        }
        if (hObject instanceof Dataset) {
            treeNode = this.copyDataset((Dataset)hObject, (H5Group)group, string);
        } else if (hObject instanceof H5Group) {
            treeNode = this.copyGroup((H5Group)hObject, (H5Group)group, string);
        } else if (hObject instanceof H5Datatype) {
            treeNode = this.copyDatatype((H5Datatype)hObject, (H5Group)group, string);
        }
        return treeNode;
    }

    @Override
    public void delete(HObject hObject) throws Exception {
        if (hObject == null || this.fid < 0) {
            return;
        }
        String string = String.valueOf(hObject.getPath()) + hObject.getName();
        H5.H5Ldelete(this.fid, string, HDF5Constants.H5P_DEFAULT);
    }

    @Override
    public void writeAttribute(HObject hObject, Attribute attribute, boolean bl) throws HDF5Exception {
        int n;
        int n2;
        int n3;
        int n4;
        block30: {
            String string = hObject.getFullName();
            String string2 = attribute.getName();
            n4 = -1;
            n3 = -1;
            n2 = -1;
            n = hObject.open();
            if (n < 0) {
                return;
            }
            try {
                Object object;
                n4 = attribute.getType().toNative();
                n3 = H5.H5Screate_simple(attribute.getRank(), attribute.getDataDims(), null);
                if (bl) {
                    n2 = H5.H5Aopen_by_name(n, string, string2, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                    int n5 = H5.H5Aget_type(n2);
                    boolean bl2 = H5.H5Tget_class(n5) == HDF5Constants.H5T_VLEN || H5.H5Tis_variable_str(n5);
                    try {
                        H5.H5Tclose(n5);
                    }
                    catch (Exception exception) {}
                    if (bl2) {
                        throw new HDF5Exception("Writing variable-length attributes is not supported");
                    }
                } else {
                    n2 = H5.H5Acreate(n, string2, n4, n3, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                }
                if ((object = attribute.getValue()) == null) break block30;
                if (attribute.getType().getDatatypeClass() == 7 && object instanceof String) {
                    object = H5.H5Rcreate(this.getFID(), (String)object, HDF5Constants.H5R_OBJECT, -1);
                } else if (Array.get(object, 0) instanceof String) {
                    String string3 = (String)Array.get(object, 0);
                    int n6 = H5.H5Tget_size(n4);
                    if (string3.length() > n6) {
                        string3 = string3.substring(0, n6);
                        Array.set(object, 0, string3);
                    } else {
                        int n7 = string3.length();
                        while (n7 < n6) {
                            string3 = String.valueOf(string3) + " ";
                            ++n7;
                        }
                    }
                    byte[] byArray = string3.getBytes();
                    byArray[string3.length() - 1] = 0;
                    object = byArray;
                }
                try {
                    int n8 = n4;
                    n4 = H5.H5Tget_native_type(n8);
                    try {
                        H5.H5Tclose(n8);
                    }
                    catch (HDF5Exception hDF5Exception) {}
                    H5.H5Awrite(n2, n4, object);
                }
                catch (Exception exception) {}
            }
            catch (Throwable throwable) {
                try {
                    H5.H5Tclose(n4);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Sclose(n3);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Aclose(n2);
                }
                catch (HDF5Exception hDF5Exception) {}
                throw throwable;
            }
        }
        try {
            H5.H5Tclose(n4);
        }
        catch (HDF5Exception hDF5Exception) {}
        try {
            H5.H5Sclose(n3);
        }
        catch (HDF5Exception hDF5Exception) {}
        try {
            H5.H5Aclose(n2);
        }
        catch (HDF5Exception hDF5Exception) {}
        hObject.close(n);
    }

    public int open(int n) throws Exception {
        return this.open(true, n);
    }

    private int open(boolean bl) throws Exception {
        int n = -1;
        int n2 = HDF5Constants.H5P_DEFAULT;
        n = this.open(bl, n2);
        return n;
    }

    private int open(boolean bl, int n) throws Exception {
        if (this.fid > 0) {
            return this.fid;
        }
        H5.H5Dchdir_ext(System.getProperty("user.dir"));
        if (this.flag < 0) {
            throw new HDF5Exception("Invalid access identifer -- " + this.flag);
        }
        if (HDF5Constants.H5F_ACC_CREAT == this.flag) {
            this.fid = H5.H5Fcreate(this.fullFileName, HDF5Constants.H5F_ACC_TRUNC, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            H5.H5Fflush(this.fid, HDF5Constants.H5F_SCOPE_LOCAL);
            H5.H5Fclose(this.fid);
            this.flag = HDF5Constants.H5F_ACC_RDWR;
        } else {
            if (!this.exists()) {
                throw new HDF5Exception("File does not exist -- " + this.fullFileName);
            }
            if (!(this.flag != HDF5Constants.H5F_ACC_RDWR && this.flag != HDF5Constants.H5F_ACC_CREAT || this.canWrite())) {
                throw new HDF5Exception("Cannot write file, try open as read-only -- " + this.fullFileName);
            }
            if (this.flag == HDF5Constants.H5F_ACC_RDONLY && !this.canRead()) {
                throw new HDF5Exception("Cannot read file -- " + this.fullFileName);
            }
        }
        try {
            this.fid = H5.H5Fopen(this.fullFileName, this.flag, n);
        }
        catch (Exception exception) {
            this.isReadOnly = true;
            this.fid = H5.H5Fopen(this.fullFileName, HDF5Constants.H5F_ACC_RDONLY, HDF5Constants.H5P_DEFAULT);
        }
        if (this.fid >= 0 && bl) {
            this.rootNode = this.loadTree();
        }
        return this.fid;
    }

    private DefaultMutableTreeNode loadTree() {
        if (this.fid < 0) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        long[] lArray = new long[1];
        H5Group h5Group = new H5Group(this, this.getName(), null, null, lArray);
        defaultMutableTreeNode = new DefaultMutableTreeNode(h5Group){
            public static final long serialVersionUID = 240L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        this.depth_first(defaultMutableTreeNode);
        return defaultMutableTreeNode;
    }

    private void depth_first(MutableTreeNode mutableTreeNode) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        String string = null;
        String string2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)mutableTreeNode;
        int n = -1;
        H5Group h5Group = (H5Group)defaultMutableTreeNode2.getUserObject();
        string2 = h5Group.getPath();
        string = string2 == null ? "/" : String.valueOf(string2) + h5Group.getName() + "/";
        int n2 = 0;
        try {
            n = h5Group.open();
            object = H5.H5Gget_info(n);
            n2 = (int)((H5G_info_t)object).nlinks;
        }
        catch (HDF5Exception hDF5Exception) {
            n2 = -1;
        }
        if (n2 <= 0) {
            h5Group.close(n);
            return;
        }
        object = new int[n2];
        long[] lArray = new long[n2];
        String[] stringArray = new String[n2];
        try {
            H5.H5Gget_obj_info_all(this.fid, string, stringArray, (int[])object, lArray);
        }
        catch (HDF5Exception hDF5Exception) {
            return;
        }
        int n3 = Math.max(0, this.getStartMembers());
        int n4 = this.getMaxMembers();
        if (n4 >= n2) {
            n4 = n2;
            n3 = 0;
        }
        n4 += n3;
        n4 = Math.min(n4, n2);
        long[] lArray2 = null;
        int n5 = n3;
        while (n5 < n4) {
            lArray2 = null;
            String string3 = stringArray[n5];
            Object object2 = object[n5];
            long l = lArray[n5];
            int[] nArray = new int[]{1};
            if (string3 != null) {
                Serializable serializable;
                Object object3;
                try {
                    object3 = null;
                    String string4 = String.valueOf(string) + string3;
                    if (string4 != null && !string4.startsWith("/")) {
                        string4 = String.valueOf(string) + string4;
                    }
                    object3 = H5.H5Rcreate(this.fid, string4, HDF5Constants.H5R_OBJECT, -1);
                    if (string4 != null && string4.length() > 0 && object3 != null) {
                        object2 = H5.H5Rget_obj_type(this.fid, HDF5Constants.H5R_OBJECT, object3, nArray);
                    }
                    lArray2 = new long[]{l};
                }
                catch (HDF5Exception hDF5Exception) {}
                if (lArray2 == null && object2 == HDF5Constants.H5O_TYPE_UNKNOWN) {
                    object3 = new H5Link(this, string3, string, lArray2);
                    defaultMutableTreeNode = new DefaultMutableTreeNode(object3);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                    h5Group.addToMemberList((HObject)object3);
                } else if (object2 == HDF5Constants.H5O_TYPE_GROUP) {
                    object3 = new H5Group(this, string3, string, h5Group, lArray2);
                    defaultMutableTreeNode = new DefaultMutableTreeNode(object3){
                        public static final long serialVersionUID = 240L;

                        @Override
                        public boolean isLeaf() {
                            return false;
                        }
                    };
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                    h5Group.addToMemberList((HObject)object3);
                    boolean bl = false;
                    HObject hObject = null;
                    serializable = defaultMutableTreeNode2;
                    while (serializable != null) {
                        hObject = (HObject)((DefaultMutableTreeNode)serializable).getUserObject();
                        if (hObject.equalsOID(lArray2)) {
                            bl = true;
                            break;
                        }
                        serializable = (DefaultMutableTreeNode)((DefaultMutableTreeNode)serializable).getParent();
                    }
                    if (!bl) {
                        this.depth_first(defaultMutableTreeNode);
                    }
                } else if (object2 == HDF5Constants.H5O_TYPE_DATASET) {
                    int n6;
                    block42: {
                        int n7 = -1;
                        int n8 = -1;
                        n6 = -1;
                        try {
                            try {
                                n7 = H5.H5Dopen(this.fid, String.valueOf(string) + string3, HDF5Constants.H5P_DEFAULT);
                                n8 = H5.H5Dget_type(n7);
                                n6 = H5.H5Tget_class(n8);
                                if (n6 == HDF5Constants.H5T_ARRAY || n6 == HDF5Constants.H5T_VLEN) {
                                    int n9 = H5.H5Tget_super(n8);
                                    n6 = H5.H5Tget_class(n9);
                                    try {
                                        H5.H5Tclose(n9);
                                    }
                                    catch (HDF5Exception hDF5Exception) {}
                                }
                            }
                            catch (HDF5Exception hDF5Exception) {
                                try {
                                    H5.H5Tclose(n8);
                                }
                                catch (HDF5Exception hDF5Exception2) {}
                                try {
                                    H5.H5Dclose(n7);
                                }
                                catch (HDF5Exception hDF5Exception3) {}
                                break block42;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                H5.H5Tclose(n8);
                            }
                            catch (HDF5Exception hDF5Exception) {}
                            try {
                                H5.H5Dclose(n7);
                            }
                            catch (HDF5Exception hDF5Exception) {}
                            throw throwable;
                        }
                        try {
                            H5.H5Tclose(n8);
                        }
                        catch (HDF5Exception hDF5Exception) {}
                        try {
                            H5.H5Dclose(n7);
                        }
                        catch (HDF5Exception hDF5Exception) {}
                    }
                    serializable = null;
                    serializable = n6 == HDF5Constants.H5T_COMPOUND ? new H5CompoundDS(this, string3, string, lArray2) : new H5ScalarDS(this, string3, string, lArray2);
                    defaultMutableTreeNode = new DefaultMutableTreeNode(serializable);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                    h5Group.addToMemberList((HObject)serializable);
                } else if (object2 == HDF5Constants.H5O_TYPE_NAMED_DATATYPE) {
                    object3 = new H5Datatype(this, string3, string, lArray2);
                    defaultMutableTreeNode = new DefaultMutableTreeNode(object3);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                    h5Group.addToMemberList((HObject)object3);
                }
            }
            ++n5;
        }
        h5Group.close(n);
    }

    private TreeNode copyDataset(Dataset dataset, H5Group h5Group, String string) throws Exception {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Dataset dataset2 = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        String string2 = null;
        string2 = h5Group.isRoot() ? "/" : String.valueOf(h5Group.getPath()) + h5Group.getName() + "/";
        if (string == null || string.equals("/") || string.length() < 1) {
            string = dataset.getName();
        }
        String cfr_ignored_0 = String.valueOf(string2) + string;
        try {
            block22: {
                n = dataset.open();
                n2 = h5Group.open();
                try {
                    try {
                        n3 = H5.H5Pcreate(HDF5Constants.H5P_OBJECT_COPY);
                        H5.H5Pset_copy_object(n3, HDF5Constants.H5O_COPY_EXPAND_REFERENCE_FLAG);
                        H5.H5Ocopy(n, ".", n2, string, n3, HDF5Constants.H5P_DEFAULT);
                    }
                    catch (Exception exception) {
                        try {
                            H5.H5Pclose(n3);
                        }
                        catch (Exception exception2) {}
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        H5.H5Pclose(n3);
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    H5.H5Pclose(n3);
                }
                catch (Exception exception) {}
            }
            dataset2 = dataset instanceof H5ScalarDS ? new H5ScalarDS(h5Group.getFileFormat(), string, string2) : new H5CompoundDS(h5Group.getFileFormat(), string, string2);
            h5Group.addToMemberList(dataset2);
            defaultMutableTreeNode = new DefaultMutableTreeNode(dataset2);
        }
        catch (Throwable throwable) {
            try {
                dataset.close(n);
            }
            catch (Exception exception) {}
            try {
                h5Group.close(n2);
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            dataset.close(n);
        }
        catch (Exception exception) {}
        try {
            h5Group.close(n2);
        }
        catch (Exception exception) {}
        return defaultMutableTreeNode;
    }

    private Dataset getDataset(int n, String string, String string2) throws HDF5Exception {
        Dataset dataset = null;
        int n2 = -1;
        int n3 = -1;
        try {
            n2 = H5.H5Dget_type(n);
            n3 = H5.H5Tget_class(n2);
            if (n3 == HDF5Constants.H5T_ARRAY) {
                int n4 = H5.H5Tget_super(n2);
                n3 = H5.H5Tget_class(n4);
                try {
                    H5.H5Tclose(n4);
                }
                catch (HDF5Exception hDF5Exception) {}
            }
        }
        catch (Throwable throwable) {
            try {
                H5.H5Tclose(n2);
            }
            catch (HDF5Exception hDF5Exception) {}
            throw throwable;
        }
        try {
            H5.H5Tclose(n2);
        }
        catch (HDF5Exception hDF5Exception) {}
        dataset = n3 == HDF5Constants.H5T_COMPOUND ? new H5CompoundDS(this, string, string2) : new H5ScalarDS(this, string, string2);
        return dataset;
    }

    private TreeNode copyDatatype(Datatype datatype, H5Group h5Group, String string) throws Exception {
        H5Datatype h5Datatype = null;
        int n = -1;
        int n2 = -1;
        String string2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        string2 = h5Group.isRoot() ? "/" : String.valueOf(h5Group.getPath()) + h5Group.getName() + "/";
        if (string == null || string.equals("/") || string.length() < 1) {
            string = datatype.getName();
        }
        try {
            n = datatype.open();
            n2 = h5Group.open();
            try {
                H5.H5Ocopy(n, ".", n2, string, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            }
            catch (Exception exception) {}
            h5Datatype = new H5Datatype(h5Group.getFileFormat(), string, string2);
            h5Group.addToMemberList(h5Datatype);
            defaultMutableTreeNode = new DefaultMutableTreeNode(h5Datatype);
        }
        catch (Throwable throwable) {
            try {
                datatype.close(n);
            }
            catch (Exception exception) {}
            try {
                h5Group.close(n2);
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            datatype.close(n);
        }
        catch (Exception exception) {}
        try {
            h5Group.close(n2);
        }
        catch (Exception exception) {}
        return defaultMutableTreeNode;
    }

    private TreeNode copyGroup(H5Group h5Group, H5Group h5Group2, String string) throws Exception {
        H5Group h5Group3 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        int n = -1;
        int n2 = -1;
        String string2 = null;
        string2 = h5Group2.isRoot() ? "/" : String.valueOf(h5Group2.getPath()) + h5Group2.getName() + "/";
        if (string == null || string.equals("/") || string.length() < 1) {
            string = h5Group.getName();
        }
        String cfr_ignored_0 = String.valueOf(string2) + string;
        try {
            n = h5Group.open();
            n2 = h5Group2.open();
            try {
                H5.H5Ocopy(n, ".", n2, string, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            h5Group3 = new H5Group(h5Group2.getFileFormat(), string, string2, h5Group2);
            defaultMutableTreeNode = new DefaultMutableTreeNode(h5Group3){
                public static final long serialVersionUID = 240L;

                @Override
                public boolean isLeaf() {
                    return false;
                }
            };
            this.depth_first(defaultMutableTreeNode);
            h5Group2.addToMemberList(h5Group3);
        }
        catch (Throwable throwable) {
            try {
                h5Group.close(n);
            }
            catch (Exception exception) {}
            try {
                h5Group2.close(n2);
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            h5Group.close(n);
        }
        catch (Exception exception) {}
        try {
            h5Group2.close(n2);
        }
        catch (Exception exception) {}
        return defaultMutableTreeNode;
    }

    private H5Group getGroup(int n, String string, Group group) throws HDF5Exception {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (group == null) {
            string = "/";
            string3 = "/";
        } else {
            string2 = group.getFullName();
            string3 = string2 == null || string2.equals("/") ? "/" + string : String.valueOf(string2) + "/" + string;
        }
        if (string2 != null) {
            string2 = string2.replaceAll("//", "/");
        }
        if (string3 != null) {
            string3 = string3.replaceAll("//", "/");
        }
        H5Group h5Group = new H5Group((FileFormat)this, string, string2, group);
        H5G_info_t h5G_info_t = null;
        H5O_info_t h5O_info_t = null;
        int n2 = -1;
        String string5 = null;
        try {
            h5G_info_t = H5.H5Gget_info(n);
        }
        catch (HDF5Exception hDF5Exception) {}
        try {
            n2 = H5.H5Oopen(n, string3, HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5Exception hDF5Exception) {}
        int n3 = 0;
        while ((long)n3 < h5G_info_t.nlinks) {
            block23: {
                try {
                    string5 = H5.H5Lget_name_by_idx(n, string3, HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_INC, n3, HDF5Constants.H5P_DEFAULT);
                    h5O_info_t = H5.H5Oget_info_by_idx(n2, string3, HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_INC, n3, HDF5Constants.H5P_DEFAULT);
                }
                catch (HDF5Exception hDF5Exception) {
                    hDF5Exception.printStackTrace();
                    break block23;
                }
                if (h5O_info_t.type == HDF5Constants.H5O_TYPE_GROUP) {
                    H5Group h5Group2 = new H5Group((FileFormat)this, string5, string3, h5Group);
                    h5Group.addToMemberList(h5Group2);
                } else if (h5O_info_t.type == HDF5Constants.H5O_TYPE_DATASET) {
                    int n4 = -1;
                    Dataset dataset = null;
                    string4 = string3 == null || string3.equals("/") ? "/" + string5 : String.valueOf(string3) + "/" + string5;
                    try {
                        n4 = H5.H5Dopen(this.fid, string4, HDF5Constants.H5P_DEFAULT);
                        dataset = this.getDataset(n4, string5, string3);
                    }
                    catch (Throwable throwable) {
                        try {
                            H5.H5Dclose(n4);
                        }
                        catch (HDF5Exception hDF5Exception) {}
                        throw throwable;
                    }
                    try {
                        H5.H5Dclose(n4);
                    }
                    catch (HDF5Exception hDF5Exception) {}
                    h5Group.addToMemberList(dataset);
                }
            }
            ++n3;
        }
        try {
            if (n2 >= 0) {
                H5.H5Oclose(n2);
            }
        }
        catch (HDF5Exception hDF5Exception) {}
        return h5Group;
    }

    public static String getLinkTargetName(HObject hObject) throws Exception {
        String[] stringArray = new String[2];
        String string = null;
        if (hObject == null) {
            return null;
        }
        H5L_info_t h5L_info_t = null;
        try {
            h5L_info_t = H5.H5Lget_info(hObject.getFID(), hObject.getFullName(), HDF5Constants.H5P_DEFAULT);
        }
        catch (Throwable throwable) {}
        if (h5L_info_t != null && (h5L_info_t.type == HDF5Constants.H5L_TYPE_SOFT || h5L_info_t.type == HDF5Constants.H5L_TYPE_EXTERNAL)) {
            try {
                H5.H5Lget_val(hObject.getFID(), hObject.getFullName(), stringArray, HDF5Constants.H5P_DEFAULT);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (h5L_info_t.type == HDF5Constants.H5L_TYPE_SOFT) {
                string = stringArray[0];
            } else if (h5L_info_t.type == HDF5Constants.H5L_TYPE_EXTERNAL) {
                string = String.valueOf(stringArray[1]) + "://" + stringArray[0];
            }
        }
        return string;
    }

    @Override
    public void renameAttribute(HObject hObject, String string, String string2) throws Exception {
        if (!this.attrFlag) {
            this.attrFlag = true;
            H5.H5Arename_by_name(hObject.getFID(), hObject.getName(), string, string2, HDF5Constants.H5P_DEFAULT);
        }
    }
}

