/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.lang.reflect.Array;
import java.util.List;
import java.util.StringTokenizer;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.h5.H5File;

public class H5Datatype
extends Datatype {
    public static final long serialVersionUID = 240L;
    private List attributeList;
    private boolean isNamed = false;
    private int nAttributes = -1;
    private H5O_info_t obj_info;
    private boolean isVLEN = false;
    private String description = null;

    public H5Datatype(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    @Deprecated
    public H5Datatype(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        this.obj_info = new H5O_info_t(-1L, -1L, 0, 0, -1L, 0L, 0L, 0L, 0L, null, null, null);
        if (lArray == null && fileFormat != null) {
            try {
                byte[] byArray = H5.H5Rcreate(fileFormat.getFID(), this.getFullName(), HDF5Constants.H5R_OBJECT, -1);
                this.oid = new long[1];
                this.oid[0] = HDFNativeData.byteToLong(byArray, 0);
            }
            catch (Exception exception) {}
        }
    }

    public H5Datatype(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public H5Datatype(int n) {
        super(n);
        this.description = H5Datatype.getDatatypeDescription(n);
        this.fromNative(n);
    }

    @Override
    public boolean hasAttribute() {
        block12: {
            this.obj_info.num_attrs = this.nAttributes;
            if (this.obj_info.num_attrs < 0L) {
                int n = -1;
                try {
                    try {
                        n = H5.H5Topen(this.getFID(), String.valueOf(this.getPath()) + this.getName(), HDF5Constants.H5P_DEFAULT);
                        this.fromNative(n);
                        this.obj_info = H5.H5Oget_info(n);
                        this.isNamed = true;
                    }
                    catch (Exception exception) {
                        this.obj_info.num_attrs = 0L;
                        try {
                            H5.H5Tclose(n);
                        }
                        catch (Exception exception2) {}
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        H5.H5Tclose(n);
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    H5.H5Tclose(n);
                }
                catch (Exception exception) {}
            }
        }
        return this.obj_info.num_attrs > 0L;
    }

    public static final String[] convertEnumValueToName(int n, Object object, String[] stringArray) throws HDF5Exception {
        int n2 = 0;
        if (object == null || (n2 = Array.getLength(object)) <= 0 || stringArray != null && n2 != Array.getLength(stringArray)) {
            return null;
        }
        int n3 = H5.H5Tget_nmembers(n);
        if (n3 <= 0) {
            return null;
        }
        if (stringArray == null) {
            stringArray = new String[n2];
        } else {
            int n4 = 0;
            while (n4 < n2) {
                stringArray[n4] = null;
                ++n4;
            }
        }
        String[] stringArray2 = new String[n3];
        int[] nArray = new int[n3];
        int[] nArray2 = new int[1];
        int n5 = 0;
        while (n5 < n3) {
            stringArray2[n5] = H5.H5Tget_member_name(n, n5);
            H5.H5Tget_member_value(n, n5, nArray2);
            nArray[n5] = nArray2[0];
            ++n5;
        }
        n5 = -1;
        int n6 = 0;
        while (n6 < n2) {
            n5 = Array.getInt(object, n6);
            int n7 = 0;
            while (n7 < n3) {
                if (n5 == nArray[n7]) {
                    stringArray[n6] = stringArray2[n7];
                    break;
                }
                ++n7;
            }
            ++n6;
        }
        return stringArray;
    }

    public static final int[] convertEnumNameToValue(int n, String[] stringArray, int[] nArray) throws HDF5Exception {
        int n2 = 0;
        if (stringArray == null || (n2 = Array.getLength(stringArray)) <= 0 || nArray != null && n2 != Array.getLength(nArray)) {
            return null;
        }
        int n3 = H5.H5Tget_nmembers(n);
        if (n3 <= 0) {
            return null;
        }
        if (nArray == null) {
            nArray = new int[n2];
        } else {
            int n4 = 0;
            while (n4 < n2) {
                nArray[n4] = -1;
                ++n4;
            }
        }
        String[] stringArray2 = new String[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[1];
        int n5 = 0;
        while (n5 < n3) {
            stringArray2[n5] = H5.H5Tget_member_name(n, n5);
            H5.H5Tget_member_value(n, n5, nArray3);
            nArray2[n5] = nArray3[0];
            ++n5;
        }
        n5 = 0;
        while (n5 < n2) {
            if (stringArray[n5] != null && stringArray[n5].length() > 0) {
                int n6 = 0;
                while (n6 < n3) {
                    if (stringArray[n5].equalsIgnoreCase(stringArray2[n6])) {
                        nArray[n5] = nArray2[n6];
                        break;
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        return nArray;
    }

    @Override
    public void fromNative(int n) {
        int n2;
        block37: {
            int n3 = -1;
            n2 = -1;
            boolean bl = false;
            boolean bl2 = false;
            try {
                n3 = H5.H5Tget_class(n);
                n2 = H5.H5Tget_size(n);
                this.isVLEN = n3 == HDF5Constants.H5T_VLEN;
            }
            catch (Exception exception) {
                this.datatypeClass = -1;
            }
            try {
                bl2 = H5.H5Tequal(n, HDF5Constants.H5T_NATIVE_UCHAR);
                bl = H5.H5Tequal(n, HDF5Constants.H5T_NATIVE_CHAR) || bl2;
            }
            catch (Exception exception) {}
            if (n3 == HDF5Constants.H5T_ARRAY) {
                int n4 = -1;
                this.datatypeClass = 10;
                try {
                    try {
                        int n5 = H5.H5Tget_array_ndims(n);
                        this.dims = new long[n5];
                        H5.H5Tget_array_dims(n, this.dims);
                        n4 = H5.H5Tget_super(n);
                        this.baseType = new H5Datatype(n4);
                    }
                    catch (Exception exception) {
                        try {
                            H5.H5Tclose(n4);
                        }
                        catch (Exception exception2) {}
                        break block37;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        H5.H5Tclose(n4);
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    H5.H5Tclose(n4);
                }
                catch (Exception exception) {}
            } else if (bl) {
                this.datatypeClass = 2;
                if (bl2) {
                    this.datatypeSign = 0;
                }
            } else if (n3 == HDF5Constants.H5T_INTEGER) {
                this.datatypeClass = 0;
                try {
                    int n6 = H5.H5Tget_sign(n);
                    if (n6 == HDF5Constants.H5T_SGN_NONE) {
                        this.datatypeSign = 0;
                    }
                }
                catch (Exception exception) {}
            } else if (n3 == HDF5Constants.H5T_FLOAT) {
                this.datatypeClass = 1;
            } else if (n3 == HDF5Constants.H5T_STRING) {
                try {
                    this.isVLEN = H5.H5Tis_variable_str(n);
                }
                catch (Exception exception) {}
                this.datatypeClass = 3;
            } else if (n3 == HDF5Constants.H5T_REFERENCE) {
                this.datatypeClass = 7;
            } else if (n3 == HDF5Constants.H5T_ENUM) {
                this.datatypeClass = 8;
                try {
                    int n7 = H5.H5Tget_nmembers(n);
                    String string = null;
                    int[] nArray = new int[1];
                    String string2 = "";
                    int n8 = 0;
                    while (n8 < n7) {
                        string = H5.H5Tget_member_name(n, n8);
                        H5.H5Tget_member_value(n, n8, nArray);
                        string2 = String.valueOf(string2) + string + "=" + nArray[0] + ",";
                        ++n8;
                    }
                    this.enumMembers = string2;
                }
                catch (Exception exception) {}
            }
        }
        this.datatypeSize = this.isVLEN ? -1 : n2;
        this.datatypeOrder = -1;
    }

    @Deprecated
    public static int toNative(int n) {
        int n2 = -1;
        try {
            n2 = H5.H5Tget_native_type(n);
        }
        catch (Exception exception) {}
        try {
            if (H5.H5Tis_variable_str(n)) {
                H5.H5Tset_size(n2, HDF5Constants.H5T_VARIABLE);
            }
        }
        catch (Exception exception) {}
        return n2;
    }

    @Override
    public int toNative() {
        int n = -1;
        int n2 = -1;
        if (this.isNamed) {
            try {
                n = H5.H5Topen(this.getFID(), String.valueOf(this.getPath()) + this.getName(), HDF5Constants.H5P_DEFAULT);
            }
            catch (Exception exception) {}
        }
        if (n >= 0) {
            return n;
        }
        try {
            switch (this.datatypeClass) {
                case 10: {
                    try {
                        n2 = this.baseType.toNative();
                        n = H5.H5Tarray_create(n2, this.dims.length, this.dims);
                        break;
                    }
                    finally {
                        this.close(n2);
                    }
                }
                case 0: 
                case 8: {
                    n = this.datatypeSize == 1 ? H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT8) : (this.datatypeSize == 2 ? H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT16) : (this.datatypeSize == 4 ? H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT32) : (this.datatypeSize == 8 ? H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT64) : H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT))));
                    if (this.datatypeOrder == 1) {
                        H5.H5Tset_order(n, HDF5Constants.H5T_ORDER_BE);
                    } else if (this.datatypeOrder == 0) {
                        H5.H5Tset_order(n, HDF5Constants.H5T_ORDER_LE);
                    }
                    if (this.datatypeSign == 0) {
                        H5.H5Tset_sign(n, HDF5Constants.H5T_SGN_NONE);
                    }
                    break;
                }
                case 1: {
                    n = this.datatypeSize == 8 ? H5.H5Tcopy(HDF5Constants.H5T_NATIVE_DOUBLE) : H5.H5Tcopy(HDF5Constants.H5T_NATIVE_FLOAT);
                    if (this.datatypeOrder == 1) {
                        H5.H5Tset_order(n, HDF5Constants.H5T_ORDER_BE);
                        break;
                    }
                    if (this.datatypeOrder == 0) {
                        H5.H5Tset_order(n, HDF5Constants.H5T_ORDER_LE);
                    }
                    break;
                }
                case 2: {
                    if (this.datatypeSign == 0) {
                        n = H5.H5Tcopy(HDF5Constants.H5T_NATIVE_UCHAR);
                        break;
                    }
                    n = H5.H5Tcopy(HDF5Constants.H5T_NATIVE_CHAR);
                    break;
                }
                case 3: {
                    n = H5.H5Tcopy(HDF5Constants.H5T_C_S1);
                    if (this.isVLEN) {
                        H5.H5Tset_size(n, HDF5Constants.H5T_VARIABLE);
                    } else {
                        H5.H5Tset_size(n, this.datatypeSize);
                    }
                    H5.H5Tset_strpad(n, HDF5Constants.H5T_STR_NULLPAD);
                    break;
                }
                case 7: {
                    if (this.datatypeSize > H5.H5Tget_size(HDF5Constants.H5T_STD_REF_OBJ)) {
                        n = H5.H5Tcopy(HDF5Constants.H5T_STD_REF_DSETREG);
                        break;
                    }
                    n = H5.H5Tcopy(HDF5Constants.H5T_STD_REF_OBJ);
                }
            }
        }
        catch (Exception exception) {
            n = -1;
        }
        if (this.datatypeClass == 8) {
            int n3 = n;
            try {
                n = H5.H5Tenum_create(n3);
                int n4 = 0;
                StringTokenizer stringTokenizer = this.enumMembers == null ? new StringTokenizer("0,1", ",") : new StringTokenizer(this.enumMembers, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string;
                    String string2 = stringTokenizer.nextToken();
                    if (string2 != null) {
                        string2 = string2.trim();
                    }
                    if (string2 == null || string2.length() < 1) continue;
                    int n5 = string2.indexOf(61);
                    if (n5 > 0) {
                        string = string2.substring(0, n5);
                        n4 = Integer.parseInt(string2.substring(n5 + 1));
                    } else {
                        string = string2;
                        ++n4;
                    }
                    H5.H5Tenum_insert(n, string, n4);
                }
            }
            catch (Exception exception) {
                n = -1;
            }
            try {
                H5.H5Tclose(n3);
            }
            catch (Exception exception) {}
        }
        return n;
    }

    public static Object allocateArray(int n, int n2) throws OutOfMemoryError {
        Object object;
        block55: {
            object = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (n2 < 0) {
                return null;
            }
            if (n2 == 0) {
                n2 = 1;
            }
            int n3 = -1;
            int n4 = -1;
            try {
                n3 = H5.H5Tget_class(n);
                n4 = H5.H5Tget_size(n);
                H5.H5Tget_sign(n);
            }
            catch (Exception exception) {}
            try {
                bl2 = H5.H5Tis_variable_str(n);
            }
            catch (Exception exception) {}
            try {
                bl = n3 == HDF5Constants.H5T_VLEN;
            }
            catch (Exception exception) {}
            try {
                bl3 = H5.H5Tequal(n, HDF5Constants.H5T_STD_REF_DSETREG);
            }
            catch (Exception exception) {}
            if (bl2 || bl || bl3) {
                object = new String[n2];
                int n5 = 0;
                while (n5 < n2) {
                    object[n5] = "";
                    ++n5;
                }
            } else if (n3 == HDF5Constants.H5T_INTEGER) {
                if (n4 == 1) {
                    object = new byte[n2];
                } else if (n4 == 2) {
                    object = new short[n2];
                } else if (n4 == 4) {
                    object = new int[n2];
                } else if (n4 == 8) {
                    object = new long[n2];
                }
            } else if (n3 == HDF5Constants.H5T_ENUM) {
                int n6 = -1;
                try {
                    try {
                        n6 = H5.H5Tget_super(n);
                        object = H5Datatype.allocateArray(n6, n2);
                    }
                    catch (Exception exception) {
                        try {
                            H5.H5Tclose(n6);
                        }
                        catch (Exception exception2) {}
                        break block55;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        H5.H5Tclose(n6);
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    H5.H5Tclose(n6);
                }
                catch (Exception exception) {}
            } else if (n3 == HDF5Constants.H5T_FLOAT) {
                if (n4 == 4) {
                    object = new float[n2];
                } else if (n4 == 8) {
                    object = new double[n2];
                }
            } else if (n3 == HDF5Constants.H5T_STRING || n3 == HDF5Constants.H5T_REFERENCE || n3 == HDF5Constants.H5T_BITFIELD) {
                object = new byte[n2 * n4];
            } else if (n3 == HDF5Constants.H5T_ARRAY) {
                int n7 = -1;
                try {
                    try {
                        int n8 = H5.H5Tget_array_ndims(n);
                        long[] lArray = new long[n8];
                        H5.H5Tget_array_dims(n, lArray);
                        int n9 = 1;
                        int n10 = 0;
                        while (n10 < n8) {
                            n9 = (int)((long)n9 * lArray[n10]);
                            ++n10;
                        }
                        n7 = H5.H5Tget_super(n);
                        object = H5Datatype.allocateArray(n7, n2 * n9);
                    }
                    catch (Exception exception) {
                        try {
                            H5.H5Tclose(n7);
                        }
                        catch (Exception exception3) {}
                        break block55;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        H5.H5Tclose(n7);
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    H5.H5Tclose(n7);
                }
                catch (Exception exception) {}
            } else {
                object = null;
            }
        }
        return object;
    }

    public static final int getDatatypeSize(int n) {
        int n2 = -1;
        try {
            n2 = H5.H5Tget_size(n);
        }
        catch (Exception exception) {
            n2 = -1;
        }
        return n2;
    }

    @Override
    public String getDatatypeDescription() {
        if (this.description == null) {
            int n = this.toNative();
            this.description = H5Datatype.getDatatypeDescription(n);
            this.close(n);
        }
        return this.description;
    }

    public static final String getDatatypeDescription(int n) {
        String string;
        block73: {
            string = "Unknown";
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            try {
                n2 = H5.H5Tget_class(n);
                n3 = H5.H5Tget_size(n);
                n4 = H5.H5Tget_sign(n);
            }
            catch (Exception exception) {}
            if (n2 == HDF5Constants.H5T_INTEGER) {
                if (n3 == 1) {
                    try {
                        if (H5.H5Tequal(n, HDF5Constants.H5T_NATIVE_UCHAR)) {
                            string = "8-bit unsigned character";
                            break block73;
                        }
                        if (H5.H5Tequal(n, HDF5Constants.H5T_NATIVE_CHAR)) {
                            string = "8-bit character";
                            break block73;
                        }
                        if (n4 == HDF5Constants.H5T_SGN_NONE) {
                            string = "8-bit unsigned integer";
                            break block73;
                        }
                        string = "8-bit integer";
                    }
                    catch (Exception exception) {
                        string = "Unknown";
                    }
                } else if (n3 == 2) {
                    string = n4 == HDF5Constants.H5T_SGN_NONE ? "16-bit unsigned integer" : "16-bit integer";
                } else if (n3 == 4) {
                    string = n4 == HDF5Constants.H5T_SGN_NONE ? "32-bit unsigned integer" : "32-bit integer";
                } else if (n3 == 8) {
                    string = n4 == HDF5Constants.H5T_SGN_NONE ? "64-bit unsigned integer" : "64-bit integer";
                }
            } else if (n2 == HDF5Constants.H5T_FLOAT) {
                if (n3 == 4) {
                    string = "32-bit floating-point";
                } else if (n3 == 8) {
                    string = "64-bit floating-point";
                }
            } else if (n2 == HDF5Constants.H5T_STRING) {
                try {
                    if (H5.H5Tis_variable_str(n)) {
                        string = "String, length = variable";
                        break block73;
                    }
                    string = "String, length = " + H5.H5Tget_size(n);
                }
                catch (Exception exception) {
                    string = "String";
                }
            } else if (n2 == HDF5Constants.H5T_REFERENCE) {
                boolean bl = false;
                try {
                    bl = H5.H5Tequal(n, HDF5Constants.H5T_STD_REF_DSETREG);
                }
                catch (Exception exception) {}
                string = bl ? "Dataset region reference" : "Object reference";
            } else if (n2 == HDF5Constants.H5T_BITFIELD) {
                string = "Bitfield";
            } else if (n2 == HDF5Constants.H5T_ENUM) {
                string = "enum";
                String string2 = " ( ";
                int[] nArray = new int[1];
                try {
                    int n5 = H5.H5Tget_nmembers(n);
                    int n6 = 0;
                    while (n6 < n5) {
                        H5.H5Tget_member_value(n, n6, nArray);
                        string2 = String.valueOf(string2) + H5.H5Tget_member_name(n, n6);
                        string2 = String.valueOf(string2) + "=" + nArray[0] + "  ";
                        ++n6;
                    }
                    string2 = String.valueOf(string2) + ")";
                    string = String.valueOf(string) + string2;
                }
                catch (Exception exception) {}
            } else if (n2 == HDF5Constants.H5T_ARRAY) {
                string = "Array of ";
                int n7 = -1;
                try {
                    try {
                        n7 = H5.H5Tget_super(n);
                        string = String.valueOf(string) + H5Datatype.getDatatypeDescription(n7);
                        int n8 = H5.H5Tget_array_ndims(n);
                        long[] lArray = new long[n8];
                        try {
                            H5.H5Tget_array_dims(n, lArray);
                        }
                        catch (Exception exception) {}
                        string = String.valueOf(string) + " (" + lArray[0];
                        int n9 = 1;
                        while (n9 < n8) {
                            string = String.valueOf(string) + "x" + lArray[n9];
                            ++n9;
                        }
                        string = String.valueOf(string) + ")";
                    }
                    catch (Exception exception) {
                        try {
                            H5.H5Tclose(n7);
                        }
                        catch (Exception exception2) {}
                        break block73;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        H5.H5Tclose(n7);
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    H5.H5Tclose(n7);
                }
                catch (Exception exception) {}
            } else if (n2 == HDF5Constants.H5T_COMPOUND) {
                string = "Compound ";
                try {
                    string = String.valueOf(string) + "{";
                    int n10 = H5.H5Tget_nmembers(n);
                    int n11 = 0;
                    try {
                        H5.H5Tclose(n11);
                    }
                    catch (Exception exception) {}
                    int n12 = 0;
                    while (n12 < n10) {
                        n11 = H5.H5Tget_member_type(n, n12);
                        string = String.valueOf(string) + H5Datatype.getDatatypeDescription(n11) + ", ";
                        try {
                            H5.H5Tclose(n11);
                        }
                        catch (Exception exception) {}
                        ++n12;
                    }
                    string = String.valueOf(string) + "}";
                }
                catch (Exception exception) {}
            } else if (n2 == HDF5Constants.H5T_VLEN) {
                int n13 = -1;
                try {
                    try {
                        n13 = H5.H5Tget_super(n);
                        string = "Variable-length of " + H5Datatype.getDatatypeDescription(n13);
                    }
                    catch (Exception exception) {
                        string = "Variable-length";
                        try {
                            H5.H5Tclose(n13);
                        }
                        catch (Exception exception3) {}
                        break block73;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        H5.H5Tclose(n13);
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    H5.H5Tclose(n13);
                }
                catch (Exception exception) {}
            } else {
                string = n2 == HDF5Constants.H5T_OPAQUE ? "Opaque" : "Unknown";
            }
        }
        return string;
    }

    @Override
    public boolean isUnsigned() {
        return this.datatypeSign == 0;
    }

    public static final boolean isUnsigned(int n) {
        boolean bl = false;
        try {
            int n2 = H5.H5Tget_sign(n);
            if (n2 == HDF5Constants.H5T_SGN_NONE) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    @Override
    public int open() {
        int n = -1;
        try {
            n = H5.H5Topen(this.getFID(), String.valueOf(this.getPath()) + this.getName(), HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5Exception hDF5Exception) {
            n = -1;
        }
        return n;
    }

    @Override
    public void close(int n) {
        try {
            H5.H5Tclose(n);
        }
        catch (HDF5Exception hDF5Exception) {}
    }

    @Override
    public List getMetadata() throws HDF5Exception {
        return this.getMetadata(HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_INC);
    }

    public List getMetadata(int ... nArray) throws HDF5Exception {
        block10: {
            if (this.attributeList == null) {
                int n = this.open();
                int n2 = HDF5Constants.H5_INDEX_NAME;
                int n3 = HDF5Constants.H5_ITER_INC;
                if (nArray.length > 0) {
                    n2 = nArray[0];
                    if (nArray.length > 1) {
                        n3 = nArray[1];
                    }
                }
                try {
                    try {
                        this.attributeList = H5File.getAttribute(n, n2, n3);
                    }
                    catch (Exception exception) {
                        this.close(n);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    this.close(n);
                    throw throwable;
                }
                this.close(n);
            }
        }
        try {
            this.linkTargetObjName = H5File.getLinkTargetName(this);
        }
        catch (Exception exception) {}
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        boolean bl = false;
        Attribute attribute = (Attribute)object;
        attribute.getName();
        if (this.attributeList == null) {
            this.getMetadata();
        }
        if (this.attributeList != null) {
            bl = this.attributeList.contains(attribute);
        }
        this.getFileFormat().writeAttribute(this, attribute, bl);
        if (!bl) {
            this.attributeList.add(attribute);
            this.nAttributes = this.attributeList.size();
        }
    }

    @Override
    public void removeMetadata(Object object) throws HDF5Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        Attribute attribute = (Attribute)object;
        int n = this.open();
        try {
            H5.H5Adelete(n, attribute.getName());
            List list = this.getMetadata();
            list.remove(attribute);
            this.nAttributes = this.attributeList.size();
        }
        finally {
            this.close(n);
        }
    }
}

