/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5File;

public class H5CompoundDS
extends CompoundDS {
    public static final long serialVersionUID = 240L;
    private List attributeList;
    private int nAttributes = -1;
    private H5O_info_t obj_info = new H5O_info_t(-1L, -1L, 0, 0, -1L, 0L, 0L, 0L, 0L, null, null, null);
    private List flatNameList;
    private List flatTypeList;
    private boolean isExternal = false;

    public H5CompoundDS(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    @Deprecated
    public H5CompoundDS(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        if (lArray == null && fileFormat != null) {
            try {
                byte[] byArray = H5.H5Rcreate(fileFormat.getFID(), this.getFullName(), HDF5Constants.H5R_OBJECT, -1);
                this.oid = new long[1];
                this.oid[0] = HDFNativeData.byteToLong(byArray, 0);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean hasAttribute() {
        this.obj_info.num_attrs = this.nAttributes;
        if (this.obj_info.num_attrs < 0L) {
            int n = -1;
            try {
                n = H5.H5Dopen(this.getFID(), String.valueOf(this.getPath()) + this.getName(), HDF5Constants.H5P_DEFAULT);
                this.obj_info = H5.H5Oget_info(n);
            }
            catch (Exception exception) {
                this.obj_info.num_attrs = 0L;
            }
            this.close(n);
        }
        return this.obj_info.num_attrs > 0L;
    }

    @Override
    public Datatype getDatatype() {
        if (this.datatype == null) {
            this.datatype = new H5Datatype(6, -1, -1, -1);
        }
        return this.datatype;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.attributeList != null) {
            ((Vector)this.attributeList).setSize(0);
        }
    }

    @Override
    public byte[] readBytes() throws HDF5Exception {
        byte[] byArray = null;
        if (this.rank <= 0) {
            this.init();
        }
        int n = this.open();
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        try {
            long[] lArray = new long[]{1L};
            int n5 = 0;
            while (n5 < this.selectedDims.length) {
                lArray[0] = lArray[0] * this.selectedDims[n5];
                ++n5;
            }
            n2 = H5.H5Dget_space(n);
            n3 = H5.H5Screate_simple(this.rank, this.selectedDims, null);
            if ((long)this.rank * this.dims[0] > 1L) {
                H5.H5Sselect_hyperslab(n2, HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
            }
            n4 = H5.H5Dget_type(n);
            n5 = H5.H5Tget_size(n4) * (int)lArray[0];
            byArray = new byte[n5];
            H5.H5Dread(n, n4, n3, n2, HDF5Constants.H5P_DEFAULT, byArray);
        }
        catch (Throwable throwable) {
            try {
                H5.H5Sclose(n2);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose(n3);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose(n4);
            }
            catch (HDF5Exception hDF5Exception) {}
            this.close(n);
            throw throwable;
        }
        try {
            H5.H5Sclose(n2);
        }
        catch (Exception exception) {}
        try {
            H5.H5Sclose(n3);
        }
        catch (Exception exception) {}
        try {
            H5.H5Tclose(n4);
        }
        catch (HDF5Exception hDF5Exception) {}
        this.close(n);
        return byArray;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object read() throws HDF5Exception {
        block63: {
            var1_1 = null;
            var2_2 = null;
            var3_3 = null;
            var4_4 = -1;
            var5_5 = -1;
            var6_6 = -1;
            var7_7 = 0;
            var8_8 = new int[]{-1, -1};
            if (this.rank <= 0) {
                this.init();
            }
            if (this.numberOfMembers <= 0) {
                return null;
            }
            if (this.isExternal) {
                var9_9 = this.getFileFormat().getAbsoluteFile().getParent();
                if (var9_9 == null) {
                    var9_9 = ".";
                }
                H5.H5Dchdir_ext(var9_9);
            }
            var9_10 = this.open();
            var1_1 = new Vector<Object>(this.flatNameList.size());
            var10_11 = new Vector<E>();
            try {
                var11_12 = new long[]{1L};
                var11_12[0] = this.selectHyperslab(var9_10, var8_8);
                var12_13 = this.flatNameList.size();
                var4_4 = H5.H5Dget_type(var9_10);
                this.extractCompoundInfo(var4_4, null, null, var10_11);
                var13_14 = 0;
                while (var13_14 < var12_13) {
                    block64: {
                        var14_15 = false;
                        if (this.isMemberSelected[var13_14]) {
                            block62: {
                                var3_3 = new String(this.memberNames[var13_14]);
                                var5_5 = (Integer)var10_11.get(var13_14);
                                try {
                                    var6_6 = H5.H5Tget_class(var5_5);
                                    var7_7 = H5.H5Tget_size(var5_5);
                                    var2_2 = H5Datatype.allocateArray(var5_5, (int)var11_12[0]);
                                }
                                catch (Exception v0) {
                                    var2_2 = null;
                                }
                                if (var2_2 == null || H5.H5Tequal(var5_5, HDF5Constants.H5T_STD_REF_DSETREG)) {
                                    var15_16 = new String[(int)var11_12[0]];
                                    var16_19 = "*unsupported*";
                                    var17_20 = 0;
                                    while ((long)var17_20 < var11_12[0]) {
                                        var15_16[var17_20] = var16_19;
                                        ++var17_20;
                                    }
                                    var1_1.add(var15_16);
                                } else {
                                    if (var6_6 == HDF5Constants.H5T_ARRAY) {
                                        var15_17 = H5.H5Tget_super(var5_5);
                                        var14_15 = H5.H5Tis_variable_str(var15_17);
                                        var6_6 = H5.H5Tget_class(var15_17);
                                        try {
                                            H5.H5Tclose(var15_17);
                                        }
                                        catch (Exception v1) {}
                                    }
                                    var15_18 = -1;
                                    v2 = new int[3];
                                    v2[0] = var6_6;
                                    v2[1] = var7_7;
                                    var16_19 = v2;
                                    try {
                                        var15_18 = this.createCompoundFieldType(var5_5, var3_3, (int[])var16_19);
                                        try {
                                            var14_15 = var14_15 != false || H5.H5Tis_variable_str(var5_5) != false;
                                            var14_15 = var14_15 != false || H5.H5Tdetect_class(var5_5, HDF5Constants.H5T_VLEN) != false;
                                        }
                                        catch (Exception v3) {}
                                        if (var14_15) {
                                            H5.H5DreadVL(var9_10, var15_18, var8_8[0], var8_8[1], HDF5Constants.H5P_DEFAULT, var2_2);
                                        } else {
                                            H5.H5Dread(var9_10, var15_18, var8_8[0], var8_8[1], HDF5Constants.H5P_DEFAULT, var2_2);
                                        }
                                        break block62;
                                    }
                                    catch (HDF5Exception v4) {
                                        var17_21 = new String[(int)var11_12[0]];
                                        var18_23 = 0;
                                        ** while ((long)var18_23 < var11_12[0])
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        var17_21[var18_23] = "";
                                        ++var18_23;
                                        continue;
                                    }
lbl88:
                                    // 1 sources

                                    var1_1.add(var17_21);
                                    try {
                                        H5.H5Tclose(var15_18);
                                    }
                                    catch (Exception v5) {}
                                }
                                break block64;
                                catch (Throwable var19_25) {
                                    try {
                                        H5.H5Tclose(var15_18);
                                    }
                                    catch (Exception v6) {}
                                    throw var19_25;
                                }
                            }
                            try {
                                H5.H5Tclose(var15_18);
                            }
                            catch (Exception v7) {}
                            if (!var14_15) {
                                var17_22 = var2_2.getClass().getName();
                                var18_23 = var17_22.charAt(var17_22.lastIndexOf("[") + 1);
                                if (var6_6 == HDF5Constants.H5T_STRING && this.convertByteToString) {
                                    if (var18_23 == 66) {
                                        var2_2 = H5CompoundDS.byteToString((byte[])var2_2, var7_7 / this.memberOrders[var13_14]);
                                    }
                                } else if (var6_6 == HDF5Constants.H5T_REFERENCE) {
                                    if (var18_23 == 66) {
                                        var2_2 = (String[])HDFNativeData.byteToLong((byte[])var2_2);
                                    }
                                } else if (var16_19[2] != false) {
                                    var2_2 = Dataset.convertFromUnsignedC(var2_2, null);
                                } else if (var6_6 == HDF5Constants.H5T_ENUM && this.enumConverted) {
                                    try {
                                        var19_24 = H5Datatype.convertEnumValueToName(var5_5, var2_2, null);
                                        if (var19_24 != null) {
                                            var2_2 = var19_24;
                                        }
                                    }
                                    catch (Exception v8) {}
                                }
                            }
                            var1_1.add(var2_2);
                        }
                    }
                    ++var13_14;
                }
                break block63;
            }
            catch (Throwable var20_26) {
                try {
                    H5.H5Sclose(var8_8[0]);
                }
                catch (Exception v9) {}
                try {
                    H5.H5Sclose(var8_8[1]);
                }
                catch (Exception v10) {}
                try {
                    H5.H5Tclose(var4_4);
                }
                catch (Exception v11) {}
                var21_27 = var10_11.size();
                var22_29 = 0;
                ** while (var22_29 < var21_27)
            }
lbl-1000:
            // 1 sources

            {
                var5_5 = (Integer)var10_11.get(var22_29);
                try {
                    H5.H5Tclose(var5_5);
                }
                catch (Exception v12) {}
                ++var22_29;
                continue;
            }
lbl163:
            // 1 sources

            this.close(var9_10);
            throw var20_26;
        }
        try {
            H5.H5Sclose(var8_8[0]);
        }
        catch (Exception v13) {}
        try {
            H5.H5Sclose(var8_8[1]);
        }
        catch (Exception v14) {}
        try {
            H5.H5Tclose(var4_4);
        }
        catch (Exception v15) {}
        var21_28 = var10_11.size();
        var22_30 = 0;
        while (var22_30 < var21_28) {
            var5_5 = (Integer)var10_11.get(var22_30);
            try {
                H5.H5Tclose(var5_5);
            }
            catch (Exception v16) {}
            ++var22_30;
        }
        this.close(var9_10);
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void write(Object var1_1) throws HDF5Exception {
        block41: {
            if (var1_1 == null || this.numberOfMembers <= 0 || !(var1_1 instanceof List)) {
                return;
            }
            var2_2 = (List)var1_1;
            var3_3 = null;
            var4_4 = null;
            var5_5 = -1;
            var6_6 = -1;
            var7_7 = -1;
            var8_8 = 0;
            var9_9 = new int[]{-1, -1};
            var10_10 = this.open();
            var11_11 = new Vector<E>();
            try {
                var12_12 = new long[]{1L};
                var12_12[0] = this.selectHyperslab(var10_10, var9_9);
                var13_13 = 0;
                var14_14 = this.flatNameList.size();
                var15_15 = false;
                var5_5 = H5.H5Dget_type(var10_10);
                this.extractCompoundInfo(var5_5, null, null, var11_11);
                var16_16 = 0;
                while (var16_16 < var14_14) {
                    if (this.isMemberSelected[var16_16]) {
                        var4_4 = new String(this.memberNames[var16_16]);
                        var6_6 = (Integer)var11_11.get(var16_16);
                        if ((var3_3 = (Object)var2_2.get(var13_13++)) != null) {
                            var17_17 = false;
                            try {
                                var17_17 = H5.H5Tdetect_class(var6_6, HDF5Constants.H5T_VLEN);
                            }
                            catch (Exception v0) {}
                            if (!var17_17) {
                                try {
                                    var7_7 = H5.H5Tget_class(var6_6);
                                    var8_8 = H5.H5Tget_size(var6_6);
                                    var15_15 = var7_7 == HDF5Constants.H5T_ENUM;
                                }
                                catch (Exception v1) {}
                                var18_18 = var3_3;
                                var19_19 = -1;
                                v2 = new int[3];
                                v2[0] = var7_7;
                                v2[1] = var8_8;
                                var20_20 = v2;
                                try {
                                    var19_19 = this.createCompoundFieldType(var6_6, var4_4, var20_20);
                                    if (var20_20[2] != 0) {
                                        var18_18 = H5CompoundDS.convertToUnsignedC(var3_3, null);
                                    } else if (var7_7 == HDF5Constants.H5T_STRING && Array.get(var3_3, 0) instanceof String) {
                                        var18_18 = H5CompoundDS.stringToByte((String[])var3_3, var8_8);
                                    } else if (var15_15 && Array.get(var3_3, 0) instanceof String) {
                                        var18_18 = H5Datatype.convertEnumNameToValue(var6_6, (String[])var3_3, null);
                                    }
                                    if (var18_18 != null) {
                                        H5.H5Dwrite(var10_10, var19_19, var9_9[0], var9_9[1], HDF5Constants.H5P_DEFAULT, var18_18);
                                    }
                                }
                                catch (Throwable var21_21) {
                                    try {
                                        H5.H5Tclose(var19_19);
                                    }
                                    catch (Exception v3) {}
                                    throw var21_21;
                                }
                                try {
                                    H5.H5Tclose(var19_19);
                                }
                                catch (Exception v4) {}
                            }
                        }
                    }
                    ++var16_16;
                }
                break block41;
            }
            catch (Throwable var22_22) {
                try {
                    H5.H5Sclose(var9_9[0]);
                }
                catch (Exception v5) {}
                try {
                    H5.H5Sclose(var9_9[1]);
                }
                catch (Exception v6) {}
                try {
                    H5.H5Tclose(var5_5);
                }
                catch (Exception v7) {}
                var23_23 = var11_11.size();
                var24_25 = 0;
                ** while (var24_25 < var23_23)
            }
lbl-1000:
            // 1 sources

            {
                var6_6 = (Integer)var11_11.get(var24_25);
                try {
                    H5.H5Tclose(var6_6);
                }
                catch (Exception v8) {}
                ++var24_25;
                continue;
            }
lbl101:
            // 1 sources

            throw var22_22;
        }
        try {
            H5.H5Sclose(var9_9[0]);
        }
        catch (Exception v9) {}
        try {
            H5.H5Sclose(var9_9[1]);
        }
        catch (Exception v10) {}
        try {
            H5.H5Tclose(var5_5);
        }
        catch (Exception v11) {}
        var23_24 = var11_11.size();
        var24_26 = 0;
        while (var24_26 < var23_24) {
            var6_6 = (Integer)var11_11.get(var24_26);
            try {
                H5.H5Tclose(var6_6);
            }
            catch (Exception v12) {}
            ++var24_26;
        }
        this.close(var10_10);
    }

    private long selectHyperslab(int n, int[] nArray) throws HDF5Exception {
        long l = 1L;
        boolean bl = true;
        int n2 = 0;
        while (n2 < this.rank) {
            l *= this.selectedDims[n2];
            if (this.selectedDims[n2] < this.dims[n2]) {
                bl = false;
            }
            ++n2;
        }
        if (bl) {
            nArray[0] = HDF5Constants.H5S_ALL;
            nArray[1] = HDF5Constants.H5S_ALL;
        } else {
            nArray[1] = H5.H5Dget_space(n);
            nArray[0] = H5.H5Screate_simple(this.rank, this.selectedDims, null);
            H5.H5Sselect_hyperslab(nArray[1], HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
        }
        return l;
    }

    @Override
    public List getMetadata() throws HDF5Exception {
        return this.getMetadata(HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_INC);
    }

    public List getMetadata(int ... nArray) throws HDF5Exception {
        if (this.rank <= 0) {
            this.init();
        }
        try {
            this.linkTargetObjName = H5File.getLinkTargetName(this);
        }
        catch (Exception exception) {}
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int n = -1;
        int n2 = -1;
        int n3 = HDF5Constants.H5_INDEX_NAME;
        int n4 = HDF5Constants.H5_ITER_INC;
        if (nArray.length > 0) {
            n3 = nArray[0];
            if (nArray.length > 1) {
                n4 = nArray[1];
            }
        }
        try {
            n = this.open();
            this.attributeList = H5File.getAttribute(n, n3, n4);
            n2 = H5.H5Dget_create_plist(n);
            if (H5.H5Pget_layout(n2) == HDF5Constants.H5D_CHUNKED) {
                this.chunkSize = new long[this.rank];
                H5.H5Pget_chunk(n2, this.rank, this.chunkSize);
            } else {
                this.chunkSize = null;
            }
            int[] nArray2 = new int[2];
            int[] nArray3 = new int[]{2};
            int[] nArray4 = new int[2];
            String[] stringArray = new String[]{"", ""};
            int n5 = H5.H5Pget_nfilters(n2);
            int n6 = -1;
            int[] nArray5 = new int[]{1};
            this.compression = "";
            int n7 = 0;
            while (n7 < n5) {
                block38: {
                    if (n7 > 0) {
                        this.compression = String.valueOf(this.compression) + ", ";
                    }
                    try {
                        n6 = H5.H5Pget_filter(n2, n7, nArray2, nArray3, nArray4, 120, stringArray, nArray5);
                    }
                    catch (Throwable throwable) {
                        this.compression = String.valueOf(this.compression) + "ERROR";
                        break block38;
                    }
                    if (n6 == HDF5Constants.H5Z_FILTER_DEFLATE) {
                        this.compression = String.valueOf(this.compression) + "GZIP: level = " + nArray4[0];
                    } else if (n6 == HDF5Constants.H5Z_FILTER_FLETCHER32) {
                        this.compression = String.valueOf(this.compression) + "Error detection filter";
                    } else if (n6 == HDF5Constants.H5Z_FILTER_SHUFFLE) {
                        this.compression = String.valueOf(this.compression) + "SHUFFLE: Nbytes = " + nArray4[0];
                    } else if (n6 == HDF5Constants.H5Z_FILTER_SZIP) {
                        this.compression = String.valueOf(this.compression) + "SZIP: Pixels per block = " + nArray4[1];
                        int n8 = -1;
                        try {
                            n8 = H5.H5Zget_filter_info(n6);
                        }
                        catch (Exception exception) {
                            n8 = -1;
                        }
                        if (n8 == HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) {
                            this.compression = String.valueOf(this.compression) + ": H5Z_FILTER_CONFIG_DECODE_ENABLED";
                        } else if (n8 == HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED || n8 >= HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED + HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) {
                            this.compression = String.valueOf(this.compression) + ": H5Z_FILTER_CONFIG_ENCODE_ENABLED";
                        }
                    }
                }
                ++n7;
            }
            if (this.compression.length() == 0) {
                this.compression = "NONE";
            }
            try {
                int[] nArray6 = new int[1];
                H5.H5Pget_alloc_time(n2, nArray6);
                this.compression = String.valueOf(this.compression) + ",         Storage allocation time: ";
                if (nArray6[0] == HDF5Constants.H5D_ALLOC_TIME_EARLY) {
                    this.compression = String.valueOf(this.compression) + "Early";
                } else if (nArray6[0] == HDF5Constants.H5D_ALLOC_TIME_INCR) {
                    this.compression = String.valueOf(this.compression) + "Incremental";
                } else if (nArray6[0] == HDF5Constants.H5D_ALLOC_TIME_LATE) {
                    this.compression = String.valueOf(this.compression) + "Late";
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            try {
                H5.H5Pclose(n2);
            }
            catch (Exception exception) {}
            this.close(n);
            throw throwable;
        }
        try {
            H5.H5Pclose(n2);
        }
        catch (Exception exception) {}
        this.close(n);
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        boolean bl = false;
        Attribute attribute = (Attribute)object;
        attribute.getName();
        if (this.attributeList == null) {
            this.getMetadata();
        }
        if (this.attributeList != null) {
            bl = this.attributeList.contains(attribute);
        }
        this.getFileFormat().writeAttribute(this, attribute, bl);
        if (!bl) {
            this.attributeList.add(attribute);
            this.nAttributes = this.attributeList.size();
        }
    }

    @Override
    public void removeMetadata(Object object) throws HDF5Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        Attribute attribute = (Attribute)object;
        int n = this.open();
        try {
            H5.H5Adelete(n, attribute.getName());
            List list = this.getMetadata();
            list.remove(attribute);
            this.nAttributes = list.size();
        }
        finally {
            this.close(n);
        }
    }

    @Override
    public int open() {
        int n = -1;
        try {
            n = H5.H5Dopen(this.getFID(), String.valueOf(this.getPath()) + this.getName(), HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5Exception hDF5Exception) {
            n = -1;
        }
        return n;
    }

    @Override
    public void close(int n) {
        try {
            H5.H5Fflush(n, HDF5Constants.H5F_SCOPE_LOCAL);
        }
        catch (Exception exception) {}
        try {
            H5.H5Dclose(n);
        }
        catch (HDF5Exception hDF5Exception) {}
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void init() {
        block52: {
            block51: {
                block53: {
                    block50: {
                        if (this.rank > 0) {
                            this.resetSelection();
                            return;
                        }
                        var1_1 = -1;
                        var2_2 = -1;
                        var3_3 = -1;
                        var4_4 = -1;
                        String.valueOf(this.getPath()) + this.getName();
                        this.flatNameList = new Vector<E>();
                        this.flatTypeList = new Vector<E>();
                        var5_5 = null;
                        var1_1 = this.open();
                        var6_6 = -1;
                        try {
                            try {
                                var6_6 = H5.H5Dget_create_plist(var1_1);
                                var7_7 = H5.H5Pget_external_count(var6_6);
                                this.isExternal = var7_7 > 0;
                            }
                            catch (Exception v0) {
                                try {
                                    H5.H5Pclose(var6_6);
                                }
                                catch (Exception v1) {}
                                break block50;
                            }
                        }
                        catch (Throwable var8_8) {
                            try {
                                H5.H5Pclose(var6_6);
                            }
                            catch (Exception v2) {}
                            throw var8_8;
                        }
                        try {
                            H5.H5Pclose(var6_6);
                        }
                        catch (Exception v3) {}
                    }
                    try {
                        try {
                            var2_2 = H5.H5Dget_space(var1_1);
                            this.rank = H5.H5Sget_simple_extent_ndims(var2_2);
                            if (this.rank == 0) {
                                this.rank = 1;
                                this.dims = new long[1];
                                this.dims[0] = 1L;
                            } else {
                                this.dims = new long[this.rank];
                                this.maxDims = new long[this.rank];
                                H5.H5Sget_simple_extent_dims(var2_2, this.dims, this.maxDims);
                            }
                            this.startDims = new long[this.rank];
                            this.selectedDims = new long[this.rank];
                            var3_3 = H5.H5Dget_type(var1_1);
                            var4_4 = H5.H5Tget_class(var3_3);
                            var7_7 = 0;
                            if (var4_4 == HDF5Constants.H5T_ARRAY) {
                                var7_7 = var3_3;
                                var3_3 = H5.H5Tget_super(var7_7);
                                try {
                                    H5.H5Tclose(var7_7);
                                }
                                catch (HDF5Exception v4) {}
                            }
                            this.extractCompoundInfo(var3_3, "", this.flatNameList, this.flatTypeList);
                            this.numberOfMembers = this.flatNameList.size();
                            this.memberNames = new String[this.numberOfMembers];
                            var5_5 = new int[this.numberOfMembers];
                            this.memberTypes = new Datatype[this.numberOfMembers];
                            this.memberOrders = new int[this.numberOfMembers];
                            this.isMemberSelected = new boolean[this.numberOfMembers];
                            this.memberDims = new Object[this.numberOfMembers];
                            var8_9 = 0;
                            while (var8_9 < this.numberOfMembers) {
                                this.isMemberSelected[var8_9] = true;
                                var5_5[var8_9] = (Integer)this.flatTypeList.get(var8_9);
                                this.memberTypes[var8_9] = new H5Datatype(var5_5[var8_9]);
                                this.memberNames[var8_9] = (String)this.flatNameList.get(var8_9);
                                this.memberOrders[var8_9] = 1;
                                this.memberDims[var8_9] = null;
                                try {
                                    var4_4 = H5.H5Tget_class(var5_5[var8_9]);
                                }
                                catch (HDF5Exception v5) {}
                                if (var4_4 == HDF5Constants.H5T_ARRAY) {
                                    var9_10 = H5.H5Tget_array_ndims(var5_5[var8_9]);
                                    var10_11 = new long[var9_10];
                                    H5.H5Tget_array_dims(var5_5[var8_9], var10_11);
                                    var11_12 = new int[var9_10];
                                    var12_13 = 0;
                                    while (var12_13 < var9_10) {
                                        var11_12[var12_13] = (int)var10_11[var12_13];
                                        ++var12_13;
                                    }
                                    this.memberDims[var8_9] = var11_12;
                                    var7_7 = H5.H5Tget_super(var5_5[var8_9]);
                                    this.memberOrders[var8_9] = H5.H5Tget_size(var5_5[var8_9]) / H5.H5Tget_size(var7_7);
                                    try {
                                        H5.H5Tclose(var7_7);
                                    }
                                    catch (HDF5Exception v6) {}
                                }
                                ++var8_9;
                            }
                            break block51;
                        }
                        catch (HDF5Exception v7) {
                            this.numberOfMembers = 0;
                            this.memberNames = null;
                            this.memberTypes = null;
                            this.memberOrders = null;
                            try {
                                H5.H5Tclose(var3_3);
                            }
                            catch (HDF5Exception v8) {}
                            try {
                                H5.H5Sclose(var2_2);
                            }
                            catch (HDF5Exception v9) {}
                            if (var5_5 == null) break block52;
                            var14_14 = 0;
                            ** while (var14_14 < var5_5.length)
                        }
                    }
                    catch (Throwable var13_17) {
                        try {
                            H5.H5Tclose(var3_3);
                        }
                        catch (HDF5Exception v11) {}
                        try {
                            H5.H5Sclose(var2_2);
                        }
                        catch (HDF5Exception v12) {}
                        if (var5_5 == null) break block53;
                        var14_15 = 0;
                        ** while (var14_15 < var5_5.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            H5.H5Tclose(var5_5[var14_14]);
                        }
                        catch (Exception v10) {}
                        ++var14_14;
                        continue;
lbl135:
                        // 1 sources

                        break block52;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            H5.H5Tclose(var5_5[var14_15]);
                        }
                        catch (Exception v13) {}
                        ++var14_15;
                        continue;
                    }
                }
                throw var13_17;
            }
            try {
                H5.H5Tclose(var3_3);
            }
            catch (HDF5Exception v14) {}
            try {
                H5.H5Sclose(var2_2);
            }
            catch (HDF5Exception v15) {}
            if (var5_5 != null) {
                var14_16 = 0;
                while (var14_16 < var5_5.length) {
                    try {
                        H5.H5Tclose(var5_5[var14_16]);
                    }
                    catch (Exception v16) {}
                    ++var14_16;
                }
            }
        }
        this.close(var1_1);
        this.resetSelection();
    }

    @Override
    public void setName(String string) throws Exception {
        String string2 = String.valueOf(this.getPath()) + this.getName();
        String string3 = String.valueOf(this.getPath()) + string;
        string2 = string2.replaceAll("//", "/");
        string3 = string3.replaceAll("//", "/");
        if (string2.equals("/")) {
            throw new HDF5Exception("Can't rename the root group.");
        }
        if (string2.equals(string3)) {
            throw new HDF5Exception("The new name is the same as the current name.");
        }
        H5.H5Lmove(this.getFID(), string2, this.getFID(), string3, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        super.setName(string);
    }

    private void resetSelection() {
        int n = 0;
        while (n < this.rank) {
            this.startDims[n] = 0L;
            this.selectedDims[n] = 1L;
            if (this.selectedStride != null) {
                this.selectedStride[n] = 1L;
            }
            ++n;
        }
        if (this.rank == 1) {
            this.selectedIndex[0] = 0;
            this.selectedDims[0] = this.dims[0];
        } else if (this.rank == 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        } else if (this.rank > 2) {
            this.selectedIndex[0] = this.rank - 2;
            this.selectedIndex[1] = this.rank - 1;
            this.selectedIndex[2] = this.rank - 3;
            this.selectedDims[this.rank - 1] = this.dims[this.rank - 1];
            this.selectedDims[this.rank - 2] = this.dims[this.rank - 2];
        }
        this.isDataLoaded = false;
        this.setMemberSelection(true);
    }

    /*
     * Loose catch block
     */
    private void extractCompoundInfo(int n, String string, List list, List list2) {
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        String string2 = null;
        try {
            n2 = H5.H5Tget_nmembers(n);
        }
        catch (Exception exception) {
            n2 = 0;
        }
        if (n2 <= 0) {
            return;
        }
        int n5 = -1;
        int n6 = 0;
        while (n6 < n2) {
            block32: {
                block36: {
                    block34: {
                        block35: {
                            try {
                                n4 = H5.H5Tget_member_type(n, n6);
                            }
                            catch (Exception exception) {
                                break block32;
                            }
                            try {
                                try {
                                    n5 = n4;
                                    n4 = H5.H5Tget_native_type(n5);
                                }
                                catch (HDF5Exception hDF5Exception) {
                                    try {
                                        H5.H5Tclose(n5);
                                    }
                                    catch (HDF5Exception hDF5Exception2) {}
                                    break block32;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    H5.H5Tclose(n5);
                                }
                                catch (HDF5Exception hDF5Exception) {}
                                throw throwable;
                            }
                            try {
                                H5.H5Tclose(n5);
                            }
                            catch (HDF5Exception hDF5Exception) {}
                            try {
                                n3 = H5.H5Tget_class(n4);
                            }
                            catch (HDF5Exception hDF5Exception) {
                                break block32;
                            }
                            if (list != null) {
                                string2 = String.valueOf(string) + H5.H5Tget_member_name(n, n6);
                            }
                            if (n3 != HDF5Constants.H5T_COMPOUND) break block35;
                            this.extractCompoundInfo(n4, String.valueOf(string2) + "\u0095", list, list2);
                            break block32;
                        }
                        if (n3 != HDF5Constants.H5T_ARRAY) break block36;
                        n5 = H5.H5Tget_super(n4);
                        int n7 = H5.H5Tget_class(n5);
                        if (n7 != HDF5Constants.H5T_COMPOUND && n7 != HDF5Constants.H5T_ARRAY) break block34;
                        try {
                            H5.H5Tclose(n5);
                        }
                        catch (Exception exception) {}
                        break block32;
                        catch (Exception exception) {
                            try {}
                            catch (Throwable throwable) {
                                try {
                                    H5.H5Tclose(n5);
                                }
                                catch (Exception exception2) {}
                                throw throwable;
                            }
                            try {
                                H5.H5Tclose(n5);
                            }
                            catch (Exception exception3) {}
                            break block32;
                        }
                    }
                    try {
                        H5.H5Tclose(n5);
                    }
                    catch (Exception exception) {}
                }
                if (list != null) {
                    list.add(string2);
                }
                list2.add(new Integer(n4));
            }
            ++n6;
        }
    }

    @Deprecated
    public static Dataset create(String string, Group group, long[] lArray, String[] stringArray, Datatype[] datatypeArray, int[] nArray, Object object) throws Exception {
        if (group == null || string == null || lArray == null || stringArray == null || datatypeArray == null || nArray == null) {
            return null;
        }
        int n = stringArray.length;
        int[] nArray2 = new int[n];
        long[][] lArray2 = new long[n][1];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = 1;
            lArray2[n2][0] = nArray[n2];
            ++n2;
        }
        return H5CompoundDS.create(string, group, lArray, stringArray, datatypeArray, nArray2, lArray2, object);
    }

    @Deprecated
    public static Dataset create(String string, Group group, long[] lArray, String[] stringArray, Datatype[] datatypeArray, int[] nArray, long[][] lArray2, Object object) throws Exception {
        return H5CompoundDS.create(string, group, lArray, null, null, -1, stringArray, datatypeArray, nArray, lArray2, object);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset create(String var0, Group var1_1, long[] var2_2, long[] var3_3, long[] var4_4, int var5_5, String[] var6_6, Datatype[] var7_7, int[] var8_8, long[][] var9_9, Object var10_10) throws Exception {
        block52: {
            var11_11 = null;
            var12_12 = null;
            var13_13 = -1;
            var14_14 = -1;
            var15_15 = -1;
            var16_16 = -1;
            if (var1_1 == null || var0 == null || var2_2 == null || var6_6 == null || var7_7 == null || var8_8 == null || var9_9 == null) {
                return null;
            }
            var17_17 = (H5File)var1_1.getFileFormat();
            if (var17_17 == null) {
                return null;
            }
            var18_18 = "/";
            if (!var1_1.isRoot()) {
                var18_18 = String.valueOf(var1_1.getPath()) + var1_1.getName() + "/";
                if (var0.endsWith("/")) {
                    var0 = var0.substring(0, var0.length() - 1);
                }
                if ((var19_19 = var0.lastIndexOf("/")) >= 0) {
                    var0 = var0.substring(var19_19 + 1);
                }
            }
            var12_12 = String.valueOf(var18_18) + var0;
            var19_19 = 0;
            var20_20 = var6_6.length;
            var21_21 = new int[var20_20];
            var22_22 = 1;
            var23_23 = var2_2.length;
            var24_24 = 0;
            while (var24_24 < var20_20) {
                var22_22 = 1;
                var25_26 = 0;
                while (var25_26 < var8_8[var24_24]) {
                    var22_22 = (int)((long)var22_22 * var9_9[var24_24][var25_26]);
                    ++var25_26;
                }
                if (var22_22 > 1 && var7_7[var24_24].getDatatypeClass() != 3) {
                    var25_26 = -1;
                    try {
                        var25_26 = var7_7[var24_24].toNative();
                        var21_21[var24_24] = H5.H5Tarray_create(var25_26, var8_8[var24_24], var9_9[var24_24]);
                    }
                    catch (Throwable var26_27) {
                        try {
                            H5.H5Tclose(var25_26);
                        }
                        catch (Exception v0) {}
                        throw var26_27;
                    }
                    try {
                        H5.H5Tclose(var25_26);
                    }
                    catch (Exception v1) {}
                } else {
                    var21_21[var24_24] = var7_7[var24_24].toNative();
                }
                var19_19 += H5.H5Tget_size(var21_21[var24_24]);
                ++var24_24;
            }
            try {
                var15_15 = H5.H5Tcreate(HDF5Constants.H5T_COMPOUND, var19_19);
                var24_24 = 0;
                var25_26 = 0;
                while (var25_26 < var20_20) {
                    H5.H5Tinsert(var15_15, var6_6[var25_26], var24_24, var21_21[var25_26]);
                    var24_24 += H5.H5Tget_size(var21_21[var25_26]);
                    ++var25_26;
                }
                var14_14 = H5.H5Screate_simple(var23_23, var2_2, var3_3);
                var25_26 = 0;
                if (var3_3 != null) {
                    var26_28 = 0;
                    while (var26_28 < var3_3.length) {
                        if (var3_3[var26_28] == 0L) {
                            var3_3[var26_28] = var2_2[var26_28];
                        } else if (var3_3[var26_28] < 0L) {
                            var3_3[var26_28] = HDF5Constants.H5S_UNLIMITED;
                        }
                        if (var3_3[var26_28] != var2_2[var26_28]) {
                            var25_26 = 1;
                        }
                        ++var26_28;
                    }
                }
                if (var4_4 == null && var25_26 != 0) {
                    var4_4 = var2_2;
                }
                var16_16 = HDF5Constants.H5P_DEFAULT;
                if (var4_4 != null) {
                    var16_16 = H5.H5Pcreate(HDF5Constants.H5P_DATASET_CREATE);
                    H5.H5Pset_layout(var16_16, HDF5Constants.H5D_CHUNKED);
                    H5.H5Pset_chunk(var16_16, var23_23, var4_4);
                    if (var5_5 > 0) {
                        H5.H5Pset_deflate(var16_16, var5_5);
                    }
                }
                var26_28 = var17_17.getFID();
                var13_13 = H5.H5Dcreate(var26_28, var12_12, var15_15, var14_14, HDF5Constants.H5P_DEFAULT, var16_16, HDF5Constants.H5P_DEFAULT);
                break block52;
            }
            catch (Throwable var27_29) {
                try {
                    H5.H5Pclose(var16_16);
                }
                catch (HDF5Exception v2) {}
                try {
                    H5.H5Sclose(var14_14);
                }
                catch (HDF5Exception v3) {}
                try {
                    H5.H5Tclose(var15_15);
                }
                catch (HDF5Exception v4) {}
                try {
                    H5.H5Dclose(var13_13);
                }
                catch (HDF5Exception v5) {}
                var28_30 = 0;
                ** while (var28_30 < var20_20)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    H5.H5Tclose(var21_21[var28_30]);
                }
                catch (HDF5Exception v6) {}
                ++var28_30;
                continue;
            }
lbl125:
            // 1 sources

            throw var27_29;
        }
        try {
            H5.H5Pclose(var16_16);
        }
        catch (HDF5Exception v7) {}
        try {
            H5.H5Sclose(var14_14);
        }
        catch (HDF5Exception v8) {}
        try {
            H5.H5Tclose(var15_15);
        }
        catch (HDF5Exception v9) {}
        try {
            H5.H5Dclose(var13_13);
        }
        catch (HDF5Exception v10) {}
        var28_31 = 0;
        while (var28_31 < var20_20) {
            try {
                H5.H5Tclose(var21_21[var28_31]);
            }
            catch (HDF5Exception v11) {}
            ++var28_31;
        }
        var11_11 = new H5CompoundDS(var17_17, var0, var18_18);
        if (var11_11 != null) {
            var1_1.addToMemberList(var11_11);
            if (var10_10 != null) {
                var11_11.init();
                var24_25 = var11_11.getSelectedDims();
                var25_26 = 0;
                while (var25_26 < var23_23) {
                    var24_25[var25_26] = var2_2[var25_26];
                    ++var25_26;
                }
                var11_11.write(var10_10);
            }
        }
        return var11_11;
    }

    @Override
    public boolean isString(int n) {
        boolean bl = false;
        try {
            bl = HDF5Constants.H5T_STRING == H5.H5Tget_class(n);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    @Override
    public int getSize(int n) {
        int n2 = -1;
        try {
            n2 = H5.H5Tget_size(n);
        }
        catch (Exception exception) {
            n2 = -1;
        }
        return n2;
    }

    private final int createCompoundFieldType(int n, String string, int[] nArray) throws HDF5Exception {
        int n2;
        int n3 = -1;
        int n4 = n2 = n;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        try {
            int n9 = nArray[0];
            int n10 = nArray[1];
            if (n9 == HDF5Constants.H5T_ARRAY) {
                int n11 = H5.H5Tget_array_ndims(n);
                long[] lArray = new long[n11];
                H5.H5Tget_array_dims(n, lArray);
                n6 = n4 = H5.H5Tget_super(n);
                n8 = H5.H5Tget_native_type(n4);
                n7 = n2 = H5.H5Tarray_create(n8, n11, lArray);
            }
            try {
                if (H5Datatype.isUnsigned(n4)) {
                    nArray[2] = 1;
                }
            }
            catch (Exception exception) {}
            n10 = H5.H5Tget_size(n);
            String string2 = string;
            n5 = H5.H5Tcopy(n2);
            int n12 = string.lastIndexOf("\u0095");
            while (n12 > 0) {
                string2 = string.substring(n12 + 1);
                n3 = H5.H5Tcreate(HDF5Constants.H5T_COMPOUND, n10);
                H5.H5Tinsert(n3, string2, 0L, n5);
                try {
                    H5.H5Tclose(n5);
                }
                catch (Exception exception) {}
                n5 = n3;
                string = string.substring(0, n12);
                n12 = string.lastIndexOf("\u0095");
            }
            n3 = H5.H5Tcreate(HDF5Constants.H5T_COMPOUND, n10);
            H5.H5Tinsert(n3, string, 0L, n5);
        }
        catch (Throwable throwable) {
            try {
                H5.H5Tclose(n5);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Tclose(n6);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Tclose(n7);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Tclose(n8);
            }
            catch (HDF5Exception hDF5Exception) {}
            throw throwable;
        }
        try {
            H5.H5Tclose(n5);
        }
        catch (HDF5Exception hDF5Exception) {}
        try {
            H5.H5Tclose(n6);
        }
        catch (HDF5Exception hDF5Exception) {}
        try {
            H5.H5Tclose(n7);
        }
        catch (HDF5Exception hDF5Exception) {}
        try {
            H5.H5Tclose(n8);
        }
        catch (HDF5Exception hDF5Exception) {}
        return n3;
    }
}

