/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.h4.H4Datatype;

public class H4Vdata
extends CompoundDS {
    public static final long serialVersionUID = 240L;
    private List attributeList;
    private int numberOfRecords = 0;
    private int[] memberTIDs;
    private int nAttributes = -1;

    public H4Vdata(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    public H4Vdata(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        this.numberOfMembers = 0;
        this.memberOrders = null;
    }

    @Override
    public boolean hasAttribute() {
        if (this.nAttributes < 0) {
            int n = this.open();
            try {
                this.nAttributes = HDFLibrary.VSnattrs(n);
            }
            catch (Exception exception) {
                this.nAttributes = 0;
            }
            this.close(n);
        }
        return this.nAttributes > 0;
    }

    @Override
    public Datatype getDatatype() {
        if (this.datatype == null) {
            this.datatype = new H4Datatype(-1);
        }
        return this.datatype;
    }

    @Override
    public byte[] readBytes() throws HDFException {
        byte[] byArray = null;
        if (this.rank <= 0) {
            this.init();
        }
        if (this.numberOfMembers <= 0) {
            return null;
        }
        int n = this.open();
        if (n < 0) {
            return null;
        }
        String string = this.memberNames[0];
        int n2 = 0;
        while (n2 < this.numberOfMembers) {
            string = String.valueOf(string) + "," + this.memberNames[n2];
            ++n2;
        }
        try {
            HDFLibrary.VSseek(n, (int)this.startDims[0]);
            HDFLibrary.VSsetfields(n, string);
            int[] nArray = new int[1];
            HDFLibrary.VSQueryvsize(n, nArray);
            int n3 = nArray[0] * (int)this.selectedDims[0];
            byArray = new byte[n3];
            HDFLibrary.VSread(n, byArray, (int)this.selectedDims[0], 0);
        }
        finally {
            this.close(n);
        }
        return byArray;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public Object read() throws HDFException {
        var1_1 = null;
        if (this.rank <= 0) {
            this.init();
        }
        if (this.numberOfMembers <= 0) {
            return null;
        }
        var2_2 = this.open();
        if (var2_2 < 0) {
            return null;
        }
        var1_1 = new Vector<String[]>();
        HDFLibrary.HXsetdir(this.getFileFormat().getParent());
        var3_3 /* !! */  = null;
        var4_4 = 0;
        while (var4_4 < this.numberOfMembers) {
            block14: {
                if (this.isMemberSelected[var4_4]) {
                    block15: {
                        try {
                            HDFLibrary.VSseek(var2_2, (int)this.startDims[0]);
                            HDFLibrary.VSsetfields(var2_2, this.memberNames[var4_4]);
                        }
                        catch (HDFException v0) {
                            this.isMemberSelected[var4_4] = false;
                            break block14;
                        }
                        var5_5 = this.memberOrders[var4_4] * (int)this.selectedDims[0];
                        var3_3 /* !! */  = H4Datatype.allocateArray(this.memberTIDs[var4_4], var5_5);
                        if (var3_3 /* !! */  == null) {
                            var6_6 = new String[var5_5];
                            var7_7 = 0;
                            while (var7_7 < var5_5) {
                                var6_6[var7_7] = "*error*";
                                ++var7_7;
                            }
                            var1_1.add(var6_6);
                        } else {
                            try {
                                HDFLibrary.VSread(var2_2, var3_3 /* !! */ , (int)this.selectedDims[0], 0);
                                if (this.memberTIDs[var4_4] == 4 || this.memberTIDs[var4_4] == 3) {
                                    var3_3 /* !! */  = Dataset.byteToString((byte[])var3_3 /* !! */ , this.memberOrders[var4_4]);
                                    this.memberTypes[var4_4] = new H4Datatype(3, this.memberOrders[var4_4], -1, -1);
                                    this.memberOrders[var4_4] = 1;
                                    break block15;
                                }
                                if (!H4Datatype.isUnsigned(this.memberTIDs[var4_4])) break block15;
                                var3_3 /* !! */  = Dataset.convertFromUnsignedC(var3_3 /* !! */ );
                                break block15;
                            }
                            catch (HDFException v1) {
                                var6_6 = new String[var5_5];
                                var7_7 = 0;
                                ** while (var7_7 < var5_5)
                            }
lbl-1000:
                            // 1 sources

                            {
                                var6_6[var7_7] = "*error*";
                                ++var7_7;
                                continue;
                            }
lbl55:
                            // 1 sources

                            var1_1.add(var6_6);
                        }
                        break block14;
                    }
                    var1_1.add(var3_3 /* !! */ );
                }
            }
            ++var4_4;
        }
        this.close(var2_2);
        return var1_1;
    }

    @Override
    public void write(Object object) throws HDFException {
    }

    @Override
    public List getMetadata() throws HDFException {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int n = this.open();
        if (n < 0) {
            return this.attributeList;
        }
        int n2 = 0;
        try {
            n2 = HDFLibrary.VSnattrs(n);
            if (n2 <= 0) {
                List list = this.attributeList;
                return list;
            }
            this.attributeList = new Vector(n2, 5);
            boolean bl = false;
            String[] stringArray = new String[1];
            int[] nArray = new int[3];
            int n3 = 0;
            while (n3 < n2) {
                stringArray[0] = "";
                try {
                    bl = HDFLibrary.VSattrinfo(n, -1, n3, stringArray, nArray);
                    nArray[0] = nArray[0] & 0xFFFFBFFF;
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (bl) {
                    long[] lArray = new long[]{nArray[1]};
                    Attribute attribute = new Attribute(stringArray[0], new H4Datatype(nArray[0]), lArray);
                    this.attributeList.add(attribute);
                    String[] stringArray2 = H4Datatype.allocateArray(nArray[0], nArray[1]);
                    try {
                        HDFLibrary.VSgetattr(n, -1, n3, stringArray2);
                    }
                    catch (HDFException hDFException) {
                        stringArray2 = null;
                    }
                    if (stringArray2 != null) {
                        if (nArray[0] == 4 || nArray[0] == 3) {
                            stringArray2 = Dataset.byteToString((byte[])stringArray2, nArray[1]);
                        }
                        attribute.setValue(stringArray2);
                    }
                }
                ++n3;
            }
        }
        finally {
            this.close(n);
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        this.getFileFormat().writeAttribute(this, (Attribute)object, true);
        if (this.attributeList == null) {
            this.attributeList = new Vector();
        }
        this.attributeList.add(object);
    }

    @Override
    public void removeMetadata(Object object) throws HDFException {
    }

    @Override
    public int open() {
        int n = -1;
        try {
            n = HDFLibrary.VSattach(this.getFID(), (int)this.oid[1], "w");
        }
        catch (HDFException hDFException) {
            n = -1;
        }
        if (n < 0) {
            try {
                n = HDFLibrary.VSattach(this.getFID(), (int)this.oid[1], "r");
            }
            catch (HDFException hDFException) {
                n = -1;
            }
        }
        return n;
    }

    @Override
    public void close(int n) {
        try {
            HDFLibrary.VSdetach(n);
        }
        catch (Exception exception) {}
    }

    @Override
    public void init() {
        if (this.rank > 0) {
            return;
        }
        int n = this.open();
        if (n < 0) {
            return;
        }
        try {
            this.numberOfMembers = HDFLibrary.VFnfields(n);
            this.numberOfRecords = HDFLibrary.VSelts(n);
        }
        catch (HDFException hDFException) {
            this.numberOfMembers = 0;
            this.numberOfRecords = 0;
        }
        this.rank = 1;
        this.dims = new long[1];
        this.dims[0] = this.numberOfRecords;
        this.selectedDims = new long[1];
        this.selectedDims[0] = this.numberOfRecords;
        this.selectedIndex[0] = 0;
        this.startDims = new long[1];
        this.startDims[0] = 0L;
        this.memberNames = new String[this.numberOfMembers];
        this.memberTIDs = new int[this.numberOfMembers];
        this.memberTypes = new Datatype[this.numberOfMembers];
        this.memberOrders = new int[this.numberOfMembers];
        this.isMemberSelected = new boolean[this.numberOfMembers];
        int n2 = 0;
        while (n2 < this.numberOfMembers) {
            this.isMemberSelected[n2] = true;
            try {
                this.memberNames[n2] = HDFLibrary.VFfieldname(n, n2);
                this.memberTIDs[n2] = HDFLibrary.VFfieldtype(n, n2);
                this.memberTypes[n2] = new H4Datatype(this.memberTIDs[n2]);
                this.memberTIDs[n2] = this.memberTIDs[n2] & 0xFFFFBFFF;
                this.memberOrders[n2] = HDFLibrary.VFfieldorder(n, n2);
            }
            catch (HDFException hDFException) {}
            ++n2;
        }
        this.close(n);
    }

    public int getRecordCount() {
        return this.numberOfRecords;
    }

    public int getFieldCount() {
        return this.numberOfMembers;
    }

    public int[] getFieldOrders() {
        return this.memberOrders;
    }

    public List getMetadata(int ... nArray) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

