/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdflib.HDFChunkInfo;
import ncsa.hdf.hdflib.HDFCompInfo;
import ncsa.hdf.hdflib.HDFDeflateCompInfo;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFJPEGCompInfo;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.hdflib.HDFNBITCompInfo;
import ncsa.hdf.hdflib.HDFSKPHUFFCompInfo;
import ncsa.hdf.hdflib.HDFSZIPCompInfo;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.h4.H4Datatype;
import ncsa.hdf.object.h4.H4File;

public class H4SDS
extends ScalarDS {
    public static final long serialVersionUID = 240L;
    public static final int DFTAG_NDG_NETCDF = 67687001;
    private List attributeList;
    private int sdid;
    private int datatypeID = -1;
    private int nAttributes = -1;

    public H4SDS(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    public H4SDS(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        this.unsignedConverted = false;
        this.sdid = ((H4File)this.getFileFormat()).getSDAccessID();
    }

    @Override
    public boolean hasAttribute() {
        if (this.nAttributes < 0) {
            this.sdid = ((H4File)this.getFileFormat()).getSDAccessID();
            int n = this.open();
            try {
                String[] stringArray = new String[]{""};
                int[] nArray = new int[3];
                int[] nArray2 = new int[32];
                HDFLibrary.SDgetinfo(n, stringArray, nArray2, nArray);
                this.nAttributes = nArray[2];
            }
            catch (Exception exception) {
                this.nAttributes = 0;
            }
            this.close(n);
        }
        return this.nAttributes > 0;
    }

    @Override
    public byte[][] readPalette(int n) {
        return null;
    }

    @Override
    public byte[] getPaletteRefs() {
        return null;
    }

    @Override
    public Datatype getDatatype() {
        if (this.datatype == null) {
            this.datatype = new H4Datatype(this.datatypeID);
        }
        return this.datatype;
    }

    @Override
    public Dataset copy(Group group, String string, long[] lArray, Object object) throws Exception {
        H4SDS h4SDS = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 1;
        int n5 = 2;
        String string2 = null;
        int[] nArray = null;
        int[] nArray2 = null;
        if (group == null) {
            return null;
        }
        if (string == null) {
            string = this.getName();
        }
        string2 = group.isRoot() ? "/" : String.valueOf(group.getPath()) + group.getName() + "/";
        n = this.open();
        if (n < 0) {
            return null;
        }
        if (lArray == null) {
            n5 = this.getRank();
            if (n5 <= 0) {
                this.init();
            }
            n5 = this.getRank();
            lArray = this.getDims();
        } else {
            n5 = lArray.length;
        }
        nArray2 = new int[n5];
        nArray = new int[n5];
        int n6 = 0;
        while (n6 < n5) {
            nArray2[n6] = 0;
            nArray[n6] = (int)lArray[n6];
            n4 *= nArray[n6];
            ++n6;
        }
        n3 = this.datatypeID;
        n2 = HDFLibrary.SDcreate(((H4File)group.getFileFormat()).getSDAccessID(), string, n3, n5, nArray);
        if (n2 < 0) {
            return null;
        }
        n6 = HDFLibrary.SDidtoref(n2);
        if (!group.isRoot()) {
            int n7 = group.open();
            HDFLibrary.Vaddtagref(n7, 720, n6);
            group.close(n7);
        }
        this.copyAttribute(n, n2);
        if (object == null) {
            object = new byte[n4 * HDFLibrary.DFKNTsize(n3)];
            HDFLibrary.SDreaddata(n, nArray2, null, nArray, object);
        }
        HDFLibrary.SDwritedata(n2, nArray2, null, nArray, object);
        long[] lArray2 = new long[]{720L, n6};
        h4SDS = new H4SDS(group.getFileFormat(), string, string2, lArray2);
        group.addToMemberList(h4SDS);
        this.close(n);
        try {
            HDFLibrary.SDendaccess(n2);
        }
        catch (HDFException hDFException) {}
        return h4SDS;
    }

    @Override
    public byte[] readBytes() throws HDFException {
        int n;
        int n2;
        byte[] byArray = null;
        if (this.rank <= 0) {
            this.init();
        }
        if ((n2 = this.open()) < 0) {
            return null;
        }
        int n3 = 1;
        int[] nArray = new int[this.rank];
        int[] nArray2 = new int[this.rank];
        int n4 = 0;
        while (n4 < this.rank) {
            n3 *= (int)this.selectedDims[n4];
            nArray[n4] = (int)this.selectedDims[n4];
            nArray2[n4] = (int)this.startDims[n4];
            ++n4;
        }
        int[] nArray3 = null;
        if (this.selectedStride != null) {
            nArray3 = new int[this.rank];
            n = 0;
            while (n < this.rank) {
                nArray3[n] = (int)this.selectedStride[n];
                ++n;
            }
        }
        try {
            n = HDFLibrary.DFKNTsize(this.datatypeID) * n3;
            byArray = new byte[n];
            HDFLibrary.SDreaddata(n2, nArray2, nArray3, nArray, byArray);
        }
        finally {
            this.close(n2);
        }
        return byArray;
    }

    @Override
    public Object read() throws HDFException {
        int n;
        String[] stringArray = null;
        if (this.rank <= 0) {
            this.init();
        }
        if ((n = this.open()) < 0) {
            return null;
        }
        int n2 = 1;
        int[] nArray = new int[this.rank];
        int[] nArray2 = new int[this.rank];
        int n3 = 0;
        while (n3 < this.rank) {
            n2 *= (int)this.selectedDims[n3];
            nArray[n3] = (int)this.selectedDims[n3];
            nArray2[n3] = (int)this.startDims[n3];
            ++n3;
        }
        int[] nArray3 = null;
        if (this.selectedStride != null) {
            nArray3 = new int[this.rank];
            int n4 = 0;
            while (n4 < this.rank) {
                nArray3[n4] = (int)this.selectedStride[n4];
                ++n4;
            }
        }
        try {
            stringArray = H4Datatype.allocateArray(this.datatypeID, n2);
            if (stringArray != null) {
                HDFLibrary.HXsetdir(this.getFileFormat().getParent());
                HDFLibrary.SDreaddata(n, nArray2, nArray3, nArray, stringArray);
                if (this.isText) {
                    stringArray = H4SDS.byteToString((byte[])stringArray, nArray[0]);
                }
            }
        }
        finally {
            this.close(n);
        }
        if (this.fillValue == null && this.isImageDisplay) {
            try {
                this.getMetadata();
            }
            catch (Exception exception) {}
        }
        this.isDefaultImageOrder = this.rank <= 1 || this.selectedIndex[0] <= this.selectedIndex[1];
        return stringArray;
    }

    @Override
    public void write(Object object) throws HDFException {
        if (object == null) {
            return;
        }
        int n = this.open();
        if (n < 0) {
            return;
        }
        int[] nArray = new int[this.rank];
        int[] nArray2 = new int[this.rank];
        int n2 = 0;
        while (n2 < this.rank) {
            nArray[n2] = (int)this.selectedDims[n2];
            nArray2[n2] = (int)this.startDims[n2];
            ++n2;
        }
        int[] nArray3 = null;
        if (this.selectedStride != null) {
            nArray3 = new int[this.rank];
            int n3 = 0;
            while (n3 < this.rank) {
                nArray3[n3] = (int)this.selectedStride[n3];
                ++n3;
            }
        }
        Object object2 = object;
        try {
            if (this.isUnsigned && this.unsignedConverted) {
                object2 = H4SDS.convertToUnsignedC(object);
            }
            HDFLibrary.HXsetdir(this.getFileFormat().getParent());
            HDFLibrary.SDwritedata(n, nArray2, nArray3, nArray, object2);
        }
        finally {
            object2 = null;
            this.close(n);
        }
    }

    @Override
    public List getMetadata() throws HDFException {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int n = this.open();
        String[] stringArray = new String[]{""};
        int[] nArray = new int[3];
        try {
            int[] nArray2 = new int[32];
            HDFLibrary.SDgetinfo(n, stringArray, nArray2, nArray);
            int n2 = nArray[2];
            if (this.attributeList == null && n2 > 0) {
                this.attributeList = new Vector(n2, 5);
            }
            boolean bl = false;
            String[] stringArray2 = new String[1];
            int[] nArray3 = new int[2];
            int n3 = 0;
            while (n3 < n2) {
                stringArray2[0] = "";
                try {
                    bl = HDFLibrary.SDattrinfo(n, n3, stringArray2, nArray3);
                    nArray3[0] = nArray3[0] & 0xFFFFBFFF;
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (bl) {
                    long[] lArray = new long[]{nArray3[1]};
                    Attribute attribute = new Attribute(stringArray2[0], new H4Datatype(nArray3[0]), lArray);
                    this.attributeList.add(attribute);
                    String[] stringArray3 = H4Datatype.allocateArray(nArray3[0], nArray3[1]);
                    try {
                        HDFLibrary.SDreadattr(n, n3, stringArray3);
                    }
                    catch (HDFException hDFException) {
                        stringArray3 = null;
                    }
                    if (stringArray3 != null) {
                        if (nArray3[0] == 4 || nArray3[0] == 3) {
                            stringArray3 = Dataset.byteToString((byte[])stringArray3, nArray3[1]);
                        } else if (stringArray2[0].equalsIgnoreCase("fillValue")) {
                            this.fillValue = stringArray3;
                        }
                        attribute.setValue(stringArray3);
                    }
                }
                ++n3;
            }
        }
        finally {
            this.close(n);
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        this.getFileFormat().writeAttribute(this, (Attribute)object, true);
        if (this.attributeList == null) {
            this.attributeList = new Vector();
        }
        this.attributeList.add(object);
    }

    @Override
    public void removeMetadata(Object object) throws HDFException {
    }

    @Override
    public int open() {
        int n = -1;
        try {
            int n2 = 0;
            int n3 = (int)this.oid[0];
            n2 = n3 == 67687001 ? (int)this.oid[1] : HDFLibrary.SDreftoindex(this.sdid, (int)this.oid[1]);
            n = HDFLibrary.SDselect(this.sdid, n2);
        }
        catch (HDFException hDFException) {
            n = -1;
        }
        return n;
    }

    @Override
    public void close(int n) {
        try {
            HDFLibrary.SDendaccess(n);
        }
        catch (HDFException hDFException) {}
    }

    @Override
    public void init() {
        int[] nArray;
        boolean bl;
        block35: {
            if (this.rank > 0) {
                return;
            }
            int n = this.open();
            String[] stringArray = new String[]{""};
            String[] stringArray2 = new String[]{""};
            int[] nArray2 = new int[3];
            int[] nArray3 = new int[3];
            bl = false;
            nArray = new int[32];
            try {
                try {
                    HDFLibrary.SDgetinfo(n, stringArray, nArray, nArray3);
                    nArray3[1] = nArray3[1] & 0xFFFFBFFF;
                    this.nAttributes = nArray3[2];
                    this.rank = nArray3[0];
                    if (this.rank <= 0) {
                        this.rank = 1;
                        nArray[0] = 1;
                    }
                    bl = HDFLibrary.SDisrecord(n);
                    this.datatypeID = nArray3[1];
                    this.isText = this.datatypeID == 4 || this.datatypeID == 3;
                    try {
                        this.dimNames = new String[this.rank];
                        int n2 = 0;
                        while (n2 < this.rank) {
                            int n3 = HDFLibrary.SDgetdimid(n, n2);
                            HDFLibrary.SDdiminfo(n3, stringArray2, nArray2);
                            this.dimNames[n2] = stringArray2[0];
                            ++n2;
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        HDFCompInfo hDFCompInfo = new HDFCompInfo();
                        HDFLibrary.SDgetcompress(n, hDFCompInfo);
                        if (hDFCompInfo.ctype == 4) {
                            HDFDeflateCompInfo hDFDeflateCompInfo = new HDFDeflateCompInfo();
                            HDFLibrary.SDgetcompress(n, hDFDeflateCompInfo);
                            this.compression = "GZIP(level=" + hDFDeflateCompInfo.level + ")";
                        } else if (hDFCompInfo.ctype == 5) {
                            HDFSZIPCompInfo hDFSZIPCompInfo = new HDFSZIPCompInfo();
                            HDFLibrary.SDgetcompress(n, hDFSZIPCompInfo);
                            this.compression = "SZIP(bits_per_pixel=" + hDFSZIPCompInfo.bits_per_pixel + ",options_mask=" + hDFSZIPCompInfo.options_mask + ",pixels=" + hDFSZIPCompInfo.pixels + ",pixels_per_block=" + hDFSZIPCompInfo.pixels_per_block + ",pixels_per_scanline=" + hDFSZIPCompInfo.pixels_per_scanline + ")";
                        } else if (hDFCompInfo.ctype == 7) {
                            HDFJPEGCompInfo hDFJPEGCompInfo = new HDFJPEGCompInfo();
                            HDFLibrary.SDgetcompress(n, hDFJPEGCompInfo);
                            this.compression = "JPEG(quality=" + hDFJPEGCompInfo.quality + ",options_mask=" + ",force_baseline=" + hDFJPEGCompInfo.force_baseline + ")";
                        } else if (hDFCompInfo.ctype == 3) {
                            HDFSKPHUFFCompInfo hDFSKPHUFFCompInfo = new HDFSKPHUFFCompInfo();
                            HDFLibrary.SDgetcompress(n, hDFSKPHUFFCompInfo);
                            this.compression = "SKPHUFF(skp_size=" + hDFSKPHUFFCompInfo.skp_size + ")";
                        } else if (hDFCompInfo.ctype == 1) {
                            this.compression = "RLE";
                        } else if (hDFCompInfo.ctype == 2) {
                            HDFNBITCompInfo hDFNBITCompInfo = new HDFNBITCompInfo();
                            HDFLibrary.SDgetcompress(n, hDFNBITCompInfo);
                            this.compression = "NBIT(nt=" + hDFNBITCompInfo.nt + ",bit_len=" + hDFNBITCompInfo.bit_len + ",ctype=" + hDFNBITCompInfo.ctype + ",fill_one=" + hDFNBITCompInfo.fill_one + ",sign_ext=" + hDFNBITCompInfo.sign_ext + ",start_bit=" + hDFNBITCompInfo.start_bit + ")";
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        HDFChunkInfo hDFChunkInfo = new HDFChunkInfo();
                        int[] nArray4 = new int[1];
                        try {
                            HDFLibrary.SDgetchunkinfo(n, hDFChunkInfo, nArray4);
                        }
                        catch (Throwable throwable) {}
                        if (nArray4[0] == 0) {
                            this.chunkSize = null;
                        } else {
                            this.chunkSize = new long[this.rank];
                            int n4 = 0;
                            while (n4 < this.rank) {
                                this.chunkSize[n4] = hDFChunkInfo.chunk_lengths[n4];
                                ++n4;
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (HDFException hDFException) {
                    this.close(n);
                    break block35;
                }
            }
            catch (Throwable throwable) {
                this.close(n);
                throw throwable;
            }
            this.close(n);
        }
        this.isUnsigned = H4Datatype.isUnsigned(this.datatypeID);
        if (nArray == null) {
            return;
        }
        this.dims = new long[this.rank];
        this.maxDims = new long[this.rank];
        this.startDims = new long[this.rank];
        this.selectedDims = new long[this.rank];
        int n = 0;
        while (n < this.rank) {
            this.startDims[n] = 0L;
            this.selectedDims[n] = 1L;
            this.dims[n] = this.maxDims[n] = (long)nArray[n];
            ++n;
        }
        if (bl) {
            this.maxDims[0] = -1L;
        }
        this.selectedIndex[0] = 0;
        this.selectedIndex[1] = 1;
        this.selectedIndex[2] = 2;
        if (this.rank == 1) {
            this.selectedDims[0] = this.dims[0];
        }
        if (this.rank > 1) {
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.isText ? 1L : this.dims[1];
        }
    }

    @Override
    public byte[][] getPalette() {
        return this.palette;
    }

    public static H4SDS create(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object) throws Exception {
        int n2;
        H4SDS h4SDS = null;
        if (group == null || string == null || lArray == null || n > 0 && lArray3 == null) {
            return null;
        }
        H4File h4File = (H4File)group.getFileFormat();
        if (h4File == null) {
            return null;
        }
        String string2 = "/";
        if (!group.isRoot()) {
            string2 = String.valueOf(group.getPath()) + group.getName() + "/";
        }
        int n3 = lArray.length;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = (int)lArray[n4];
            nArray2[n4] = 0;
            int cfr_ignored_0 = nArray[n4];
            ++n4;
        }
        if (lArray2 != null && lArray2[0] < 0L) {
            nArray[0] = 0;
        }
        int[] nArray3 = null;
        if (lArray3 != null) {
            nArray3 = new int[n3];
            n2 = 0;
            while (n2 < n3) {
                nArray3[n2] = (int)lArray3[n2];
                ++n2;
            }
        }
        n2 = h4File.getSDAccessID();
        int n5 = datatype.toNative();
        int n6 = HDFLibrary.SDcreate(n2, string, n5, n3, nArray);
        int n7 = HDFLibrary.DFKNTsize(n5);
        Object object2 = new byte[n7];
        int n8 = 0;
        while (n8 < n7) {
            object2[n8] = 0;
            ++n8;
        }
        HDFLibrary.SDsetfillvalue(n6, object2);
        if (n6 < 0) {
            throw new HDFException("Unable to create the new dataset.");
        }
        if (n6 > 0 && object != null) {
            HDFLibrary.SDwritedata(n6, nArray2, null, nArray, object);
        }
        if (lArray3 != null) {
            HDFChunkInfo hDFChunkInfo = new HDFChunkInfo(nArray3);
            HDFLibrary.SDsetchunk(n6, hDFChunkInfo, 1);
        }
        if (n > 0) {
            n7 = 4;
            object2 = new HDFDeflateCompInfo();
            object2.level = n;
            HDFLibrary.SDsetcompress(n6, n7, (HDFCompInfo)object2);
        }
        n7 = HDFLibrary.SDidtoref(n6);
        if (!group.isRoot()) {
            int n9 = group.open();
            if (n9 < 0) {
                if (n6 > 0) {
                    HDFLibrary.SDendaccess(n6);
                }
                throw new HDFException("Unable to open the parent group.");
            }
            HDFLibrary.Vaddtagref(n9, 720, n7);
            group.close(n9);
        }
        try {
            if (n6 > 0) {
                HDFLibrary.SDendaccess(n6);
            }
        }
        catch (Exception exception) {}
        if ((h4SDS = new H4SDS(h4File, string, string2, (long[])(object2 = (Object)new long[]{720L, n7}))) != null) {
            group.addToMemberList(h4SDS);
        }
        return h4SDS;
    }

    private void copyAttribute(int n, int n2) {
        try {
            String[] stringArray = new String[]{""};
            int[] nArray = new int[3];
            int[] nArray2 = new int[32];
            HDFLibrary.SDgetinfo(n, stringArray, nArray2, nArray);
            int n3 = nArray[2];
            boolean bl = false;
            String[] stringArray2 = new String[1];
            int[] nArray3 = new int[2];
            int n4 = 0;
            while (n4 < n3) {
                stringArray2[0] = "";
                try {
                    bl = HDFLibrary.SDattrinfo(n, n4, stringArray2, nArray3);
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (bl) {
                    byte[] byArray = new byte[nArray3[1] * HDFLibrary.DFKNTsize(nArray3[0])];
                    try {
                        HDFLibrary.SDreadattr(n, n4, byArray);
                    }
                    catch (HDFException hDFException) {
                        byArray = null;
                    }
                    if (byArray != null) {
                        HDFLibrary.SDsetattr(n2, stringArray2[0], nArray3[0], nArray3[1], byArray);
                    }
                }
                ++n4;
            }
        }
        catch (Exception exception) {}
    }

    public List getMetadata(int ... nArray) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

