/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.h4.H4Datatype;
import ncsa.hdf.object.h4.H4File;

public class H4Group
extends Group {
    public static final long serialVersionUID = 240L;
    private List attributeList;
    private int nAttributes = -1;
    private static final long[] DEFAULT_OID = new long[2];

    public H4Group(FileFormat fileFormat, String string, String string2, Group group) {
        this(fileFormat, string, string2, group, null);
    }

    public H4Group(FileFormat fileFormat, String string, String string2, Group group, long[] lArray) {
        super(fileFormat, string, string2, group, lArray == null ? DEFAULT_OID : lArray);
    }

    @Override
    public boolean hasAttribute() {
        if (this.nAttributes < 0) {
            int n = this.open();
            try {
                this.nAttributes = HDFLibrary.Vnattrs(n);
                this.nMembersInFile = HDFLibrary.Vntagrefs(n);
            }
            catch (Exception exception) {
                this.nAttributes = 0;
            }
            this.close(n);
        }
        return this.nAttributes > 0;
    }

    @Override
    public List getMetadata() throws HDFException {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        this.attributeList = new Vector();
        int n = this.open();
        if (n <= 0) {
            return this.attributeList;
        }
        int n2 = -1;
        try {
            n2 = HDFLibrary.Vnattrs(n);
            boolean bl = false;
            String[] stringArray = new String[1];
            int[] nArray = new int[3];
            int n3 = 0;
            while (n3 < n2) {
                stringArray[0] = "";
                try {
                    bl = HDFLibrary.Vattrinfo(n, n3, stringArray, nArray);
                    nArray[0] = nArray[0] & 0xFFFFBFFF;
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (bl) {
                    long[] lArray = new long[]{nArray[1]};
                    Attribute attribute = new Attribute(stringArray[0], new H4Datatype(nArray[0]), lArray);
                    this.attributeList.add(attribute);
                    String[] stringArray2 = H4Datatype.allocateArray(nArray[0], nArray[1]);
                    try {
                        HDFLibrary.Vgetattr(n, n3, stringArray2);
                    }
                    catch (HDFException hDFException) {
                        stringArray2 = null;
                    }
                    if (stringArray2 != null) {
                        if (nArray[0] == 4 || nArray[0] == 3) {
                            stringArray2 = Dataset.byteToString((byte[])stringArray2, nArray[1]);
                        }
                        attribute.setValue(stringArray2);
                    }
                }
                ++n3;
            }
        }
        finally {
            this.close(n);
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        this.getFileFormat().writeAttribute(this, (Attribute)object, true);
        if (this.attributeList == null) {
            this.attributeList = new Vector();
        }
        this.attributeList.add(object);
    }

    @Override
    public void removeMetadata(Object object) throws HDFException {
    }

    @Override
    public int open() {
        int n = -1;
        try {
            n = HDFLibrary.Vattach(this.getFID(), (int)this.oid[1], "w");
        }
        catch (HDFException hDFException) {
            n = -1;
        }
        if (n < 0) {
            try {
                n = HDFLibrary.Vattach(this.getFID(), (int)this.oid[1], "r");
            }
            catch (HDFException hDFException) {
                n = -1;
            }
        }
        return n;
    }

    @Override
    public void close(int n) {
        try {
            HDFLibrary.Vdetach(n);
        }
        catch (Exception exception) {}
    }

    public static H4Group create(String string, Group group) throws Exception {
        int n;
        H4Group h4Group = null;
        if (group == null || string == null) {
            return null;
        }
        H4File h4File = (H4File)group.getFileFormat();
        if (h4File == null) {
            return null;
        }
        String string2 = "/";
        if (!group.isRoot()) {
            string2 = String.valueOf(group.getPath()) + group.getName() + "/";
        }
        if ((n = h4File.open()) < 0) {
            return null;
        }
        int n2 = HDFLibrary.Vattach(n, -1, "w");
        if (n2 < 0) {
            return null;
        }
        HDFLibrary.Vsetname(n2, string);
        int n3 = HDFLibrary.VQueryref(n2);
        int n4 = HDFLibrary.VQuerytag(n2);
        if (!group.isRoot()) {
            int n5 = group.open();
            if (n5 < 0) {
                throw new HDFException("Unable to open the parent group.");
            }
            HDFLibrary.Vinsert(n5, n2);
            group.close(n5);
        }
        try {
            HDFLibrary.Vdetach(n2);
        }
        catch (Exception exception) {}
        long[] lArray = new long[]{n4, n3};
        h4Group = new H4Group(h4File, string, string2, group, lArray);
        if (h4Group != null) {
            group.addToMemberList(h4Group);
        }
        return h4Group;
    }

    public List getMetadata(int ... nArray) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

