/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import java.io.File;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h4.H4Datatype;
import ncsa.hdf.object.h4.H4GRImage;
import ncsa.hdf.object.h4.H4Group;
import ncsa.hdf.object.h4.H4SDS;
import ncsa.hdf.object.h4.H4Vdata;

public class H4File
extends FileFormat {
    public static final long serialVersionUID = 240L;
    private int flag;
    private DefaultMutableTreeNode rootNode;
    private List objList;
    private int grid;
    private boolean isNetCDF = false;
    private int sdid;
    private boolean showAll = false;

    static {
        HDFLibrary.loadH4Lib();
    }

    public H4File() {
        this("", 1);
    }

    public H4File(String string) {
        this(string, 1);
    }

    public H4File(String string, int n) {
        super(string);
        this.isReadOnly = n == 0;
        this.objList = new Vector();
        this.fid = -1;
        this.flag = n == 0 ? 1 : (n == 1 ? 2 : (n == 2 ? 4 : n));
        String string2 = System.getProperty("h4showall");
        if (string2 != null) {
            this.showAll = true;
        }
    }

    @Override
    public boolean isThisType(FileFormat fileFormat) {
        return fileFormat instanceof H4File;
    }

    @Override
    public boolean isThisType(String string) {
        boolean bl = false;
        try {
            bl = HDFLibrary.Hishdf(string);
        }
        catch (HDFException hDFException) {
            bl = false;
        }
        if (!bl) {
            bl = this.isNetCDF(string);
        }
        return bl;
    }

    @Override
    public FileFormat createFile(String string, int n) throws Exception {
        File file;
        Boolean bl = true;
        if (n == 11 && (file = new File(string)).exists()) {
            bl = false;
        }
        if (bl.booleanValue()) {
            int n2 = HDFLibrary.Hopen(string, 4);
            try {
                HDFLibrary.Hclose(n2);
            }
            catch (HDFException hDFException) {}
        }
        return new H4File(string, 1);
    }

    @Override
    public FileFormat createInstance(String string, int n) throws Exception {
        return new H4File(string, n);
    }

    @Override
    public int open() throws Exception {
        if (this.fid >= 0) {
            return this.fid;
        }
        if (this.flag < 0) {
            throw new HDFException("Invalid access identifer -- " + this.flag);
        }
        if (this.flag == 1) {
            if (!this.exists()) {
                throw new HDFException("File does not exist -- " + this.fullFileName);
            }
            if (this.exists() && !this.canRead()) {
                throw new HDFException("Cannot read file -- " + this.fullFileName);
            }
        } else if ((this.flag == 2 || this.flag == 4) && this.exists() && !this.canWrite()) {
            throw new HDFException("Cannot write file, try open as read-only -- " + this.fullFileName);
        }
        this.isNetCDF = this.isNetCDF(this.fullFileName);
        if (this.isNetCDF) {
            this.isReadOnly = true;
        }
        if (this.isNetCDF) {
            this.fid = 0;
        } else {
            this.fid = HDFLibrary.Hopen(this.fullFileName, this.flag);
            HDFLibrary.Vstart(this.fid);
            this.grid = HDFLibrary.GRstart(this.fid);
        }
        this.sdid = HDFLibrary.SDstart(this.fullFileName, this.flag);
        this.rootNode = this.loadTree();
        return this.fid;
    }

    @Override
    public void close() throws HDFException {
        if (this.rootNode != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            HObject hObject = null;
            Enumeration<TreeNode> enumeration = this.rootNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                hObject = (HObject)defaultMutableTreeNode.getUserObject();
                if (hObject instanceof Dataset) {
                    ((Dataset)hObject).clearData();
                }
                hObject = null;
                defaultMutableTreeNode = null;
            }
        }
        try {
            HDFLibrary.GRend(this.grid);
        }
        catch (HDFException hDFException) {}
        try {
            HDFLibrary.SDend(this.sdid);
        }
        catch (HDFException hDFException) {}
        try {
            HDFLibrary.Vend(this.fid);
        }
        catch (HDFException hDFException) {}
        HDFLibrary.Hclose(this.fid);
        this.fid = -1;
        this.objList = null;
    }

    @Override
    public TreeNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public Group createGroup(String string, Group group) throws Exception {
        return H4Group.create(string, group);
    }

    @Override
    public Datatype createDatatype(int n, int n2, int n3, int n4) throws Exception {
        return new H4Datatype(n, n2, n3, n4);
    }

    @Override
    public Datatype createDatatype(int n, int n2, int n3, int n4, String string) throws Exception {
        throw new UnsupportedOperationException("HDF4 does not support named datatype.");
    }

    @Override
    public Dataset createScalarDS(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object) throws Exception {
        return H4SDS.create(string, group, datatype, lArray, lArray2, lArray3, n, object);
    }

    @Override
    public Dataset createImage(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, int n3, Object object) throws Exception {
        H4GRImage h4GRImage = H4GRImage.create(string, group, datatype, lArray, lArray2, lArray3, n, n2, n3, object);
        return h4GRImage;
    }

    @Override
    public void delete(HObject hObject) throws Exception {
        throw new UnsupportedOperationException("Cannot delete HDF4 object.");
    }

    @Override
    public TreeNode copy(HObject hObject, Group group, String string) throws Exception {
        TreeNode treeNode = null;
        if (hObject == null || group == null) {
            return null;
        }
        if (string == null) {
            string = hObject.getName();
        }
        if (hObject instanceof H4SDS) {
            treeNode = new DefaultMutableTreeNode(((H4SDS)hObject).copy(group, string, null, null));
        } else if (hObject instanceof H4GRImage) {
            treeNode = new DefaultMutableTreeNode(((H4GRImage)hObject).copy(group, string, null, null));
        } else if (hObject instanceof H4Vdata) {
            treeNode = new DefaultMutableTreeNode(((H4Vdata)hObject).copy(group, null, null, null));
        } else if (hObject instanceof H4Group) {
            treeNode = this.copyGroup((H4Group)hObject, (H4Group)group);
        }
        return treeNode;
    }

    @Override
    public void writeAttribute(HObject hObject, Attribute attribute, boolean bl) throws HDFException {
        Object object;
        String string = attribute.getName();
        int n = attribute.getType().toNative();
        long[] lArray = attribute.getDataDims();
        int n2 = 1;
        if (lArray != null) {
            int n3 = 0;
            while (n3 < lArray.length) {
                n2 *= (int)lArray[n3];
                ++n3;
            }
        }
        if (Array.get(object = attribute.getValue(), 0) instanceof String) {
            String string2 = (String)Array.get(object, 0);
            if (string2.length() > n2) {
                string2 = string2.substring(0, n2);
                Array.set(object, 0, string2);
            } else {
                int n4 = string2.length();
                while (n4 < n2) {
                    string2 = String.valueOf(string2) + " ";
                    ++n4;
                }
            }
            byte[] byArray = string2.getBytes();
            byArray[string2.length() - 1] = 0;
            object = byArray;
        }
        if (hObject instanceof H4Group && ((H4Group)hObject).isRoot()) {
            if (bl) {
                HDFLibrary.SDsetattr(this.sdid, string, n, n2, object);
            } else {
                HDFLibrary.GRsetattr(this.grid, string, n, n2, object);
            }
            return;
        }
        int n5 = hObject.open();
        if (hObject instanceof H4Group) {
            HDFLibrary.Vsetattr(n5, string, n, n2, object);
        } else if (hObject instanceof H4SDS) {
            HDFLibrary.SDsetattr(n5, string, n, n2, object);
        } else if (hObject instanceof H4GRImage) {
            HDFLibrary.GRsetattr(n5, string, n, n2, object);
        } else if (hObject instanceof H4Vdata) {
            HDFLibrary.VSsetattr(n5, -1, string, n, n2, object);
        }
        hObject.close(n5);
    }

    private TreeNode copyGroup(H4Group h4Group, H4Group h4Group2) throws Exception {
        int n;
        H4Group h4Group3 = null;
        String string = null;
        String string2 = null;
        int n2 = HDFLibrary.Vattach(this.fid, -1, "w");
        if (n2 < 0) {
            return null;
        }
        string = h4Group.getName();
        int n3 = h4Group.open();
        HDFLibrary.Vsetname(n2, string);
        int n4 = HDFLibrary.VQueryref(n2);
        int n5 = HDFLibrary.VQuerytag(n2);
        if (h4Group2.isRoot()) {
            string2 = "/";
        } else {
            string2 = String.valueOf(h4Group2.getPath()) + h4Group2.getName() + "/";
            n = h4Group2.open();
            HDFLibrary.Vinsert(n, n2);
            h4Group2.close(n);
        }
        n = 0;
        try {
            n = HDFLibrary.Vnattrs(n3);
        }
        catch (Exception exception) {
            n = 0;
        }
        String[] stringArray = new String[1];
        byte[] byArray = null;
        int[] nArray = new int[3];
        int n6 = 0;
        while (n6 < n) {
            try {
                stringArray[0] = "";
                HDFLibrary.Vattrinfo(n3, n6, stringArray, nArray);
                byArray = new byte[nArray[2]];
                HDFLibrary.Vgetattr(n3, n6, byArray);
                HDFLibrary.Vsetattr(n2, stringArray[0], nArray[0], nArray[2], byArray);
            }
            catch (Exception exception) {}
            ++n6;
        }
        long[] lArray = new long[]{n5, n4};
        h4Group3 = new H4Group(this, string, string2, h4Group2, lArray);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(h4Group3){
            public static final long serialVersionUID = 240L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        h4Group2.addToMemberList(h4Group3);
        List<HObject> list = h4Group.getMemberList();
        if (list != null && list.size() > 0) {
            for (HObject hObject : list) {
                try {
                    defaultMutableTreeNode.add((MutableTreeNode)this.copy(hObject, h4Group3));
                }
                catch (Exception exception) {}
            }
        }
        h4Group.close(n3);
        try {
            HDFLibrary.Vdetach(n2);
        }
        catch (Exception exception) {}
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode loadTree() {
        Dataset dataset;
        if (this.fid < 0) {
            return null;
        }
        long[] lArray = new long[2];
        int n = 0;
        int n2 = -1;
        int[] nArray = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        H4Group h4Group = new H4Group(this, this.getName(), null, null, lArray);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(h4Group){
            public static final long serialVersionUID = 240L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        int[] nArray2 = new int[1];
        int[] nArray3 = null;
        try {
            n = HDFLibrary.Vlone(this.fid, nArray2, 0);
            nArray3 = new int[n];
            n = HDFLibrary.Vlone(this.fid, nArray3, n);
        }
        catch (HDFException hDFException) {
            n = 0;
        }
        int n3 = Math.max(0, this.getStartMembers());
        int n4 = this.getMaxMembers();
        if (n4 >= n) {
            n4 = n;
            n3 = 0;
        }
        n4 += n3;
        n4 = Math.min(n4, n);
        int n5 = n3;
        while (n5 < n4) {
            n2 = nArray3[n5];
            H4Group h4Group2 = this.getVGroup(1965, n2, "/", h4Group, false);
            if (h4Group2 != null) {
                defaultMutableTreeNode = new DefaultMutableTreeNode(h4Group2){
                    public static final long serialVersionUID = 240L;

                    @Override
                    public boolean isLeaf() {
                        return false;
                    }
                };
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                h4Group.addToMemberList(h4Group2);
                this.depth_first(defaultMutableTreeNode, null);
            }
            ++n5;
        }
        nArray = new int[2];
        n5 = 0;
        try {
            n5 = HDFLibrary.GRfileinfo(this.grid, nArray) ? 1 : 0;
        }
        catch (HDFException hDFException) {
            n5 = 0;
        }
        if (n5 != 0) {
            n = nArray[0];
            int n6 = 0;
            while (n6 < n) {
                dataset = this.getGRImage(306, n6, "/", false);
                if (dataset != null) {
                    defaultMutableTreeNode = new DefaultMutableTreeNode(dataset);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                    h4Group.addToMemberList(dataset);
                }
                ++n6;
            }
        }
        try {
            n5 = HDFLibrary.SDfileinfo(this.sdid, nArray) ? 1 : 0;
        }
        catch (HDFException hDFException) {
            n5 = 0;
        }
        if (n5 != 0) {
            n = nArray[0];
            int n7 = 0;
            while (n7 < n) {
                dataset = this.getSDS(720, n7, "/", false);
                if (dataset != null) {
                    defaultMutableTreeNode = new DefaultMutableTreeNode(dataset);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                    h4Group.addToMemberList(dataset);
                }
                ++n7;
            }
        }
        try {
            n = HDFLibrary.VSlone(this.fid, nArray2, 0);
            nArray3 = new int[n];
            n = HDFLibrary.VSlone(this.fid, nArray3, n);
        }
        catch (HDFException hDFException) {
            n = 0;
        }
        int n8 = 0;
        while (n8 < n) {
            n2 = nArray3[n8];
            dataset = this.getVdata(1963, n2, "/", false);
            if (dataset != null) {
                defaultMutableTreeNode = new DefaultMutableTreeNode(dataset);
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                h4Group.addToMemberList(dataset);
            }
            ++n8;
        }
        if (h4Group != null) {
            List list = null;
            try {
                list = h4Group.getMetadata();
            }
            catch (HDFException hDFException) {}
            if (list != null) {
                try {
                    this.getFileAnnotation(this.fid, list);
                }
                catch (HDFException hDFException) {}
                try {
                    this.getGRglobleAttribute(this.grid, list);
                }
                catch (HDFException hDFException) {}
                try {
                    this.getSDSglobleAttribute(this.sdid, list);
                }
                catch (HDFException hDFException) {}
            }
        }
        return defaultMutableTreeNode2;
    }

    private void depth_first(MutableTreeNode mutableTreeNode, H4Group h4Group) {
        String string;
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        int[] nArray;
        int[] nArray2;
        int n;
        int n2;
        int n3;
        int n4;
        block22: {
            if (h4Group == null && mutableTreeNode == null) {
                return;
            }
            n4 = 0;
            n3 = -1;
            n2 = -1;
            n = -1;
            nArray2 = null;
            nArray = null;
            defaultMutableTreeNode2 = null;
            defaultMutableTreeNode = null;
            if (mutableTreeNode != null) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)mutableTreeNode;
                h4Group = (H4Group)defaultMutableTreeNode.getUserObject();
            }
            string = String.valueOf(h4Group.getPath()) + h4Group.getName() + "/";
            int n5 = h4Group.open();
            if (n5 == -1) {
                return;
            }
            try {
                try {
                    n4 = HDFLibrary.Vntagrefs(n5);
                    nArray2 = new int[n4];
                    nArray = new int[n4];
                    n4 = HDFLibrary.Vgettagrefs(n5, nArray2, nArray, n4);
                }
                catch (HDFException hDFException) {
                    n4 = 0;
                    h4Group.close(n5);
                    break block22;
                }
            }
            catch (Throwable throwable) {
                h4Group.close(n5);
                throw throwable;
            }
            h4Group.close(n5);
        }
        int n6 = Math.max(0, this.getStartMembers());
        int n7 = this.getMaxMembers();
        if (n7 >= n4) {
            n7 = n4;
            n6 = 0;
        }
        n7 += n6;
        n7 = Math.min(n7, n4);
        int n8 = n6;
        while (n8 < n7) {
            n2 = nArray2[n8];
            n3 = nArray[n8];
            switch (n2) {
                case 202: 
                case 302: 
                case 306: {
                    try {
                        n = HDFLibrary.GRreftoindex(this.grid, (short)n3);
                    }
                    catch (HDFException hDFException) {
                        n = -1;
                    }
                    if (n == -1) break;
                    Dataset dataset = this.getGRImage(n2, n, string, true);
                    h4Group.addToMemberList(dataset);
                    if (dataset == null || defaultMutableTreeNode == null) break;
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(dataset);
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    break;
                }
                case 700: 
                case 702: 
                case 720: {
                    try {
                        n = HDFLibrary.SDreftoindex(this.sdid, n3);
                    }
                    catch (HDFException hDFException) {
                        n = -1;
                    }
                    if (n == -1) break;
                    Dataset dataset = this.getSDS(n2, n, string, true);
                    h4Group.addToMemberList(dataset);
                    if (dataset == null || defaultMutableTreeNode == null) break;
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(dataset);
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    break;
                }
                case 1962: 
                case 1963: {
                    Dataset dataset = this.getVdata(n2, n3, string, true);
                    h4Group.addToMemberList(dataset);
                    if (dataset == null || defaultMutableTreeNode == null) break;
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(dataset);
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    break;
                }
                case 1965: {
                    H4Group h4Group2 = this.getVGroup(n2, n3, string, h4Group, true);
                    h4Group.addToMemberList(h4Group2);
                    if (h4Group2 == null || defaultMutableTreeNode == null) break;
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(h4Group2){
                        public static final long serialVersionUID = 240L;

                        @Override
                        public boolean isLeaf() {
                            return false;
                        }
                    };
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    boolean bl = false;
                    DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode;
                    while (defaultMutableTreeNode3 != null && !bl) {
                        long[] lArray;
                        H4Group h4Group3 = (H4Group)defaultMutableTreeNode3.getUserObject();
                        if (h4Group3.equalsOID(lArray = new long[]{n2, n3})) {
                            bl = true;
                            continue;
                        }
                        defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getParent();
                    }
                    if (bl) break;
                    this.depth_first(defaultMutableTreeNode2, null);
                    break;
                }
            }
            ++n8;
        }
    }

    private final H4GRImage getGRImage(int n, int n2, String string, boolean bl) {
        String[] stringArray;
        H4GRImage h4GRImage;
        int n3;
        int n4;
        block15: {
            n4 = -1;
            n3 = -1;
            h4GRImage = null;
            stringArray = new String[]{""};
            int[] nArray = new int[4];
            int[] nArray2 = new int[2];
            try {
                try {
                    n4 = HDFLibrary.GRselect(this.grid, n2);
                    n3 = HDFLibrary.GRidtoref(n4);
                    HDFLibrary.GRgetiminfo(n4, stringArray, nArray, nArray2);
                }
                catch (HDFException hDFException) {
                    n4 = -1;
                    try {
                        HDFLibrary.GRendaccess(n4);
                    }
                    catch (HDFException hDFException2) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    HDFLibrary.GRendaccess(n4);
                }
                catch (HDFException hDFException) {}
                throw throwable;
            }
            try {
                HDFLibrary.GRendaccess(n4);
            }
            catch (HDFException hDFException) {}
        }
        if (n4 != -1) {
            long[] lArray = new long[]{n, n3};
            if (bl) {
                this.objList.add(lArray);
            } else if (this.find(lArray)) {
                return null;
            }
            h4GRImage = new H4GRImage(this, stringArray[0], string, lArray);
        }
        return h4GRImage;
    }

    private final H4SDS getSDS(int n, int n2, String string, boolean bl) {
        boolean bl2;
        String[] stringArray;
        H4SDS h4SDS;
        int n3;
        int n4;
        block18: {
            n4 = -1;
            n3 = -1;
            h4SDS = null;
            stringArray = new String[]{""};
            int[] nArray = new int[32];
            int[] nArray2 = new int[3];
            bl2 = false;
            try {
                try {
                    n4 = HDFLibrary.SDselect(this.sdid, n2);
                    if (this.isNetCDF) {
                        n3 = n2;
                        n = 67687001;
                    } else {
                        n3 = HDFLibrary.SDidtoref(n4);
                    }
                    HDFLibrary.SDgetinfo(n4, stringArray, nArray, nArray2);
                    bl2 = HDFLibrary.SDiscoordvar(n4);
                }
                catch (HDFException hDFException) {
                    n4 = -1;
                    try {
                        HDFLibrary.SDendaccess(n4);
                    }
                    catch (HDFException hDFException2) {}
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    HDFLibrary.SDendaccess(n4);
                }
                catch (HDFException hDFException) {}
                throw throwable;
            }
            try {
                HDFLibrary.SDendaccess(n4);
            }
            catch (HDFException hDFException) {}
        }
        if (bl2) {
            stringArray[0] = String.valueOf(stringArray[0]) + " (dimension)";
        }
        if (n4 != -1) {
            long[] lArray = new long[]{n, n3};
            if (bl) {
                this.objList.add(lArray);
            } else if (this.find(lArray)) {
                return null;
            }
            h4SDS = new H4SDS(this, stringArray[0], string, lArray);
        }
        return h4SDS;
    }

    private final H4Vdata getVdata(int n, int n2, String string, boolean bl) {
        long[] lArray;
        String[] stringArray;
        String[] stringArray2;
        H4Vdata h4Vdata;
        int n3;
        block15: {
            n3 = -1;
            h4Vdata = null;
            stringArray2 = new String[]{""};
            stringArray = new String[]{""};
            lArray = new long[]{n, n2};
            if (bl) {
                this.objList.add(lArray);
            } else if (this.find(lArray)) {
                return null;
            }
            try {
                try {
                    n3 = HDFLibrary.VSattach(this.fid, n2, "r");
                    HDFLibrary.VSgetclass(n3, stringArray);
                    stringArray[0] = stringArray[0].trim();
                    HDFLibrary.VSgetname(n3, stringArray2);
                }
                catch (HDFException hDFException) {
                    n3 = -1;
                    try {
                        HDFLibrary.VSdetach(n3);
                    }
                    catch (HDFException hDFException2) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    HDFLibrary.VSdetach(n3);
                }
                catch (HDFException hDFException) {}
                throw throwable;
            }
            try {
                HDFLibrary.VSdetach(n3);
            }
            catch (HDFException hDFException) {}
        }
        if (this.showAll || n3 != -1 && !stringArray[0].startsWith("_HDF_CHK_TBL_") && !stringArray[0].equalsIgnoreCase("CDF0.0")) {
            h4Vdata = new H4Vdata(this, stringArray2[0], string, lArray);
        }
        return h4Vdata;
    }

    private final H4Group getVGroup(int n, int n2, String string, H4Group h4Group, boolean bl) {
        long[] lArray;
        String[] stringArray;
        String[] stringArray2;
        H4Group h4Group2;
        int n3;
        block15: {
            n3 = -1;
            h4Group2 = null;
            stringArray2 = new String[]{""};
            stringArray = new String[]{""};
            lArray = new long[]{n, n2};
            if (bl) {
                this.objList.add(lArray);
            } else if (this.find(lArray)) {
                return null;
            }
            try {
                try {
                    n3 = HDFLibrary.Vattach(this.fid, n2, "r");
                    HDFLibrary.Vgetclass(n3, stringArray);
                    stringArray[0] = stringArray[0].trim();
                    HDFLibrary.Vgetname(n3, stringArray2);
                }
                catch (HDFException hDFException) {
                    n3 = -1;
                    try {
                        HDFLibrary.Vdetach(n3);
                    }
                    catch (HDFException hDFException2) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    HDFLibrary.Vdetach(n3);
                }
                catch (HDFException hDFException) {}
                throw throwable;
            }
            try {
                HDFLibrary.Vdetach(n3);
            }
            catch (HDFException hDFException) {}
        }
        if (this.showAll || n3 != -1 && !stringArray[0].equalsIgnoreCase("RIG0.0") && !stringArray[0].equalsIgnoreCase("RI0.0") && !stringArray[0].equalsIgnoreCase("RIATTR0.0N") && !stringArray[0].equalsIgnoreCase("RIATTR0.0C") && !stringArray[0].equalsIgnoreCase("CDF0.0")) {
            h4Group2 = new H4Group(this, stringArray2[0], string, h4Group, lArray);
        }
        return h4Group2;
    }

    private final boolean find(long[] lArray) {
        boolean bl = false;
        if (this.objList == null) {
            return false;
        }
        int n = this.objList.size();
        long[] lArray2 = null;
        int n2 = 0;
        while (n2 < n) {
            lArray2 = (long[])this.objList.get(n2);
            if (lArray2[0] == lArray[0] && lArray2[1] == lArray[1]) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            this.objList.add(lArray);
        }
        return bl;
    }

    int getGRAccessID() {
        return this.grid;
    }

    int getSDAccessID() {
        return this.sdid;
    }

    private List getFileAnnotation(int n, List vector) throws HDFException {
        int[] nArray;
        int n2;
        block29: {
            if (n < 0) {
                return vector;
            }
            n2 = -1;
            n2 = HDFLibrary.ANstart(n);
            nArray = new int[4];
            HDFLibrary.ANfileinfo(n2, nArray);
            if (nArray[0] + nArray[1] > 0) break block29;
            try {
                HDFLibrary.ANend(n2);
            }
            catch (HDFException hDFException) {}
            Vector<Attribute> vector2 = vector;
            try {
                HDFLibrary.ANend(n2);
            }
            catch (HDFException hDFException) {}
            return vector2;
        }
        try {
            if (vector == null) {
                vector = new Vector<Attribute>(nArray[0] + nArray[1], 5);
            }
            int n3 = -1;
            int[] nArray2 = new int[]{2, 3};
            int n4 = 0;
            while (n4 < 2) {
                String string = null;
                string = n4 == 0 ? "File Label" : "File Description";
                int n5 = 0;
                while (n5 < nArray[n4]) {
                    try {
                        n3 = HDFLibrary.ANselect(n2, n5, nArray2[n4]);
                    }
                    catch (HDFException hDFException) {
                        n3 = -1;
                    }
                    if (n3 == -1) {
                        try {
                            HDFLibrary.ANendaccess(n3);
                        }
                        catch (HDFException hDFException) {}
                    } else {
                        int n6 = 0;
                        try {
                            n6 = HDFLibrary.ANannlen(n3) + 1;
                        }
                        catch (HDFException hDFException) {
                            n6 = 0;
                        }
                        if (n6 > 0) {
                            boolean bl = false;
                            String[] stringArray = new String[]{""};
                            try {
                                bl = HDFLibrary.ANreadann(n3, stringArray, n6);
                            }
                            catch (HDFException hDFException) {
                                bl = false;
                            }
                            if (bl && stringArray[0].length() > 0) {
                                long[] lArray = new long[]{stringArray[0].length()};
                                Attribute attribute = new Attribute(String.valueOf(string) + " #" + n5, new H4Datatype(4), lArray);
                                vector.add(attribute);
                                attribute.setValue(stringArray[0]);
                            }
                        }
                        try {
                            HDFLibrary.ANendaccess(n3);
                        }
                        catch (HDFException hDFException) {}
                    }
                    ++n5;
                }
                ++n4;
            }
        }
        catch (Throwable throwable) {
            try {
                HDFLibrary.ANend(n2);
            }
            catch (HDFException hDFException) {}
            throw throwable;
        }
        try {
            HDFLibrary.ANend(n2);
        }
        catch (HDFException hDFException) {}
        return vector;
    }

    private List getGRglobleAttribute(int n, List vector) throws HDFException {
        if (n == -1) {
            return vector;
        }
        int[] nArray = new int[2];
        HDFLibrary.GRfileinfo(n, nArray);
        int n2 = nArray[1];
        if (n2 > 0) {
            if (vector == null) {
                vector = new Vector<Attribute>(n2, 5);
            }
            String[] stringArray = new String[1];
            int n3 = 0;
            while (n3 < n2) {
                stringArray[0] = "";
                boolean bl = false;
                try {
                    bl = HDFLibrary.GRattrinfo(n, n3, stringArray, nArray);
                    nArray[0] = nArray[0] & 0xFFFFBFFF;
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (bl) {
                    long[] lArray = new long[]{nArray[1]};
                    Attribute attribute = new Attribute(stringArray[0], new H4Datatype(nArray[0]), lArray);
                    vector.add(attribute);
                    String[] stringArray2 = H4Datatype.allocateArray(nArray[0], nArray[1]);
                    try {
                        HDFLibrary.GRgetattr(n, n3, stringArray2);
                    }
                    catch (HDFException hDFException) {
                        stringArray2 = null;
                    }
                    if (stringArray2 != null) {
                        if (nArray[0] == 4 || nArray[0] == 3) {
                            stringArray2 = Dataset.byteToString((byte[])stringArray2, nArray[1]);
                        }
                        attribute.setValue(stringArray2);
                    }
                }
                ++n3;
            }
        }
        return vector;
    }

    private List getSDSglobleAttribute(int n, List vector) throws HDFException {
        if (n == -1) {
            return vector;
        }
        int[] nArray = new int[2];
        HDFLibrary.SDfileinfo(n, nArray);
        int n2 = nArray[1];
        if (n2 > 0) {
            if (vector == null) {
                vector = new Vector<Attribute>(n2, 5);
            }
            String[] stringArray = new String[1];
            int n3 = 0;
            while (n3 < n2) {
                stringArray[0] = "";
                boolean bl = false;
                try {
                    bl = HDFLibrary.SDattrinfo(n, n3, stringArray, nArray);
                    nArray[0] = nArray[0] & 0xFFFFBFFF;
                }
                catch (HDFException hDFException) {
                    bl = false;
                }
                if (bl) {
                    long[] lArray = new long[]{nArray[1]};
                    Attribute attribute = new Attribute(stringArray[0], new H4Datatype(nArray[0]), lArray);
                    vector.add(attribute);
                    String[] stringArray2 = H4Datatype.allocateArray(nArray[0], nArray[1]);
                    try {
                        HDFLibrary.SDreadattr(n, n3, stringArray2);
                    }
                    catch (HDFException hDFException) {
                        stringArray2 = null;
                    }
                    if (stringArray2 != null) {
                        if (nArray[0] == 4 || nArray[0] == 3) {
                            stringArray2 = Dataset.byteToString((byte[])stringArray2, nArray[1]);
                        }
                        attribute.setValue(stringArray2);
                    }
                }
                ++n3;
            }
        }
        return vector;
    }

    @Override
    public String getLibversion() {
        int[] nArray = new int[3];
        String string = "HDF ";
        String[] stringArray = new String[]{""};
        try {
            HDFLibrary.Hgetlibversion(nArray, stringArray);
        }
        catch (HDFException hDFException) {}
        string = String.valueOf(string) + nArray[0] + "." + nArray[1] + "." + nArray[2];
        return string;
    }

    private boolean isNetCDF(String string) {
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
        }
        catch (Exception exception) {
            try {
                randomAccessFile.close();
            }
            catch (Exception exception2) {}
            randomAccessFile = null;
        }
        if (randomAccessFile == null) {
            return false;
        }
        byte[] byArray = new byte[4];
        try {
            randomAccessFile.read(byArray);
        }
        catch (Exception exception) {
            byArray = null;
        }
        if (byArray != null) {
            bl = byArray[0] == 67 && byArray[1] == 68 && byArray[2] == 70 && byArray[3] == 1;
        }
        try {
            randomAccessFile.close();
        }
        catch (Exception exception) {}
        return bl;
    }

    @Override
    public HObject get(String string) throws Exception {
        if (this.objList == null) {
            this.objList = new Vector();
        }
        if (string == null || string.length() <= 0) {
            return null;
        }
        if (!(string = string.replace('\\', '/')).startsWith("/")) {
            string = "/" + string;
        }
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        if (string.equals("/")) {
            string2 = "/";
            bl = true;
        } else {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 2);
            }
            int n = string.lastIndexOf(47);
            string2 = string.substring(n + 1);
            string3 = n == 0 ? "/" : string.substring(0, n);
        }
        HObject hObject = null;
        this.isReadOnly = false;
        if (this.fid < 0) {
            this.fid = HDFLibrary.Hopen(this.fullFileName, 2);
            if (this.fid < 0) {
                this.isReadOnly = true;
                this.fid = HDFLibrary.Hopen(this.fullFileName, 1);
            }
            HDFLibrary.Vstart(this.fid);
            this.grid = HDFLibrary.GRstart(this.fid);
            this.sdid = HDFLibrary.SDstart(this.fullFileName, this.flag);
        }
        hObject = bl ? this.getRootGroup() : this.getAttachedObject(string3, string2);
        return hObject;
    }

    private H4Group getRootGroup() {
        Dataset dataset;
        H4Group h4Group = null;
        long[] lArray = new long[2];
        int n = 0;
        int n2 = -1;
        int[] nArray = null;
        h4Group = new H4Group(this, "/", null, null, lArray);
        int[] nArray2 = new int[1];
        int[] nArray3 = null;
        try {
            n = HDFLibrary.Vlone(this.fid, nArray2, 0);
            nArray3 = new int[n];
            n = HDFLibrary.Vlone(this.fid, nArray3, n);
        }
        catch (HDFException hDFException) {
            n = 0;
        }
        int n3 = 0;
        while (n3 < n) {
            n2 = nArray3[n3];
            H4Group h4Group2 = this.getVGroup(1965, n2, "/", h4Group, false);
            if (h4Group2 != null) {
                h4Group.addToMemberList(h4Group2);
            }
            ++n3;
        }
        nArray = new int[2];
        n3 = 0;
        try {
            n3 = HDFLibrary.GRfileinfo(this.grid, nArray) ? 1 : 0;
        }
        catch (HDFException hDFException) {
            n3 = 0;
        }
        if (n3 != 0) {
            n = nArray[0];
            int n4 = 0;
            while (n4 < n) {
                dataset = this.getGRImage(306, n4, "/", false);
                if (dataset != null) {
                    h4Group.addToMemberList(dataset);
                }
                ++n4;
            }
        }
        try {
            n3 = HDFLibrary.SDfileinfo(this.sdid, nArray) ? 1 : 0;
        }
        catch (HDFException hDFException) {
            n3 = 0;
        }
        if (n3 != 0) {
            n = nArray[0];
            int n5 = 0;
            while (n5 < n) {
                dataset = this.getSDS(720, n5, "/", false);
                if (dataset != null) {
                    h4Group.addToMemberList(dataset);
                }
                ++n5;
            }
        }
        try {
            n = HDFLibrary.VSlone(this.fid, nArray2, 0);
            nArray3 = new int[n];
            n = HDFLibrary.VSlone(this.fid, nArray3, n);
        }
        catch (HDFException hDFException) {
            n = 0;
        }
        int n6 = 0;
        while (n6 < n) {
            n2 = nArray3[n6];
            dataset = this.getVdata(1963, n2, "/", false);
            if (dataset != null) {
                h4Group.addToMemberList(dataset);
            }
            ++n6;
        }
        if (h4Group != null) {
            List list = null;
            try {
                list = h4Group.getMetadata();
            }
            catch (HDFException hDFException) {}
            if (list != null) {
                try {
                    this.getFileAnnotation(this.fid, list);
                }
                catch (HDFException hDFException) {}
                try {
                    this.getGRglobleAttribute(this.grid, list);
                }
                catch (HDFException hDFException) {}
                try {
                    this.getSDSglobleAttribute(this.sdid, list);
                }
                catch (HDFException hDFException) {}
            }
        }
        return h4Group;
    }

    private HObject getAttachedObject(String string, String string2) {
        if (string2 == null || string2.length() <= 0) {
            return null;
        }
        HObject hObject = null;
        String[] stringArray = new String[]{""};
        int n = -1;
        try {
            n = HDFLibrary.GRnametoindex(this.grid, string2);
        }
        catch (HDFException hDFException) {
            n = -1;
        }
        if (n >= 0) {
            return this.getGRImage(306, n, "/", false);
        }
        try {
            n = HDFLibrary.SDnametoindex(this.sdid, string2);
        }
        catch (HDFException hDFException) {
            n = -1;
        }
        if (n >= 0) {
            return this.getSDS(720, n, "/", false);
        }
        int n2 = 0;
        try {
            n2 = HDFLibrary.Vfind(this.fid, string2);
        }
        catch (HDFException hDFException) {
            n2 = -1;
        }
        if (n2 > 0) {
            long[] lArray = new long[]{1965L, n2};
            H4Group h4Group = new H4Group(this, stringArray[0], string, null, lArray);
            this.depth_first(null, h4Group);
            return h4Group;
        }
        try {
            n2 = HDFLibrary.VSfind(this.fid, string2);
        }
        catch (HDFException hDFException) {
            n2 = -1;
        }
        if (n2 > 0) {
            return this.getVdata(1963, n2, "/", false);
        }
        return hObject;
    }
}

